/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.execution;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.processors.execution.ExecutionController;
import amazon.fws.clicommando.util.StringUtils;
import amazon.fws.clicommando.util.XmlUtils;
import amazon.fws.clicommando.validators.UnsignedLongParamValidator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerIteratorExecutionController
extends ExecutionController {
    public static final String FETCH_MIN_TAG = "fetch.min";
    public static final String FETCH_MAX_TAG = "fetch.max";
    public static final String MAXRECORDS_TAG = "MaxRecords";
    public static final String MARKER_TAG = "Marker";
    public static final String SHOWHEADERS_TAG = "DisplayHeaders";
    public static final String MARKER_RESPONSE_XPATH_TAG = "marker-response-xpath";
    public static final String MARKER_PARAMETER = "marker-parameter";
    public static final String MAXRECORDS_PARAMETER = "maxrecords-parameter";
    public static final String SHOWHEADERS_PARAMETER = "showheaders-parameter";
    public static final String RECORDS_LEFT_KEY = "records-left";
    Map<String, Object> userData;
    private String newMarkerTag;
    private String newMaxRecordsTag;

    @Override
    public Command process(Command command) throws CliCommandoException {
        this.userData = command.getUserData();
        this.updateUserData(command);
        this.setupNextIteration(command);
        return command;
    }

    private void updateUserData(Command command) {
        if (this.userData.get(RECORDS_LEFT_KEY) == null) {
            this.loadUserData(command, this.userData);
        } else {
            this.loadFromResponse(command);
        }
    }

    private void loadUserData(Command command, Map<String, Object> userData) {
        Long maxFetch;
        Long minFetch;
        String markerParameter = this.getConfig().get(MARKER_PARAMETER);
        this.newMarkerTag = StringUtils.isEmpty(markerParameter) ? MARKER_TAG : markerParameter;
        userData.put(MARKER_PARAMETER, this.newMarkerTag);
        String maxrecordsParameter = this.getConfig().get(MAXRECORDS_PARAMETER);
        this.newMaxRecordsTag = StringUtils.isEmpty(maxrecordsParameter) ? MAXRECORDS_TAG : maxrecordsParameter;
        userData.put(MAXRECORDS_PARAMETER, this.newMaxRecordsTag);
        UnsignedLongParamValidator longValidator = new UnsignedLongParamValidator();
        try {
            userData.put(FETCH_MIN_TAG, longValidator.validate(this.getConfig().get(FETCH_MIN_TAG)));
            userData.put(FETCH_MAX_TAG, longValidator.validate(this.getConfig().get(FETCH_MAX_TAG)));
            minFetch = (Long)userData.get(FETCH_MIN_TAG);
            maxFetch = (Long)userData.get(FETCH_MAX_TAG);
        }
        catch (CliCommandoException e) {
            throw new ConfigurationErrorException("Problem with fetch values (" + e.getMessage() + ") - fetch.min: " + this.getConfig().get(FETCH_MIN_TAG) + " fetch.max: " + this.getConfig().get(FETCH_MAX_TAG));
        }
        if (maxFetch <= minFetch) {
            throw new ConfigurationErrorException("fetch.max must be bigger than fetch.max Min: " + minFetch + " Max: " + minFetch);
        }
        String maxRecordsValue = this.getMaxRecordsValue(command);
        Long maxRecords = StringUtils.isEmpty(maxRecordsValue) ? Long.valueOf(Long.MAX_VALUE) : (Long)longValidator.validate(maxRecordsValue);
        userData.put(this.newMaxRecordsTag, maxRecords);
        userData.put(RECORDS_LEFT_KEY, maxRecords);
        String markerResponseXpathTag = this.getConfig().get(MARKER_RESPONSE_XPATH_TAG);
        userData.put(MARKER_RESPONSE_XPATH_TAG, StringUtils.isEmpty(markerResponseXpathTag) ? "//" + this.newMarkerTag : markerResponseXpathTag);
        String displayHeadersTag = this.getConfig().get(SHOWHEADERS_PARAMETER);
        userData.put(SHOWHEADERS_PARAMETER, StringUtils.isEmpty(displayHeadersTag) ? SHOWHEADERS_TAG : displayHeadersTag);
    }

    private void loadFromResponse(Command command) {
        String response = command.getCurrentCommandConfig().getResponse();
        this.newMarkerTag = (String)this.userData.get(MARKER_PARAMETER);
        this.newMaxRecordsTag = (String)this.userData.get(MAXRECORDS_PARAMETER);
        if (StringUtils.isEmpty(response)) {
            this.userData.put(this.newMarkerTag, "");
            return;
        }
        this.userData.put(this.newMarkerTag, this.getMarker(response));
        this.setShowHeaders(command, false);
    }

    private void setupNextIteration(Command command) {
        Long recordsLeft = (Long)this.userData.get(RECORDS_LEFT_KEY);
        Long maxFetch = (Long)this.userData.get(FETCH_MAX_TAG);
        Long minFetch = (Long)this.userData.get(FETCH_MIN_TAG);
        String markerTag = (String)this.userData.get(this.newMarkerTag);
        if (markerTag == null) {
            this.setMaxRecords(command, this.calcNextFetchSize(recordsLeft, minFetch, maxFetch));
            command.setIterate(true);
        } else {
            String maxRecordsValueString = this.getMaxRecordsValue(command);
            if (maxRecordsValueString != null) {
                long lastFetchSize = Long.valueOf(maxRecordsValueString);
                recordsLeft = recordsLeft - lastFetchSize;
                this.userData.put(RECORDS_LEFT_KEY, (long)recordsLeft);
            }
            if (recordsLeft <= 0L) {
                command.setIterate(false);
            } else if (markerTag == "") {
                command.setIterate(false);
            } else {
                this.setMarker(command, markerTag);
                this.setMaxRecords(command, this.calcNextFetchSize(recordsLeft, minFetch, maxFetch));
                command.setIterate(true);
            }
        }
    }

    private void setMarker(Command command, String marker) {
        String markerParamName = (String)this.userData.get(MARKER_PARAMETER);
        command.getCurrentCommandConfig().getParameter(markerParamName).setValue(marker);
    }

    private void setMaxRecords(Command command, long maxRecords) {
        String maxRecordsParamName = (String)this.userData.get(MAXRECORDS_PARAMETER);
        if (command.getCurrentCommandConfig().doesParameterExist(maxRecordsParamName)) {
            command.getCurrentCommandConfig().getParameter(maxRecordsParamName).setValue(String.valueOf(maxRecords));
        }
    }

    private void setShowHeaders(Command command, boolean value) {
        String showHeadersParamName = (String)this.userData.get(SHOWHEADERS_PARAMETER);
        try {
            ParamConfig displayHeaders = command.getCurrentCommandConfig().getParameter(showHeadersParamName);
            displayHeaders.setValue(String.valueOf(value));
        }
        catch (ConfigurationErrorException e) {
            // empty catch block
        }
    }

    private String getMarker(String response) {
        return XmlUtils.getTextFromChildXPath(response, (String)this.userData.get(MARKER_RESPONSE_XPATH_TAG), "");
    }

    private long calcNextFetchSize(long recordsLeft, long minFetch, long maxFetch) {
        long retVal = recordsLeft <= maxFetch ? recordsLeft : (recordsLeft < minFetch + maxFetch ? recordsLeft - minFetch : maxFetch);
        return retVal;
    }

    private String getMaxRecordsValue(Command command) {
        if (command.getCurrentCommandConfig().doesParameterExist(this.newMaxRecordsTag)) {
            return command.getCurrentCommandConfig().getParameter(this.newMaxRecordsTag).getValue();
        }
        return null;
    }
}

