/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.StringUtils;

public class Argv0CommandProcessor
implements CommandProcessor {
    private String[] helpOptions = new String[]{"--help", "-h", "-?", "-help", "help"};
    private String[] versionOptions = new String[]{"--version", "-version", "version"};

    public Command process(Command command) throws CliCommandoException {
        String av0;
        String[] argv = StringUtils.removeEmptyEntries(command.getCommandLineArgs());
        if (this.argsEmpty(argv)) {
            argv = new String[]{"help"};
        }
        if (this.isKnownOption(av0 = argv[0], this.helpOptions)) {
            command.setCommand("help");
            if (argv.length == 2) {
                command.setCommandLineArgs(new String[]{"help", argv[1]});
            } else {
                command.setCommandLineArgs(new String[]{"help"});
            }
            return command;
        }
        if (argv.length > 1 && this.isKnownOption(argv[1], this.helpOptions)) {
            command.setCommand("help");
            command.setCommandLineArgs(new String[]{"help", av0});
            return command;
        }
        if (this.isKnownOption(av0, this.versionOptions)) {
            command.setCommand("version");
            command.setCommandLineArgs(new String[]{"version"});
            return command;
        }
        if (av0.startsWith("-")) {
            throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_COMMAND, av0);
        }
        command.setCommand(av0);
        return command;
    }

    private boolean argsEmpty(String[] str) {
        return str == null || str.length < 1;
    }

    private boolean isKnownOption(String str, String[] args) {
        for (String s : args) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }
}

