#!/usr/bin/perl

use warnings;
use strict;
my %ref;
my $ref=\%ref;
my %strong;
my $strong=\%strong;
my ($type, $add)=("","");
for my $file (glob("*/*/*/*")) {
  open(IN, $file) ;
  while (<IN>) { my $line = $_;
    if ($line=~ /<strong>([^<]+)<\/strong>/) { $strong{$1} .= " $file"};
    next if !($line =~ /gl_keywords=/ || $line =~ /gl_type=/) ;
    $type=$1 if($line=~/gl_type=(.*)/);
    $add =$1 if($line=~/!set gl_keywords=(.*)/);
    chomp $add; chomp $type;
  }
  $type='main' if !($type);
  $ref{$add} .= "$file/$type " if ($add);
  $type="";$add="";
};
my $Text="generated by mkindex.pl\n\n";
while (my ($key, $value) = each(%ref) ) {
  my $s= join(",",sortuniq(split(' ', $value)));
  $Text .= $key . ":" . $s . "\n" ;
}
out("connexe_domain",$Text);

$Text="";
while (my ($key, $value) = each(%strong) ) {
  my $s= join(",",sortuniq(split(' ', $value)));
  $Text .= $key . ":" . $s . "\n" ;
}
out("strong_index",join("\n",sortuniq(split("\n",$Text))));

sub sortuniq {
  my $prev = "not $_[0]";
  grep { $_ ne $prev && ($prev = $_, 1) } sort @_;
}

sub out { my ($bloc, $text) = @_;
  open  (OUT, ">$bloc") ;
  print OUT $text ; close OUT;
}
