///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <scripting/Scripting.h>
#include <scripting/plugins/ScriptPlugin.h>

namespace Scripting {

/******************************************************************************
* Constructor for the ScriptPlugin class.
******************************************************************************/
ScriptPlugin::ScriptPlugin(const QString& manifestFile) :
	Plugin(manifestFile)
{
}

/******************************************************************************
* Parses a custom toplevel element from the manifest that is specific to the plugin type.
******************************************************************************/
bool ScriptPlugin::parseToplevelManifestElement(const QDomElement& element)
{
	// Process the <ScriptPlugin> element that describes the script plugin's characteristics.
	if(element.localName() == "ScriptPlugin") {
		return true;
	}
	return false;
}

/******************************************************************************
* Loads the script plugin.
******************************************************************************/
void ScriptPlugin::loadPluginImpl()
{
}

};
