# -*- coding: utf-8 -*-
"""
importlib was introduced in python2.7, python3.2...
"""

from __future__ import absolute_import
import warnings

# -- DEPRECATED: importlib is either part of python standard library
#   or its requirement (for the backport) is explicitly stated (for Python 2.6)
warnings.warn("DEPRECATED, no longer needed", DeprecationWarning, stacklevel=2)


try:
    from importlib import import_module
except ImportError:
    """Backport of importlib.import_module from 3.x."""
    # While not critical (and in no way guaranteed!), it would be nice to keep this
    # code compatible with Python 2.3.
    from six.moves import range
    import sys

    def _resolve_name(name, package, level):
        """Return the absolute name of the module to be imported."""
        if not hasattr(package, 'rindex'):
            raise ValueError("'package' not set to a string")
        dot = len(package)
        for x in range(level, 1, -1):
            try:
                dot = package.rindex('.', 0, dot)
            except ValueError:
                raise ValueError("attempted relative import beyond top-level "
                                  "package")
        return "%s.%s" % (package[:dot], name)


    def import_module(name, package=None):
        """Import a module.

        The 'package' argument is required when performing a relative import. It
        specifies the package to use as the anchor point from which to resolve the
        relative import to an absolute import.

        """
        if name.startswith('.'):
            if not package:
                raise TypeError("relative imports require the 'package' argument")
            level = 0
            for character in name:
                if character != '.':
                    break
                level += 1
            name = _resolve_name(name[level:], package, level)
        __import__(name)
        return sys.modules[name]
