#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.ScriptElement import ScriptElement
import operator
from functools import reduce

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.3'
__CHEETAH_versionTuple__ = (3, 2, 3, 'final', 0)
__CHEETAH_genTime__ = 1558054970.614274
__CHEETAH_genTimestamp__ = 'Fri May 17 11:02:50 2019'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-3.0.0/xpdeint/Features/Transforms/Basis.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class Basis(ScriptElement):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(Basis, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def costEstimate(self, basisReps, **KWS):



        ## CHEETAH: generated from @def costEstimate(basisReps) at line 31, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        costMultiplier = 4 if VFFSL(SL,"matrixType",True) == 'complex' else 1
        return reduce(operator.mul, [rep.latticeEstimate for rep in basisReps]) * costMultiplier
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimReps(self, forwardDimRep, backwardDimRep, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimReps($forwardDimRep, $backwardDimRep) at line 36, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''_mmt_matrix_forward  = (''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 37, col 25
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 37, col 25.
        write(''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 37, col 58
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 37, col 58.
        write(''') * ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 37, col 73
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 37, col 73.
        write(''' * ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 37, col 106
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 37, col 106.
        write(''');
_mmt_matrix_backward = (''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 38, col 25
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 38, col 25.
        write(''' *)xmds_malloc(sizeof(''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 38, col 58
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 38, col 58.
        write(''') * ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 38, col 73
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 38, col 73.
        write(''' * ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 38, col 107
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 38, col 107.
        write(''');
for (long _i0 = 0; _i0 < ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 39, col 26
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 39, col 26.
        write('''; _i0++) {
  ''')
        _v = VFFSL(SL,"transformMatricesForwardDimConstantsAtIndex",False)(forwardDimRep, backwardDimRep, '_i0') # "${transformMatricesForwardDimConstantsAtIndex(forwardDimRep, backwardDimRep, '_i0'), autoIndent=True}" on line 40, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${transformMatricesForwardDimConstantsAtIndex(forwardDimRep, backwardDimRep, '_i0'), autoIndent=True}")) # from line 40, col 3.
        write('''  for (long _i1 = 0; _i1 < ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 41, col 28
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 41, col 28.
        write('''; _i1++) {
    ''')
        _v = VFFSL(SL,"transformMatricesForDimRepsAtIndices",False)(forwardDimRep, backwardDimRep, '_i0', '_i1') # "${transformMatricesForDimRepsAtIndices(forwardDimRep, backwardDimRep, '_i0', '_i1'), autoIndent=True}" on line 42, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${transformMatricesForDimRepsAtIndices(forwardDimRep, backwardDimRep, '_i0', '_i1'), autoIndent=True}")) # from line 42, col 5.
        write('''  }
}
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForwardDimConstantsAtIndex(self, forwardDimRep, backwardDimRep, index, **KWS):



        ## CHEETAH: generated from @def transformMatricesForwardDimConstantsAtIndex($forwardDimRep, $backwardDimRep, $index) at line 47, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformMatricesForDimRepsAtIndices(self, forwardDimRep, backwardDimRep, forwardIndex, backwardIndex, **KWS):



        ## CHEETAH: generated from @def transformMatricesForDimRepsAtIndices($forwardDimRep, $backwardDimRep, $forwardIndex, $backwardIndex) at line 50, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''_mmt_matrix_forward [''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 52, col 22
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 52, col 22.
        write(''' * ''')
        _v = VFFSL(SL,"forwardDimRep.globalLattice",True) # '${forwardDimRep.globalLattice}' on line 52, col 41
        if _v is not None: write(_filter(_v, rawExpr='${forwardDimRep.globalLattice}')) # from line 52, col 41.
        write(''' + ''')
        _v = VFFSL(SL,"forwardIndex",True) # '${forwardIndex}' on line 52, col 74
        if _v is not None: write(_filter(_v, rawExpr='${forwardIndex}')) # from line 52, col 74.
        write('''] = \\
  ''')
        _v = VFFSL(SL,"forwardMatrixForDimAtIndices",False)(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex) # '${forwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex)}' on line 53, col 3
        if _v is not None: write(_filter(_v, rawExpr='${forwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex)}')) # from line 53, col 3.
        write(''';
_mmt_matrix_backward[''')
        _v = VFFSL(SL,"forwardIndex",True) # '${forwardIndex}' on line 54, col 22
        if _v is not None: write(_filter(_v, rawExpr='${forwardIndex}')) # from line 54, col 22.
        write(''' * ''')
        _v = VFFSL(SL,"backwardDimRep.globalLattice",True) # '${backwardDimRep.globalLattice}' on line 54, col 40
        if _v is not None: write(_filter(_v, rawExpr='${backwardDimRep.globalLattice}')) # from line 54, col 40.
        write(''' + ''')
        _v = VFFSL(SL,"backwardIndex",True) # '${backwardIndex}' on line 54, col 74
        if _v is not None: write(_filter(_v, rawExpr='${backwardIndex}')) # from line 54, col 74.
        write('''] = \\
  ''')
        _v = VFFSL(SL,"backwardMatrixForDimAtIndices",False)(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex) # '${backwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex)}' on line 55, col 3
        if _v is not None: write(_filter(_v, rawExpr='${backwardMatrixForDimAtIndices(forwardDimRep, backwardDimRep, forwardIndex, backwardIndex)}')) # from line 55, col 3.
        write(''';
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def performTransform(self, sourceDimRep, destDimRep, dir=None, **KWS):



        ## CHEETAH: generated from @def performTransform($sourceDimRep, $destDimRep, $dir = None) at line 59, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        blasTypeChar = {'real': {'single': 's', 'double': 'd'}, 'complex': {'single': 'c', 'double': 'z'}}[self.matrixType][VFFSL(SL,"precision",True)]
        matMultFunction = 'cblas_%sgemm' % blasTypeChar
        alphaBetaPrefix = {'real': '', 'complex': '&'}[self.matrixType]
        write('''const ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 64, col 7
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 64, col 7.
        write(''' alpha = 1.0;
const ''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 65, col 7
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 65, col 7.
        write(''' beta = 0.0;
''')
        _v = VFFSL(SL,"matMultFunction",True) # '${matMultFunction}' on line 66, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matMultFunction}')) # from line 66, col 1.
        write('''(
  CblasRowMajor, CblasNoTrans, CblasNoTrans,
  ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 68, col 3
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 68, col 3.
        write(''',
  /* nelem */ innerLoopSize,
  ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 70, col 3
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 70, col 3.
        write(''',
  /* alpha */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 71, col 15
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 71, col 15.
        write('''alpha,
  /* A */ _mmt_matrix_''')
        _v = VFFSL(SL,"dir",True) # '${dir}' on line 72, col 23
        if _v is not None: write(_filter(_v, rawExpr='${dir}')) # from line 72, col 23.
        write(''', ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 72, col 31
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 72, col 31.
        write(''',
  /* B */ source_data + _i0 * innerLoopSize * ''')
        _v = VFFSL(SL,"sourceDimRep.globalLattice",True) # '${sourceDimRep.globalLattice}' on line 73, col 47
        if _v is not None: write(_filter(_v, rawExpr='${sourceDimRep.globalLattice}')) # from line 73, col 47.
        write(''',
          innerLoopSize,
  /* beta */ ''')
        _v = VFFSL(SL,"alphaBetaPrefix",True) # '${alphaBetaPrefix}' on line 75, col 14
        if _v is not None: write(_filter(_v, rawExpr='${alphaBetaPrefix}')) # from line 75, col 14.
        write('''beta,
  /* C */ dest_data + _i0 * innerLoopSize * ''')
        _v = VFFSL(SL,"destDimRep.globalLattice",True) # '${destDimRep.globalLattice}' on line 76, col 45
        if _v is not None: write(_filter(_v, rawExpr='${destDimRep.globalLattice}')) # from line 76, col 45.
        write(''',
  innerLoopSize
);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformFunctionStart(self, **KWS):



        ## CHEETAH: generated from @def transformFunctionStart at line 82, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''static ''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 83, col 8
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 83, col 8.
        write(''' *_mmt_matrix_forward = NULL;
static ''')
        _v = VFFSL(SL,"matrixType",True) # '$matrixType' on line 84, col 8
        if _v is not None: write(_filter(_v, rawExpr='$matrixType')) # from line 84, col 8.
        write(''' *_mmt_matrix_backward = NULL;
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transformFunction(self, transformID, transformDict, function, **KWS):



        ## CHEETAH: generated from @def transformFunction(transformID, transformDict, function) at line 87, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        transformPair = transformDict['transformPair']
        forwardDimRep = transformPair[0][0]
        backwardDimRep = transformPair[1][0]
        write('''static bool _initialised = false;
''')
        _v = VFFSL(SL,"transformFunctionStart",True) # '${transformFunctionStart}' on line 93, col 1
        if _v is not None: write(_filter(_v, rawExpr='${transformFunctionStart}')) # from line 93, col 1.
        write('''ptrdiff_t innerLoopSize = _postfix_lattice;
''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 95, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 95, col 1.
        write('''* const __restrict__ source_data = reinterpret_cast<''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 95, col 66
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 95, col 66.
        write('''* const>(_data_in);
''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 96, col 1
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 96, col 1.
        write('''* const __restrict__ dest_data = reinterpret_cast<''')
        _v = VFFSL(SL,"matrixType",True) # '${matrixType}' on line 96, col 64
        if _v is not None: write(_filter(_v, rawExpr='${matrixType}')) # from line 96, col 64.
        write('''* const>(_data_out);

if (!_initialised) {
  _LOG(_SIMULATION_LOG_LEVEL, "Building matrices for ''')
        _v = VFFSL(SL,"function.description",True) # '${function.description}' on line 99, col 54
        if _v is not None: write(_filter(_v, rawExpr='${function.description}')) # from line 99, col 54.
        write('''...");
  
  ''')
        _v = VFFSL(SL,"transformMatricesForDimReps",False)(VFFSL(SL,"forwardDimRep",True), VFFSL(SL,"backwardDimRep",True)) # '${transformMatricesForDimReps($forwardDimRep, $backwardDimRep), autoIndent=True}' on line 101, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr='${transformMatricesForDimReps($forwardDimRep, $backwardDimRep), autoIndent=True}')) # from line 101, col 3.
        write('''  
  _LOG(_SIMULATION_LOG_LEVEL, " done.\\n");
  _initialised = true;
}

if (_forward) {
  for (long _i0 = 0; _i0 < _prefix_lattice; _i0++) {
    ''')
        _v = VFFSL(SL,"performTransform",False)(forwardDimRep, backwardDimRep, dir='forward') # "${performTransform(forwardDimRep, backwardDimRep, dir='forward'), autoIndent=True}" on line 109, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${performTransform(forwardDimRep, backwardDimRep, dir='forward'), autoIndent=True}")) # from line 109, col 5.
        write('''  }
} else {
  for (long _i0 = 0; _i0 < _prefix_lattice; _i0++) {
    ''')
        _v = VFFSL(SL,"performTransform",False)(backwardDimRep, forwardDimRep, dir='backward') # "${performTransform(backwardDimRep, forwardDimRep, dir='backward'), autoIndent=True}" on line 113, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr="${performTransform(backwardDimRep, forwardDimRep, dir='backward'), autoIndent=True}")) # from line 113, col 5.
        write('''  }
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # Basis.tmpl
        # 
        # Created by Graham Dennis on 2008-12-14.
        # 
        # Copyright (c) 2008-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''







''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    matrixType = 'real'

    supportsInPlaceOperation = False

    _mainCheetahMethod_for_Basis = 'writeBody'

## END CLASS DEFINITION

if not hasattr(Basis, '_initCheetahAttributes'):
    templateAPIClass = getattr(Basis,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(Basis)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=Basis()).run()


