/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.dem;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import org.j3d.loaders.HeightMapSource;
import org.j3d.loaders.dem.DEMTypeARecord;
import org.j3d.loaders.dem.DEMTypeBRecord;
import org.j3d.loaders.dem.DEMTypeCRecord;
import org.j3d.util.CharHashMap;

public class DEMParser
implements HeightMapSource {
    private static CharHashMap processCodes = new CharHashMap(7);
    private static HashMap groundRefCodes;
    private static CharHashMap unitCodes;
    private byte[] buffer = new byte[1024];
    private char[] charBuffer;
    private BufferedInputStream inputStream;
    private BufferedReader inputReader;
    private DEMTypeARecord header;
    private DEMTypeBRecord[] heights;
    private DEMTypeCRecord statistics;
    private float[] gridStepData = new float[2];
    private boolean dataReady = false;
    private boolean hasTypeC;
    private StringBuffer stringBuffer = new StringBuffer();

    public DEMParser() {
    }

    public DEMParser(InputStream inputStream) {
        this();
        this.inputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public DEMParser(Reader reader) {
        this();
        this.inputReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.charBuffer = new char[1024];
    }

    public void clear() {
        this.dataReady = false;
        this.header = null;
        this.heights = null;
        this.statistics = null;
        this.hasTypeC = false;
        this.inputStream = null;
        this.inputReader = null;
        this.charBuffer = null;
    }

    public void reset(InputStream inputStream) {
        this.inputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.dataReady = false;
        this.header = null;
        this.heights = null;
        this.statistics = null;
        this.hasTypeC = false;
        this.inputReader = null;
        this.charBuffer = null;
    }

    public void reset(Reader reader) {
        this.inputReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        if (this.charBuffer == null) {
            this.charBuffer = new char[1024];
        }
        this.dataReady = false;
        this.header = null;
        this.heights = null;
        this.statistics = null;
        this.hasTypeC = false;
        this.inputStream = null;
    }

    public DEMTypeARecord getTypeARecord() {
        return this.header;
    }

    public DEMTypeBRecord[] getTypeBRecords() {
        return this.heights;
    }

    public DEMTypeCRecord getTypeCRecord() {
        return this.statistics;
    }

    public float[][] getHeights() {
        float[][] fArray = null;
        if (this.dataReady) {
            fArray = this.convertHeights();
        }
        return fArray;
    }

    public float[] getGridStep() {
        return this.gridStepData;
    }

    public float[][] parse(boolean bl) throws IOException {
        if (this.dataReady) {
            throw new IOException("Data has already been read from this stream");
        }
        this.parseARecord();
        this.parseBRecords();
        this.parseCRecord();
        float[][] fArray = null;
        if (bl) {
            fArray = this.convertHeights();
        }
        this.gridStepData[0] = this.header.spatialResolution[0];
        this.gridStepData[1] = this.header.spatialResolution[1];
        this.dataReady = true;
        return fArray;
    }

    private void fillBuffer() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.read(this.buffer, 0, 1024);
        } else {
            this.inputReader.read(this.charBuffer, 0, 1024);
            int n = 1024;
            while (--n <= 0) {
                this.buffer[n] = (byte)this.charBuffer[n];
            }
        }
    }

    private void parseARecord() throws IOException {
        this.header = new DEMTypeARecord();
        this.fillBuffer();
        this.header.filename = new String(this.buffer, 0, 40);
        this.header.freeFormatText = new String(this.buffer, 41, 40);
        this.readGeoCoords(110);
        char c = (char)this.buffer[136];
        Integer n = (Integer)processCodes.get(c);
        this.header.processCode = n != null ? n : 0;
        String string = new String(this.buffer, 138, 3).trim();
        if (string.length() != 0) {
            this.header.sectionIndicator = string;
        }
        if ((string = new String(this.buffer, 141, 4).trim()).length() != 0) {
            this.header.originCode = string;
        }
        this.header.levelType = this.readInt(145, 6, 0);
        this.header.elevationPattern = this.readChar(151, 6, '0') == '1';
        string = new String(this.buffer, 157, 6).trim();
        n = (Integer)groundRefCodes.get(string);
        if (n != null) {
            this.header.groundReferenceSystem = n;
        } else {
            System.out.println("Unknown ground reference code " + string);
        }
        if (this.header.groundReferenceSystem != 0) {
            this.header.groundZoneSystem = this.readInt(163, 8, 0);
        }
        if (this.header.groundReferenceSystem >= 2) {
            System.out.println("projection parameter parsing not handled yet");
        }
        n = (Integer)unitCodes.get(this.readChar(529, 6, '0'));
        this.header.groundUnitOfMeasure = n;
        n = (Integer)unitCodes.get(this.readChar(535, 6, '0'));
        this.header.elevationUnitOfMeasure = n;
        this.header.numPolygonSides = this.readInt(541, 6, 4);
        this.header.SWCornerCoords[0] = this.readDouble(547, 24, 0.0);
        this.header.SWCornerCoords[1] = this.readDouble(571, 24, 0.0);
        this.header.NWCornerCoords[0] = this.readDouble(595, 24, 0.0);
        this.header.NWCornerCoords[1] = this.readDouble(619, 24, 0.0);
        this.header.NECornerCoords[0] = this.readDouble(643, 24, 0.0);
        this.header.NECornerCoords[1] = this.readDouble(667, 24, 0.0);
        this.header.SECornerCoords[0] = this.readDouble(691, 24, 0.0);
        this.header.SECornerCoords[1] = this.readDouble(715, 24, 0.0);
        this.header.minHeight = this.readDouble(739, 24, 0.0);
        this.header.maxHeight = this.readDouble(763, 24, 0.0);
        this.header.referenceOrientation = this.readDouble(787, 24, 0.0);
        this.hasTypeC = this.header.hasAccuracy = this.readInt(811, 6, 0) == 1;
        this.header.spatialResolution[0] = this.readInt(817, 12, 0);
        this.header.spatialResolution[1] = this.readInt(817, 12, 0);
        this.header.spatialResolution[2] = this.readFloat(817, 12, 0.0f);
        this.header.numRows = this.readInt(853, 6, 0);
        this.header.numColumns = this.readInt(859, 6, 0);
        this.header.largestContourInterval = this.readInt(865, 5, 0);
        this.header.largestIntervalUnits = this.readInt(870, 1, 0);
        this.header.smallestContourInterval = this.readInt(871, 5, 0);
        this.header.smallestIntervalUnits = this.readInt(876, 1, 0);
        this.header.sourceDate = this.readInt(877, 4, 0);
        this.header.revisionDate = this.readInt(881, 4, 0);
        this.header.inspected = this.readChar(885, 1, '0') == 'I';
        this.header.dataValidated = this.readInt(886, 1, 0);
        this.header.suspectAreas = this.readInt(887, 2, 0);
        this.header.verticalDatum = this.readInt(889, 2, 0);
        this.header.horizontalDatum = this.readInt(891, 2, 0);
        this.header.dataEdition = this.readInt(893, 4, 1);
        if (this.header.suspectAreas >= 2) {
            this.header.percentageVoid = this.readInt(897, 4, 0);
        }
        this.header.edgeMatching = this.readInt(901, 4, 0);
        this.header.verticalDatumShift = this.readFloat(909, 7, 0.0f);
    }

    private void parseBRecords() throws IOException {
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < this.header.numColumns; ++i) {
            this.parseBRecordProfile(linkedList);
        }
        this.heights = new DEMTypeBRecord[linkedList.size()];
        linkedList.toArray(this.heights);
    }

    private void parseBRecordProfile(LinkedList linkedList) throws IOException {
        int n;
        DEMTypeBRecord dEMTypeBRecord = new DEMTypeBRecord();
        dEMTypeBRecord.isDataOnly = false;
        this.fillBuffer();
        dEMTypeBRecord.rowNumber = this.readInt(1, 6, 0);
        dEMTypeBRecord.columnNumber = this.readInt(7, 6, 0);
        dEMTypeBRecord.numRows = this.readInt(13, 6, 0);
        dEMTypeBRecord.numColumns = this.readInt(19, 6, 0);
        dEMTypeBRecord.firstPositionX = this.readDouble(25, 24, 0.0);
        dEMTypeBRecord.firstPositionY = this.readDouble(49, 24, 0.0);
        dEMTypeBRecord.localElevationDatum = this.readDouble(73, 24, 0.0);
        dEMTypeBRecord.minElevation = this.readDouble(97, 24, 0.0);
        dEMTypeBRecord.maxElevation = this.readDouble(121, 24, 0.0);
        int n2 = dEMTypeBRecord.numRows;
        this.readElevations(dEMTypeBRecord, 145, n);
        linkedList.add(dEMTypeBRecord);
        for (int i = n = dEMTypeBRecord.numRows < 146 ? dEMTypeBRecord.numRows : 146; i < n2; i += n) {
            this.fillBuffer();
            dEMTypeBRecord = new DEMTypeBRecord();
            dEMTypeBRecord.isDataOnly = true;
            n = n2 - i < 170 ? n2 - i : 170;
            this.readElevations(dEMTypeBRecord, 0, n);
            linkedList.add(dEMTypeBRecord);
        }
    }

    private void readElevations(DEMTypeBRecord dEMTypeBRecord, int n, int n2) {
        dEMTypeBRecord.elevations = new int[n2];
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            dEMTypeBRecord.elevations[i] = this.readInt(n3, 6, 0);
            n3 += 6;
        }
    }

    private void parseCRecord() throws IOException {
        boolean bl;
        boolean bl2;
        if (!this.hasTypeC) {
            return;
        }
        this.statistics = new DEMTypeCRecord();
        this.fillBuffer();
        boolean bl3 = bl2 = this.readInt(1, 6, 0) == 49;
        if (bl2) {
            this.statistics.absoluteRootMeanSquare = new int[3];
            this.statistics.absoluteRootMeanSquare[0] = this.readInt(7, 6, 0);
            this.statistics.absoluteRootMeanSquare[1] = this.readInt(13, 6, 0);
            this.statistics.absoluteRootMeanSquare[2] = this.readInt(20, 6, 0);
            this.statistics.absoluteSampleSize = this.readInt(25, 6, 0);
        }
        boolean bl4 = bl = this.readInt(31, 6, 0) == 49;
        if (bl) {
            this.statistics.relativeRootMeanSquare = new int[3];
            this.statistics.relativeRootMeanSquare[0] = this.readInt(37, 6, 0);
            this.statistics.relativeRootMeanSquare[1] = this.readInt(43, 6, 0);
            this.statistics.relativeRootMeanSquare[2] = this.readInt(49, 6, 0);
            this.statistics.relativeSampleSize = this.readInt(55, 6, 0);
        }
    }

    private float[][] convertHeights() {
        int n = this.header.numColumns;
        int n2 = 0;
        float[][] fArrayArray = new float[n][];
        float f = this.header.spatialResolution[2];
        for (int i = 0; i < n; ++i) {
            int n3;
            float[] fArray = new float[n];
            int n4 = this.heights[n2].numRows;
            int n5 = 0;
            int n6 = this.heights[n2].elevations.length;
            int[] nArray = this.heights[n2].elevations;
            double d = this.heights[n2].localElevationDatum;
            for (n3 = 0; n3 < n6; ++n3) {
                fArray[n5++] = (float)((double)((float)nArray[n3] * f) + d);
            }
            ++n2;
            while (n5 < n4) {
                nArray = this.heights[n2].elevations;
                d = this.heights[n2].localElevationDatum;
                n6 = this.heights[n2].elevations.length;
                for (n3 = 0; n3 < n6; ++n3) {
                    fArray[n5++] = (float)((double)((float)nArray[n3] * f) + d);
                }
                ++n2;
            }
            fArrayArray[i] = fArray;
        }
        return fArrayArray;
    }

    private void readGeoCoords(int n) throws IOException {
        if (this.buffer[n] == 32) {
            return;
        }
        this.header.southEdge[0] = this.readInt(n, 4, 0);
        this.header.southEdge[1] = this.readInt(n + 4, 2, 0);
        this.header.southEdge[2] = this.readFloat(n + 6, 7, 0.0f);
        this.header.eastEdge[0] = this.readInt(n + 13, 4, 0);
        this.header.eastEdge[1] = this.readInt(n + 17, 2, 0);
        this.header.eastEdge[2] = this.readFloat(n + 19, 7, 0.0f);
    }

    private char readChar(int n, int n2, char c) {
        char c2 = c;
        boolean bl = false;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (this.buffer[i] == 32) continue;
            c2 = (char)this.buffer[i];
            break;
        }
        return c2;
    }

    private int readInt(int n, int n2, int n3) {
        int n4 = n3;
        boolean bl = false;
        int n5 = 0;
        int n6 = n + n2;
        for (int i = n; i < n6; ++i) {
            if (this.buffer[i] == 32) continue;
            char c = (char)this.buffer[i];
            n5 = n5 * 10 + c - 48;
            bl = true;
        }
        if (bl) {
            n4 = n5;
        }
        return n4;
    }

    private long readLong(int n, int n2, long l) {
        long l2 = l;
        boolean bl = false;
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            if (this.buffer[i] == 32) continue;
            char c = (char)this.buffer[i];
            n3 = n3 * 10 + c - 48;
            bl = true;
        }
        if (bl) {
            l2 = n3;
        }
        return l2;
    }

    private double readDouble(int n, int n2, double d) {
        int n3;
        int n4 = n + n2;
        for (n3 = n; n3 < n4 && this.buffer[n3] == 32; ++n3) {
        }
        if (n3 == n4) {
            return d;
        }
        this.stringBuffer.setLength(n4 - n3);
        for (int i = n3; i < n4; ++i) {
            if (this.buffer[i] == 68 || this.buffer[i] == 100) {
                this.stringBuffer.setCharAt(i - n3, 'e');
                continue;
            }
            this.stringBuffer.setCharAt(i - n3, (char)this.buffer[i]);
        }
        try {
            return Double.valueOf(new String(this.stringBuffer));
        }
        catch (Exception exception) {
            return d;
        }
    }

    private float readFloat(int n, int n2, float f) {
        return (float)this.readDouble(n, n2, f);
    }

    private void printBuf(int n, int n2) {
        System.out.println("read \"" + new String(this.buffer, n, n2) + "\"");
    }

    static {
        processCodes.put('1', new Integer(1));
        processCodes.put('2', new Integer(2));
        processCodes.put('3', new Integer(3));
        processCodes.put('4', new Integer(4));
        processCodes.put('5', new Integer(5));
        processCodes.put('6', new Integer(6));
        processCodes.put('7', new Integer(7));
        groundRefCodes = new HashMap(20);
        groundRefCodes.put("0", new Integer(0));
        groundRefCodes.put("1", new Integer(1));
        groundRefCodes.put("2", new Integer(2));
        unitCodes = new CharHashMap(4);
        unitCodes.put('1', new Integer(0));
        unitCodes.put('2', new Integer(2));
        unitCodes.put('3', new Integer(1));
        unitCodes.put('3', new Integer(3));
    }
}

