/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * february 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/vdk.h> 

class NotebookComponent: public VDKBox
{
  VDKNotebook  *book;
  VDKCustomButton *next,*prev,*rotate,*enable;
  VDKCustomList *list;
  VDKEntry *firstname,*address,*city,*phonenumber;
public:
  NotebookComponent(VDKForm* owner):  VDKBox(owner) {}
  ~NotebookComponent() {}
  void Setup();
  bool NextTab(VDKObject* );
  bool PrevTab(VDKObject* );
  bool RotateTab(VDKObject*); 
  bool EnableTab(VDKObject*); 
  void MakePage1();
  void MakePage2();
  bool ListSelection(VDKObject*);
  bool ListUnselection(VDKObject*);
  DECLARE_SIGNAL_MAP(NotebookComponent);
};
