import { SizeForArbitrary } from '../helpers/MaxLengthFromMinLength';
/**
 * Constraints to be applied on typed arrays for integer values
 * @remarks Since 2.9.0
 * @public
 */
export declare type IntArrayConstraints = {
    /**
     * Lower bound of the generated array size
     * @remarks Since 2.9.0
     */
    minLength?: number;
    /**
     * Upper bound of the generated array size
     * @remarks Since 2.9.0
     */
    maxLength?: number;
    /**
     * Lower bound for the generated int (included)
     * @defaultValue smallest possible value for this type
     * @remarks Since 2.9.0
     */
    min?: number;
    /**
     * Upper bound for the generated int (included)
     * @defaultValue highest possible value for this type
     * @remarks Since 2.9.0
     */
    max?: number;
    /**
     * Define how large the generated values should be (at max)
     * @remarks Since 2.22.0
     */
    size?: SizeForArbitrary;
};
