
/* WARNING -- This C source program generated by gwart preprocessor. */
/* Do not edit this file; edit the gwart-format source file instead, */
/* and then run it through gwart to produce a new C source file.     */

/* G P R O T O  --  Protocol module for gkermit  */             /* -*-C-*- */

/*
  Author:
    Frank da Cruz
    The Kermit Project
    Columbia University
    612 West 115th Street
    New York NY 10025-7799  USA
    http://www.columbia.edu/kermit/
    kermit@columbia.edu

  Copyright (C) 1999,
  The Trustees of Columbia University in the City of New York.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include "gkermit.h"

_MYPROTOTYPE( int closof, (void) );	/* Close output file */
_MYPROTOTYPE( VOID errpkt, (char *) );	/* Send Error packet */

extern char * xdata, *rdatap, **cmlist, *cmarg, *rpar(), strbuf[], filnam[];
extern int start, bctu, bctr, delay, cx, cz, failure, attributes, datalen;
extern int streamok, streaming, timint;
extern FILE * db;

static int x;

static VOID
streamon() {				/* Start streaming if negotiated */
    x = 0;
    if (streamok > 0) {
	streaming = 1;
	timint = 0;
    }
}

/* Declare gwart states (like lex) */

#define ssini 1
#define ssfil 2
#define ssdat 3
#define ssatt 4
#define sseot 5
#define sseof 6
#define sipkt 7
#define srini 8
#define srfil 9
#define srdat 10
#define sratt 11

/* Packets are read by the input() function, which returns the packet type */
/* that serves as the input to the state machine, which follows... */


#define BEGIN state =

int state = 0;

int
gwart()
{
    int c,actno;
    extern short tbl[];
    while (1) {
	c = input() - 32;
	if (c < 0 || c > 95) c = 0;
	if ((actno = tbl[c + state*96]) != -1)
	    switch(actno) {
case 1:
    {					/* Start state for Send. */
    tinit();				/* Initialize transaction. */
    if (sinit('S') < 0) { errpkt("sinit"); } /* Build and send the S packet. */
    else BEGIN ssini;
}
    break;
case 2:
    {				/* Receive ACK to I packet */
    spar(rdatap);			/* Set parameters from it */
    bctu = bctr;			/* Switch to negotiated block check */
    if (gnfile() > 0) {			/* Is there a file to send? */
        if (sfile() < 0) {		/* Yes, open it, send F packet, */
	    errpkt("sfile");
	} else {			/* No error */
	    streamon();
	    BEGIN ssfil;
	}
    } else {				/* No files to send, */
        if (seot() < 0) { errpkt("seot"); } /* so send EOT packet. */
        else BEGIN sseot;
    }
}
    break;
case 3:
    {				/* Receive ACK to File header packet */
    if (attributes) {			/* If attributes negotiated */
	if (sattr() < 0) {		/* Send file attributes */
	    errpkt("sattr");
	} else
	  BEGIN ssatt;
    } else if ((x = sdata()) == 0) {	/* Otherwise send first Data packet */
	if (seof("") < 0) {		/* Empty file - send EOF */
	    errpkt("seof");
	} else {
	    BEGIN sseof;
	}
    } else if (x < 0) {			/* Error */
	errpkt("sdata");
    } else {				/* OK - switch to Data state */
	BEGIN ssdat;
    }
}
    break;
case 4:
    {				/* Receive ACK to Attribute packet */
    if (*rdatap == 'N') {		/* Check for refusal */
	seof("D");
	BEGIN sseof;
    } else if ((x = sdata()) == 0) {	/* Otherwise send first Data packet */
	if (seof("") < 0) {		/* Empty file - send EOF */
	    errpkt("seof");
	} else {
	    BEGIN sseof;
	}
    } else if (x < 0) {			/* Error */
	errpkt("sdata");
    } else {				/* OK - switch to Data state */
	BEGIN ssdat;
    }
}
    break;
case 5:
    {				/* Receive ACK to Data packet */
    if (*rdatap == 'X')			/* Check for file cancellation */
      cx = 1;
    else if (*rdatap == 'Z')		/* Check for batch cancellation */
      cz = 1;
    if ((x = sdata()) == 0) {		/* Send data packet if data left. */
	if (seof((cx | cz) ? "D" : "") < 0) { /* If not, send Z packet */
	    errpkt("seof");
	} else {
	    BEGIN sseof;
	}
    } else if (x < 0)			/* Fatal error sending data */
      errpkt("sdata");
}
    break;
case 6:
    {				/* Receive ACK to EOF */
    if (gnfile() > 0) {			/* Get next file from list */
	if (sfile() > 0)
	  BEGIN ssfil;
	else { errpkt("sfile"); }
    } else {				/* No more files */
	seot();				/* Send EOT */
	BEGIN sseot;
    }
}
    break;
case 7:
    { return(failure); }
    break;
case 8:
    { tinit(); rinit(); BEGIN srini; }
    break;
case 9:
    {				/* Receive S packet */
    spar(rdatap);			/* Set parameters from it */
    ack1(rpar());			/* ACK with our parameters */
    bctu = bctr;			/* Switch to negotiated block check */
    streamon();
    BEGIN srfil;			/* Wait for file or EOT */
}
    break;
case 10:
    { ack(); return(failure); }
    break;
case 11:
    {				/* Receive File header packet */
    if (rcvfil() < 0) {
	errpkt("rcvfil");
    } else {
	encstr(filnam);
	ack1(xdata);
	streamon();
	BEGIN sratt;
    }
}
    break;
case 12:
    {				/* Receive Attribute packet */
    if (gattr(rdatap) == 0) {
	ack();
    } else {
	ack1("\"");
    }
}
    break;
case 13:
    {				/* Receive first Data packet */
    if (decode(datalen) < 0) {
	errpkt("Packet decoding error");
    } else {
	ack();
	BEGIN srdat;
    }
}
    break;
case 14:
    {				/* Empty file */
    if (*rdatap == 'D')			/* Check for Discard directive */
      cx = 1;
    if (closof() < 0) {			/* Close the output file */
	errpkt("closof");
    } else {
	ack();				/* Send ACK */
	BEGIN srfil;			/* Wait for another file or EOT */
    }
}
    break;
case 15:
    {				/* Receive Data packet */
    if (decode(datalen) < 0)
      errpkt("Packet decoding error");
    else
      ack();
}
    break;
case 16:
    {				/* Receive EOF packet */
    if (*rdatap == 'D')			/* Check for Discard directive */
      cx = 1;
    if (closof() < 0) {			/* Close the output file */
	errpkt("closof");
    } else {
	ack();				/* Send ACK */
	BEGIN srfil;			/* Wait for another file or EOT */
    }
}
    break;
case 17:
    {					/* Start state for Get */
    tinit();				/* Initialize transaction */
    ginit();				/* Initialize Get */
    sinit('I');				/* Send I packet */
    BEGIN sipkt;
}
    break;
case 18:
    {				/* Receive ACK for I packet */
    spar(rdatap);			/* Set parameters from it */
    if (scmd('R',cmarg) < 0)		/* Send GET packet file filespec */
      errpkt("scmd");
    else
      BEGIN srini;			/* Wait for S packet */
}
    break;
case 19:
    { return(failure = 1); }
    break;
case 20:
    { errpkt("Unknown packet type"); }
    break;

	    }
    }
}

short tbl[] = {
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,  2, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,  3, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,  5, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,  4, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,  7, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20,  6, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 18, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 10, 20, 20, 19, 11, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 15, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 16, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20, 20,
  0, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 12, 20, 20, 13, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 14, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 17,  1, 20, 20,  8, 20, 20, 20, 20, 20, 20, 20, 20,20
};

