//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DevicesClient contains the methods for the Devices group.
// Don't use this type directly, use NewDevicesClient() instead.
type DevicesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewDevicesClient creates a new instance of DevicesClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewDevicesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DevicesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &DevicesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdateAlertSettings - Creates or updates the alert settings
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// alertSettings - The alert settings.
// options - DevicesClientBeginCreateOrUpdateAlertSettingsOptions contains the optional parameters for the DevicesClient.BeginCreateOrUpdateAlertSettings
// method.
func (client *DevicesClient) BeginCreateOrUpdateAlertSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, alertSettings AlertSettings, options *DevicesClientBeginCreateOrUpdateAlertSettingsOptions) (*runtime.Poller[DevicesClientCreateOrUpdateAlertSettingsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateAlertSettings(ctx, deviceName, resourceGroupName, managerName, alertSettings, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientCreateOrUpdateAlertSettingsResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientCreateOrUpdateAlertSettingsResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdateAlertSettings - Creates or updates the alert settings
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) createOrUpdateAlertSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, alertSettings AlertSettings, options *DevicesClientBeginCreateOrUpdateAlertSettingsOptions) (*http.Response, error) {
	req, err := client.createOrUpdateAlertSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, alertSettings, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateAlertSettingsCreateRequest creates the CreateOrUpdateAlertSettings request.
func (client *DevicesClient) createOrUpdateAlertSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, alertSettings AlertSettings, options *DevicesClientBeginCreateOrUpdateAlertSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/alertSettings/default"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, alertSettings)
}

// BeginCreateOrUpdateSecuritySettings - Creates or updates the security settings.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// securitySettings - The security settings.
// options - DevicesClientBeginCreateOrUpdateSecuritySettingsOptions contains the optional parameters for the DevicesClient.BeginCreateOrUpdateSecuritySettings
// method.
func (client *DevicesClient) BeginCreateOrUpdateSecuritySettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, securitySettings SecuritySettings, options *DevicesClientBeginCreateOrUpdateSecuritySettingsOptions) (*runtime.Poller[DevicesClientCreateOrUpdateSecuritySettingsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateSecuritySettings(ctx, deviceName, resourceGroupName, managerName, securitySettings, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientCreateOrUpdateSecuritySettingsResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientCreateOrUpdateSecuritySettingsResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdateSecuritySettings - Creates or updates the security settings.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) createOrUpdateSecuritySettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, securitySettings SecuritySettings, options *DevicesClientBeginCreateOrUpdateSecuritySettingsOptions) (*http.Response, error) {
	req, err := client.createOrUpdateSecuritySettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, securitySettings, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateSecuritySettingsCreateRequest creates the CreateOrUpdateSecuritySettings request.
func (client *DevicesClient) createOrUpdateSecuritySettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, securitySettings SecuritySettings, options *DevicesClientBeginCreateOrUpdateSecuritySettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default/update"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, securitySettings)
}

// BeginDeactivate - Deactivates the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientBeginDeactivateOptions contains the optional parameters for the DevicesClient.BeginDeactivate method.
func (client *DevicesClient) BeginDeactivate(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeactivateOptions) (*runtime.Poller[DevicesClientDeactivateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deactivate(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientDeactivateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientDeactivateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Deactivate - Deactivates the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) deactivate(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeactivateOptions) (*http.Response, error) {
	req, err := client.deactivateCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deactivateCreateRequest creates the Deactivate request.
func (client *DevicesClient) deactivateCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeactivateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/deactivate"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDelete - Deletes the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientBeginDeleteOptions contains the optional parameters for the DevicesClient.BeginDelete method.
func (client *DevicesClient) BeginDelete(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeleteOptions) (*runtime.Poller[DevicesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) deleteOperation(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *DevicesClient) deleteCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDownloadUpdates - Downloads updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientBeginDownloadUpdatesOptions contains the optional parameters for the DevicesClient.BeginDownloadUpdates
// method.
func (client *DevicesClient) BeginDownloadUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDownloadUpdatesOptions) (*runtime.Poller[DevicesClientDownloadUpdatesResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.downloadUpdates(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientDownloadUpdatesResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientDownloadUpdatesResponse](options.ResumeToken, client.pl, nil)
	}
}

// DownloadUpdates - Downloads updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) downloadUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDownloadUpdatesOptions) (*http.Response, error) {
	req, err := client.downloadUpdatesCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// downloadUpdatesCreateRequest creates the DownloadUpdates request.
func (client *DevicesClient) downloadUpdatesCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDownloadUpdatesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/download"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginFailover - Fails over the device to another device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// failoverRequest - The failover request.
// options - DevicesClientBeginFailoverOptions contains the optional parameters for the DevicesClient.BeginFailover method.
func (client *DevicesClient) BeginFailover(ctx context.Context, deviceName string, resourceGroupName string, managerName string, failoverRequest FailoverRequest, options *DevicesClientBeginFailoverOptions) (*runtime.Poller[DevicesClientFailoverResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.failover(ctx, deviceName, resourceGroupName, managerName, failoverRequest, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientFailoverResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientFailoverResponse](options.ResumeToken, client.pl, nil)
	}
}

// Failover - Fails over the device to another device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) failover(ctx context.Context, deviceName string, resourceGroupName string, managerName string, failoverRequest FailoverRequest, options *DevicesClientBeginFailoverOptions) (*http.Response, error) {
	req, err := client.failoverCreateRequest(ctx, deviceName, resourceGroupName, managerName, failoverRequest, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// failoverCreateRequest creates the Failover request.
func (client *DevicesClient) failoverCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, failoverRequest FailoverRequest, options *DevicesClientBeginFailoverOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/failover"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, failoverRequest)
}

// Get - Returns the properties of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientGetOptions contains the optional parameters for the DevicesClient.Get method.
func (client *DevicesClient) Get(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetOptions) (DevicesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DevicesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DevicesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DevicesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *DevicesClient) getCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DevicesClient) getHandleResponse(resp *http.Response) (DevicesClientGetResponse, error) {
	result := DevicesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Device); err != nil {
		return DevicesClientGetResponse{}, err
	}
	return result, nil
}

// GetAlertSettings - Returns the alert settings of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientGetAlertSettingsOptions contains the optional parameters for the DevicesClient.GetAlertSettings
// method.
func (client *DevicesClient) GetAlertSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetAlertSettingsOptions) (DevicesClientGetAlertSettingsResponse, error) {
	req, err := client.getAlertSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DevicesClientGetAlertSettingsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DevicesClientGetAlertSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DevicesClientGetAlertSettingsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAlertSettingsHandleResponse(resp)
}

// getAlertSettingsCreateRequest creates the GetAlertSettings request.
func (client *DevicesClient) getAlertSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetAlertSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/alertSettings/default"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAlertSettingsHandleResponse handles the GetAlertSettings response.
func (client *DevicesClient) getAlertSettingsHandleResponse(resp *http.Response) (DevicesClientGetAlertSettingsResponse, error) {
	result := DevicesClientGetAlertSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertSettings); err != nil {
		return DevicesClientGetAlertSettingsResponse{}, err
	}
	return result, nil
}

// GetNetworkSettings - Returns the network settings of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientGetNetworkSettingsOptions contains the optional parameters for the DevicesClient.GetNetworkSettings
// method.
func (client *DevicesClient) GetNetworkSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetNetworkSettingsOptions) (DevicesClientGetNetworkSettingsResponse, error) {
	req, err := client.getNetworkSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DevicesClientGetNetworkSettingsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DevicesClientGetNetworkSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DevicesClientGetNetworkSettingsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getNetworkSettingsHandleResponse(resp)
}

// getNetworkSettingsCreateRequest creates the GetNetworkSettings request.
func (client *DevicesClient) getNetworkSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetNetworkSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/networkSettings/default"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkSettingsHandleResponse handles the GetNetworkSettings response.
func (client *DevicesClient) getNetworkSettingsHandleResponse(resp *http.Response) (DevicesClientGetNetworkSettingsResponse, error) {
	result := DevicesClientGetNetworkSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkSettings); err != nil {
		return DevicesClientGetNetworkSettingsResponse{}, err
	}
	return result, nil
}

// GetTimeSettings - Returns the time settings of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientGetTimeSettingsOptions contains the optional parameters for the DevicesClient.GetTimeSettings method.
func (client *DevicesClient) GetTimeSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetTimeSettingsOptions) (DevicesClientGetTimeSettingsResponse, error) {
	req, err := client.getTimeSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DevicesClientGetTimeSettingsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DevicesClientGetTimeSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DevicesClientGetTimeSettingsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getTimeSettingsHandleResponse(resp)
}

// getTimeSettingsCreateRequest creates the GetTimeSettings request.
func (client *DevicesClient) getTimeSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetTimeSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/timeSettings/default"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getTimeSettingsHandleResponse handles the GetTimeSettings response.
func (client *DevicesClient) getTimeSettingsHandleResponse(resp *http.Response) (DevicesClientGetTimeSettingsResponse, error) {
	result := DevicesClientGetTimeSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TimeSettings); err != nil {
		return DevicesClientGetTimeSettingsResponse{}, err
	}
	return result, nil
}

// GetUpdateSummary - Returns the update summary of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientGetUpdateSummaryOptions contains the optional parameters for the DevicesClient.GetUpdateSummary
// method.
func (client *DevicesClient) GetUpdateSummary(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetUpdateSummaryOptions) (DevicesClientGetUpdateSummaryResponse, error) {
	req, err := client.getUpdateSummaryCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DevicesClientGetUpdateSummaryResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DevicesClientGetUpdateSummaryResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DevicesClientGetUpdateSummaryResponse{}, runtime.NewResponseError(resp)
	}
	return client.getUpdateSummaryHandleResponse(resp)
}

// getUpdateSummaryCreateRequest creates the GetUpdateSummary request.
func (client *DevicesClient) getUpdateSummaryCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetUpdateSummaryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/updateSummary/default"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getUpdateSummaryHandleResponse handles the GetUpdateSummary response.
func (client *DevicesClient) getUpdateSummaryHandleResponse(resp *http.Response) (DevicesClientGetUpdateSummaryResponse, error) {
	result := DevicesClientGetUpdateSummaryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Updates); err != nil {
		return DevicesClientGetUpdateSummaryResponse{}, err
	}
	return result, nil
}

// BeginInstallUpdates - Installs the updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientBeginInstallUpdatesOptions contains the optional parameters for the DevicesClient.BeginInstallUpdates
// method.
func (client *DevicesClient) BeginInstallUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginInstallUpdatesOptions) (*runtime.Poller[DevicesClientInstallUpdatesResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.installUpdates(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientInstallUpdatesResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientInstallUpdatesResponse](options.ResumeToken, client.pl, nil)
	}
}

// InstallUpdates - Installs the updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) installUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginInstallUpdatesOptions) (*http.Response, error) {
	req, err := client.installUpdatesCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// installUpdatesCreateRequest creates the InstallUpdates request.
func (client *DevicesClient) installUpdatesCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginInstallUpdatesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/install"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// NewListByManagerPager - Retrieves all the devices in a manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientListByManagerOptions contains the optional parameters for the DevicesClient.ListByManager method.
func (client *DevicesClient) NewListByManagerPager(resourceGroupName string, managerName string, options *DevicesClientListByManagerOptions) *runtime.Pager[DevicesClientListByManagerResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListByManagerResponse]{
		More: func(page DevicesClientListByManagerResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListByManagerResponse) (DevicesClientListByManagerResponse, error) {
			req, err := client.listByManagerCreateRequest(ctx, resourceGroupName, managerName, options)
			if err != nil {
				return DevicesClientListByManagerResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DevicesClientListByManagerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListByManagerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByManagerHandleResponse(resp)
		},
	})
}

// listByManagerCreateRequest creates the ListByManager request.
func (client *DevicesClient) listByManagerCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *DevicesClientListByManagerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByManagerHandleResponse handles the ListByManager response.
func (client *DevicesClient) listByManagerHandleResponse(resp *http.Response) (DevicesClientListByManagerResponse, error) {
	result := DevicesClientListByManagerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeviceList); err != nil {
		return DevicesClientListByManagerResponse{}, err
	}
	return result, nil
}

// NewListFailoverTargetPager - Retrieves all the devices which can be used as failover targets for the given device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientListFailoverTargetOptions contains the optional parameters for the DevicesClient.ListFailoverTarget
// method.
func (client *DevicesClient) NewListFailoverTargetPager(deviceName string, resourceGroupName string, managerName string, options *DevicesClientListFailoverTargetOptions) *runtime.Pager[DevicesClientListFailoverTargetResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListFailoverTargetResponse]{
		More: func(page DevicesClientListFailoverTargetResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListFailoverTargetResponse) (DevicesClientListFailoverTargetResponse, error) {
			req, err := client.listFailoverTargetCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return DevicesClientListFailoverTargetResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DevicesClientListFailoverTargetResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListFailoverTargetResponse{}, runtime.NewResponseError(resp)
			}
			return client.listFailoverTargetHandleResponse(resp)
		},
	})
}

// listFailoverTargetCreateRequest creates the ListFailoverTarget request.
func (client *DevicesClient) listFailoverTargetCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientListFailoverTargetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/failoverTargets"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFailoverTargetHandleResponse handles the ListFailoverTarget response.
func (client *DevicesClient) listFailoverTargetHandleResponse(resp *http.Response) (DevicesClientListFailoverTargetResponse, error) {
	result := DevicesClientListFailoverTargetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeviceList); err != nil {
		return DevicesClientListFailoverTargetResponse{}, err
	}
	return result, nil
}

// NewListMetricDefinitionPager - Retrieves metric definition of all metrics aggregated at device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The name of the appliance.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientListMetricDefinitionOptions contains the optional parameters for the DevicesClient.ListMetricDefinition
// method.
func (client *DevicesClient) NewListMetricDefinitionPager(deviceName string, resourceGroupName string, managerName string, options *DevicesClientListMetricDefinitionOptions) *runtime.Pager[DevicesClientListMetricDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListMetricDefinitionResponse]{
		More: func(page DevicesClientListMetricDefinitionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListMetricDefinitionResponse) (DevicesClientListMetricDefinitionResponse, error) {
			req, err := client.listMetricDefinitionCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return DevicesClientListMetricDefinitionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DevicesClientListMetricDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListMetricDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricDefinitionHandleResponse(resp)
		},
	})
}

// listMetricDefinitionCreateRequest creates the ListMetricDefinition request.
func (client *DevicesClient) listMetricDefinitionCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientListMetricDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/metricsDefinitions"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricDefinitionHandleResponse handles the ListMetricDefinition response.
func (client *DevicesClient) listMetricDefinitionHandleResponse(resp *http.Response) (DevicesClientListMetricDefinitionResponse, error) {
	result := DevicesClientListMetricDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionList); err != nil {
		return DevicesClientListMetricDefinitionResponse{}, err
	}
	return result, nil
}

// NewListMetricsPager - Retrieves the device metrics.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The name of the appliance.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientListMetricsOptions contains the optional parameters for the DevicesClient.ListMetrics method.
func (client *DevicesClient) NewListMetricsPager(deviceName string, resourceGroupName string, managerName string, options *DevicesClientListMetricsOptions) *runtime.Pager[DevicesClientListMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListMetricsResponse]{
		More: func(page DevicesClientListMetricsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListMetricsResponse) (DevicesClientListMetricsResponse, error) {
			req, err := client.listMetricsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return DevicesClientListMetricsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return DevicesClientListMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricsHandleResponse(resp)
		},
	})
}

// listMetricsCreateRequest creates the ListMetrics request.
func (client *DevicesClient) listMetricsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientListMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/metrics"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricsHandleResponse handles the ListMetrics response.
func (client *DevicesClient) listMetricsHandleResponse(resp *http.Response) (DevicesClientListMetricsResponse, error) {
	result := DevicesClientListMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricList); err != nil {
		return DevicesClientListMetricsResponse{}, err
	}
	return result, nil
}

// BeginPatch - Patches the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device Name.
// resourceGroupName - The resource group name
// managerName - The manager name
// devicePatch - Patch representation of the device.
// options - DevicesClientBeginPatchOptions contains the optional parameters for the DevicesClient.BeginPatch method.
func (client *DevicesClient) BeginPatch(ctx context.Context, deviceName string, resourceGroupName string, managerName string, devicePatch DevicePatch, options *DevicesClientBeginPatchOptions) (*runtime.Poller[DevicesClientPatchResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.patch(ctx, deviceName, resourceGroupName, managerName, devicePatch, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientPatchResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientPatchResponse](options.ResumeToken, client.pl, nil)
	}
}

// Patch - Patches the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) patch(ctx context.Context, deviceName string, resourceGroupName string, managerName string, devicePatch DevicePatch, options *DevicesClientBeginPatchOptions) (*http.Response, error) {
	req, err := client.patchCreateRequest(ctx, deviceName, resourceGroupName, managerName, devicePatch, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// patchCreateRequest creates the Patch request.
func (client *DevicesClient) patchCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, devicePatch DevicePatch, options *DevicesClientBeginPatchOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, devicePatch)
}

// BeginScanForUpdates - Scans for updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// deviceName - The device name.
// resourceGroupName - The resource group name
// managerName - The manager name
// options - DevicesClientBeginScanForUpdatesOptions contains the optional parameters for the DevicesClient.BeginScanForUpdates
// method.
func (client *DevicesClient) BeginScanForUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginScanForUpdatesOptions) (*runtime.Poller[DevicesClientScanForUpdatesResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.scanForUpdates(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[DevicesClientScanForUpdatesResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[DevicesClientScanForUpdatesResponse](options.ResumeToken, client.pl, nil)
	}
}

// ScanForUpdates - Scans for updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
func (client *DevicesClient) scanForUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginScanForUpdatesOptions) (*http.Response, error) {
	req, err := client.scanForUpdatesCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// scanForUpdatesCreateRequest creates the ScanForUpdates request.
func (client *DevicesClient) scanForUpdatesCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginScanForUpdatesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/scanForUpdates"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
