//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragesync

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointChangeEnumerationActivity.
func (c CloudEndpointChangeEnumerationActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deletesProgressPercent", c.DeletesProgressPercent)
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	populate(objectMap, "minutesRemaining", c.MinutesRemaining)
	populate(objectMap, "operationState", c.OperationState)
	populate(objectMap, "processedDirectoriesCount", c.ProcessedDirectoriesCount)
	populate(objectMap, "processedFilesCount", c.ProcessedFilesCount)
	populate(objectMap, "progressPercent", c.ProgressPercent)
	populateTimeRFC3339(objectMap, "startedTimestamp", c.StartedTimestamp)
	populate(objectMap, "statusCode", c.StatusCode)
	populate(objectMap, "totalCountsState", c.TotalCountsState)
	populate(objectMap, "totalDirectoriesCount", c.TotalDirectoriesCount)
	populate(objectMap, "totalFilesCount", c.TotalFilesCount)
	populate(objectMap, "totalSizeBytes", c.TotalSizeBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointChangeEnumerationActivity.
func (c *CloudEndpointChangeEnumerationActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletesProgressPercent":
			err = unpopulate(val, "DeletesProgressPercent", &c.DeletesProgressPercent)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "minutesRemaining":
			err = unpopulate(val, "MinutesRemaining", &c.MinutesRemaining)
			delete(rawMsg, key)
		case "operationState":
			err = unpopulate(val, "OperationState", &c.OperationState)
			delete(rawMsg, key)
		case "processedDirectoriesCount":
			err = unpopulate(val, "ProcessedDirectoriesCount", &c.ProcessedDirectoriesCount)
			delete(rawMsg, key)
		case "processedFilesCount":
			err = unpopulate(val, "ProcessedFilesCount", &c.ProcessedFilesCount)
			delete(rawMsg, key)
		case "progressPercent":
			err = unpopulate(val, "ProgressPercent", &c.ProgressPercent)
			delete(rawMsg, key)
		case "startedTimestamp":
			err = unpopulateTimeRFC3339(val, "StartedTimestamp", &c.StartedTimestamp)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &c.StatusCode)
			delete(rawMsg, key)
		case "totalCountsState":
			err = unpopulate(val, "TotalCountsState", &c.TotalCountsState)
			delete(rawMsg, key)
		case "totalDirectoriesCount":
			err = unpopulate(val, "TotalDirectoriesCount", &c.TotalDirectoriesCount)
			delete(rawMsg, key)
		case "totalFilesCount":
			err = unpopulate(val, "TotalFilesCount", &c.TotalFilesCount)
			delete(rawMsg, key)
		case "totalSizeBytes":
			err = unpopulate(val, "TotalSizeBytes", &c.TotalSizeBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointChangeEnumerationStatus.
func (c CloudEndpointChangeEnumerationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activity", c.Activity)
	populate(objectMap, "lastEnumerationStatus", c.LastEnumerationStatus)
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointChangeEnumerationStatus.
func (c *CloudEndpointChangeEnumerationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activity":
			err = unpopulate(val, "Activity", &c.Activity)
			delete(rawMsg, key)
		case "lastEnumerationStatus":
			err = unpopulate(val, "LastEnumerationStatus", &c.LastEnumerationStatus)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointLastChangeEnumerationStatus.
func (c CloudEndpointLastChangeEnumerationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "completedTimestamp", c.CompletedTimestamp)
	populate(objectMap, "namespaceDirectoriesCount", c.NamespaceDirectoriesCount)
	populate(objectMap, "namespaceFilesCount", c.NamespaceFilesCount)
	populate(objectMap, "namespaceSizeBytes", c.NamespaceSizeBytes)
	populateTimeRFC3339(objectMap, "nextRunTimestamp", c.NextRunTimestamp)
	populateTimeRFC3339(objectMap, "startedTimestamp", c.StartedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointLastChangeEnumerationStatus.
func (c *CloudEndpointLastChangeEnumerationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedTimestamp":
			err = unpopulateTimeRFC3339(val, "CompletedTimestamp", &c.CompletedTimestamp)
			delete(rawMsg, key)
		case "namespaceDirectoriesCount":
			err = unpopulate(val, "NamespaceDirectoriesCount", &c.NamespaceDirectoriesCount)
			delete(rawMsg, key)
		case "namespaceFilesCount":
			err = unpopulate(val, "NamespaceFilesCount", &c.NamespaceFilesCount)
			delete(rawMsg, key)
		case "namespaceSizeBytes":
			err = unpopulate(val, "NamespaceSizeBytes", &c.NamespaceSizeBytes)
			delete(rawMsg, key)
		case "nextRunTimestamp":
			err = unpopulateTimeRFC3339(val, "NextRunTimestamp", &c.NextRunTimestamp)
			delete(rawMsg, key)
		case "startedTimestamp":
			err = unpopulateTimeRFC3339(val, "StartedTimestamp", &c.StartedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringCachePerformance.
func (c CloudTieringCachePerformance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cacheHitBytes", c.CacheHitBytes)
	populate(objectMap, "cacheHitBytesPercent", c.CacheHitBytesPercent)
	populate(objectMap, "cacheMissBytes", c.CacheMissBytes)
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringCachePerformance.
func (c *CloudTieringCachePerformance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheHitBytes":
			err = unpopulate(val, "CacheHitBytes", &c.CacheHitBytes)
			delete(rawMsg, key)
		case "cacheHitBytesPercent":
			err = unpopulate(val, "CacheHitBytesPercent", &c.CacheHitBytesPercent)
			delete(rawMsg, key)
		case "cacheMissBytes":
			err = unpopulate(val, "CacheMissBytes", &c.CacheMissBytes)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringDatePolicyStatus.
func (c CloudTieringDatePolicyStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	populateTimeRFC3339(objectMap, "tieredFilesMostRecentAccessTimestamp", c.TieredFilesMostRecentAccessTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringDatePolicyStatus.
func (c *CloudTieringDatePolicyStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "tieredFilesMostRecentAccessTimestamp":
			err = unpopulateTimeRFC3339(val, "TieredFilesMostRecentAccessTimestamp", &c.TieredFilesMostRecentAccessTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringFilesNotTiering.
func (c CloudTieringFilesNotTiering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errors", c.Errors)
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	populate(objectMap, "totalFileCount", c.TotalFileCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringFilesNotTiering.
func (c *CloudTieringFilesNotTiering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "totalFileCount":
			err = unpopulate(val, "TotalFileCount", &c.TotalFileCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringSpaceSavings.
func (c CloudTieringSpaceSavings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cachedSizeBytes", c.CachedSizeBytes)
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	populate(objectMap, "spaceSavingsBytes", c.SpaceSavingsBytes)
	populate(objectMap, "spaceSavingsPercent", c.SpaceSavingsPercent)
	populate(objectMap, "totalSizeCloudBytes", c.TotalSizeCloudBytes)
	populate(objectMap, "volumeSizeBytes", c.VolumeSizeBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringSpaceSavings.
func (c *CloudTieringSpaceSavings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cachedSizeBytes":
			err = unpopulate(val, "CachedSizeBytes", &c.CachedSizeBytes)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "spaceSavingsBytes":
			err = unpopulate(val, "SpaceSavingsBytes", &c.SpaceSavingsBytes)
			delete(rawMsg, key)
		case "spaceSavingsPercent":
			err = unpopulate(val, "SpaceSavingsPercent", &c.SpaceSavingsPercent)
			delete(rawMsg, key)
		case "totalSizeCloudBytes":
			err = unpopulate(val, "TotalSizeCloudBytes", &c.TotalSizeCloudBytes)
			delete(rawMsg, key)
		case "volumeSizeBytes":
			err = unpopulate(val, "VolumeSizeBytes", &c.VolumeSizeBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringVolumeFreeSpacePolicyStatus.
func (c CloudTieringVolumeFreeSpacePolicyStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "currentVolumeFreeSpacePercent", c.CurrentVolumeFreeSpacePercent)
	populate(objectMap, "effectiveVolumeFreeSpacePolicy", c.EffectiveVolumeFreeSpacePolicy)
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringVolumeFreeSpacePolicyStatus.
func (c *CloudTieringVolumeFreeSpacePolicyStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentVolumeFreeSpacePercent":
			err = unpopulate(val, "CurrentVolumeFreeSpacePercent", &c.CurrentVolumeFreeSpacePercent)
			delete(rawMsg, key)
		case "effectiveVolumeFreeSpacePolicy":
			err = unpopulate(val, "EffectiveVolumeFreeSpacePolicy", &c.EffectiveVolumeFreeSpacePolicy)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocationOperationStatus.
func (l *LocationOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &l.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &l.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &l.PercentComplete)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &l.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatus.
func (o *OperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostRestoreRequest.
func (p PostRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureFileShareUri", p.AzureFileShareURI)
	populate(objectMap, "failedFileList", p.FailedFileList)
	populate(objectMap, "partition", p.Partition)
	populate(objectMap, "replicaGroup", p.ReplicaGroup)
	populate(objectMap, "requestId", p.RequestID)
	populate(objectMap, "restoreFileSpec", p.RestoreFileSpec)
	populate(objectMap, "sourceAzureFileShareUri", p.SourceAzureFileShareURI)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PreRestoreRequest.
func (p PreRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureFileShareUri", p.AzureFileShareURI)
	populate(objectMap, "backupMetadataPropertyBag", p.BackupMetadataPropertyBag)
	populate(objectMap, "partition", p.Partition)
	populate(objectMap, "pauseWaitForSyncDrainTimePeriodInSeconds", p.PauseWaitForSyncDrainTimePeriodInSeconds)
	populate(objectMap, "replicaGroup", p.ReplicaGroup)
	populate(objectMap, "requestId", p.RequestID)
	populate(objectMap, "restoreFileSpec", p.RestoreFileSpec)
	populate(objectMap, "sourceAzureFileShareUri", p.SourceAzureFileShareURI)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RegisteredServerProperties.
func (r RegisteredServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentVersion", r.AgentVersion)
	populateTimeRFC3339(objectMap, "agentVersionExpirationDate", r.AgentVersionExpirationDate)
	populate(objectMap, "agentVersionStatus", r.AgentVersionStatus)
	populate(objectMap, "clusterId", r.ClusterID)
	populate(objectMap, "clusterName", r.ClusterName)
	populate(objectMap, "discoveryEndpointUri", r.DiscoveryEndpointURI)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "lastHeartBeat", r.LastHeartBeat)
	populate(objectMap, "lastOperationName", r.LastOperationName)
	populate(objectMap, "lastWorkflowId", r.LastWorkflowID)
	populate(objectMap, "managementEndpointUri", r.ManagementEndpointURI)
	populate(objectMap, "monitoringConfiguration", r.MonitoringConfiguration)
	populate(objectMap, "monitoringEndpointUri", r.MonitoringEndpointURI)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "resourceLocation", r.ResourceLocation)
	populate(objectMap, "serverCertificate", r.ServerCertificate)
	populate(objectMap, "serverId", r.ServerID)
	populate(objectMap, "serverManagementErrorCode", r.ServerManagementErrorCode)
	populate(objectMap, "serverName", r.ServerName)
	populate(objectMap, "serverOSVersion", r.ServerOSVersion)
	populate(objectMap, "serverRole", r.ServerRole)
	populate(objectMap, "serviceLocation", r.ServiceLocation)
	populate(objectMap, "storageSyncServiceUid", r.StorageSyncServiceUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegisteredServerProperties.
func (r *RegisteredServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &r.AgentVersion)
			delete(rawMsg, key)
		case "agentVersionExpirationDate":
			err = unpopulateTimeRFC3339(val, "AgentVersionExpirationDate", &r.AgentVersionExpirationDate)
			delete(rawMsg, key)
		case "agentVersionStatus":
			err = unpopulate(val, "AgentVersionStatus", &r.AgentVersionStatus)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &r.ClusterID)
			delete(rawMsg, key)
		case "clusterName":
			err = unpopulate(val, "ClusterName", &r.ClusterName)
			delete(rawMsg, key)
		case "discoveryEndpointUri":
			err = unpopulate(val, "DiscoveryEndpointURI", &r.DiscoveryEndpointURI)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "lastHeartBeat":
			err = unpopulate(val, "LastHeartBeat", &r.LastHeartBeat)
			delete(rawMsg, key)
		case "lastOperationName":
			err = unpopulate(val, "LastOperationName", &r.LastOperationName)
			delete(rawMsg, key)
		case "lastWorkflowId":
			err = unpopulate(val, "LastWorkflowID", &r.LastWorkflowID)
			delete(rawMsg, key)
		case "managementEndpointUri":
			err = unpopulate(val, "ManagementEndpointURI", &r.ManagementEndpointURI)
			delete(rawMsg, key)
		case "monitoringConfiguration":
			err = unpopulate(val, "MonitoringConfiguration", &r.MonitoringConfiguration)
			delete(rawMsg, key)
		case "monitoringEndpointUri":
			err = unpopulate(val, "MonitoringEndpointURI", &r.MonitoringEndpointURI)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &r.ResourceLocation)
			delete(rawMsg, key)
		case "serverCertificate":
			err = unpopulate(val, "ServerCertificate", &r.ServerCertificate)
			delete(rawMsg, key)
		case "serverId":
			err = unpopulate(val, "ServerID", &r.ServerID)
			delete(rawMsg, key)
		case "serverManagementErrorCode":
			err = unpopulate(val, "ServerManagementErrorCode", &r.ServerManagementErrorCode)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &r.ServerName)
			delete(rawMsg, key)
		case "serverOSVersion":
			err = unpopulate(val, "ServerOSVersion", &r.ServerOSVersion)
			delete(rawMsg, key)
		case "serverRole":
			err = unpopulate(val, "ServerRole", &r.ServerRole)
			delete(rawMsg, key)
		case "serviceLocation":
			err = unpopulate(val, "ServiceLocation", &r.ServiceLocation)
			delete(rawMsg, key)
		case "storageSyncServiceUid":
			err = unpopulate(val, "StorageSyncServiceUID", &r.StorageSyncServiceUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointBackgroundDataDownloadActivity.
func (s ServerEndpointBackgroundDataDownloadActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "downloadedBytes", s.DownloadedBytes)
	populate(objectMap, "percentProgress", s.PercentProgress)
	populateTimeRFC3339(objectMap, "startedTimestamp", s.StartedTimestamp)
	populateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointBackgroundDataDownloadActivity.
func (s *ServerEndpointBackgroundDataDownloadActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downloadedBytes":
			err = unpopulate(val, "DownloadedBytes", &s.DownloadedBytes)
			delete(rawMsg, key)
		case "percentProgress":
			err = unpopulate(val, "PercentProgress", &s.PercentProgress)
			delete(rawMsg, key)
		case "startedTimestamp":
			err = unpopulateTimeRFC3339(val, "StartedTimestamp", &s.StartedTimestamp)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointCloudTieringStatus.
func (s ServerEndpointCloudTieringStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cachePerformance", s.CachePerformance)
	populate(objectMap, "datePolicyStatus", s.DatePolicyStatus)
	populate(objectMap, "filesNotTiering", s.FilesNotTiering)
	populate(objectMap, "health", s.Health)
	populateTimeRFC3339(objectMap, "healthLastUpdatedTimestamp", s.HealthLastUpdatedTimestamp)
	populate(objectMap, "lastCloudTieringResult", s.LastCloudTieringResult)
	populateTimeRFC3339(objectMap, "lastSuccessTimestamp", s.LastSuccessTimestamp)
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", s.LastUpdatedTimestamp)
	populate(objectMap, "spaceSavings", s.SpaceSavings)
	populate(objectMap, "volumeFreeSpacePolicyStatus", s.VolumeFreeSpacePolicyStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointCloudTieringStatus.
func (s *ServerEndpointCloudTieringStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cachePerformance":
			err = unpopulate(val, "CachePerformance", &s.CachePerformance)
			delete(rawMsg, key)
		case "datePolicyStatus":
			err = unpopulate(val, "DatePolicyStatus", &s.DatePolicyStatus)
			delete(rawMsg, key)
		case "filesNotTiering":
			err = unpopulate(val, "FilesNotTiering", &s.FilesNotTiering)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &s.Health)
			delete(rawMsg, key)
		case "healthLastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "HealthLastUpdatedTimestamp", &s.HealthLastUpdatedTimestamp)
			delete(rawMsg, key)
		case "lastCloudTieringResult":
			err = unpopulate(val, "LastCloudTieringResult", &s.LastCloudTieringResult)
			delete(rawMsg, key)
		case "lastSuccessTimestamp":
			err = unpopulateTimeRFC3339(val, "LastSuccessTimestamp", &s.LastSuccessTimestamp)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &s.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "spaceSavings":
			err = unpopulate(val, "SpaceSavings", &s.SpaceSavings)
			delete(rawMsg, key)
		case "volumeFreeSpacePolicyStatus":
			err = unpopulate(val, "VolumeFreeSpacePolicyStatus", &s.VolumeFreeSpacePolicyStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointRecallStatus.
func (s ServerEndpointRecallStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", s.LastUpdatedTimestamp)
	populate(objectMap, "recallErrors", s.RecallErrors)
	populate(objectMap, "totalRecallErrorsCount", s.TotalRecallErrorsCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointRecallStatus.
func (s *ServerEndpointRecallStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &s.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "recallErrors":
			err = unpopulate(val, "RecallErrors", &s.RecallErrors)
			delete(rawMsg, key)
		case "totalRecallErrorsCount":
			err = unpopulate(val, "TotalRecallErrorsCount", &s.TotalRecallErrorsCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointSyncActivityStatus.
func (s ServerEndpointSyncActivityStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appliedBytes", s.AppliedBytes)
	populate(objectMap, "appliedItemCount", s.AppliedItemCount)
	populate(objectMap, "perItemErrorCount", s.PerItemErrorCount)
	populate(objectMap, "sessionMinutesRemaining", s.SessionMinutesRemaining)
	populate(objectMap, "syncMode", s.SyncMode)
	populateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	populate(objectMap, "totalBytes", s.TotalBytes)
	populate(objectMap, "totalItemCount", s.TotalItemCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointSyncActivityStatus.
func (s *ServerEndpointSyncActivityStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedBytes":
			err = unpopulate(val, "AppliedBytes", &s.AppliedBytes)
			delete(rawMsg, key)
		case "appliedItemCount":
			err = unpopulate(val, "AppliedItemCount", &s.AppliedItemCount)
			delete(rawMsg, key)
		case "perItemErrorCount":
			err = unpopulate(val, "PerItemErrorCount", &s.PerItemErrorCount)
			delete(rawMsg, key)
		case "sessionMinutesRemaining":
			err = unpopulate(val, "SessionMinutesRemaining", &s.SessionMinutesRemaining)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &s.SyncMode)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		case "totalBytes":
			err = unpopulate(val, "TotalBytes", &s.TotalBytes)
			delete(rawMsg, key)
		case "totalItemCount":
			err = unpopulate(val, "TotalItemCount", &s.TotalItemCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointSyncSessionStatus.
func (s ServerEndpointSyncSessionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "filesNotSyncingErrors", s.FilesNotSyncingErrors)
	populate(objectMap, "lastSyncMode", s.LastSyncMode)
	populate(objectMap, "lastSyncPerItemErrorCount", s.LastSyncPerItemErrorCount)
	populate(objectMap, "lastSyncResult", s.LastSyncResult)
	populateTimeRFC3339(objectMap, "lastSyncSuccessTimestamp", s.LastSyncSuccessTimestamp)
	populateTimeRFC3339(objectMap, "lastSyncTimestamp", s.LastSyncTimestamp)
	populate(objectMap, "persistentFilesNotSyncingCount", s.PersistentFilesNotSyncingCount)
	populate(objectMap, "transientFilesNotSyncingCount", s.TransientFilesNotSyncingCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointSyncSessionStatus.
func (s *ServerEndpointSyncSessionStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filesNotSyncingErrors":
			err = unpopulate(val, "FilesNotSyncingErrors", &s.FilesNotSyncingErrors)
			delete(rawMsg, key)
		case "lastSyncMode":
			err = unpopulate(val, "LastSyncMode", &s.LastSyncMode)
			delete(rawMsg, key)
		case "lastSyncPerItemErrorCount":
			err = unpopulate(val, "LastSyncPerItemErrorCount", &s.LastSyncPerItemErrorCount)
			delete(rawMsg, key)
		case "lastSyncResult":
			err = unpopulate(val, "LastSyncResult", &s.LastSyncResult)
			delete(rawMsg, key)
		case "lastSyncSuccessTimestamp":
			err = unpopulateTimeRFC3339(val, "LastSyncSuccessTimestamp", &s.LastSyncSuccessTimestamp)
			delete(rawMsg, key)
		case "lastSyncTimestamp":
			err = unpopulateTimeRFC3339(val, "LastSyncTimestamp", &s.LastSyncTimestamp)
			delete(rawMsg, key)
		case "persistentFilesNotSyncingCount":
			err = unpopulate(val, "PersistentFilesNotSyncingCount", &s.PersistentFilesNotSyncingCount)
			delete(rawMsg, key)
		case "transientFilesNotSyncingCount":
			err = unpopulate(val, "TransientFilesNotSyncingCount", &s.TransientFilesNotSyncingCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointSyncStatus.
func (s ServerEndpointSyncStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "backgroundDataDownloadActivity", s.BackgroundDataDownloadActivity)
	populate(objectMap, "combinedHealth", s.CombinedHealth)
	populate(objectMap, "downloadActivity", s.DownloadActivity)
	populate(objectMap, "downloadHealth", s.DownloadHealth)
	populate(objectMap, "downloadStatus", s.DownloadStatus)
	populateTimeRFC3339(objectMap, "lastUpdatedTimestamp", s.LastUpdatedTimestamp)
	populate(objectMap, "offlineDataTransferStatus", s.OfflineDataTransferStatus)
	populate(objectMap, "syncActivity", s.SyncActivity)
	populate(objectMap, "totalPersistentFilesNotSyncingCount", s.TotalPersistentFilesNotSyncingCount)
	populate(objectMap, "uploadActivity", s.UploadActivity)
	populate(objectMap, "uploadHealth", s.UploadHealth)
	populate(objectMap, "uploadStatus", s.UploadStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointSyncStatus.
func (s *ServerEndpointSyncStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backgroundDataDownloadActivity":
			err = unpopulate(val, "BackgroundDataDownloadActivity", &s.BackgroundDataDownloadActivity)
			delete(rawMsg, key)
		case "combinedHealth":
			err = unpopulate(val, "CombinedHealth", &s.CombinedHealth)
			delete(rawMsg, key)
		case "downloadActivity":
			err = unpopulate(val, "DownloadActivity", &s.DownloadActivity)
			delete(rawMsg, key)
		case "downloadHealth":
			err = unpopulate(val, "DownloadHealth", &s.DownloadHealth)
			delete(rawMsg, key)
		case "downloadStatus":
			err = unpopulate(val, "DownloadStatus", &s.DownloadStatus)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateTimeRFC3339(val, "LastUpdatedTimestamp", &s.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "offlineDataTransferStatus":
			err = unpopulate(val, "OfflineDataTransferStatus", &s.OfflineDataTransferStatus)
			delete(rawMsg, key)
		case "syncActivity":
			err = unpopulate(val, "SyncActivity", &s.SyncActivity)
			delete(rawMsg, key)
		case "totalPersistentFilesNotSyncingCount":
			err = unpopulate(val, "TotalPersistentFilesNotSyncingCount", &s.TotalPersistentFilesNotSyncingCount)
			delete(rawMsg, key)
		case "uploadActivity":
			err = unpopulate(val, "UploadActivity", &s.UploadActivity)
			delete(rawMsg, key)
		case "uploadHealth":
			err = unpopulate(val, "UploadHealth", &s.UploadHealth)
			delete(rawMsg, key)
		case "uploadStatus":
			err = unpopulate(val, "UploadStatus", &s.UploadStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointUpdateParameters.
func (s ServerEndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceCreateParameters.
func (s ServiceCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProperties.
func (s ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "incomingTrafficPolicy", s.IncomingTrafficPolicy)
	populate(objectMap, "lastOperationName", s.LastOperationName)
	populate(objectMap, "lastWorkflowId", s.LastWorkflowID)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "storageSyncServiceStatus", s.StorageSyncServiceStatus)
	populate(objectMap, "storageSyncServiceUid", s.StorageSyncServiceUID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUpdateParameters.
func (s ServiceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TriggerChangeDetectionParameters.
func (t TriggerChangeDetectionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "changeDetectionMode", t.ChangeDetectionMode)
	populate(objectMap, "directoryPath", t.DirectoryPath)
	populate(objectMap, "paths", t.Paths)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowProperties.
func (w WorkflowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "commandName", w.CommandName)
	populateTimeRFC3339(objectMap, "createdTimestamp", w.CreatedTimestamp)
	populate(objectMap, "lastOperationId", w.LastOperationID)
	populateTimeRFC3339(objectMap, "lastStatusTimestamp", w.LastStatusTimestamp)
	populate(objectMap, "lastStepName", w.LastStepName)
	populate(objectMap, "operation", w.Operation)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "steps", w.Steps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowProperties.
func (w *WorkflowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandName":
			err = unpopulate(val, "CommandName", &w.CommandName)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateTimeRFC3339(val, "CreatedTimestamp", &w.CreatedTimestamp)
			delete(rawMsg, key)
		case "lastOperationId":
			err = unpopulate(val, "LastOperationID", &w.LastOperationID)
			delete(rawMsg, key)
		case "lastStatusTimestamp":
			err = unpopulateTimeRFC3339(val, "LastStatusTimestamp", &w.LastStatusTimestamp)
			delete(rawMsg, key)
		case "lastStepName":
			err = unpopulate(val, "LastStepName", &w.LastStepName)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &w.Operation)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "steps":
			err = unpopulate(val, "Steps", &w.Steps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
