//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrate

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServerCollectorsClient contains the methods for the ServerCollectors group.
// Don't use this type directly, use NewServerCollectorsClient() instead.
type ServerCollectorsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewServerCollectorsClient creates a new instance of ServerCollectorsClient with the specified values.
// subscriptionID - Azure Subscription Id in which project was created.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewServerCollectorsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServerCollectorsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ServerCollectorsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Create - Create or Update Server collector
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-10-01
// resourceGroupName - Name of the Azure Resource Group that project is part of.
// projectName - Name of the Azure Migrate project.
// serverCollectorName - Unique name of a Server collector within a project.
// options - ServerCollectorsClientCreateOptions contains the optional parameters for the ServerCollectorsClient.Create method.
func (client *ServerCollectorsClient) Create(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *ServerCollectorsClientCreateOptions) (ServerCollectorsClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, projectName, serverCollectorName, options)
	if err != nil {
		return ServerCollectorsClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerCollectorsClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ServerCollectorsClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *ServerCollectorsClient) createCreateRequest(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *ServerCollectorsClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/servercollectors/{serverCollectorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	if serverCollectorName == "" {
		return nil, errors.New("parameter serverCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverCollectorName}", url.PathEscape(serverCollectorName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.CollectorBody != nil {
		return req, runtime.MarshalAsJSON(req, *options.CollectorBody)
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *ServerCollectorsClient) createHandleResponse(resp *http.Response) (ServerCollectorsClientCreateResponse, error) {
	result := ServerCollectorsClientCreateResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerCollector); err != nil {
		return ServerCollectorsClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a Server collector from the project.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-10-01
// resourceGroupName - Name of the Azure Resource Group that project is part of.
// projectName - Name of the Azure Migrate project.
// serverCollectorName - Unique name of a Server collector within a project.
// options - ServerCollectorsClientDeleteOptions contains the optional parameters for the ServerCollectorsClient.Delete method.
func (client *ServerCollectorsClient) Delete(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *ServerCollectorsClientDeleteOptions) (ServerCollectorsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, projectName, serverCollectorName, options)
	if err != nil {
		return ServerCollectorsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerCollectorsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ServerCollectorsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteHandleResponse(resp)
}

// deleteCreateRequest creates the Delete request.
func (client *ServerCollectorsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *ServerCollectorsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/servercollectors/{serverCollectorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	if serverCollectorName == "" {
		return nil, errors.New("parameter serverCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverCollectorName}", url.PathEscape(serverCollectorName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *ServerCollectorsClient) deleteHandleResponse(resp *http.Response) (ServerCollectorsClientDeleteResponse, error) {
	result := ServerCollectorsClientDeleteResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	return result, nil
}

// Get - Get a Server collector.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-10-01
// resourceGroupName - Name of the Azure Resource Group that project is part of.
// projectName - Name of the Azure Migrate project.
// serverCollectorName - Unique name of a Server collector within a project.
// options - ServerCollectorsClientGetOptions contains the optional parameters for the ServerCollectorsClient.Get method.
func (client *ServerCollectorsClient) Get(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *ServerCollectorsClientGetOptions) (ServerCollectorsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, projectName, serverCollectorName, options)
	if err != nil {
		return ServerCollectorsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServerCollectorsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServerCollectorsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ServerCollectorsClient) getCreateRequest(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *ServerCollectorsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/servercollectors/{serverCollectorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	if serverCollectorName == "" {
		return nil, errors.New("parameter serverCollectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverCollectorName}", url.PathEscape(serverCollectorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ServerCollectorsClient) getHandleResponse(resp *http.Response) (ServerCollectorsClientGetResponse, error) {
	result := ServerCollectorsClientGetResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerCollector); err != nil {
		return ServerCollectorsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByProjectPager - Get a list of Server collector.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-10-01
// resourceGroupName - Name of the Azure Resource Group that project is part of.
// projectName - Name of the Azure Migrate project.
// options - ServerCollectorsClientListByProjectOptions contains the optional parameters for the ServerCollectorsClient.ListByProject
// method.
func (client *ServerCollectorsClient) NewListByProjectPager(resourceGroupName string, projectName string, options *ServerCollectorsClientListByProjectOptions) *runtime.Pager[ServerCollectorsClientListByProjectResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServerCollectorsClientListByProjectResponse]{
		More: func(page ServerCollectorsClientListByProjectResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ServerCollectorsClientListByProjectResponse) (ServerCollectorsClientListByProjectResponse, error) {
			req, err := client.listByProjectCreateRequest(ctx, resourceGroupName, projectName, options)
			if err != nil {
				return ServerCollectorsClientListByProjectResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ServerCollectorsClientListByProjectResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ServerCollectorsClientListByProjectResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByProjectHandleResponse(resp)
		},
	})
}

// listByProjectCreateRequest creates the ListByProject request.
func (client *ServerCollectorsClient) listByProjectCreateRequest(ctx context.Context, resourceGroupName string, projectName string, options *ServerCollectorsClientListByProjectOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/servercollectors"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByProjectHandleResponse handles the ListByProject response.
func (client *ServerCollectorsClient) listByProjectHandleResponse(resp *http.Response) (ServerCollectorsClientListByProjectResponse, error) {
	result := ServerCollectorsClientListByProjectResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.XMSRequestID = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerCollectorList); err != nil {
		return ServerCollectorsClientListByProjectResponse{}, err
	}
	return result, nil
}
