# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=6.2.0 --output=unicodedb_6_2_0 --base=unicodedb_5_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_5_2_0 as base_mod
version = '6.2.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x05 AND '
'\x0f AND COLD SWEAT'
'\r AND YEN SIGN'
'\x06 BLOCK'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x04 CAR'
'\n CHARACTER'
'\x06 CHART'
'\x0b DECORATION'
'\x07 ENGINE'
'\x06 EPOCH'
'\x05 FACE'
'\x06 FACE '
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x0e IN SILHOUETTE'
'\x06 LARGE'
'\t LEERAEWA'
'\x0b LOCOMOTIVE'
'\x08 LUGGAGE'
'\x07 MAELEE'
'\x07 MAEMBA'
'\x05 MARK'
'\x05 MFON'
'\x07 MUOMAE'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x08 OF FOOD'
'\x04 ORE'
'\x0f OVER MOUNTAINS'
'\x02 P'
'\x04 POT'
'\x08 SATCHEL'
'\x04 SET'
'\x06 SEVEN'
'\t SPARKLER'
'\x05 STOP'
'\x05 TABS'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x16 WITH DECORATIVE COVER'
'\t WITH DOT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\n WITH FACE'
'\x17 WITH HALF-CIRCLE BELOW'
'\r WITH INK PEN'
'\x1b WITH LEFTWARDS ARROW ABOVE'
'\x14 WITH OBLIQUE STROKE'
'\x12 WITH SMILING EYES'
'\x12 WITH VERTICAL BAR'
'\x08 YUQ NAE'
'\x01-'
'\x02-2'
'\t-AMMONIAC'
'\x0b-COPPER ORE'
'\x08-EM DASH'
'\x0c-MAIL SYMBOL'
'\x0f-NO-EVIL MONKEY'
'\x07-SHIFT-'
'\x06-SHIRT'
'\x07-THIRTY'
'\x010'
'\x011'
'\x012'
'\x03272'
'\x013'
'\x014'
'\x03408'
'\x015'
'\x03533'
'\x035B6'
'\x016'
'\x017'
'\x0270'
'\x018'
'\x019'
'\x03981'
'\x01A'
'\x02A '
'\x06A MFON'
'\x05A YUE'
'\x03A7A'
'\x02AA'
'\x03AAM'
'\x05AAMAE'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\nABATA TREE'
'\x11ABBREVIATION SIGN'
'\x05ABIC '
'\x11ABLE WATER SYMBOL'
'\x05ABOVE'
'\tABULATION'
'\x1eAC SUBLINEAR COLON SKEWED LEFT'
'\x07ACE OF '
'\x03ACK'
'\x04ACK '
'\x0bACKNOWLEDGE'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x02AD'
'\x02AE'
'\rAE WITH GRAVE'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x04AGON'
'\x02AH'
'\x05AHMI '
'\x03AIN'
'\x04AIN '
'\x02AK'
'\x03AK '
'\x0cAKAARAANSAYA'
'\x06AKEUAE'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x03ALE'
'\x04ALF '
'\x05ALGAR'
'\x04ALL '
'\x03ALO'
'\x02AM'
'\x04AMBA'
'\x07AME DIE'
'\x03AMI'
'\rAMMA WITH DOT'
'\x1dAMOND SHAPE WITH A DOT INSIDE'
'\x0bAMUSED FACE'
'\x02AN'
'\x03ANA'
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\tANGE BOOK'
'\x05ANGEL'
'\tANGGEUAET'
'\x07ANGKUOQ'
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x08ANGULAR '
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUSVARA'
'\x03AO '
'\x02AP'
'\x04APAQ'
'\x03APE'
'\x03APP'
'\rAPPED PRESENT'
'\x05APPLE'
'\x02AQ'
'\x02AR'
'\x04ARAE'
'\x08ARCASITE'
'\nARCHAIC YE'
'\x03ARD'
'\x07ARDSMAN'
'\nARFUL FACE'
'\tARM CLOCK'
'\rARRED TRIDENT'
'\x05ARROW'
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\nASPIRATION'
'\x12ASTED SWEET POTATO'
'\x02AT'
'\nAT ON BONE'
'\x13ATED TELLER MACHINE'
'\x07ATH OF '
'\x14ATIN CAPITAL LETTER '
'\x07AU MARK'
'\nAUTOMOBILE'
'\x08AVAGRAHA'
'\x17AVOURING DELICIOUS FOOD'
'\x02AW'
'\x02AY'
'\x08AY-NIGHT'
'\x0bAYING CARD '
'\x01B'
'\x02B '
'\x02BA'
'\nBA SATANGA'
'\x08BACKWARD'
'\x03BAG'
'\x03BAH'
'\x04BALL'
'\x04BAYI'
'\x02BB'
'\x04BBIT'
'\x04BBON'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\x03BEH'
'\x16BEH WITH SMALL V BELOW'
'\x05BELOW'
'\x08BER POLE'
'\x07BERGINE'
'\x06BETAN '
'\x07BETWEEN'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\nBILE PHONE'
'\x06BISCUS'
'\x16BKA- SHOG GI MGO RGYAN'
'\x0eBLE CURLY LOOP'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\nBLOND HAIR'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x04BOOK'
'\x05BOOTS'
'\x06BOTTLE'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x0cBRATION MODE'
'\x11BRIGHTNESS SYMBOL'
'\x03BSP'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x04BUNG'
'\x06BURGER'
'\x03BUS'
'\x11BUT RELIEVED FACE'
'\x02BY'
'\x01C'
'\x02C '
'\x06C SIGN'
'\nC WITH BAR'
'\x02CA'
'\x0cCABBAGE-TREE'
'\x08CABLEWAY'
'\x03CAH'
'\x05CAKRA'
'\x04CALL'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x0bCANDRABINDU'
'\x07CAP TEN'
'\x15CAPITAL H WITH STROKE'
'\x0fCAPITAL LETTER '
'\x1cCAPITAL LETTER BOHAIRIC KHEI'
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CCEPT'
'\x04CCHH'
'\x02CE'
'\x03CE '
'\x08CE CREAM'
'\x03CEL'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x02CH'
'\nCH BALLOON'
'\x03CHA'
'\x14CHARACTER INTRODUCER'
'$CHED LEFT SEMICIRCLE WITH THREE DOTS'
'\x08CHEIKHAN'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHICK'
'\x03CHO'
'\rCHRONOUS IDLE'
'\nCHWA WITH '
'\x0cCIDUOUS TREE'
'\x06CIRCLE'
'\x1dCIRCLED LATIN CAPITAL LETTER '
'\x02CK'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\x04CKET'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x0bCLOSED EYES'
'\x06CLOSET'
'\x07CLOTHES'
'\x05CLUBS'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\nCOMBINING '
'\x07COMING '
'\x0fCOMING ENVELOPE'
'\x05COMMA'
'\nCONSONANT '
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x18CONSONANT SIGN PASANGAN '
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x10CREAMING IN FEAR'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\nCROSS MARK'
'\x0cCROSS POMMEE'
'\x06CTOPUS'
'\x04CTOR'
'\x06CTRIC '
'\x05CTURE'
'\x04CTUS'
'\rCULATED LORRY'
'\x12CUP WITHOUT HANDLE'
'\x06CURLY '
'\tCURSIVE L'
'\nCY MESSAGE'
'\x04CYCL'
'\x10CYRILLIC LETTER '
'\x01D'
'\x02D '
'\x07D APPLE'
'\x07D CHIME'
'\x07D INDEX'
'\x06D SIGN'
'\x02DA'
'\nDA SATANGA'
'\x03DAA'
'\x03DAD'
'\x06DAGGER'
'\x03DAH'
'\x05DAIC '
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANESE '
'\x0bDASH SYMBOL'
'\x05DBOAT'
'\x02DD'
'\x05DDING'
'\nDECORATION'
'\x03DEN'
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDESCENDER'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x02DF'
'\x04DGER'
'\x02DH'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x04DIC '
'\x0eDIFIER LETTER '
'\x06DIGIT '
'\x0eDING CHARACTER'
'\x03DIO'
'\x04DISC'
'\x08DIT CARD'
'\x05DLING'
'\x02DO'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DOT'
'\tDOT ABOVE'
'\x08DOT REPH'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x1bDOUBLE INVERTED BREVE BELOW'
'\x0fDOUBLE TRIANGLE'
'\x04DOWN'
'\x1cDOWN POINTING BACKHAND INDEX'
'\tDOWN SIGN'
'\x1dDOWN-POINTING DOUBLE TRIANGLE'
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS TREND'
'\x06DPHONE'
'\x04DRAM'
'\x05DRINK'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x06DUCEUS'
'\x08DUSHENNA'
'\x08DVANTAGE'
'\x02DY'
'\tDY BEETLE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E GLASS'
'\x05E OF '
'\x08E OF POO'
'\x0bE WITH VEIL'
'\x03E80'
'\x02EA'
'\x07EAD ORE'
'\x03EAM'
'\x04EANS'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EBOOK'
'\x0bECTION MARK'
'\x08ED BRICK'
'\x08ED FLAGS'
'\x07ED RICE'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEM'
'\x03EEN'
'\x04EEN '
'\x03EEP'
'\x05EESHI'
'\x03EET'
'\x06EFCASE'
'\x02EH'
'\x0cEH WITH LOOP'
'\x02EI'
'\x05EIGHT'
'\tEIGHT OF '
'\x06EIGHTH'
'\x05EKEET'
'\x0cELECTED AREA'
'\x0bELLOW HEART'
'\x04ELVE'
'\x02EM'
'\x05EMBIC'
'\x02EN'
'\x03EN '
'\x08EN NTEUM'
'\x06EN OF '
'\x04ENCH'
'\nENCH FRIES'
'\rENCY EXCHANGE'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\nENS SYMBOL'
'\x07ENSHUET'
'\nENTRY SIGN'
'\x04ENTY'
'\x05EOPLE'
'\x08EPARATOR'
'\x05EPAYA'
'\x02EQ'
'\x02ER'
'\x08ER BOARD'
'\x06ER MUG'
'\tER SYMBOL'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\rERIAL TRAMWAY'
'\x0fERICAN FOOTBALL'
'\x0fERING MEGAPHONE'
'\x05ERSE '
'\x03ERT'
'\x03ERU'
'\x02ES'
';ESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRACKET'
'\x03ESS'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\x03ETE'
'\x0bETEI MAYEK '
'\x06ETTER '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\x04EVEN'
'\x08EVEN OF '
'\x0cEVERING FACE'
'\x02EW'
'\x02EX'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0bEXED BICEPS'
'\x03EXT'
'\x06EXTRA-'
'\x02EY'
'\x03EY '
'\x01F'
'\x02F '
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\tFACING UP'
'\x10FALLING DIAGONAL'
'\x05FATHA'
'\x0bFATHA WITH '
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x04FEED'
'\x03FEH'
"'FEH WITH DOT BELOW AND THREE DOTS ABOVE"
'\x04FEUQ'
'\x0eFFICE BUILDING'
'\x0bFILE FOLDER'
'\x07FINAGH '
'\x06FINAL '
'\x04FIRE'
'\x04FIRI'
'\x04FISH'
'\x04FIST'
'\x0cFLAG ON POST'
'\x06FLOWER'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\nFORMATION '
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x04FOUR'
'\nFOUR DOTS '
'\x04FREE'
'\x08FROWNING'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT ICE CREAM'
'\x03FTY'
'\x03FUE'
'\x01G'
'\x06G FACE'
'\x02GA'
'\x03GAA'
'\x03GAH'
'\x12GALI LETTER KHINYA'
'\x04GAME'
'\x07GATIVE '
'\x02GB'
'\x05GBASA'
'\x06GBASAQ'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x02GE'
'\x0bGE AT NIGHT'
' GEMINATION AND VOWEL LENGTH MARK'
'\x0fGEMINATION MARK'
'\x03GEN'
'\x03GER'
'\x06GERINE'
'\x0bGGAGE CLAIM'
'\nGGER WITH '
'\x03GGY'
'\x02GH'
'\x05GHAIN'
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x03GHT'
'\x08GHT RAIL'
'\x04GHT-'
'\x13GIBBOUS MOON SYMBOL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x02GJ'
'\x07GLASSES'
'\x03GLE'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x05GRAVE'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x04GUIN'
'\x05GULUS'
'\x01H'
'\x0bH WITH HOOK'
'\x02HA'
'\x03HAA'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x14HALA CONSONANT SIGN '
'\x04HALF'
'\x05HALQA'
'\x0bHAMZA ABOVE'
'\x04HAND'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x03HAQ'
'\tHARD SIGN'
'\x03HAT'
'\x02HE'
'\x07HEADING'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x10HEAVY CHECK MARK'
'\x0bHEELED SHOE'
'\x04HEEN'
'\x03HEH'
'\x05HEUAE'
'\x06HEUAEP'
'\x02HH'
'\x03HHA'
'\x02HI'
'\rHIEROGLYPHIC '
'\x1fHIGH EXTRA-LOW CONTOUR TONE BAR'
'\x12HILOSOPHERS SULFUR'
'\x07HIOPIC '
'\x07HIUCHUS'
'\x05HMER '
'\x12HOOKED SCHWA WITH '
'\x04HOOL'
'\x04HOST'
'\x05HOTEL'
'\x04HREE'
'\nHREE DOTS '
'\x08HREE OF '
'\x05HROOM'
'\x04HUET'
'\x07HUNDRED'
'\x02HY'
'\x01I'
'\x0eI AND SKI BOOT'
'\x07I NTEUM'
'\x19I SYLLABLE ITERATION MARK'
'\tIAL LINE '
'\x0eIAN RUPEE SIGN'
'\x05ICAL '
'\x0cICE CONTROL '
'\x0cICE OF PIZZA'
'3ICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x0bIDEOGRAPH A'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x1bIERSTRASS ELLIPTIC FUNCTION'
'\x03IES'
'\x04IGHT'
'\nIGHT RULER'
'\x0fIGHT WITH STARS'
'\x05IGIT '
'\x04IGN '
'\x15IGN INVERTED MCHU CAN'
'\nIGN SAMVAT'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03IKA'
'\x02IL'
'\tIL POLISH'
'\x05ILED '
'\x04ILET'
'\x05ILVER'
'\nIMALUNGUN '
'\x05IMGBA'
'\x03IMN'
'\x02IN'
'\tINARBORAS'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x05INDEX'
'\x04INDI'
'\x03INE'
'\x04ING '
'\x08ING BOWL'
'\x0eING HANDS SIGN'
'\tING HEART'
'\x07ING OF '
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x08INITIAL '
'\x07INNABAR'
'\x04INU '
'\x11INVERTED MCHU CAN'
'\x03ION'
'\x02IP'
'\x02IQ'
'\x02IR'
'\nIRAL SHELL'
'\x05IRAMA'
'\x05IRCUT'
'\x03IRL'
'\x04IRON'
'\x04IRTY'
'\x02IS'
'\x03ISA'
'\nISMUTH ORE'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x02IT'
'\nIT MBAAKET'
'\x0cIT SEPARATOR'
'\x08ITA MFON'
'\x04ITAR'
'\x04ITE '
'\x03IVE'
'\x07IVE OF '
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IX'
'\x06IX OF '
'\rIYA FRACTION '
'\x04IYAQ'
'\tIZONTAL T'
'\x01J'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x03JAM'
'\x18JARATI ABBREVIATION SIGN'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x0bJIHVAMULIYA'
'\x1eJK COMPATIBILITY IDEOGRAPH-FA2'
'\x15JK UNIFIED IDEOGRAPH-'
'\x05JUDUL'
'\x01K'
'\x0bK AND KNIFE'
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x08K SYMBOL'
'\x15K WITH OBLIQUE STROKE'
'\x02KA'
'\nKA SATANGA'
'\x03KAD'
'\x03KAH'
'\x04KALI'
'\x03KAQ'
'\x05KARO '
'\x07KARO BA'
'\x0cKASHMIRI YEH'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\tKATAKANA '
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x04KHAH'
'\x05KHMU '
'\nKINDI MVOP'
'\tKING FACE'
'\x04KINI'
'\x0eKISH LIRA SIGN'
'\x04KMA '
'\x04KOKO'
'\x03KOM'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x04KRI '
'\x03KUE'
'\x05KWAEN'
'\tKYO TOWER'
'\x01L'
'\x1eL WITH RETROFLEX HOOK AND BELT'
'\x02LA'
'\x03LAA'
'\x0bLABIAL SIGN'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\x03LAH'
'\x03LAM'
'\x13LAM WITH DOUBLE BAR'
'\x14LASHING SWEAT SYMBOL'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x03LAW'
'\x0fLAYALAM LETTER '
'\x0bLCE TSA CAN'
'\tLD TAMIL '
'\x05LDER '
'\x0eLDREN CROSSING'
'\x02LE'
'\x03LE '
'\x13LEADING MCHAN RTAGS'
'\x04LED '
'\x05LEERI'
'\x03LEF'
'\nLEFT GUARD'
'\x1cLEFT POINTING BACKHAND INDEX'
'\x1dLEFT-POINTING DOUBLE TRIANGLE'
'\x06LENDAR'
'\x06LETTER'
'\x07LETTER '
'\x1dLETTER SMALL CAPITAL TURNED M'
'\x08LETTER Y'
'\x07LETTERS'
'\x03LEU'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x07LF FACE'
'\x0fLF SECTION SIGN'
'\x04LFUR'
'\x02LH'
'\x11LHOUETTE OF JAPAN'
'\x05LICE '
'\x08LICOPTER'
'\x0bLIEVED FACE'
'\nLIGHT BULB'
'\x04LINE'
'\tLINE FEED'
'\x05LING '
'\x03LIP'
'\x07LKY WAY'
'\tLLEN LEAF'
'\x0cLLER COASTER'
'\x07LLEYBUS'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x05LLOON'
'\x07LM TREE'
'\x02LO'
'\x04LOCK'
'\rLOCK WITH KEY'
'\x03LON'
'\x0fLOOK OF TRIUMPH'
'\x05LOOP '
'\x04LOW '
'\x1fLOW EXTRA-HIGH CONTOUR TONE BAR'
'\x0cLOWERED FLAG'
'\x05LPHIN'
'\x14LTIPLE MUSICAL NOTES'
'\x08LTRY LEG'
'\x05LURAL'
'\x08LWAY CAR'
'\x02LX'
'\x07LY LOOP'
'\x01M'
'\x06M FEED'
'\x0cM NSHUT NYAM'
'\x07M STONE'
'\x02MA'
'\x03MAA'
'\x07MAAYYAA'
'\x0bMACING FACE'
'\tMAEMGBIEE'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x06MALGAM'
'\rMALL HIGH WAW'
'\x0cMALL LETTER '
'\x03MAN'
'\x04MARK'
'\x05MARK '
'\x04MARY'
'\x07MASSAGE'
'\rMATHEMATICAL '
'\x04MATO'
'\x03MBA'
'\x08MBINING '
'\x08MCHU CAN'
'\x08ME BADGE'
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x06MEDIUM'
'\x04MEEM'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x1aMEEM WITH THREE DOTS ABOVE'
'\x05MELON'
'\x11MEN HOLDING HANDS'
'\x10MENIAN DRAM SIGN'
'\x03MER'
'\tMER CLOCK'
'\x04MERA'
'\x07MERICAS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x04MIL '
'\x0bMILING EYES'
'\x04MILY'
'\nMINUS SIGN'
'\x02MO'
'\rMOBILE PHONES'
'\x03MON'
'\x04MONO'
'\x05MOON '
'\x02MP'
'\x05MSHAE'
'\x03MSP'
'\x04MUCH'
'\x11MUM LETTER PHASE-'
'\x08MY HOUSE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x07N WITH '
'\x16N-POTABLE WATER SYMBOL'
'\x02NA'
'\x08NA METEK'
'\x03NAA'
'\x04NBOW'
'\x04NBSP'
'\x05NCESS'
'\x08NDA FACE'
'\nNDA PA NJI'
'\tNDAILING '
'\x05NDBAG'
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x04NED '
'\x05NEGAR'
'\x04NEMA'
'\x03NEY'
'\x02NG'
'\x03NGE'
'\x04NGUE'
'\x02NI'
'\tNIGHT OF '
'\x04NINE'
'\x08NINE OF '
'\x05NING '
'\x04NJAM'
'\x03NJI'
'\x0fNKING BEER MUGS'
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x11NNADA LETTER LLLA'
'\x06NNING '
'\x15NNIS RACQUET AND BALL'
'\x04NNNA'
'\x0fNO GOOD GESTURE'
'\x04NOON'
'\x04NOSE'
'\x04NOTE'
'\nNOTE WITH '
'\x08NOWLEDGE'
'\tNS SYMBOL'
'\x06NSANAQ'
'\x05NSIEE'
'\x05NSUAE'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\tNTESSENCE'
'\x0bNTIMONY ORE'
'\x05NUKTA'
'\x07NUMBER '
'\x07NUMBERS'
'\x07NUSVARA'
'\x03NYI'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\tO LETTER '
'\x06O MARK'
'\x04OALA'
'\x03OAP'
'\x03OAT'
'\x05OBILE'
'\x0eOBLIQUE STROKE'
'\x07OCALIC '
'\x08OCK SALT'
'\x0bOCOLATE BAR'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x08ODESTONE'
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x03OFF'
'\x07OFFICER'
'\x04OFUM'
'\x07OGICAL '
'\x08OGOGRAM '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x03OIL'
'\x02OK'
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x06OLCANO'
'\x03OLD'
'\x04OLIN'
'\nOLLAR SIGN'
'\rOLVING HEARTS'
'\x02OM'
'\x08OM NTEUM'
'\x04OMBU'
'\x05OMEGA'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\tON TEUAEQ'
'\x0cON US SYMBOL'
'\x13ON VIEWING CEREMONY'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x03ONE'
'\x04ONE '
'\x08ONE DOT '
'\x0eONE SOUND WAVE'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x07ONGONAN'
'\x03ONI'
'\x0cONISHED FACE'
'\x04ONTH'
'\x07ONTIEEN'
'\x03OOL'
'\x06OOPED '
'\x02OP'
'\nOP NKAARAE'
'\x05OPARD'
'\x05OPEN '
'\nOPEN MOUTH'
'\x0cOPEN O WITH '
'\tOPERATOR '
'\x06OPPER '
'\x07OPWATCH'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x05ORAIL'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\rORD SEPARATOR'
'\x03ORE'
'\x07ORGIAN '
'\x04ORNS'
'\nORTHERN TA'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\tOTIFIED E'
'\nOTING STAR'
'\x07OTLESS '
'\x08OTPRINTS'
'\x04OTUS'
'\x0bOUBLE DANDA'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\x03OUR'
'\x07OUR OF '
'\x0bOUSEL HORSE'
'\x03OUT'
'\tOUT MOUTH'
'\nOUTHERN TA'
'\x0cOUTING WHALE'
'\tOWBOARDER'
'\nOWEL SIGN '
'\x01P'
'\x02P '
'\x07P PIEET'
'\nP STREAMER'
'\x0bP-POINTING '
'\x02PA'
'\rPA NJI PIPAEM'
'\x03PAH'
'\x08PAKPAK E'
'\x03PAN'
'\x07PANESE '
'\x05PARAQ'
'\x0ePARTMENT STORE'
'\x06PBOARD'
'\x0bPEDESTRIANS'
'\tPEN MOUTH'
'\x0fPENSION RAILWAY'
'\x07PERCLIP'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x05PHANT'
'\x05PHONE'
'\x0ePHONE RECEIVER'
'\x06PICKET'
'\x05PIRIT'
'\tPLE HEART'
'\x08PLE LEAF'
'\x04PLET'
'\x19PLICATION PROGRAM COMMAND'
'\x04PLUG'
'\tPLUS SIGN'
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\nPOLICE CAR'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x03POQ'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x11PRESSIONLESS FACE'
'\x0ePROTECTED AREA'
'\x06PSTICK'
'\x05PTIC '
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x03PUQ'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x01Q'
'\x02QA'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x03QUA'
'\x07QUARED '
'\x07QUARTER'
'\x08QUARTERS'
'\tQUEEN OF '
'\x0bQUERED FLAG'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUI'
'\x01R'
'\x06R FACE'
'\x15R WITH OBLIQUE STROKE'
'\x0eR-OFF CALENDAR'
'\x02RA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x05RADA '
'\x03RAE'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x07RAILWAY'
'\x0bRAISED FLAG'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAMA'
'\x0bRANSMISSION'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\tREAK HERE'
'\x11REATIONAL VEHICLE'
'\nRECIPITATE'
'\x08RECT HIT'
'\nRED CIRCLE'
'\x08RED FACE'
'\x0cRED TRIANGLE'
'\x03REE'
'\x0bREE-EM DASH'
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x06REMEDY'
'\x03REU'
'\x0cREVERSED TSE'
'\x04RFER'
'\x04RGE '
'\x18RGLASS WITH FLOWING SAND'
'\x02RI'
'\x0cRIAGE RETURN'
'\x06RIBBON'
'\x04RICE'
'\x04RICK'
'\x06RIDENT'
'\x05RIEEN'
'\x04RIFY'
'\x05RIGHT'
'\x10RIGHT ARROWHEAD '
'\x0bRIGHT GUARD'
'\x1dRIGHT POINTING BACKHAND INDEX'
'\x0fRIGHT-POINTING '
'+RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x03RII'
'\x07RILLIC '
'\x04RING'
'\x04RISE'
'\x0fRISING DIAGONAL'
'\x0cRISTMAS TREE'
'\nRKING FACE'
'\x03RKL'
'\x03RMT'
'\x02RO'
'\x07ROITIC '
'\x04ROLL'
'\x03ROM'
'\x1bRONOMICAL SYMBOL FOR URANUS'
'\x14ROTATED ARDHAVISARGA'
'\nROUNDED ER'
'\x02RR'
'\x03RRA'
'\nRRIED FACE'
'\nRRIS WHEEL'
'\x08RSE DUNG'
'\x06RSENIC'
'\x02RT'
'\x06RT OF '
'\x06RTCAKE'
'\x08RTICAL T'
'\x03RTY'
'\x02RU'
'\x05RULER'
'\x02RY'
'\x07RY FACE'
'\x01S'
'\x02S '
'\x0fS IN SILHOUETTE'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x15S WITH OBLIQUE STROKE'
'\x02SA'
'\x03SAA'
'\x03SAH'
'\nSALIZATION'
'\x08SALT OF '
'\x06SANDAL'
'\x0bSAPPOINTED '
'\x05SARGA'
'\x02SC'
'\nSCENT MOON'
'\x05SCOPE'
'\x05SCORE'
'\x02SE'
'\x03SE '
'\x04SED '
'\rSELECTED AREA'
'\tSEMICOLON'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x02SH'
'\tSH SYMBOL'
'\x03SHA'
'\x04SHAE'
'\tSHED FACE'
'\x04SHES'
'\x13SHHA WITH DESCENDER'
'\x07SHIFT T'
'\x05SHPIN'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x04SIGN'
'\x05SIGN '
'\x0bSIGN VIRAMA'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\tSIVE FACE'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x11SKETBALL AND HOOP'
'\rSMALL LETTER '
'\x1aSMALL LETTER BOHAIRIC KHEI'
'\rSMALL LETTERS'
'\x11SMALL LIGATURE OE'
'\x12SMALL RED TRIANGLE'
'\nSMALL TAH '
'\x0cSMILING EYES'
'\x0eSMOKING SYMBOL'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x05SOLVE'
'\x03SOS'
'\x02SP'
'\x05SPACE'
'\x06SPADES'
'\x06SPAPER'
'\x0bSPEED TRAIN'
'\x06SPITAL'
'\rSQUARE BUTTON'
'\x08SQUARED '
'\x02SS'
'\rSSAGE WAITING'
'\x04SSOM'
'\x0eSSPORT CONTROL'
'\x02ST'
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\tSTAL BALL'
'\tSTER FACE'
'\x07STITUTE'
'\x05STNUT'
'\x04STOL'
'\x06STRING'
'\x06STROOM'
'\nSTRUCTION '
'\x10STUCK-OUT TONGUE'
'\x05SURYA'
'\x08SWIMMING'
'\tSYLLABLE '
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02TA'
'\x0eTA LINK ESCAPE'
'\nTABULATION'
'\x06TAGRAM'
'\x03TAH'
'\x17TAH WITH TWO DOTS ABOVE'
'\x0eTAKANA LETTER '
'\x03TAN'
'\x04TAXI'
'\x0cTCHING CHICK'
'\rTE ORDER MARK'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\rTED HAND SIGN'
'\x03TEE'
'\x03TEL'
'\x0fTELLITE ANTENNA'
'\x03TER'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\tTH GLOBE '
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x0cTHLETIC SHOE'
'\x08THOUSAND'
'\x06THREE '
'\x11THREE SOUND WAVES'
'\x0fTHROWING A KISS'
'\x02TI'
'\nTICAL DISC'
'\x0bTIEE SHEUOQ'
'\x13TIGHTLY-CLOSED EYES'
'\x04TILL'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\x03TLE'
'\x06TLESS '
'\x06TO BOX'
'\x03TOM'
'\x05TONE '
'\x11TONE CANDRA ABOVE'
'\tTOP RIGHT'
'\x05TORCH'
'\x04TORT'
'\x04TORY'
'\x14TRAILING MCHAN RTAGS'
'\x14TRATERRESTRIAL ALIEN'
'\x03TRE'
'\nTREFACTION'
'\tTRETCHED '
'\x0bTRIAN CAMEL'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x05TRING'
'\x05TRIOL'
'\x03TRO'
'\x18TROL SEQUENCE INTRODUCER'
'\x02TT'
'\x05TTER '
'\x03TTH'
'\x04TTTA'
'\x03TUB'
'\x06TURBAN'
'\x08TURNED H'
'\x0eTURNED V WITH '
'\x03TWO'
'\tTWO DOTS '
'\x02TY'
'\x0fTYSCAPE AT DUSK'
'\x01U'
'\x02U '
'\x06U MBIT'
'\x07U-BRJGU'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x0eUBJOINED SIGN '
'\x08UBLE DOT'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\x16UBSCRIPT SMALL LETTER '
'\x06UCIBLE'
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x02UH'
'\x04UIRY'
'\x0bUISHED FACE'
'\x08UKEUTNDA'
'\x03ULL'
'\tULL MOON '
'\x02UM'
'\x08UMBRELLA'
'\x05UMBS '
'\x05UMPET'
'\x02UN'
'\x07UN MEUT'
'\x0bUND PUSHPIN'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\x02UO'
'\x03UOM'
'\x03UOQ'
'\x02UP'
'\x1aUP POINTING BACKHAND INDEX'
'\x0cUP SEPARATOR'
'\x07UP SIGN'
'\x18UP WITH EXCLAMATION MARK'
'\x1bUP-POINTING DOUBLE TRIANGLE'
'\x0bUPADHMANIYA'
'\x0fUPLE WITH HEART'
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\x0eUR LEAF CLOVER'
'\x05URINE'
'\nURIPIGMENT'
'\x06URNAMA'
'\x08UROPEAN '
'\x07US TENT'
'\tUSED FACE'
'\nUSHED FACE'
'\x07USHENNA'
'\x02UT'
'\x04UTAE'
'\nUTBOX TRAY'
'\x05UTEUX'
'\nUTRAL FACE'
'\x04UTTY'
'\x02UU'
'\x02UX'
'\x01V'
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x07VAPOURS'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VED ICE'
'\x03VEE'
'!VELOPE WITH DOWNWARDS ARROW ABOVE'
'\x0eVENIENCE STORE'
'\rVERGREEN TREE'
'\x10VERTED PENTAGRAM'
'\x0bVERTICALLY '
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x02VI'
'\nVIE CAMERA'
'\x0eVING HAND SIGN'
'\x07VISARGA'
'\x06VISION'
'\x05VITAE'
'\x02VO'
'\x08VOCALIC '
'\x11VOCALIZATION MARK'
'\x07VOICING'
'\x03VOP'
'\x11VOWEL LENGTH MARK'
'\x0bVOWEL SIGN '
'\x02VS'
'\x04VUEQ'
'\x03VY '
'\x01W'
'\x13W BRIGHTNESS SYMBOL'
'\x08W PRINTS'
'\x02WA'
'\x03WAA'
'\x04WAEN'
'\x04WAET'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\x13WAW WITH DOT WITHIN'
'\x06WBERRY'
'\x05WBOAT'
'\x02WC'
'\x04WDER'
'\x03WER'
'\x11WER PLAYING CARDS'
'\x05WFISH'
'\x0bWHITE JOKER'
'\x06WIMMER'
'\nWING HEART'
'\tWING STAR'
'\x0bWINKING EYE'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\tWITH CURL'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x05WLING'
'\x02WN'
'\x0cWN-POINTING '
'\x1aWNING FACE WITH OPEN MOUTH'
'\x02WO'
'\x08WO DOTS '
'\x06WO OF '
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x14WORD REPETITION MARK'
'\x04WORK'
'\x06WORKER'
'\tWRY SMILE'
'\x05WUAET'
'\x01X'
'\tX MACHINE'
'\x1eX POINTED STAR WITH MIDDLE DOT'
'\x02XA'
'\x02XI'
'\x05XING '
'\x07XOPHONE'
'\x07XT LINE'
'\x01Y'
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x03YAI'
'\x07YANSAYA'
'\x02YE'
'\x03YEE'
'\x03YEH'
'\x1cYEH WITH TWO DOTS BELOW AND '
'\x08YEN SIGN'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x10YIR MKPARAQ MEUN'
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\x02YN'
'\x02YO'
'\x01Z'
'\x02ZA'
'\x03ZAH'
'\x0eZAKAYA LANTERN'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x04ZERO'
'\x02ZW'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[66678,
 -63711,
 -1,
 131991,
 838,
 -1,
 197428,
 74074,
 -1,
 262370,
 135010,
 -1,
 327744,
 205173,
 -1,
 393247,
 267292,
 -1,
 458767,
 334628,
 -1,
 524298,
 406388,
 -1,
 -65527,
 468671,
 92598,
 -1,
 532367,
 92619,
 720909,
 463316,
 -1,
 -65524,
 669944,
 92543,
 -1,
 721957,
 92553,
 983039,
 656198,
 92531,
 -1,
 853273,
 92601,
 1048600,
 398364,
 -1,
 1114132,
 996212,
 -1,
 -65518,
 1059240,
 92550,
 -65517,
 1124031,
 92624,
 -1,
 1180765,
 92563,
 1441791,
 1052512,
 -1,
 1441815,
 1323912,
 92607,
 -1,
 1388623,
 92535,
 -1,
 1380326,
 92557,
 1638426,
 996232,
 92640,
 -1,
 1585231,
 92657,
 1769501,
 1581898,
 -1,
 -65508,
 1714402,
 92544,
 -1,
 1779391,
 92541,
 -65506,
 1708586,
 92579,
 -1,
 1901382,
 92658,
 2097193,
 330998,
 -1,
 2162725,
 2032454,
 -1,
 2228260,
 2097992,
 -1,
 -65501,
 2174725,
 92562,
 -1,
 2236780,
 92637,
 -1,
 2172607,
 92518,
 2490408,
 2103132,
 -1,
 -65497,
 2435298,
 92558,
 -1,
 2491921,
 92592,
 -1,
 2438265,
 92528,
 2752559,
 2038416,
 -1,
 2818094,
 2690912,
 -1,
 2883629,
 2756448,
 92628,
 -1,
 2818168,
 92648,
 -1,
 2831829,
 92547,
 -1,
 2753583,
 92554,
 3145780,
 2698675,
 -1,
 3211315,
 3093364,
 -1,
 -65486,
 3155240,
 92527,
 -1,
 3215200,
 92545,
 -1,
 3151906,
 92540,
 3473463,
 3095013,
 -1,
 -65482,
 3421508,
 92609,
 -1,
 3474961,
 92583,
 3670074,
 3422646,
 -1,
 -65479,
 3607361,
 92589,
 -1,
 3671982,
 92608,
 3866685,
 3616847,
 -1,
 -65476,
 3814497,
 92604,
 -1,
 3868141,
 92622,
 4063295,
 3801926,
 92662,
 -1,
 4001632,
 92613,
 -1,
 4004941,
 92584,
 4259928,
 272063,
 -1,
 4325447,
 4207476,
 92576,
 4390981,
 4260678,
 -1,
 -65468,
 4335842,
 92618,
 -1,
 4394848,
 92529,
 -65466,
 4333455,
 92561,
 -1,
 4525920,
 92649,
 4718669,
 4260678,
 -1,
 4784202,
 4653894,
 92524,
 -1,
 4726671,
 92536,
 4980735,
 4718925,
 -1,
 -65460,
 4857717,
 92634,
 -1,
 4919509,
 92625,
 5111889,
 4659036,
 92663,
 5242879,
 5050208,
 -1,
 -65456,
 5124175,
 92621,
 -1,
 5181674,
 92593,
 5374038,
 5050208,
 -1,
 5439573,
 5321588,
 -1,
 -65452,
 5388536,
 92647,
 -1,
 5451855,
 92605,
 -1,
 5378143,
 92548,
 5767167,
 5317450,
 92568,
 -1,
 5645414,
 92610,
 5832811,
 4202383,
 -1,
 5898334,
 5768006,
 92667,
 5963868,
 5836640,
 92600,
 -1,
 5906319,
 92542,
 -65443,
 5908706,
 92668,
 -1,
 6039231,
 92555,
 6226016,
 5838684,
 92654,
 -1,
 6164451,
 92611,
 6357091,
 6165584,
 -1,
 -65438,
 6295656,
 92581,
 -1,
 6357830,
 92551,
 6553702,
 6293340,
 -1,
 -65435,
 6501473,
 92520,
 -1,
 6557536,
 92582,
 -65433,
 6502011,
 92617,
 -65432,
 6697864,
 92614,
 -65431,
 6759526,
 92671,
 -65430,
 6820665,
 92591,
 -1,
 6885480,
 92666,
 7078014,
 5779535,
 -1,
 7143538,
 7013190,
 -1,
 7209071,
 7078726,
 92635,
 -1,
 7153890,
 92577,
 -65424,
 7153890,
 92636,
 -65423,
 7282575,
 92530,
 -1,
 7344239,
 92559,
 7536758,
 7091060,
 -1,
 7602293,
 7479183,
 92586,
 -1,
 7537684,
 92569,
 -1,
 7537684,
 92566,
 7798906,
 7480138,
 -1,
 7864441,
 7742282,
 92537,
 -1,
 7807349,
 92519,
 -1,
 7809250,
 92630,
 8126463,
 7737184,
 -1,
 8126589,
 8008564,
 92669,
 -1,
 8062035,
 92572,
 -1,
 8069493,
 92672,
 8323216,
 7027007,
 -1,
 8388740,
 8270708,
 -1,
 -65407,
 8333538,
 92644,
 -65406,
 8397173,
 92645,
 -65405,
 8458474,
 92594,
 -1,
 8520764,
 92641,
 8716425,
 8327636,
 -1,
 8781959,
 8651796,
 92567,
 -1,
 8728655,
 92623,
 -65400,
 8730872,
 92639,
 -1,
 8855439,
 92606,
 9044108,
 8660342,
 -1,
 -65397,
 8990708,
 92642,
 -1,
 9047081,
 92643,
 9240719,
 8984412,
 -1,
 -65394,
 9187407,
 92590,
 -1,
 9244643,
 92564,
 -1,
 9176557,
 92588,
 9502876,
 8268990,
 -1,
 9568406,
 9442736,
 -1,
 9633940,
 9511754,
 92659,
 -1,
 9578722,
 92660,
 -65387,
 9574845,
 92638,
 -1,
 9703926,
 92580,
 9896089,
 9506656,
 -1,
 -65384,
 9842767,
 92560,
 -1,
 9899872,
 92534,
 -65382,
 9843601,
 92571,
 -65381,
 10036293,
 92525,
 -1,
 10093404,
 92549,
 10289321,
 9444483,
 -1,
 10354851,
 10232650,
 -1,
 10420385,
 10298186,
 -1,
 -65376,
 10367055,
 92556,
 -1,
 10428789,
 92523,
 -65374,
 10365154,
 92664,
 -1,
 10559375,
 92539,
 10748071,
 10289990,
 -1,
 -65371,
 10692834,
 92633,
 -65370,
 10757823,
 92521,
 -1,
 10814729,
 92575,
 -65368,
 10695540,
 92653,
 -1,
 10949091,
 92595,
 11141302,
 10230564,
 -1,
 11206830,
 11088756,
 -1,
 -65364,
 11153487,
 92620,
 -65363,
 11216168,
 92538,
 -1,
 11276707,
 92587,
 11468979,
 11145056,
 -1,
 11534514,
 11416436,
 -1,
 -65359,
 11483384,
 92646,
 -1,
 11535380,
 92570,
 -1,
 11481167,
 92599,
 -65356,
 11413339,
 92532,
 -65355,
 11739978,
 92665,
 -1,
 11802460,
 92670,
 11993282,
 11080367,
 -1,
 12058814,
 11940724,
 -1,
 12124348,
 11993088,
 -1,
 -65350,
 12069598,
 92661,
 -65349,
 12130140,
 92616,
 -1,
 12192045,
 92626,
 12451839,
 12062560,
 92596,
 -1,
 12333135,
 92612,
 12517568,
 11993926,
 92603,
 -1,
 12462306,
 92673,
 -65343,
 12461125,
 92627,
 -1,
 12586979,
 92651,
 12779727,
 11932700,
 -1,
 12845260,
 12719536,
 -1,
 12910794,
 12783456,
 -1,
 12976329,
 12858228,
 -1,
 -65337,
 12925176,
 92552,
 -65336,
 12984693,
 92565,
 -1,
 13042708,
 92615,
 -1,
 12922959,
 92602,
 -65333,
 12854341,
 92674,
 -1,
 13239139,
 92578,
 13500415,
 12781404,
 -1,
 -65330,
 13383125,
 92597,
 -1,
 13447247,
 92585,
 13631701,
 12724570,
 -1,
 13697235,
 13566790,
 -1,
 -65326,
 13641954,
 92526,
 -1,
 13700960,
 92656,
 -65324,
 13637851,
 92546,
 -1,
 13832786,
 92655,
 14024922,
 13580033,
 -1,
 14090457,
 13972340,
 -1,
 -65320,
 14033738,
 92533,
 -1,
 14094176,
 92650,
 -1,
 14029394,
 92574,
 14352607,
 13972952,
 -1,
 14418142,
 14290784,
 -1,
 -65315,
 14365576,
 92573,
 -1,
 14421856,
 92652,
 -1,
 14361669,
 92522,
 -65312,
 14295882,
 92631,
 -65311,
 14620508,
 92632,
 -1,
 14680902,
 92629,
 14877065,
 199928,
 -1,
 14942487,
 14819701,
 -1,
 15007989,
 14881820,
 -1,
 15073517,
 14949156,
 -1,
 15139049,
 15012308,
 -1,
 -65304,
 15084313,
 92432,
 -1,
 15139923,
 92457,
 -65302,
 15088000,
 92435,
 -65301,
 15283321,
 92412,
 -65300,
 15341602,
 92476,
 -1,
 15402477,
 92414,
 15663103,
 15012892,
 -1,
 15663346,
 15532870,
 -1,
 15728881,
 15598857,
 92465,
 -1,
 15664148,
 92409,
 -1,
 15673023,
 92483,
 -65293,
 15611687,
 92467,
 -65292,
 15873194,
 92485,
 -1,
 15929938,
 92475,
 16122109,
 14949008,
 -1,
 16187640,
 16062300,
 92403,
 -1,
 16125923,
 92405,
 16318715,
 16126420,
 -1,
 -65286,
 16265295,
 92407,
 -1,
 16319525,
 92430,
 -65284,
 16266290,
 92487,
 -1,
 16451053,
 92418,
 16646405,
 16067774,
 -1,
 16711937,
 16586786,
 -1,
 -65280,
 16658511,
 92459,
 -1,
 16721599,
 92447,
 16908548,
 16651696,
 -1,
 -65277,
 16856489,
 92486,
 -1,
 16912355,
 92408,
 -1,
 16856161,
 92480,
 17170698,
 16595263,
 -1,
 -65273,
 17118227,
 92463,
 -65272,
 17176412,
 92493,
 -65271,
 17240483,
 92450,
 -1,
 17302793,
 92410,
 17498384,
 17108214,
 -1,
 17563918,
 17436512,
 -1,
 -65267,
 17511893,
 92425,
 -1,
 17567584,
 92437,
 -65265,
 17507430,
 92440,
 -1,
 17696009,
 92471,
 17891605,
 17444943,
 -1,
 17957140,
 17829728,
 -1,
 -65261,
 17904737,
 92472,
 -1,
 17960800,
 92505,
 -1,
 17905106,
 92514,
 -65258,
 17838964,
 92503,
 -1,
 18159452,
 92507,
 18350386,
 14884751,
 92497,
 18415903,
 18289327,
 -1,
 18481435,
 18359114,
 92445,
 -1,
 18424181,
 92404,
 18612510,
 18420180,
 -1,
 -65251,
 18559055,
 92424,
 -1,
 18613268,
 92458,
 -1,
 18552866,
 92466,
 18874659,
 18355280,
 -1,
 -65247,
 18818003,
 92438,
 -65246,
 18880546,
 92444,
 -1,
 18944521,
 92442,
 19136808,
 18812768,
 -1,
 19202343,
 19084148,
 -1,
 -65242,
 19148879,
 92427,
 -1,
 19210613,
 92478,
 -1,
 19140582,
 92496,
 19464492,
 19072801,
 -1,
 19530027,
 19399516,
 92448,
 -1,
 19464547,
 92515,
 -1,
 19477671,
 92401,
 19726639,
 19399494,
 -1,
 -65234,
 19668347,
 92426,
 -1,
 19730589,
 92482,
 -65232,
 19674835,
 92510,
 -65231,
 19870580,
 92499,
 -1,
 19932415,
 92441,
 20119877,
 18295998,
 -1,
 20185404,
 20059568,
 -1,
 20250937,
 20123488,
 -1,
 20316472,
 20198260,
 -1,
 -65225,
 20265208,
 92501,
 -1,
 20317204,
 92417,
 -1,
 20254560,
 92413,
 -65222,
 20198260,
 92504,
 -65221,
 20522355,
 92508,
 -1,
 20584619,
 92500,
 20775232,
 20132724,
 -1,
 -65218,
 20722548,
 92498,
 -65217,
 20778848,
 92419,
 -1,
 20841492,
 92473,
 21037379,
 20710214,
 -1,
 -65214,
 20981986,
 92516,
 -1,
 21046975,
 92423,
 -65212,
 20981210,
 92452,
 -1,
 21172726,
 92428,
 21365075,
 20060964,
 -1,
 21430605,
 21303136,
 -1,
 21496140,
 21377908,
 -1,
 -65207,
 21440191,
 92460,
 -65206,
 21505512,
 92431,
 -65205,
 21569423,
 92454,
 -1,
 21628009,
 92415,
 -1,
 21442639,
 92420,
 21889361,
 21377908,
 92489,
 -65201,
 21833954,
 92479,
 -65200,
 21898309,
 92422,
 -1,
 21963125,
 92474,
 -65198,
 21838208,
 92502,
 -1,
 22099756,
 92449,
 22282591,
 21311567,
 -1,
 22348122,
 22220640,
 -1,
 22413657,
 22295412,
 -1,
 -65193,
 22360143,
 92416,
 -65192,
 22421877,
 92481,
 -1,
 22479932,
 92451,
 -1,
 22351846,
 92456,
 22741340,
 22295412,
 92433,
 -1,
 22685146,
 92477,
 -65187,
 22685043,
 92492,
 -65186,
 22812508,
 92513,
 -1,
 22873108,
 92491,
 23069033,
 22224003,
 -1,
 23134566,
 23007072,
 -1,
 23200100,
 23081844,
 -1,
 -65181,
 23142287,
 92484,
 -1,
 23200841,
 92439,
 -65179,
 23146575,
 92464,
 -1,
 23334886,
 92495,
 -65177,
 23082081,
 92446,
 -65176,
 23471475,
 92511,
 -1,
 23533602,
 92406,
 23724402,
 23013055,
 -1,
 23789933,
 23671668,
 -1,
 -65172,
 23737769,
 92443,
 -1,
 23800034,
 92509,
 23986544,
 23727968,
 -1,
 -65169,
 23934380,
 92462,
 -1,
 23990112,
 92506,
 -65167,
 23927226,
 92461,
 -1,
 24118765,
 92469,
 24314234,
 23673151,
 -1,
 24379768,
 24261492,
 -1,
 24445303,
 24322890,
 -1,
 -65162,
 24389311,
 92470,
 -1,
 24453007,
 92468,
 -1,
 24393923,
 92453,
 -65159,
 24318056,
 92429,
 -1,
 24642613,
 92421,
 24838528,
 24258906,
 -1,
 24904062,
 24776811,
 -1,
 -65155,
 24847395,
 92490,
 -1,
 24912213,
 92512,
 -65153,
 24844459,
 92494,
 -1,
 25035813,
 92455,
 25231747,
 24786689,
 -1,
 -65150,
 25179025,
 92411,
 -1,
 25232877,
 92402,
 25428358,
 25171168,
 -1,
 -65147,
 25367006,
 92488,
 -1,
 25428828,
 92434,
 25690111,
 25367215,
 -1,
 -65144,
 25563644,
 92436,
 -1,
 25625436,
 92517,
 25821724,
 14813429,
 -1,
 25887166,
 25764213,
 -1,
 25952664,
 25826332,
 -1,
 26018195,
 25891868,
 -1,
 26083730,
 25965428,
 92362,
 -65137,
 26027110,
 92341,
 -65136,
 26091407,
 92347,
 -65135,
 26152966,
 92370,
 -1,
 26215488,
 92336,
 -1,
 26021992,
 92307,
 26476950,
 25959204,
 -1,
 -65131,
 26424346,
 92303,
 -1,
 26478097,
 92309,
 -65129,
 26420293,
 92368,
 -1,
 26609169,
 92395,
 26804640,
 25898174,
 -1,
 26870172,
 26751860,
 -1,
 -65125,
 26813937,
 92359,
 -1,
 26878325,
 92374,
 -65123,
 26813509,
 92371,
 -65122,
 27006522,
 92351,
 -65121,
 27070953,
 92325,
 -1,
 27132742,
 92350,
 27328937,
 26742006,
 -1,
 27394468,
 27267540,
 -1,
 -65117,
 27340879,
 92349,
 -1,
 27395159,
 92308,
 27591079,
 27329350,
 -1,
 -65114,
 27535039,
 92378,
 -1,
 27598735,
 92375,
 -65112,
 27534417,
 92317,
 -1,
 27727879,
 92331,
 27918769,
 27269776,
 -1,
 27984301,
 27856736,
 -1,
 -65108,
 27932117,
 92389,
 -1,
 27987942,
 92360,
 28180912,
 27919174,
 -1,
 -65105,
 28123023,
 92367,
 -1,
 28184671,
 92356,
 -1,
 28128306,
 92333,
 28443063,
 27865167,
 -1,
 28508597,
 28381024,
 -1,
 -65100,
 28456087,
 92345,
 -1,
 28516725,
 92372,
 -65098,
 28455801,
 92314,
 -1,
 28640092,
 92340,
 28836282,
 28391909,
 -1,
 -65095,
 28774917,
 92323,
 -1,
 28836678,
 92304,
 29032893,
 28771142,
 -1,
 -65092,
 28977378,
 92396,
 -1,
 29041368,
 92338,
 -1,
 28981690,
 92313,
 29295067,
 25829263,
 -1,
 29360593,
 29230881,
 -1,
 29426118,
 29298528,
 -1,
 29491652,
 29373300,
 -1,
 -65085,
 29440248,
 92385,
 -1,
 29499279,
 92315,
 -65083,
 29436328,
 92354,
 -1,
 29626427,
 92311,
 29819337,
 29366108,
 92381,
 -65080,
 29765711,
 92326,
 -1,
 29829953,
 92343,
 30015950,
 29754182,
 -1,
 30081485,
 29950792,
 -1,
 -65076,
 30025598,
 92387,
 -1,
 30083341,
 92318,
 -1,
 30024508,
 92383,
 30408703,
 29963124,
 -1,
 -65072,
 30281568,
 92324,
 -1,
 30344229,
 92364,
 30540248,
 29295430,
 -1,
 30605781,
 30478176,
 -1,
 -65068,
 30551546,
 92363,
 -1,
 30613559,
 92382,
 30867455,
 30539776,
 -1,
 -65065,
 30745311,
 92376,
 -1,
 30809077,
 92339,
 -65063,
 30487432,
 92391,
 -65062,
 30939170,
 92390,
 -1,
 31003737,
 92344,
 31195628,
 29236004,
 -1,
 31261159,
 31133536,
 -1,
 31326691,
 31208308,
 -1,
 31392225,
 31272126,
 -1,
 -65056,
 31332002,
 92319,
 -1,
 31396434,
 92384,
 -65054,
 31334287,
 92386,
 -1,
 31529875,
 92321,
 31719910,
 31269239,
 -1,
 -65051,
 31661340,
 92393,
 -1,
 31724285,
 92394,
 -1,
 31666255,
 92361,
 31982058,
 31208308,
 -1,
 -65047,
 31928399,
 92366,
 -1,
 31991083,
 92373,
 -65045,
 31926029,
 92328,
 -1,
 32113500,
 92329,
 32309747,
 31144255,
 -1,
 32375281,
 32256884,
 -1,
 -65041,
 32323779,
 92388,
 -65040,
 32382863,
 92305,
 -1,
 32440566,
 92322,
 -65038,
 32313888,
 92327,
 -1,
 32572252,
 92377,
 32768507,
 32256079,
 -1,
 32834039,
 32709142,
 -1,
 -65034,
 32781206,
 92358,
 -1,
 32834386,
 92334,
 33030650,
 32771936,
 -1,
 -65031,
 32978364,
 92346,
 -1,
 33042511,
 92400,
 -1,
 32965487,
 92332,
 33292803,
 32713918,
 -1,
 33358335,
 33232304,
 -1,
 -65026,
 33305650,
 92379,
 -1,
 33364413,
 92392,
 33554946,
 33296224,
 -1,
 -65023,
 33502677,
 92330,
 -1,
 33567100,
 92380,
 -1,
 33502114,
 92335,
 33817097,
 33234051,
 -1,
 33882631,
 33751878,
 -1,
 -65018,
 33826495,
 92342,
 -1,
 33890191,
 92357,
 -65016,
 33829748,
 92365,
 -1,
 34019773,
 92397,
 34210318,
 33760959,
 -1,
 34275853,
 34150236,
 -1,
 -65012,
 34220865,
 92316,
 -1,
 34283893,
 92398,
 -1,
 34213992,
 92399,
 34538003,
 34149404,
 -1,
 34603538,
 34477502,
 -1,
 -65007,
 34548136,
 92310,
 -1,
 34612927,
 92320,
 -1,
 34539338,
 92312,
 34865686,
 34486017,
 -1,
 -65003,
 34813106,
 92369,
 -1,
 34866597,
 92306,
 35062297,
 34813539,
 -1,
 -65000,
 35010808,
 92337,
 -1,
 35062861,
 92353,
 -64998,
 35007658,
 92355,
 -64997,
 35197976,
 92348,
 -1,
 35260622,
 92352,
 35455642,
 25756488,
 -1,
 35521088,
 35398005,
 -1,
 35586596,
 35467343,
 -1,
 35652131,
 35522029,
 92223,
 35782655,
 35586048,
 -1,
 -64990,
 35660547,
 92194,
 -1,
 35725558,
 92185,
 -1,
 35595655,
 92178,
 35979818,
 35525660,
 -1,
 36045352,
 35921007,
 -1,
 -64985,
 35988292,
 92182,
 -1,
 36045040,
 92160,
 -64983,
 35984566,
 92229,
 -1,
 36177341,
 92173,
 36373038,
 35928383,
 -1,
 36438573,
 36312924,
 92239,
 -1,
 36384900,
 92225,
 -1,
 36376995,
 92233,
 36635185,
 36321765,
 -1,
 -64976,
 36582524,
 92191,
 -1,
 36635467,
 92167,
 36831796,
 36580787,
 -1,
 -64973,
 36771874,
 92237,
 -1,
 36832070,
 92241,
 37028407,
 36772644,
 -1,
 -64970,
 36968726,
 92180,
 -1,
 37028713,
 92227,
 37225018,
 36965658,
 -1,
 -64967,
 37160347,
 92212,
 -1,
 37224635,
 92201,
 37421629,
 37159750,
 -1,
 -64964,
 37365986,
 92245,
 -1,
 37421899,
 92164,
 -64962,
 37362338,
 92231,
 -64961,
 37558446,
 92204,
 -1,
 37621864,
 92244,
 37814871,
 35463055,
 -1,
 37880396,
 37749574,
 -1,
 37945930,
 37818208,
 -1,
 38011463,
 37887887,
 92238,
 -64955,
 37959286,
 92174,
 -64954,
 38018137,
 92203,
 -1,
 38078390,
 92171,
 -64952,
 37957114,
 92230,
 -64951,
 38216508,
 92210,
 -1,
 38280189,
 92186,
 -64949,
 37889732,
 92221,
 -1,
 38413029,
 92175,
 38601297,
 37823306,
 -1,
 38666832,
 38544453,
 -1,
 -64945,
 38611138,
 92198,
 -1,
 38670926,
 92214,
 -1,
 38609274,
 92190,
 38928980,
 38536998,
 -1,
 -64941,
 38873314,
 92246,
 -1,
 38937404,
 92232,
 -64939,
 38876775,
 92176,
 -64938,
 39064659,
 92196,
 -1,
 39129613,
 92197,
 39322215,
 37760190,
 -1,
 39387744,
 39261616,
 -1,
 39453276,
 39334772,
 -1,
 -64933,
 39395215,
 92215,
 -1,
 39456957,
 92165,
 39649887,
 39393116,
 -1,
 -64930,
 39594408,
 92222,
 -1,
 39657933,
 92168,
 -1,
 39593338,
 92224,
 39912036,
 39330634,
 -1,
 -64926,
 39858255,
 92235,
 -64925,
 39921890,
 92220,
 -1,
 39985728,
 92208,
 -64923,
 39859666,
 92181,
 -64922,
 40114667,
 92195,
 -1,
 40178201,
 92177,
 40370808,
 39265983,
 -1,
 40436335,
 40305478,
 -1,
 40501868,
 40371014,
 -1,
 -64917,
 40446376,
 92226,
 -1,
 40509327,
 92236,
 -64915,
 40447428,
 92187,
 -64914,
 40640843,
 92189,
 -1,
 40698043,
 92200,
 40895094,
 40379497,
 -1,
 40960627,
 40838886,
 -1,
 -64910,
 40899680,
 92169,
 -1,
 40961830,
 92170,
 41222143,
 40902907,
 -1,
 -64907,
 41096288,
 92162,
 -1,
 41158438,
 92163,
 -64905,
 40842418,
 92205,
 -1,
 41292195,
 92202,
 41484929,
 40311588,
 -1,
 41550460,
 41422688,
 -1,
 -64901,
 41497674,
 92179,
 -1,
 41562191,
 92211,
 41747071,
 41485126,
 -1,
 -64898,
 41691362,
 92240,
 -1,
 41751220,
 92199,
 -64896,
 41694382,
 92213,
 -1,
 41887771,
 92219,
 42074761,
 41431119,
 -1,
 42140293,
 42021748,
 -1,
 -64892,
 42075209,
 92206,
 -1,
 42139874,
 92172,
 42336904,
 42078676,
 -1,
 -64889,
 42283376,
 92209,
 -1,
 42337340,
 92234,
 -1,
 42277425,
 92166,
 42599055,
 42015875,
 -1,
 42664588,
 42546036,
 92243,
 -1,
 42599497,
 92207,
 -64883,
 42607708,
 92216,
 -64882,
 42733990,
 92184,
 -1,
 42796528,
 92183,
 42992276,
 42538012,
 -1,
 43057811,
 42931868,
 -1,
 -64878,
 43002280,
 92188,
 -1,
 43062512,
 92193,
 -1,
 42993638,
 92161,
 43319959,
 42939252,
 -1,
 -64874,
 43262553,
 92228,
 -1,
 43319994,
 92192,
 -64872,
 43267587,
 92242,
 -64871,
 43461663,
 92218,
 -1,
 43520877,
 92217,
 43713259,
 35391267,
 -1,
 43778734,
 43655055,
 -1,
 43844259,
 43714337,
 -1,
 43909792,
 43778886,
 -1,
 -64865,
 43845143,
 92255,
 -1,
 43909338,
 92252,
 -64863,
 43857070,
 92292,
 -64862,
 44046873,
 92268,
 -1,
 44110385,
 92286,
 44303015,
 43778886,
 92300,
 44433407,
 44237054,
 -1,
 -64858,
 44315975,
 92296,
 -1,
 44372463,
 92295,
 44565162,
 44241583,
 -1,
 -64855,
 44508269,
 92267,
 -1,
 44571265,
 92284,
 44761773,
 44503508,
 -1,
 -64852,
 44707985,
 92290,
 -1,
 44771554,
 92281,
 -1,
 44705045,
 92287,
 45023935,
 43721077,
 -1,
 45089463,
 44962844,
 -1,
 45154997,
 45028380,
 -1,
 45220531,
 45102254,
 92282,
 -1,
 45154484,
 92283,
 -64844,
 45158871,
 92277,
 -1,
 45286239,
 92298,
 -64842,
 45098053,
 92302,
 -1,
 45423642,
 92276,
 45613754,
 45037887,
 -1,
 -64839,
 45553517,
 92269,
 -1,
 45614121,
 92288,
 45810365,
 45558974,
 -1,
 -64836,
 45750092,
 92247,
 -1,
 45813864,
 92299,
 -64834,
 45756929,
 92260,
 -1,
 45944609,
 92261,
 46138055,
 44969150,
 -1,
 46203587,
 46077516,
 -1,
 -64830,
 46150555,
 92266,
 -1,
 46215322,
 92265,
 -64828,
 46150675,
 92285,
 -64827,
 46340130,
 92249,
 -64826,
 46404013,
 92250,
 -1,
 46466259,
 92279,
 46662352,
 46078756,
 -1,
 46727884,
 46600660,
 -1,
 -64822,
 46676398,
 92272,
 -64821,
 46737602,
 92270,
 -1,
 46793765,
 92294,
 46990031,
 46667612,
 -1,
 -64818,
 46934242,
 92301,
 -1,
 46993391,
 92253,
 -1,
 46925065,
 92256,
 47252181,
 46606015,
 -1,
 -64814,
 47199376,
 92289,
 -64813,
 47258134,
 92263,
 -64812,
 47321088,
 92257,
 -1,
 47384171,
 92274,
 47579867,
 47193219,
 -1,
 47645401,
 47514438,
 -1,
 -64808,
 47587224,
 92259,
 -1,
 47646044,
 92273,
 -64806,
 47588424,
 92251,
 -1,
 47780259,
 92297,
 47973088,
 47525967,
 -1,
 48038623,
 47919990,
 -1,
 -64802,
 47981279,
 92264,
 -1,
 48046024,
 92248,
 -1,
 47973215,
 92280,
 48300771,
 47921471,
 -1,
 -64798,
 48239140,
 92254,
 -1,
 48301211,
 92258,
 48497382,
 48239863,
 -1,
 -64795,
 48444300,
 92262,
 -1,
 48505205,
 92271,
 48693993,
 48435973,
 -1,
 -64792,
 48641493,
 92291,
 -1,
 48697184,
 92293,
 -64790,
 48642290,
 92278,
 -1,
 48838257,
 92275,
 49086463,
 43651761,
 -1,
 49087226,
 48963957,
 -1,
 49152751,
 49034100,
 92697,
 -1,
 49087508,
 92696,
 49283826,
 49093264,
 -1,
 -64783,
 49230728,
 92698,
 -1,
 49284133,
 92688,
 49480437,
 49222684,
 -1,
 -64780,
 49421427,
 92711,
 -1,
 49484837,
 92712,
 -64778,
 49428915,
 92681,
 -64777,
 49623375,
 92704,
 -64776,
 49688000,
 92702,
 -64775,
 49747804,
 92708,
 -1,
 49810728,
 92687,
 50004739,
 49032382,
 -1,
 50070271,
 49943984,
 -1,
 -64771,
 50017140,
 92700,
 -64770,
 50078538,
 92713,
 -1,
 50141355,
 92691,
 -64768,
 50017746,
 92690,
 -64767,
 50272092,
 92692,
 -64766,
 50336338,
 92693,
 -1,
 50398476,
 92727,
 50594572,
 49945380,
 -1,
 50660103,
 50532192,
 -1,
 -64762,
 50606159,
 92695,
 -1,
 50667893,
 92710,
 -64760,
 50608512,
 92694,
 -64759,
 50803572,
 92677,
 -64758,
 50865891,
 92726,
 -64757,
 50930506,
 92719,
 -1,
 50987846,
 92675,
 51184405,
 50538842,
 -1,
 51249937,
 51122016,
 -1,
 -64753,
 51197397,
 92709,
 -64752,
 51257717,
 92721,
 -1,
 51318624,
 92679,
 51512084,
 51189596,
 -1,
 -64749,
 51451740,
 92683,
 -1,
 51515363,
 92684,
 -1,
 51458932,
 92707,
 51774236,
 51126159,
 92689,
 51839769,
 51709729,
 -1,
 -64744,
 51777640,
 92720,
 -1,
 51839836,
 92724,
 -64742,
 51782474,
 92723,
 -64741,
 51974122,
 92685,
 -1,
 52036422,
 92722,
 52232993,
 51720271,
 -1,
 52298528,
 52167494,
 -1,
 -64737,
 52236128,
 92680,
 -1,
 52298566,
 92686,
 -1,
 52236707,
 92725,
 52560678,
 52176575,
 -1,
 52626213,
 52498272,
 -1,
 -64732,
 52573653,
 92703,
 -1,
 52629344,
 92706,
 -1,
 52573064,
 92714,
 52888362,
 52501635,
 -1,
 -64728,
 52831603,
 92718,
 -64727,
 52893532,
 92717,
 -1,
 52953926,
 92682,
 53150509,
 52836671,
 -1,
 -64724,
 53093747,
 92699,
 -1,
 53150534,
 92701,
 53347120,
 53098241,
 -1,
 -64721,
 53294099,
 92705,
 -1,
 53347142,
 92716,
 -64719,
 53294840,
 92728,
 -64718,
 53490548,
 92676,
 -64717,
 53547945,
 92715,
 -1,
 53612515,
 92678,
 53805950,
 143439,
 -1,
 53871483,
 53740738,
 -1,
 53936994,
 53812697,
 -1,
 54002501,
 53882046,
 -1,
 54068035,
 53942480,
 -1,
 -64710,
 54016358,
 7132,
 -64709,
 54081312,
 7116,
 -64708,
 54144258,
 7129,
 -64707,
 54208904,
 7123,
 -64706,
 54273763,
 7112,
 -64705,
 54337453,
 7125,
 -64704,
 54402212,
 7135,
 -64703,
 54465982,
 7107,
 -64702,
 54531109,
 7119,
 -1,
 54592326,
 7105,
 -64700,
 54011538,
 7126,
 -1,
 54723398,
 7128,
 54920011,
 53944693,
 -1,
 -64697,
 54868326,
 7136,
 -64696,
 54928841,
 7127,
 -64695,
 54989861,
 7133,
 -64694,
 55053594,
 7138,
 -1,
 55116614,
 7113,
 55313234,
 54861711,
 -1,
 55378769,
 55247686,
 7124,
 55508991,
 55321048,
 -1,
 -64689,
 55389442,
 7130,
 -64688,
 55452068,
 7114,
 -1,
 55514558,
 7108,
 -1,
 55314214,
 7139,
 55771988,
 55256803,
 7111,
 -1,
 55712849,
 7117,
 -64683,
 55720294,
 7131,
 -64682,
 55850784,
 7115,
 -64681,
 55915380,
 7141,
 -64680,
 55978376,
 7122,
 -64679,
 56040612,
 7134,
 -64678,
 56105885,
 7110,
 -64677,
 56171154,
 7120,
 -64676,
 56235868,
 7140,
 -64675,
 56300990,
 7106,
 -64674,
 56366117,
 7118,
 -64673,
 56429850,
 7121,
 -64672,
 56494346,
 7137,
 -64671,
 56559398,
 7109,
 -1,
 56623942,
 7104,
 56820589,
 53884649,
 -1,
 56886117,
 56767348,
 7150,
 -1,
 56819852,
 7151,
 57017192,
 56826775,
 -1,
 -64665,
 56959818,
 7149,
 -1,
 57022300,
 7147,
 57213802,
 56954720,
 7143,
 -1,
 57151328,
 7145,
 -64661,
 57157368,
 7144,
 -64660,
 57287498,
 7148,
 -1,
 57349980,
 7146,
 57541493,
 56765630,
 -1,
 57607028,
 57489874,
 -1,
 57672562,
 57550527,
 -1,
 -64655,
 57612520,
 7165,
 -1,
 57673141,
 7167,
 -64653,
 57614759,
 7164,
 -1,
 57809694,
 7166,
 -1,
 57546910,
 7142,
 58065784,
 57485057,
 -1,
 -64649,
 58008823,
 7155,
 -1,
 58070372,
 7154,
 58327039,
 58002384,
 -1,
 -64646,
 58204691,
 7152,
 -1,
 58267056,
 7153,
 58459005,
 53810608,
 128704,
 -1,
 58405680,
 128705,
 -1,
 58405227,
 128267,
 58655622,
 53748085,
 -1,
 58721157,
 58596132,
 127974,
 58851327,
 58663610,
 -1,
 -64638,
 58735013,
 128180,
 -64637,
 58796075,
 128183,
 -64636,
 58855990,
 128182,
 -1,
 58920466,
 128181,
 -1,
 58656088,
 127820,
 59179916,
 58591472,
 128118,
 59310079,
 59113472,
 -1,
 -64631,
 59191328,
 128700,
 -64630,
 59247281,
 128036,
 -64629,
 59312240,
 127868,
 -1,
 59377045,
 128124,
 59573137,
 59115763,
 -1,
 59638672,
 59513636,
 -1,
 -64625,
 59584283,
 983056,
 -1,
 59638371,
 128281,
 -1,
 59585223,
 128043,
 59900820,
 59517274,
 -1,
 -64621,
 59836310,
 128136,
 -1,
 59899997,
 128202,
 -64619,
 59846246,
 127936,
 -64618,
 60038881,
 127880,
 -1,
 60101829,
 128708,
 60294197,
 76122,
 -1,
 60359724,
 60228784,
 -1,
 60425181,
 60300761,
 -1,
 60490657,
 60372440,
 -1,
 60556192,
 60433279,
 -1,
 60621726,
 60500314,
 69643,
 -1,
 60565850,
 69644,
 60817407,
 60562563,
 69645,
 -1,
 60693635,
 69646,
 -1,
 60490566,
 69679,
 60949415,
 60436559,
 -1,
 61014949,
 60895311,
 -1,
 -64604,
 60954046,
 69662,
 -1,
 61014854,
 69661,
 -64602,
 60954046,
 69667,
 -1,
 61145926,
 69666,
 61342636,
 60891978,
 69649,
 61472767,
 61283644,
 -1,
 -64598,
 61353058,
 69686,
 -64597,
 61416086,
 69687,
 -1,
 61480668,
 69685,
 61670321,
 61284725,
 -1,
 -64594,
 61618534,
 69660,
 -64593,
 61677988,
 69665,
 -64592,
 61740069,
 69655,
 -1,
 61801286,
 69670,
 61998007,
 61607158,
 -1,
 62063541,
 61934838,
 -1,
 -64588,
 62002622,
 69664,
 -1,
 62063430,
 69663,
 -64586,
 62002622,
 69669,
 -1,
 62194502,
 69668,
 62391227,
 61932358,
 69637,
 -64583,
 62337908,
 69650,
 -64582,
 62396252,
 69648,
 -1,
 62456646,
 69638,
 62653375,
 62336190,
 -1,
 -64579,
 62598402,
 69681,
 -64578,
 62657982,
 69680,
 -1,
 62718790,
 69682,
 62915521,
 62600052,
 69641,
 -1,
 62862196,
 69642,
 63046596,
 62858943,
 -1,
 -64573,
 62985662,
 69672,
 -1,
 63046470,
 69671,
 63243207,
 62987395,
 -1,
 -64570,
 63184036,
 69684,
 -1,
 63243078,
 69678,
 63439818,
 63183652,
 -1,
 -64567,
 63378878,
 69652,
 -1,
 63439686,
 69651,
 63636429,
 63380112,
 -1,
 -64564,
 63575486,
 69659,
 -1,
 63636294,
 69658,
 63833039,
 63575900,
 69639,
 -1,
 63772508,
 69640,
 63964114,
 63771676,
 -1,
 -64559,
 63903166,
 69654,
 -1,
 63963974,
 69653,
 64160725,
 63899891,
 -1,
 -64556,
 64099774,
 69657,
 -1,
 64160582,
 69656,
 64357336,
 64096033,
 -1,
 -64553,
 64296382,
 69674,
 -1,
 64357190,
 69673,
 -64551,
 64305510,
 69676,
 -64550,
 64498056,
 69677,
 -64549,
 64561069,
 69675,
 -64548,
 64624062,
 69683,
 -1,
 64687968,
 69647,
 64881658,
 60367652,
 -1,
 64947174,
 64827471,
 -1,
 65012706,
 64894721,
 -1,
 -64543,
 64955210,
 69715,
 -1,
 65016016,
 69724,
 65209317,
 64951728,
 -1,
 -64540,
 65153711,
 69716,
 -1,
 65214947,
 69725,
 -1,
 65146984,
 69723,
 65471467,
 64892094,
 -1,
 65537001,
 65411689,
 69719,
 -1,
 65483617,
 69728,
 65732607,
 65475158,
 69720,
 -1,
 65614689,
 69729,
 65799154,
 65409711,
 -1,
 65864687,
 65741642,
 -1,
 -64530,
 65811793,
 69717,
 -1,
 65875110,
 69726,
 66125823,
 65804124,
 -1,
 -64527,
 66008564,
 69718,
 -1,
 66065428,
 69727,
 66257910,
 65742007,
 69714,
 66387967,
 66191360,
 -1,
 -64523,
 66269633,
 69733,
 -1,
 66328401,
 69732,
 66520056,
 66200108,
 69722,
 -1,
 66466657,
 69731,
 66715647,
 66457636,
 69721,
 -1,
 66599231,
 69730,
 66782221,
 64828888,
 -1,
 66847756,
 66725556,
 -1,
 66913281,
 66795184,
 -1,
 66978815,
 66857306,
 69694,
 -1,
 66922842,
 69695,
 67174399,
 66919555,
 69696,
 -1,
 67050627,
 69697,
 67240965,
 66847558,
 -1,
 -64509,
 67187572,
 69701,
 -64508,
 67245916,
 69699,
 -1,
 67306310,
 69688,
 67503111,
 67187572,
 69692,
 -1,
 67449716,
 69693,
 67634185,
 67442524,
 69690,
 -1,
 67573596,
 69691,
 -64502,
 67576650,
 69700,
 -64501,
 67702624,
 69698,
 -1,
 67766209,
 69689,
 -1,
 66787790,
 69702,
 68027422,
 66718966,
 -1,
 68092956,
 67967090,
 -1,
 68158482,
 68038735,
 -1,
 -64495,
 68106390,
 69736,
 -1,
 68163373,
 69737,
 68355093,
 68103358,
 -1,
 -64492,
 68295273,
 69740,
 -1,
 68358742,
 69741,
 68551704,
 68293295,
 -1,
 -64489,
 68494956,
 69738,
 -1,
 68557380,
 69739,
 -64487,
 68500016,
 69734,
 -64486,
 68691127,
 69735,
 -64485,
 68756012,
 69743,
 -1,
 68816932,
 69742,
 -64483,
 68036132,
 69704,
 -1,
 68945286,
 69703,
 69141540,
 67972624,
 -1,
 -64480,
 69088920,
 69634,
 -64479,
 69154074,
 69636,
 -64478,
 69212893,
 69635,
 -64477,
 69273933,
 69632,
 -1,
 69338592,
 69633,
 69599231,
 69085346,
 -1,
 69600296,
 69475459,
 -1,
 -64473,
 69543455,
 69709,
 -1,
 69605659,
 69707,
 69796907,
 69537295,
 -1,
 -64470,
 69743542,
 69706,
 -1,
 69808207,
 69705,
 -1,
 69733451,
 69708,
 70059057,
 60299100,
 -1,
 70124592,
 69995766,
 -1,
 -64465,
 70063225,
 127753,
 -1,
 70127484,
 128112,
 -1,
 70062090,
 128188,
 70386740,
 69996428,
 -1,
 -64461,
 70327112,
 983124,
 -1,
 70388982,
 127838,
 -1,
 70329348,
 128148,
 70648903,
 60234883,
 -1,
 70714433,
 70583273,
 -1,
 70779963,
 70658957,
 -1,
 70845498,
 70717052,
 9193,
 -1,
 70779559,
 9197,
 -1,
 70791891,
 9199,
 71042109,
 70720941,
 9194,
 -1,
 70976167,
 9198,
 -64450,
 70989054,
 9195,
 -64449,
 71118658,
 128306,
 -64448,
 71182655,
 10067,
 -1,
 71241400,
 9196,
 71435332,
 70661142,
 -1,
 -64445,
 71374423,
 128153,
 -1,
 71436389,
 128216,
 71696383,
 71377738,
 -1,
 -64442,
 71579530,
 128033,
 -1,
 71642986,
 127804,
 71828566,
 70591306,
 -1,
 71894092,
 71772172,
 -1,
 -64438,
 71842360,
 12730,
 -64437,
 71900739,
 12729,
 -1,
 71963872,
 12728,
 72156240,
 71836673,
 -1,
 72221775,
 72097804,
 128278,
 -1,
 72155514,
 128209,
 -1,
 72166590,
 128218,
 72418386,
 72097679,
 983247,
 -1,
 72353569,
 128163,
 -64429,
 72366399,
 128102,
 -64428,
 72497253,
 127923,
 -64427,
 72561995,
 128144,
 -1,
 72615444,
 128023,
 72811617,
 71765856,
 -1,
 72877146,
 72752259,
 983055,
 73007103,
 72817795,
 128276,
 -1,
 72876458,
 128277,
 73073757,
 72819061,
 -1,
 -64420,
 73019975,
 127857,
 -1,
 73077808,
 983621,
 73270368,
 73007942,
 -1,
 -64417,
 73216561,
 128147,
 -1,
 73279836,
 128059,
 -1,
 73208057,
 127866,
 73532522,
 72750940,
 -1,
 73598053,
 73476442,
 -1,
 -64412,
 73544078,
 127874,
 -1,
 73600246,
 128038,
 73794664,
 73534688,
 -1,
 -64409,
 73734650,
 128692,
 -1,
 73797472,
 128690,
 -64407,
 73735870,
 127921,
 -1,
 73931823,
 128089,
 74122353,
 73479028,
 -1,
 74187888,
 74067134,
 128652,
 74253423,
 74133583,
 -1,
 -64402,
 74198211,
 128101,
 -1,
 74252453,
 128100,
 -1,
 74187124,
 128655,
 -1,
 74126364,
 128027,
 74581108,
 74070335,
 -1,
 -64397,
 74529277,
 983249,
 -1,
 74592543,
 983246,
 -64395,
 74525886,
 983057,
 -1,
 74721120,
 983125,
 74909311,
 12367,
 -1,
 74974762,
 74842950,
 -1,
 75040204,
 74916103,
 -1,
 75105715,
 74985469,
 -1,
 75171003,
 75047285,
 -1,
 75236501,
 75112821,
 -1,
 75302025,
 75178357,
 -1,
 75367553,
 75236166,
 -1,
 -64385,
 75314036,
 983843,
 -64384,
 75372380,
 983840,
 -1,
 75432774,
 983833,
 75629699,
 75314036,
 983836,
 -1,
 75576180,
 983837,
 75760773,
 75572042,
 983841,
 -1,
 75703114,
 983842,
 75891847,
 75700060,
 983834,
 -1,
 75831132,
 983835,
 76087295,
 75829088,
 983838,
 -1,
 75960160,
 983839,
 76153997,
 75236166,
 -1,
 -64373,
 76100468,
 983711,
 -64372,
 76158812,
 983708,
 -1,
 76219206,
 983701,
 76416143,
 76100468,
 983704,
 -1,
 76362612,
 983705,
 76547217,
 76358474,
 983709,
 -1,
 76489546,
 983710,
 76678291,
 76486492,
 983702,
 -1,
 76617564,
 983703,
 76873727,
 76615520,
 983706,
 -1,
 76746592,
 983707,
 76940450,
 75184447,
 -1,
 77005978,
 76874566,
 -1,
 -64360,
 76952436,
 983689,
 -64359,
 77010780,
 983686,
 -1,
 77071174,
 983679,
 77268124,
 76952436,
 983682,
 -1,
 77214580,
 983683,
 77399198,
 77210442,
 983687,
 -1,
 77341514,
 983688,
 77530272,
 77338460,
 983680,
 -1,
 77469532,
 983681,
 77725695,
 77467488,
 983684,
 -1,
 77598560,
 983685,
 77792431,
 76878876,
 -1,
 77857959,
 77726534,
 -1,
 -64347,
 77804404,
 983667,
 -64346,
 77862748,
 983664,
 -1,
 77923142,
 983657,
 78120105,
 77804404,
 983660,
 -1,
 78066548,
 983661,
 78251179,
 78062410,
 983665,
 -1,
 78193482,
 983666,
 78382253,
 78190428,
 983658,
 -1,
 78321500,
 983659,
 78577663,
 78319456,
 983662,
 -1,
 78450528,
 983663,
 78644403,
 77726534,
 -1,
 -64335,
 78590836,
 983733,
 -64334,
 78649180,
 983730,
 -1,
 78709574,
 983723,
 78906549,
 78590836,
 983726,
 -1,
 78852980,
 983727,
 79037623,
 78848842,
 983731,
 -1,
 78979914,
 983732,
 79168697,
 78976860,
 983724,
 -1,
 79107932,
 983725,
 79364095,
 79105888,
 983728,
 -1,
 79236960,
 983729,
 79430883,
 75115710,
 -1,
 79496394,
 79369648,
 -1,
 79561921,
 79430470,
 -1,
 -64321,
 79508340,
 983865,
 -64320,
 79566684,
 983862,
 -1,
 79627078,
 983855,
 79824067,
 79508340,
 983858,
 -1,
 79770484,
 983859,
 79955141,
 79766346,
 983863,
 -1,
 79897418,
 983864,
 80086215,
 79894364,
 983856,
 -1,
 80025436,
 983857,
 80217289,
 80023392,
 983860,
 -1,
 80154464,
 983861,
 -1,
 80161737,
 983911,
 80413911,
 79441086,
 -1,
 80479439,
 80347974,
 -1,
 -64307,
 80425844,
 983876,
 -64306,
 80484188,
 983873,
 -1,
 80544582,
 983866,
 80741585,
 80425844,
 983869,
 -1,
 80687988,
 983870,
 80872659,
 80683850,
 983874,
 -1,
 80814922,
 983875,
 81003733,
 80811868,
 983867,
 -1,
 80942940,
 983868,
 81199103,
 80940896,
 983871,
 -1,
 81071968,
 983872,
 81265883,
 80347974,
 -1,
 -64295,
 81212276,
 983887,
 -64294,
 81270620,
 983884,
 -1,
 81331014,
 983877,
 81528029,
 81212276,
 983880,
 -1,
 81474420,
 983881,
 81659103,
 81470282,
 983885,
 -1,
 81601354,
 983886,
 81790177,
 81598300,
 983878,
 -1,
 81729372,
 983879,
 81985535,
 81727328,
 983882,
 -1,
 81858400,
 983883,
 82052362,
 79371395,
 -1,
 82117886,
 81992835,
 -1,
 82183410,
 82058371,
 -1,
 82248938,
 82117446,
 -1,
 -64280,
 82195316,
 983810,
 -64279,
 82253660,
 983807,
 -1,
 82314054,
 983800,
 82511084,
 82195316,
 983803,
 -1,
 82457460,
 983804,
 82642158,
 82453322,
 983808,
 -1,
 82584394,
 983809,
 82773232,
 82581340,
 983801,
 -1,
 82712412,
 983802,
 82968575,
 82710368,
 983805,
 -1,
 82841440,
 983806,
 83035382,
 82117446,
 -1,
 -64268,
 82981748,
 983821,
 -64267,
 83040092,
 983818,
 -1,
 83100486,
 983811,
 83297528,
 82981748,
 983814,
 -1,
 83243892,
 983815,
 83428602,
 83239754,
 983819,
 -1,
 83370826,
 983820,
 83559676,
 83367772,
 983812,
 -1,
 83498844,
 983813,
 83755007,
 83496800,
 983816,
 -1,
 83627872,
 983817,
 83821826,
 82051910,
 -1,
 -64256,
 83768180,
 983788,
 -64255,
 83826524,
 983785,
 -1,
 83886918,
 983778,
 84083972,
 83768180,
 983781,
 -1,
 84030324,
 983782,
 84215046,
 84026186,
 983786,
 -1,
 84157258,
 983787,
 84346120,
 84154204,
 983779,
 -1,
 84285276,
 983780,
 84541439,
 84283232,
 983783,
 -1,
 84414304,
 983784,
 84608292,
 81992484,
 -1,
 84673816,
 84553561,
 -1,
 84739344,
 84607814,
 983899,
 -64242,
 84685684,
 983910,
 -64241,
 84744028,
 983907,
 -1,
 84804422,
 983900,
 85001490,
 84685684,
 983903,
 -1,
 84947828,
 983904,
 85132564,
 84943690,
 983908,
 -1,
 85074762,
 983909,
 85263638,
 85071708,
 983901,
 -1,
 85202780,
 983902,
 85458943,
 85200736,
 983905,
 -1,
 85331808,
 983906,
 85525788,
 84607814,
 -1,
 -64230,
 85472116,
 983656,
 -64229,
 85530460,
 983653,
 -1,
 85590854,
 983646,
 85787934,
 85472116,
 983649,
 -1,
 85734260,
 983650,
 85919008,
 85730122,
 983654,
 -1,
 85861194,
 983655,
 86050082,
 85858140,
 983647,
 -1,
 85989212,
 983648,
 86245375,
 85987168,
 983651,
 -1,
 86118240,
 983652,
 86312254,
 84553807,
 -1,
 86377778,
 86257743,
 -1,
 86443306,
 86311750,
 -1,
 -64216,
 86389620,
 983700,
 -64215,
 86447964,
 983697,
 -1,
 86508358,
 983690,
 86705452,
 86389620,
 983693,
 -1,
 86651764,
 983694,
 86836526,
 86647626,
 983698,
 -1,
 86778698,
 983699,
 86967600,
 86775644,
 983691,
 -1,
 86906716,
 983692,
 87162879,
 86904672,
 983695,
 -1,
 87035744,
 983696,
 87229750,
 86311750,
 -1,
 -64204,
 87176052,
 983722,
 -64203,
 87234396,
 983719,
 -1,
 87294790,
 983712,
 87491896,
 87176052,
 983715,
 -1,
 87438196,
 983716,
 87622970,
 87434058,
 983720,
 -1,
 87565130,
 983721,
 87754044,
 87562076,
 983713,
 -1,
 87693148,
 983714,
 87949311,
 87691104,
 983717,
 -1,
 87822176,
 983718,
 88016216,
 86255962,
 -1,
 88081740,
 87959898,
 -1,
 88147268,
 88015686,
 -1,
 -64190,
 88093556,
 983832,
 -64189,
 88151900,
 983829,
 -1,
 88212294,
 983822,
 88409414,
 88093556,
 983825,
 -1,
 88355700,
 983826,
 88540488,
 88351562,
 983830,
 -1,
 88482634,
 983831,
 88671562,
 88479580,
 983823,
 -1,
 88610652,
 983824,
 88866815,
 88608608,
 983827,
 -1,
 88739680,
 983828,
 88933712,
 88015686,
 -1,
 -64178,
 88879988,
 983777,
 -64177,
 88938332,
 983774,
 -1,
 88998726,
 983767,
 89195858,
 88879988,
 983770,
 -1,
 89142132,
 983771,
 89326932,
 89137994,
 983775,
 -1,
 89269066,
 983776,
 89458006,
 89266012,
 983768,
 -1,
 89397084,
 983769,
 89653247,
 89395040,
 983772,
 -1,
 89526112,
 983773,
 89720165,
 87963967,
 -1,
 89785693,
 89654086,
 -1,
 -64165,
 89731956,
 983766,
 -64164,
 89790300,
 983763,
 -1,
 89850694,
 983756,
 90047839,
 89731956,
 983759,
 -1,
 89994100,
 983760,
 90178913,
 89989962,
 983764,
 -1,
 90121034,
 983765,
 90309987,
 90117980,
 983757,
 -1,
 90249052,
 983758,
 90505215,
 90247008,
 983761,
 -1,
 90378080,
 983762,
 90572146,
 89667032,
 -1,
 90637674,
 90506054,
 -1,
 -64152,
 90583924,
 983799,
 -64151,
 90642268,
 983796,
 -1,
 90702662,
 983789,
 90899820,
 90583924,
 983792,
 -1,
 90846068,
 983793,
 91030894,
 90841930,
 983797,
 -1,
 90973002,
 983798,
 91161968,
 90969948,
 983790,
 -1,
 91101020,
 983791,
 91357183,
 91098976,
 983794,
 -1,
 91230048,
 983795,
 91424127,
 90515135,
 -1,
 91489655,
 91358022,
 -1,
 -64139,
 91435892,
 983744,
 -64138,
 91494236,
 983741,
 -1,
 91554630,
 983734,
 91751801,
 91435892,
 983737,
 -1,
 91698036,
 983738,
 91882875,
 91693898,
 983742,
 -1,
 91824970,
 983743,
 92013949,
 91821916,
 983735,
 -1,
 91952988,
 983736,
 92209151,
 91950944,
 983739,
 -1,
 92082016,
 983740,
 92276108,
 91365263,
 -1,
 92341636,
 92209990,
 -1,
 -64126,
 92287860,
 983755,
 -64125,
 92346204,
 983752,
 -1,
 92406598,
 983745,
 92603782,
 92287860,
 983748,
 -1,
 92550004,
 983749,
 92734856,
 92545866,
 983753,
 -1,
 92676938,
 983754,
 92865930,
 92673884,
 983746,
 -1,
 92804956,
 983747,
 93061119,
 92802912,
 983750,
 -1,
 92933984,
 983751,
 93128089,
 92215952,
 -1,
 93193617,
 93061958,
 -1,
 -64113,
 93139828,
 983854,
 -64112,
 93198172,
 983851,
 -1,
 93258566,
 983844,
 93455763,
 93139828,
 983847,
 -1,
 93401972,
 983848,
 93586837,
 93397834,
 983852,
 -1,
 93528906,
 983853,
 93717911,
 93525852,
 983845,
 -1,
 93656924,
 983846,
 93913087,
 93654880,
 983849,
 -1,
 93785952,
 983850,
 93980070,
 93066672,
 -1,
 94045598,
 93913926,
 -1,
 -64100,
 93991796,
 983898,
 -64099,
 94050140,
 983895,
 -1,
 94110534,
 983888,
 94307744,
 93991796,
 983891,
 -1,
 94253940,
 983892,
 94438818,
 94249802,
 983896,
 -1,
 94380874,
 983897,
 94569892,
 94377820,
 983889,
 -1,
 94508892,
 983890,
 94765055,
 94506848,
 983893,
 -1,
 94637920,
 983894,
 94896127,
 93915379,
 -1,
 94897579,
 94765894,
 -1,
 -64087,
 94843764,
 983678,
 -64086,
 94902108,
 983675,
 -1,
 94962502,
 983668,
 95159725,
 94843764,
 983671,
 -1,
 95105908,
 983672,
 95290799,
 95101770,
 983676,
 -1,
 95232842,
 983677,
 95421873,
 95229788,
 983669,
 -1,
 95360860,
 983670,
 95617023,
 95358816,
 983673,
 -1,
 95489888,
 983674,
 95748095,
 75041716,
 -1,
 95749561,
 95625589,
 983629,
 95815095,
 95691125,
 983627,
 -1,
 95756661,
 983639,
 -64072,
 95762751,
 983625,
 -1,
 95884316,
 983623,
 96077244,
 95694014,
 983643,
 -64069,
 96021694,
 983642,
 -1,
 96081328,
 983641,
 96273855,
 96017539,
 983634,
 96403455,
 96214147,
 983637,
 -1,
 96279683,
 983636,
 96470465,
 96219215,
 983628,
 -1,
 96415823,
 983626,
 96601539,
 96414042,
 983633,
 -1,
 96545114,
 983638,
 96732613,
 96541476,
 983622,
 -1,
 96677721,
 983645,
 -64058,
 96680255,
 983632,
 -64057,
 96810456,
 983635,
 -64056,
 96872127,
 983630,
 -64055,
 96935823,
 983631,
 -64054,
 97000080,
 983640,
 -64053,
 97064368,
 983644,
 -1,
 97126643,
 983624,
 97322533,
 74980458,
 -1,
 97388038,
 97263065,
 -1,
 97453524,
 97333327,
 -1,
 97519058,
 97398863,
 -1,
 -64047,
 97457598,
 71317,
 -1,
 97518406,
 71316,
 -64045,
 97457598,
 71322,
 -1,
 97649478,
 71321,
 97846745,
 97395061,
 -1,
 -64042,
 97794406,
 71315,
 -64041,
 97853860,
 71320,
 -64040,
 97915941,
 71310,
 -1,
 97977158,
 71325,
 98174431,
 97783030,
 -1,
 98239965,
 98110710,
 -1,
 -64036,
 98178494,
 71319,
 -1,
 98239302,
 71318,
 -64034,
 98178494,
 71324,
 -1,
 98370374,
 71323,
 98567651,
 98108230,
 71296,
 -64031,
 98513780,
 71305,
 -64030,
 98572124,
 71303,
 -1,
 98632518,
 71297,
 98829797,
 98513780,
 71300,
 -1,
 98775924,
 71301,
 98960872,
 98774206,
 -1,
 -64025,
 98899390,
 71335,
 -1,
 98960198,
 71336,
 99157483,
 98904410,
 -1,
 -64022,
 99101064,
 71338,
 -1,
 99156806,
 71332,
 99354094,
 99100351,
 -1,
 -64019,
 99292606,
 71327,
 -1,
 99353414,
 71326,
 99550705,
 99293988,
 -1,
 -64016,
 99489214,
 71307,
 -1,
 99550022,
 71306,
 99747316,
 99490448,
 -1,
 -64013,
 99685822,
 71314,
 -1,
 99746630,
 71313,
 99943926,
 99686236,
 71298,
 -1,
 99882844,
 71299,
 100075001,
 99882012,
 -1,
 -64008,
 100013502,
 71309,
 -1,
 100074310,
 71308,
 100271612,
 100010227,
 -1,
 -64005,
 100210110,
 71312,
 -1,
 100270918,
 71311,
 100468223,
 100206369,
 -1,
 -64002,
 100406718,
 71329,
 -1,
 100467526,
 71328,
 -64000,
 100415846,
 71331,
 -63999,
 100611546,
 71334,
 -63998,
 100672330,
 71304,
 -63997,
 100736941,
 71330,
 -63996,
 100801700,
 71333,
 -63995,
 100865470,
 71337,
 -1,
 100929376,
 71302,
 101123604,
 97324513,
 -1,
 101189130,
 101068879,
 -1,
 -63991,
 101136534,
 71362,
 -1,
 101193517,
 71363,
 101385741,
 101133502,
 -1,
 -63988,
 101325417,
 71366,
 -1,
 101388886,
 71367,
 101582352,
 101323439,
 -1,
 -63985,
 101525100,
 71364,
 -1,
 101587524,
 71365,
 -63983,
 101530160,
 71360,
 -63982,
 101721271,
 71361,
 -63981,
 101786156,
 71369,
 -1,
 101847076,
 71368,
 102041119,
 101070569,
 -1,
 102106649,
 101974854,
 -1,
 -63977,
 102052724,
 71349,
 -63976,
 102111068,
 71347,
 -1,
 102171462,
 71341,
 102368795,
 102052724,
 71344,
 -1,
 102314868,
 71345,
 102499869,
 102307676,
 71342,
 -1,
 102438748,
 71343,
 -63970,
 102441802,
 71348,
 -1,
 102567776,
 71346,
 102825983,
 101985808,
 -1,
 102827555,
 102708859,
 -1,
 -63966,
 102772020,
 71340,
 -1,
 102836738,
 71350,
 -63964,
 102769438,
 71351,
 -1,
 102958560,
 71339,
 103155240,
 97263989,
 -1,
 -63961,
 103093438,
 127818,
 -1,
 103154553,
 127883,
 -63959,
 103102758,
 128661,
 -1,
 103286561,
 983061,
 103482945,
 74913628,
 -1,
 103548470,
 103417767,
 -1,
 103614002,
 103492798,
 -1,
 103679537,
 103560103,
 -1,
 -63953,
 103620676,
 3982,
 -63952,
 103685424,
 3981,
 -1,
 103750052,
 3983,
 -1,
 103618685,
 3980,
 104071167,
 103555089,
 -1,
 -63948,
 103953028,
 4058,
 -63947,
 104013154,
 4057,
 -1,
 104073217,
 983207,
 104269372,
 103486297,
 -1,
 104334906,
 104209919,
 -1,
 -63943,
 104276810,
 11623,
 -1,
 104337248,
 11622,
 -63941,
 104279437,
 11632,
 -1,
 104467391,
 11647,
 104662590,
 104207546,
 128005,
 -1,
 104595583,
 128047,
 -63937,
 104606361,
 128555,
 -63936,
 104734943,
 9202,
 -1,
 104794921,
 127915,
 104990292,
 103426394,
 -1,
 105055817,
 104932170,
 -1,
 105121352,
 104998591,
 -1,
 105186887,
 105060264,
 -1,
 -63930,
 105124722,
 128032,
 -1,
 105189147,
 127865,
 -1,
 105125721,
 127942,
 -1,
 105062070,
 128654,
 105514574,
 104989510,
 -1,
 105580108,
 105455503,
 128650,
 -1,
 105513037,
 128651,
 -63923,
 105519333,
 128646,
 -1,
 105647244,
 128668,
 105842259,
 105453404,
 -1,
 105907794,
 105776578,
 -1,
 -63919,
 105852077,
 128208,
 -1,
 105911164,
 128681,
 -1,
 105844098,
 128305,
 -1,
 105788531,
 127930,
 106235486,
 104932170,
 -1,
 106301018,
 106178241,
 -1,
 106366553,
 106239422,
 -1,
 -63912,
 106311759,
 127913,
 -1,
 106372654,
 11833,
 -1,
 106313793,
 128285,
 -63909,
 106242586,
 128069,
 -63908,
 106569778,
 127813,
 -63907,
 106634361,
 128508,
 -1,
 106698949,
 128701,
 106890855,
 106181492,
 -1,
 106956390,
 106834266,
 -1,
 107021924,
 106897919,
 -1,
 -63902,
 106966382,
 11829,
 -63901,
 107023664,
 11832,
 -1,
 107088814,
 11826,
 -63899,
 106967612,
 128034,
 -1,
 107224116,
 8378,
 -1,
 106897043,
 127799,
 107480688,
 106827616,
 -1,
 107546220,
 107421019,
 -1,
 -63894,
 107493024,
 128250,
 -63893,
 107556168,
 128301,
 -1,
 107620207,
 128222,
 107808367,
 107479878,
 -1,
 -63890,
 107751801,
 128198,
 -1,
 107809969,
 127861,
 -1,
 107750016,
 127934,
 108070520,
 107427585,
 -1,
 108136055,
 108012362,
 -1,
 108201590,
 108068864,
 -1,
 -63884,
 108148911,
 128109,
 -63883,
 108208312,
 128108,
 -1,
 108271215,
 128149,
 -1,
 108135134,
 11834,
 -1,
 108075518,
 128256,
 108594814,
 108008880,
 -1,
 108660348,
 108541037,
 -1,
 -63877,
 108606685,
 128077,
 -1,
 108662446,
 128078,
 -63875,
 108604083,
 11835,
 -1,
 108799564,
 128173,
 -1,
 108528396,
 128085,
 109054037,
 74842950,
 -1,
 109119380,
 108996954,
 -1,
 109184912,
 109052822,
 -1,
 109250365,
 109125668,
 -1,
 109315756,
 109186294,
 -1,
 109381289,
 109257546,
 -1,
 109446820,
 109327319,
 -1,
 109512332,
 109391951,
 -1,
 109577866,
 109450672,
 -1,
 -63863,
 109514769,
 126646,
 -1,
 109577434,
 126648,
 -63861,
 109514769,
 126645,
 -1,
 109708461,
 126632,
 109905552,
 109456574,
 -1,
 -63858,
 109844115,
 126644,
 -63857,
 109907955,
 126638,
 -1,
 109970449,
 126641,
 110167699,
 109853159,
 -1,
 -63854,
 110106853,
 126630,
 -1,
 110171568,
 126650,
 110364310,
 110103834,
 -1,
 -63851,
 110304387,
 126627,
 -1,
 110365942,
 126649,
 -63849,
 110311812,
 126633,
 -63848,
 110507847,
 126629,
 -63847,
 110570202,
 126643,
 -63846,
 110635239,
 126642,
 -63845,
 110699179,
 126637,
 -63844,
 110764151,
 126636,
 -63843,
 110828754,
 126635,
 -63842,
 110894095,
 126647,
 -63841,
 110959295,
 126626,
 -63840,
 111023557,
 126631,
 -63839,
 111088867,
 126651,
 -63838,
 111153933,
 126640,
 -63837,
 111216501,
 126625,
 -1,
 111281334,
 126639,
 111542271,
 109392448,
 -1,
 -63834,
 111421671,
 126495,
 -63833,
 111485611,
 126493,
 -63832,
 111547149,
 126494,
 -1,
 111609717,
 126492,
 111869951,
 109314886,
 -1,
 -63829,
 111746179,
 126467,
 -1,
 111807734,
 126489,
 112002769,
 109255811,
 -1,
 112068304,
 111944993,
 -1,
 112133812,
 112013391,
 -1,
 112199346,
 112072112,
 -1,
 -63823,
 112136209,
 126614,
 -1,
 112198874,
 126616,
 -63821,
 112136209,
 126613,
 -1,
 112329901,
 126600,
 112527032,
 112078014,
 -1,
 -63818,
 112465555,
 126612,
 -63817,
 112529395,
 126606,
 -1,
 112591889,
 126609,
 112789179,
 112474599,
 -1,
 -63814,
 112728293,
 126598,
 -1,
 112793008,
 126618,
 112985790,
 112727472,
 -1,
 -63811,
 112922641,
 126596,
 -1,
 112985261,
 126599,
 113182401,
 112921882,
 -1,
 -63808,
 113122435,
 126595,
 -1,
 113183990,
 126617,
 113379012,
 113115974,
 -1,
 -63805,
 113319297,
 126592,
 -1,
 113383653,
 126607,
 -63803,
 113326468,
 126601,
 -63802,
 113522503,
 126597,
 -63801,
 113584858,
 126611,
 -63800,
 113649895,
 126610,
 -63799,
 113713835,
 126605,
 -63798,
 113778807,
 126604,
 -63797,
 113843410,
 126603,
 -63796,
 113908751,
 126615,
 -63795,
 113973951,
 126594,
 -63794,
 114037987,
 126619,
 -63793,
 114103053,
 126608,
 -1,
 114165621,
 126593,
 -1,
 112002313,
 126475,
 114427635,
 111946942,
 -1,
 114493168,
 114373309,
 -1,
 114558679,
 114438223,
 -1,
 -63787,
 114497176,
 126582,
 -63786,
 114561041,
 126581,
 -1,
 114623661,
 126568,
 114820827,
 114502846,
 -1,
 -63783,
 114759315,
 126580,
 -63782,
 114823155,
 126574,
 -1,
 114885649,
 126577,
 115082976,
 114756854,
 -1,
 115148511,
 115025422,
 -1,
 -63778,
 115086093,
 126590,
 -1,
 115148661,
 126588,
 -1,
 115082257,
 126585,
 115410659,
 115022628,
 -1,
 -63774,
 115348933,
 126583,
 -1,
 115410033,
 126570,
 115607270,
 115348912,
 -1,
 -63771,
 115544081,
 126564,
 -1,
 115606701,
 126567,
 -63769,
 115554794,
 126586,
 -63768,
 115751300,
 126569,
 -63767,
 115812583,
 126578,
 -63766,
 115876523,
 126573,
 -63765,
 115941495,
 126572,
 -63764,
 116005567,
 126562,
 -63763,
 116069603,
 126587,
 -63762,
 116134669,
 126576,
 -63761,
 116197237,
 126561,
 -1,
 116262070,
 126575,
 -63759,
 114431635,
 126484,
 -63758,
 116396019,
 126478,
 -1,
 116458513,
 126481,
 116655884,
 114366862,
 -1,
 116721400,
 116599998,
 -1,
 -63754,
 116659859,
 126516,
 -63753,
 116723699,
 126510,
 -1,
 116786193,
 126513,
 116983547,
 116666447,
 -1,
 -63750,
 116922008,
 126518,
 -1,
 116985873,
 126517,
 117180158,
 116923172,
 -1,
 -63747,
 117118405,
 126519,
 -1,
 117179505,
 126506,
 117376769,
 117118384,
 -1,
 -63744,
 117313553,
 126500,
 -1,
 117376173,
 126503,
 -63742,
 117324164,
 126505,
 -63741,
 117516519,
 126514,
 -63740,
 117580459,
 126509,
 -63739,
 117645431,
 126508,
 -63738,
 117710034,
 126507,
 -63737,
 117775039,
 126498,
 -63736,
 117839075,
 126523,
 -63735,
 117904141,
 126512,
 -63734,
 117968172,
 126521,
 -63733,
 118032245,
 126497,
 -1,
 118097078,
 126511,
 118294310,
 116600911,
 -1,
 118359842,
 118227782,
 -1,
 118425377,
 118298815,
 -1,
 118490899,
 118369470,
 -1,
 -63727,
 118429331,
 126548,
 -63726,
 118493171,
 126542,
 -1,
 118555665,
 126545,
 118753048,
 118426870,
 -1,
 118818583,
 118695438,
 -1,
 -63722,
 118761703,
 126559,
 -1,
 118825643,
 126557,
 -1,
 118752273,
 126553,
 -63719,
 118700420,
 126537,
 -63718,
 119023847,
 126546,
 -63717,
 119087787,
 126541,
 -63716,
 119151826,
 126539,
 -63715,
 119217167,
 126551,
 -63714,
 119282367,
 126530,
 -63713,
 119346629,
 126535,
 -63712,
 119411939,
 126555,
 -1,
 119473334,
 126543,
 -1,
 118363568,
 126472,
 119736101,
 118298032,
 -1,
 -63708,
 119672849,
 126486,
 -1,
 119735514,
 126488,
 -1,
 119672849,
 126485,
 119998249,
 118241767,
 -1,
 -63704,
 119937253,
 126470,
 -1,
 120001968,
 126490,
 120194860,
 119940442,
 -1,
 -63701,
 120135804,
 126704,
 -1,
 120198601,
 126705,
 120391471,
 120134436,
 -1,
 -63698,
 120329669,
 126487,
 -1,
 120390769,
 126474,
 120588082,
 120324934,
 -1,
 -63695,
 120528257,
 126464,
 -1,
 120592613,
 126479,
 -63693,
 120535428,
 126473,
 -63692,
 120731463,
 126469,
 -63691,
 120793818,
 126483,
 -63690,
 120858855,
 126482,
 -63689,
 120922795,
 126477,
 -63688,
 120987767,
 126476,
 -63687,
 121051839,
 126466,
 -63686,
 121116101,
 126471,
 -63685,
 121181411,
 126491,
 -63684,
 121246477,
 126480,
 -1,
 121309045,
 126465,
 121505626,
 109194430,
 -1,
 121571160,
 121453003,
 -1,
 121636684,
 121516111,
 -1,
 121702214,
 121583769,
 -1,
 121767748,
 121648727,
 -1,
 -63677,
 121702288,
 64446,
 -1,
 121766830,
 64445,
 -63675,
 121702288,
 64437,
 -1,
 121897902,
 64436,
 122159103,
 121640754,
 -1,
 122160970,
 122038220,
 -1,
 -63671,
 122095504,
 64441,
 -1,
 122160046,
 64440,
 -63669,
 122095504,
 64439,
 -1,
 122291118,
 64438,
 122488657,
 121572879,
 -1,
 122554192,
 122433617,
 -1,
 -63665,
 122488720,
 64435,
 -1,
 122553262,
 64434,
 -1,
 122500031,
 64444,
 122816340,
 122433236,
 -1,
 -63661,
 122750864,
 64449,
 -1,
 122815406,
 64448,
 123012951,
 122754009,
 -1,
 -63658,
 122947472,
 64443,
 -1,
 123012014,
 64442,
 -1,
 122956757,
 64447,
 -63655,
 121511917,
 2291,
 -1,
 123213971,
 1540,
 123406190,
 121445723,
 -1,
 123471723,
 123351841,
 -1,
 123537247,
 123419016,
 -1,
 -63650,
 123475446,
 2216,
 -1,
 123538984,
 2217,
 123733858,
 123480410,
 -1,
 -63647,
 123675633,
 2220,
 -1,
 123736084,
 2218,
 -63645,
 123680587,
 2219,
 -63644,
 123875554,
 2211,
 -63643,
 123939051,
 2213,
 -63642,
 124002455,
 2215,
 -63641,
 124067030,
 2214,
 -63640,
 124132261,
 1568,
 -63639,
 124197572,
 2210,
 -63638,
 124261137,
 2212,
 -1,
 124323705,
 2208,
 124583935,
 123409401,
 -1,
 -63635,
 124454800,
 2297,
 -1,
 124519342,
 2295,
 124716920,
 123351634,
 -1,
 124782450,
 124662615,
 -1,
 -63631,
 124716944,
 2286,
 -1,
 124781486,
 2283,
 124979061,
 124724416,
 -1,
 -63628,
 124913552,
 2285,
 -1,
 124978094,
 2282,
 125239295,
 124919577,
 -1,
 -63625,
 125110160,
 2287,
 -1,
 125174702,
 2284,
 125372287,
 124652740,
 -1,
 125437819,
 125311922,
 2278,
 -1,
 125382921,
 2281,
 125568893,
 125375202,
 2276,
 -1,
 125513993,
 2279,
 125763583,
 125504833,
 2277,
 -1,
 125645065,
 2280,
 125831043,
 125315922,
 -1,
 125896578,
 125764526,
 2296,
 -1,
 125829621,
 2301,
 -1,
 125831056,
 2298,
 126093191,
 125773116,
 -1,
 -63611,
 126032845,
 2290,
 -63610,
 126096116,
 2288,
 -1,
 126160199,
 2289,
 126355339,
 126029046,
 -1,
 126420874,
 126297648,
 2299,
 -1,
 126353909,
 2300,
 -1,
 126354717,
 2302,
 126617486,
 126292712,
 -1,
 -63603,
 126561237,
 2292,
 -1,
 126619176,
 2293,
 -63601,
 126564150,
 1631,
 -1,
 126753720,
 2294,
 126945171,
 109130227,
 -1,
 -63598,
 126889857,
 127912,
 -1,
 126946467,
 128667,
 -1,
 126886090,
 1423,
 127207483,
 109059203,
 -1,
 127273016,
 127142556,
 -1,
 127338415,
 127216830,
 -1,
 127403937,
 127284084,
 -1,
 127469472,
 127338560,
 -1,
 127535007,
 127405933,
 -1,
 127600541,
 127479064,
 -1,
 -63588,
 127536143,
 128807,
 -1,
 127600087,
 128814,
 -63586,
 127536143,
 128802,
 -1,
 127731159,
 128812,
 -1,
 127474102,
 128862,
 -1,
 127409726,
 128781,
 128059303,
 127337690,
 -1,
 128124838,
 128004175,
 128788,
 128253951,
 128057629,
 -1,
 -63579,
 128125974,
 128806,
 -1,
 128189911,
 128813,
 -1,
 128058056,
 128825,
 128452523,
 128004175,
 -1,
 128518058,
 128395817,
 128860,
 -1,
 128451269,
 128861,
 -1,
 128452177,
 128850,
 -63572,
 128395141,
 128839,
 -63571,
 128656226,
 128852,
 -63570,
 128719050,
 128795,
 -1,
 128780852,
 128847,
 128976834,
 127271750,
 -1,
 129042359,
 128919806,
 -1,
 129107894,
 128974848,
 -1,
 129173428,
 129054375,
 128776,
 -1,
 129106629,
 128777,
 129368063,
 129116884,
 128774,
 -1,
 129237701,
 128775,
 -1,
 129045445,
 128773,
 129501116,
 128982147,
 -1,
 129566650,
 129440654,
 128822,
 -1,
 129499845,
 128823,
 -63557,
 129512545,
 128837,
 -1,
 129634402,
 128874,
 -63555,
 129447273,
 128829,
 -63554,
 129773011,
 128855,
 -63553,
 129838213,
 128826,
 -63552,
 129901330,
 128811,
 -63551,
 129966054,
 128859,
 -1,
 130030016,
 128769,
 130222038,
 128911603,
 -1,
 130287566,
 130165082,
 -1,
 130353098,
 130233339,
 128869,
 130482175,
 130286275,
 -1,
 -63545,
 130351917,
 128873,
 -63544,
 130417447,
 128872,
 -63543,
 130482981,
 128871,
 -1,
 130548511,
 128870,
 130809855,
 130294697,
 -1,
 130811853,
 130681871,
 128803,
 -1,
 130745029,
 128804,
 -1,
 130750942,
 128798,
 131008466,
 130220870,
 -1,
 -63536,
 130951366,
 128846,
 -63535,
 131014532,
 128844,
 -1,
 131075893,
 128848,
 131270613,
 130950500,
 -1,
 -63532,
 131212728,
 128800,
 -1,
 131270091,
 128805,
 -1,
 131209623,
 128787,
 131532774,
 130165082,
 -1,
 131598308,
 131469152,
 -1,
 131663841,
 131536298,
 128818,
 131729373,
 131596995,
 -1,
 -63525,
 131662631,
 128821,
 -63524,
 131728165,
 128820,
 -1,
 131793695,
 128819,
 132055039,
 131662109,
 -1,
 132057056,
 131925463,
 128816,
 -1,
 131990213,
 128817,
 -1,
 131996126,
 128799,
 132253667,
 131597562,
 128827,
 -1,
 132186821,
 128828,
 -1,
 132199034,
 128877,
 132513791,
 131539847,
 128792,
 -1,
 132383429,
 128793,
 132581361,
 131467041,
 -1,
 132646891,
 132523429,
 128834,
 132775935,
 132580035,
 -1,
 -63510,
 132645669,
 128836,
 -1,
 132711199,
 128835,
 132909038,
 132581045,
 -1,
 -63507,
 132855273,
 128876,
 -1,
 132915223,
 128875,
 -63505,
 132852533,
 128857,
 -63504,
 133045442,
 128783,
 -1,
 133110255,
 128830,
 133302267,
 132527576,
 -1,
 133367802,
 133240668,
 -1,
 133433336,
 133308932,
 128778,
 133498871,
 133366467,
 -1,
 -63498,
 133432101,
 128780,
 -1,
 133497631,
 128779,
 -1,
 133431586,
 128815,
 133824511,
 133378811,
 128790,
 -1,
 133694149,
 128791,
 -1,
 133304603,
 128808,
 133957637,
 133244607,
 -1,
 134023168,
 133899082,
 -1,
 134088703,
 133969775,
 128843,
 -1,
 134025161,
 128858,
 -1,
 134033503,
 128856,
 134285315,
 133968756,
 -1,
 -63486,
 134230706,
 128868,
 -1,
 134294343,
 128867,
 -63484,
 134228602,
 128863,
 -1,
 134420193,
 128782,
 134613005,
 133902415,
 -1,
 134678537,
 134551781,
 -1,
 -63480,
 134614168,
 128840,
 -1,
 134676792,
 128809,
 134875147,
 134612581,
 128831,
 -1,
 134808261,
 128832,
 -63476,
 134821325,
 128845,
 -1,
 134949690,
 128849,
 135137300,
 134553487,
 -1,
 135202834,
 135074058,
 128784,
 135331839,
 135135939,
 -1,
 -63471,
 135201573,
 128786,
 -1,
 135267103,
 128785,
 -63469,
 135144720,
 128881,
 -1,
 135398940,
 128824,
 135596059,
 135075248,
 -1,
 135661592,
 135537482,
 -1,
 -63465,
 135607633,
 128878,
 -1,
 135670908,
 128854,
 135921663,
 135595253,
 -1,
 -63462,
 135800410,
 128883,
 -1,
 135859990,
 128882,
 136054817,
 135531766,
 -1,
 136120352,
 135993832,
 -1,
 136185887,
 136064782,
 128865,
 -1,
 136118981,
 128866,
 -1,
 136131105,
 128864,
 -1,
 136054540,
 128880,
 136448037,
 135993822,
 -1,
 136513572,
 136380728,
 128796,
 -1,
 136446661,
 128797,
 -1,
 136446674,
 128801,
 136710184,
 136394528,
 -1,
 -63449,
 136657144,
 128842,
 -1,
 136720743,
 128772,
 136906795,
 136653142,
 -1,
 -63446,
 136848136,
 128768,
 -1,
 136907529,
 128833,
 137103406,
 136847903,
 -1,
 -63443,
 137048750,
 128789,
 -1,
 137106693,
 128879,
 137300017,
 137043075,
 -1,
 -63440,
 137241522,
 128851,
 -1,
 137301903,
 128810,
 137496628,
 137237532,
 -1,
 -63437,
 137442401,
 128841,
 -1,
 137503779,
 128794,
 -63435,
 137442659,
 128853,
 -63434,
 137634813,
 128838,
 -63433,
 137696104,
 128770,
 -1,
 137760689,
 128771,
 -63431,
 127211558,
 128126,
 -63430,
 137892184,
 983054,
 -1,
 137954887,
 9200,
 138152003,
 127148405,
 -1,
 138217535,
 138096719,
 128028,
 -63426,
 138155976,
 128260,
 -1,
 138219683,
 128246,
 138477567,
 138155036,
 -1,
 -63423,
 138359870,
 128551,
 -63422,
 138423478,
 128544,
 -1,
 138481920,
 128162,
 138676296,
 138097524,
 -1,
 138741831,
 138621518,
 -1,
 -63418,
 138683242,
 128663,
 -1,
 138741409,
 127975,
 -1,
 138676127,
 127814,
 139003979,
 138620798,
 -1,
 -63414,
 138947619,
 9954,
 -1,
 139011331,
 128562,
 139200590,
 138946239,
 -1,
 -63411,
 139143075,
 983194,
 -1,
 139200755,
 983195,
 139397201,
 139141007,
 -1,
 -63408,
 139333938,
 127944,
 -1,
 139397318,
 128657,
 139593811,
 139332358,
 983053,
 -1,
 139535045,
 983052,
 -63404,
 139538868,
 128095,
 -1,
 139661604,
 128673,
 139856346,
 108994447,
 -1,
 139921678,
 139794268,
 -1,
 139987203,
 139855337,
 -1,
 140052685,
 139927001,
 -1,
 140118123,
 139997263,
 -1,
 140183650,
 140059890,
 -1,
 -63396,
 140116798,
 94105,
 -63395,
 140182329,
 94104,
 -63394,
 140247863,
 94103,
 -63393,
 140313389,
 94102,
 -63392,
 140378919,
 94101,
 -63391,
 140444453,
 94100,
 -1,
 140509983,
 94099,
 140707942,
 140127422,
 -1,
 -63388,
 140651778,
 93994,
 -63387,
 140711358,
 93998,
 -1,
 140772166,
 94007,
 140970089,
 140648003,
 -1,
 -63384,
 140917094,
 93980,
 -1,
 140968774,
 93978,
 -63382,
 140914874,
 93966,
 -1,
 141099846,
 93962,
 141297784,
 140058997,
 -1,
 141363311,
 141244735,
 -1,
 -63378,
 141301182,
 93997,
 -1,
 141361990,
 93996,
 141559922,
 141304181,
 -1,
 -63375,
 141497790,
 93973,
 -1,
 141558598,
 93972,
 141756533,
 141497372,
 -1,
 -63372,
 141694398,
 93988,
 -1,
 141755206,
 93987,
 141953143,
 141689670,
 93968,
 -1,
 141896973,
 94032,
 -1,
 141891006,
 93969,
 142149764,
 141244901,
 -1,
 142215295,
 142096869,
 -1,
 142280829,
 142159038,
 -1,
 -63364,
 142227814,
 94017,
 -1,
 142279494,
 94014,
 -63362,
 142227814,
 94016,
 -1,
 142410566,
 94013,
 142608514,
 142159038,
 -1,
 -63359,
 142546366,
 94006,
 -1,
 142607174,
 94012,
 -63357,
 142546366,
 94005,
 -1,
 142738246,
 94011,
 142936207,
 142096822,
 -1,
 143001739,
 142880847,
 -1,
 143067273,
 142945470,
 -1,
 -63352,
 143005118,
 94000,
 -1,
 143065926,
 94009,
 -63350,
 143012026,
 93964,
 -1,
 143196998,
 93965,
 -63348,
 142943971,
 93954,
 -63347,
 143336035,
 93970,
 -63346,
 143399800,
 93984,
 -1,
 143462235,
 94001,
 143657112,
 142879433,
 -1,
 143722647,
 143598834,
 -1,
 -63342,
 143655742,
 94111,
 -63341,
 143721271,
 94110,
 -63340,
 143786797,
 94109,
 -63339,
 143852327,
 94108,
 -63338,
 143917855,
 94107,
 -1,
 143983389,
 94106,
 -1,
 143666624,
 94002,
 144246946,
 143592694,
 -1,
 144312477,
 144194021,
 -1,
 -63333,
 144259559,
 93995,
 -63332,
 144315838,
 93999,
 -1,
 144376646,
 94008,
 144574624,
 144252483,
 -1,
 -63329,
 144521574,
 93981,
 -1,
 144573254,
 93979,
 -63327,
 144510234,
 93967,
 -1,
 144704326,
 93963,
 144902314,
 144180038,
 -1,
 144967849,
 144845379,
 -1,
 145033383,
 144908661,
 -1,
 -63322,
 144970789,
 93989,
 -1,
 145032006,
 93971,
 -63320,
 144980539,
 94015,
 -1,
 145170349,
 93958,
 -1,
 144905648,
 94019,
 145426608,
 144841859,
 -1,
 145492142,
 145364400,
 -1,
 -63315,
 145439078,
 93977,
 -1,
 145490758,
 93976,
 -63313,
 145439078,
 93975,
 -1,
 145621830,
 93974,
 145819828,
 145370302,
 -1,
 -63310,
 145763586,
 94004,
 -63309,
 145823166,
 94003,
 -1,
 145883974,
 94010,
 146081977,
 145757212,
 -1,
 146147512,
 146019760,
 -1,
 -63305,
 146085310,
 93993,
 -1,
 146146118,
 93992,
 -1,
 146080582,
 93983,
 146409660,
 146027992,
 -1,
 -63301,
 146346676,
 93961,
 -1,
 146408262,
 93960,
 146606271,
 146352354,
 -1,
 -63298,
 146543653,
 93986,
 -1,
 146604870,
 93985,
 146802882,
 146548415,
 -1,
 -63295,
 146742436,
 93955,
 -1,
 146801478,
 93952,
 146999493,
 146743183,
 -1,
 -63292,
 146937278,
 93957,
 -1,
 146998086,
 93956,
 147196104,
 146937264,
 -1,
 -63289,
 147133886,
 94020,
 -1,
 147194694,
 93990,
 -63287,
 147142947,
 93991,
 -63286,
 147339040,
 94018,
 -63285,
 147397496,
 93982,
 -63284,
 147460788,
 93959,
 -1,
 147523366,
 93953,
 147720441,
 139998953,
 -1,
 147785943,
 147658588,
 94049,
 147851474,
 147718982,
 94050,
 147980287,
 147792245,
 94051,
 -1,
 147854364,
 94052,
 -63277,
 147796852,
 94056,
 -63276,
 147989322,
 94053,
 -63275,
 148054547,
 94057,
 -63274,
 148117340,
 94055,
 -1,
 148180832,
 94054,
 148375776,
 147718982,
 94036,
 148441306,
 148316533,
 94039,
 -1,
 148378652,
 94040,
 148572380,
 148377440,
 94067,
 -1,
 148508512,
 94068,
 -63267,
 148517748,
 94075,
 -63266,
 148641628,
 94073,
 -63265,
 148706985,
 94038,
 -1,
 148767558,
 94037,
 148965607,
 148321140,
 94058,
 149031140,
 148898630,
 94059,
 149159935,
 148971893,
 94060,
 -1,
 149034012,
 94061,
 -63259,
 148976500,
 94062,
 -63258,
 149168659,
 94064,
 -1,
 149229601,
 94063,
 149424365,
 148901728,
 94045,
 149489898,
 149367130,
 94071,
 -1,
 149432666,
 94069,
 149620972,
 149430645,
 94046,
 -1,
 149558300,
 94047,
 -1,
 149559132,
 94074,
 149817585,
 149365578,
 94041,
 -63249,
 149762932,
 94076,
 -63248,
 149824330,
 94042,
 -1,
 149885608,
 94048,
 150079731,
 149764415,
 94065,
 -1,
 150017884,
 94066,
 150210805,
 150025985,
 94044,
 -1,
 150152010,
 94043,
 150341879,
 150154324,
 94072,
 -1,
 150284634,
 94070,
 150536191,
 150282613,
 94077,
 -1,
 150410268,
 94078,
 150604030,
 147665490,
 -1,
 -63237,
 150549098,
 94096,
 -63236,
 150612812,
 94095,
 -63235,
 150669200,
 94098,
 -1,
 150733742,
 94097,
 150994943,
 150547984,
 -1,
 150997250,
 150874815,
 -1,
 -63231,
 150943435,
 94034,
 -1,
 150996597,
 94035,
 -1,
 150931061,
 94033,
 151259402,
 139922479,
 -1,
 151324935,
 151200586,
 -1,
 -63226,
 151268680,
 128300,
 -1,
 151332713,
 127908,
 151584767,
 151257088,
 -1,
 -63223,
 151463031,
 983226,
 -1,
 151522648,
 983227,
 151718157,
 151200287,
 -1,
 -63220,
 151653883,
 128189,
 -1,
 151718106,
 128656,
 -1,
 151658135,
 127756,
 151980415,
 139857760,
 -1,
 152045911,
 151923730,
 -1,
 152111414,
 151983795,
 -1,
 152176948,
 152051161,
 -1,
 152242456,
 152121423,
 -1,
 152307989,
 152178528,
 67994,
 -1,
 152240837,
 67995,
 152439063,
 152240966,
 67992,
 -1,
 152371909,
 67993,
 -1,
 152380234,
 67996,
 152635677,
 152183157,
 -1,
 152701211,
 152571744,
 67980,
 -1,
 152634053,
 67981,
 152895487,
 152634182,
 67978,
 -1,
 152765125,
 67979,
 152963361,
 152579262,
 -1,
 153028896,
 152896326,
 67987,
 -1,
 152961733,
 67988,
 -1,
 152964960,
 67989,
 153225507,
 152906120,
 67982,
 -1,
 153158341,
 67983,
 153356582,
 153164580,
 -1,
 -63195,
 153294270,
 67985,
 -1,
 153355078,
 67990,
 153553192,
 153290534,
 67974,
 -1,
 153486021,
 67975,
 -63191,
 153500006,
 67972,
 -63190,
 153630496,
 67973,
 -63189,
 153692388,
 67991,
 -63188,
 153757411,
 67976,
 -63187,
 153822026,
 67971,
 -63186,
 153886637,
 67977,
 -63185,
 153951396,
 67984,
 -63184,
 154015580,
 67970,
 -63183,
 154080940,
 67986,
 -63182,
 154144608,
 67969,
 -63181,
 154209562,
 67997,
 -1,
 154272582,
 67968,
 154533887,
 152121403,
 67998,
 -1,
 154403525,
 67999,
 154664959,
 152046795,
 -1,
 154667348,
 154538435,
 -1,
 154732860,
 154611791,
 -1,
 -63174,
 154673994,
 68022,
 -63173,
 154734432,
 68021,
 -1,
 154796870,
 68020,
 154995007,
 154676414,
 -1,
 -63170,
 154931040,
 68017,
 -1,
 154993478,
 68015,
 155191618,
 154935669,
 -1,
 -63167,
 155127648,
 68010,
 -1,
 155190086,
 68009,
 155388229,
 155130660,
 -1,
 -63164,
 155325886,
 68013,
 -1,
 155386694,
 68018,
 155584839,
 155321158,
 68000,
 -1,
 155527764,
 68016,
 -63160,
 155531622,
 68004,
 -63159,
 155662112,
 68005,
 -63158,
 155724168,
 68011,
 -63157,
 155789540,
 68019,
 -63156,
 155854563,
 68007,
 -63155,
 155919178,
 68003,
 -63154,
 155983789,
 68008,
 -63153,
 156048548,
 68012,
 -63152,
 156112732,
 68002,
 -63151,
 156178092,
 68014,
 -63150,
 156241760,
 68001,
 -63149,
 156306714,
 68023,
 -1,
 156370726,
 68006,
 156631039,
 154608608,
 -1,
 -63146,
 156511243,
 68030,
 -1,
 156571873,
 68031,
 156764537,
 151982519,
 -1,
 156830056,
 156704217,
 -1,
 156895580,
 156775198,
 -1,
 -63141,
 156833214,
 43749,
 -1,
 156894022,
 43748,
 157092191,
 156839102,
 -1,
 -63138,
 157035778,
 43754,
 -1,
 157095358,
 43753,
 157288802,
 157032821,
 -1,
 -63135,
 157235558,
 43747,
 -1,
 157295012,
 43752,
 157485413,
 157224298,
 -1,
 -63132,
 157423038,
 43751,
 -1,
 157483846,
 43750,
 -63130,
 157426506,
 43745,
 -63129,
 157618016,
 43744,
 -1,
 157682261,
 43746,
 157878643,
 156775896,
 -1,
 157944178,
 157820596,
 -1,
 158009711,
 157877062,
 -1,
 158075246,
 157942598,
 -1,
 -63123,
 158020468,
 43759,
 -1,
 158078812,
 43757,
 -1,
 158020468,
 43758,
 -63120,
 157955736,
 43765,
 -63119,
 158283218,
 43756,
 -1,
 158341291,
 43755,
 -1,
 157882830,
 43766,
 158599542,
 157811526,
 -1,
 -63115,
 158540357,
 43762,
 -1,
 158602798,
 43761,
 -63113,
 158546119,
 43764,
 -63112,
 158740487,
 43763,
 -1,
 158796435,
 43760,
 -63110,
 156709633,
 128647,
 -63109,
 158936924,
 983172,
 -63108,
 158999246,
 128697,
 -63107,
 159064360,
 128221,
 -63106,
 159129349,
 127816,
 -1,
 159188630,
 127830,
 159386032,
 151913286,
 -1,
 159451560,
 159326581,
 128104,
 159517090,
 159386939,
 -1,
 159582622,
 159456729,
 -1,
 159648151,
 159515462,
 -1,
 159713671,
 159591614,
 2126,
 -63098,
 159660517,
 2129,
 -1,
 159716784,
 2132,
 159910281,
 159658063,
 2133,
 -1,
 159854671,
 2120,
 160041355,
 159849252,
 2122,
 -1,
 159984898,
 2121,
 -63092,
 159988197,
 2118,
 -63091,
 160115034,
 2131,
 -63090,
 160180450,
 2130,
 -63089,
 160245439,
 2128,
 -63088,
 160309621,
 2125,
 -63087,
 160374671,
 2124,
 -63086,
 160439427,
 2123,
 -63085,
 160504037,
 2136,
 -63084,
 160568752,
 2116,
 -63083,
 160633884,
 2114,
 -63082,
 160697590,
 2115,
 -1,
 160761633,
 2113,
 160958874,
 159586140,
 -1,
 -63079,
 160903247,
 2119,
 -1,
 160964981,
 2127,
 -63077,
 160904609,
 2117,
 -63076,
 161094534,
 2135,
 -63075,
 161158640,
 2112,
 -1,
 161222460,
 2134,
 -63073,
 159528633,
 2138,
 -63072,
 161360022,
 2142,
 -63071,
 161420454,
 2139,
 -1,
 161481866,
 2137,
 161679783,
 159449088,
 -1,
 161745318,
 161626063,
 -1,
 -63067,
 161690420,
 128115,
 -1,
 161748365,
 128114,
 -1,
 161678702,
 128107,
 -1,
 161623269,
 128094,
 162073004,
 159391008,
 -1,
 -63062,
 162018091,
 3386,
 -63061,
 162079382,
 3369,
 -1,
 162139698,
 3406,
 162335151,
 162017689,
 -1,
 -63058,
 162278367,
 10187,
 -1,
 162337489,
 10189,
 -1,
 162277269,
 127809,
 162597327,
 159327050,
 -1,
 162662843,
 162542452,
 -1,
 162728376,
 162603755,
 -1,
 162793911,
 162661562,
 -1,
 -63051,
 162736588,
 128670,
 -63050,
 162793754,
 128672,
 -1,
 162858960,
 128693,
 -1,
 162726047,
 128507,
 163121594,
 162671956,
 128001,
 -1,
 163053695,
 128045,
 -1,
 163066241,
 128068,
 163318210,
 162603381,
 -1,
 163383742,
 163257346,
 128018,
 -1,
 163315839,
 128053,
 163514817,
 163320491,
 -1,
 -63040,
 163461210,
 128184,
 -1,
 163514173,
 128176,
 -1,
 163456400,
 128669,
 163776968,
 163253714,
 -1,
 163842502,
 163713697,
 -1,
 -63035,
 163782436,
 983972,
 -1,
 163845825,
 983971,
 -63033,
 163786415,
 43001,
 -1,
 163973473,
 43000,
 164170188,
 163710959,
 128241,
 164298751,
 164102144,
 -1,
 -63029,
 164182051,
 128242,
 -1,
 164242375,
 128244,
 -63027,
 164116849,
 128511,
 -63026,
 164378238,
 127909,
 -1,
 164439172,
 127889,
 164628951,
 162542452,
 -1,
 164694486,
 164572350,
 -1,
 164760021,
 164632488,
 -1,
 -63021,
 164703566,
 127932,
 -63020,
 164766389,
 127925,
 -1,
 164830214,
 127929,
 -1,
 164697926,
 127812,
 -1,
 164634455,
 127926,
 -63016,
 164574977,
 983173,
 -63015,
 165099253,
 983211,
 -1,
 165159249,
 983223,
 165350249,
 139799742,
 -1,
 165415513,
 165287344,
 -1,
 165481038,
 165348166,
 -1,
 165546573,
 165423522,
 -1,
 165612062,
 165486041,
 -1,
 165677542,
 165557720,
 -1,
 165743077,
 165618559,
 -1,
 165808611,
 165685594,
 70025,
 -1,
 165751130,
 70026,
 166002687,
 165747843,
 70027,
 -1,
 165878915,
 70028,
 -1,
 165675846,
 70062,
 166136300,
 165621839,
 -1,
 166201834,
 166080591,
 -1,
 -62999,
 166139326,
 70044,
 -1,
 166200134,
 70043,
 -62997,
 166139326,
 70049,
 -1,
 166331206,
 70048,
 166529521,
 166076789,
 -1,
 -62994,
 166476134,
 70042,
 -62993,
 166535588,
 70047,
 -62992,
 166597669,
 70037,
 -1,
 166658886,
 70052,
 166857207,
 166464758,
 -1,
 166922741,
 166792438,
 -1,
 -62988,
 166860222,
 70046,
 -1,
 166921030,
 70045,
 -62986,
 166860222,
 70051,
 -1,
 167052102,
 70050,
 167250427,
 166789958,
 70019,
 -62983,
 167195508,
 70032,
 -62982,
 167253852,
 70030,
 -1,
 167314246,
 70020,
 167512575,
 167193790,
 -1,
 -62979,
 167456002,
 70064,
 -62978,
 167515582,
 70063,
 -1,
 167576390,
 70065,
 167774721,
 167457652,
 70023,
 -1,
 167719796,
 70024,
 167905796,
 167716543,
 -1,
 -62973,
 167843262,
 70054,
 -1,
 167904070,
 70053,
 168102407,
 167844995,
 -1,
 -62970,
 168041636,
 70061,
 -1,
 168100678,
 70060,
 168299018,
 168041252,
 -1,
 -62967,
 168236478,
 70034,
 -1,
 168297286,
 70033,
 168495629,
 168237712,
 -1,
 -62964,
 168433086,
 70041,
 -1,
 168493894,
 70040,
 168692239,
 168433500,
 70021,
 -1,
 168630108,
 70022,
 168823314,
 168629276,
 -1,
 -62959,
 168760766,
 70036,
 -1,
 168821574,
 70035,
 169019925,
 168757491,
 -1,
 -62956,
 168957374,
 70039,
 -1,
 169018182,
 70038,
 169216536,
 168953633,
 -1,
 -62953,
 169153982,
 70056,
 -1,
 169214790,
 70055,
 -62951,
 169163110,
 70058,
 -62950,
 169355656,
 70059,
 -62949,
 169419594,
 70031,
 -62948,
 169484205,
 70057,
 -62947,
 169547198,
 70066,
 -1,
 169611104,
 70029,
 169806382,
 165557993,
 -1,
 169871908,
 169752240,
 -1,
 169937442,
 169814362,
 70072,
 -1,
 169879898,
 70073,
 170131455,
 169876611,
 70074,
 -1,
 170007683,
 70075,
 170199592,
 169804614,
 -1,
 -62938,
 170144628,
 70079,
 -62937,
 170202972,
 70077,
 -1,
 170263366,
 70067,
 170461738,
 170144628,
 70070,
 -1,
 170406772,
 70071,
 170592812,
 170399580,
 70068,
 -1,
 170530652,
 70069,
 -62931,
 170533706,
 70078,
 -1,
 170659680,
 70076,
 170854975,
 169741558,
 -1,
 170920509,
 170793074,
 -1,
 170986035,
 170864719,
 -1,
 -62926,
 170932374,
 70098,
 -1,
 170989357,
 70099,
 171182646,
 170929342,
 -1,
 -62923,
 171121257,
 70102,
 -1,
 171184726,
 70103,
 171379257,
 171119279,
 -1,
 -62920,
 171320940,
 70100,
 -1,
 171383364,
 70101,
 -62918,
 171326000,
 70096,
 -62917,
 171517111,
 70097,
 -62916,
 171581996,
 70105,
 -1,
 171642916,
 70104,
 -62914,
 170862116,
 70086,
 -1,
 171771270,
 70085,
 171969099,
 170798270,
 -1,
 172034634,
 171907192,
 -1,
 172100164,
 171980411,
 -1,
 -62909,
 172043572,
 70018,
 -1,
 172108290,
 70080,
 172296775,
 172032838,
 -1,
 -62906,
 172242397,
 70081,
 -1,
 172303156,
 70017,
 -62904,
 172242202,
 70083,
 -62903,
 172432093,
 70082,
 -1,
 172493133,
 70016,
 -1,
 171970779,
 70088,
 -62900,
 171910213,
 70084,
 -1,
 172688260,
 70087,
 -1,
 165492219,
 127847,
 172952146,
 165421898,
 -1,
 -62896,
 172898164,
 128703,
 -62895,
 172960918,
 127856,
 -1,
 173024771,
 127776,
 173214295,
 172889948,
 -1,
 173279830,
 173151221,
 -1,
 -62891,
 173221508,
 983075,
 -1,
 173283557,
 983078,
 -1,
 173221567,
 128674,
 -62888,
 173160767,
 983197,
 -1,
 173477884,
 128017,
 173673106,
 165357826,
 -1,
 173738612,
 173612163,
 -1,
 173804145,
 173672125,
 -1,
 -62883,
 173750757,
 127305,
 -62882,
 173816127,
 127304,
 -62881,
 173881592,
 127303,
 -62880,
 173946328,
 127301,
 -62879,
 174011252,
 127300,
 -62878,
 174075983,
 127299,
 -62877,
 174139738,
 127297,
 -62876,
 174205154,
 127296,
 -62875,
 174269258,
 127294,
 -62874,
 174333839,
 127292,
 -62873,
 174398595,
 127291,
 -62872,
 174463780,
 127290,
 -62871,
 174529168,
 127289,
 -62870,
 174593884,
 127288,
 -62869,
 174658992,
 127287,
 -62868,
 174724124,
 127286,
 -62867,
 174789295,
 127285,
 -62866,
 174853984,
 127284,
 -62865,
 174918902,
 127283,
 -62864,
 174983411,
 127282,
 -1,
 175047494,
 127280,
 175308799,
 173745112,
 -1,
 -62861,
 175187341,
 10191,
 -1,
 175244650,
 10190,
 175442565,
 173672691,
 -1,
 175508099,
 175381256,
 -1,
 175573626,
 175440697,
 -1,
 -62856,
 175506264,
 127539,
 -62855,
 175571778,
 127538,
 -1,
 175637295,
 127544,
 175835775,
 175506231,
 -1,
 175901310,
 175768379,
 -1,
 -62851,
 175833920,
 127542,
 -1,
 175899454,
 127543,
 -1,
 175837064,
 127541,
 176226303,
 175768365,
 -1,
 -62847,
 176096051,
 127546,
 -62846,
 176161577,
 127540,
 -1,
 176227105,
 127545,
 -62844,
 175449373,
 127378,
 -1,
 176364675,
 127377,
 176556680,
 175382901,
 -1,
 -62841,
 176493596,
 127382,
 -1,
 176558705,
 127381,
 176753291,
 176495574,
 -1,
 -62838,
 176696578,
 127490,
 -1,
 176757832,
 127489,
 -62836,
 176699244,
 127311,
 -62835,
 176895733,
 127386,
 -62834,
 176960741,
 127385,
 -62833,
 177024788,
 127384,
 -62832,
 177087489,
 127383,
 -62831,
 177149956,
 127380,
 -1,
 177214436,
 127379,
 177408707,
 173613898,
 983077,
 177474239,
 177351051,
 -1,
 177539761,
 177413593,
 -1,
 177605273,
 177480053,
 -1,
 -62825,
 177551725,
 69857,
 -62824,
 177607724,
 69847,
 -1,
 177669293,
 69849,
 177867420,
 177545133,
 -1,
 -62821,
 177804720,
 69846,
 -1,
 177868640,
 69864,
 178064031,
 177803104,
 -1,
 -62818,
 178001328,
 69863,
 -1,
 178065425,
 69859,
 -62816,
 178010477,
 69852,
 -62815,
 178206181,
 69850,
 -62814,
 178271286,
 69861,
 -62813,
 178335966,
 69841,
 -62812,
 178400521,
 69840,
 -62811,
 178465224,
 69853,
 -62810,
 178530036,
 69851,
 -62809,
 178594798,
 69862,
 -62808,
 178658510,
 69848,
 -62807,
 178723722,
 69855,
 -62806,
 178789022,
 69856,
 -62805,
 178854056,
 69860,
 -62804,
 178918853,
 69854,
 -62803,
 178983980,
 69845,
 -62802,
 179047735,
 69844,
 -62801,
 179112227,
 69843,
 -62800,
 179177281,
 69842,
 -1,
 179242157,
 69858,
 179503103,
 177475041,
 -1,
 179505845,
 179384399,
 -1,
 -62796,
 179452054,
 69874,
 -1,
 179509037,
 69875,
 179702456,
 179449022,
 -1,
 -62793,
 179640937,
 69878,
 -1,
 179704406,
 69879,
 179899067,
 179638959,
 -1,
 -62790,
 179840620,
 69876,
 -1,
 179903044,
 69877,
 -62788,
 179845680,
 69872,
 -62787,
 180036791,
 69873,
 -62786,
 180101676,
 69881,
 -1,
 180162596,
 69880,
 -62784,
 177417406,
 983181,
 -62783,
 180298904,
 128284,
 -62782,
 180360624,
 983043,
 -1,
 180425735,
 127846,
 180620007,
 177353588,
 -1,
 180685537,
 180560245,
 -1,
 180751068,
 180620624,
 -1,
 180816592,
 180693167,
 -1,
 180882122,
 180758207,
 -1,
 -62775,
 180827508,
 7362,
 -1,
 180880813,
 7361,
 -62773,
 180826094,
 7360,
 -62772,
 181018132,
 7364,
 -62771,
 181083003,
 7365,
 -62770,
 181144861,
 7366,
 -62769,
 181209383,
 7363,
 -1,
 181274409,
 7367,
 181471959,
 180755929,
 -1,
 181537492,
 181408609,
 -1,
 -62765,
 181477263,
 7103,
 -1,
 181541668,
 7102,
 -62763,
 181480165,
 7099,
 -62762,
 181673488,
 7100,
 -1,
 181733309,
 7101,
 181930714,
 181406710,
 -1,
 -62759,
 181876512,
 7085,
 -1,
 181936045,
 7084,
 -62757,
 181874198,
 7083,
 -1,
 182060773,
 7098,
 182258398,
 180693978,
 127749,
 -1,
 182190397,
 127748,
 -62753,
 182201760,
 127751,
 -62752,
 182326153,
 127803,
 -1,
 182387250,
 127774,
 182586084,
 180628670,
 -1,
 -62749,
 182527807,
 128671,
 -1,
 182589104,
 127843,
 182782694,
 182519585,
 983102,
 -1,
 182726577,
 983101,
 -1,
 182725366,
 127940,
 182979327,
 180564047,
 983189,
 183044852,
 182911814,
 -1,
 183110385,
 182987919,
 -1,
 183175917,
 183053502,
 -1,
 -62740,
 183120629,
 983180,
 -1,
 183177281,
 983132,
 -62738,
 183120247,
 983044,
 -62737,
 183314554,
 983175,
 -62736,
 183375439,
 983042,
 -1,
 183440792,
 983174,
 183697407,
 183054415,
 -1,
 -62733,
 183579684,
 128509,
 -1,
 183638454,
 128649,
 183831289,
 182987098,
 -1,
 183896824,
 183763782,
 -1,
 -62729,
 183842655,
 127827,
 -1,
 183900247,
 128207,
 -1,
 183834996,
 983188,
 184158972,
 183766935,
 -1,
 -62725,
 184097060,
 127836,
 -1,
 184156357,
 128642,
 -62723,
 184105208,
 983045,
 -62722,
 184298686,
 983169,
 -1,
 184362347,
 9201,
 184552211,
 182920895,
 983117,
 184617739,
 184487776,
 -1,
 184683272,
 184550591,
 -1,
 184748807,
 184619245,
 128264,
 184877055,
 184680832,
 -1,
 -62715,
 184758737,
 128266,
 -62714,
 184820937,
 128265,
 -1,
 184879417,
 128263,
 -1,
 184681204,
 128586,
 185204735,
 184618848,
 -1,
 -62710,
 185077092,
 128676,
 -1,
 185141834,
 128172,
 185338640,
 184550214,
 983176,
 185404175,
 185281543,
 -1,
 -62706,
 185342268,
 128150,
 -1,
 185405792,
 10024,
 -1,
 185341161,
 127837,
 -62703,
 185280157,
 128051,
 -62702,
 185605354,
 128166,
 -1,
 185670083,
 128026,
 185862955,
 184491919,
 -1,
 185928487,
 185800540,
 -1,
 185994022,
 185867917,
 -1,
 186059555,
 185930428,
 -1,
 186125084,
 186000706,
 128515,
 186253311,
 186056706,
 -1,
 -62694,
 186135053,
 128518,
 -62693,
 186199775,
 128516,
 -1,
 186256256,
 128517,
 186452768,
 186062256,
 -1,
 -62690,
 186394052,
 128520,
 -62689,
 186453920,
 128525,
 -1,
 186516741,
 128519,
 186777599,
 186395838,
 -1,
 -62686,
 186659997,
 128526,
 -1,
 186720524,
 128522,
 186974207,
 185993681,
 -1,
 -62683,
 186852674,
 128570,
 -1,
 186914397,
 128571,
 -1,
 185936892,
 128527,
 187173674,
 185861376,
 -1,
 -62679,
 187114902,
 128312,
 -1,
 187172952,
 128313,
 -1,
 187114511,
 128684,
 187435838,
 185800540,
 983080,
 187501372,
 187375989,
 -1,
 187566903,
 187438422,
 -1,
 187632436,
 187498496,
 -1,
 187697970,
 187575788,
 -1,
 -62671,
 187644054,
 983154,
 -1,
 187701037,
 983157,
 -62669,
 187635050,
 983182,
 -1,
 187828825,
 983184,
 188088319,
 187564804,
 -1,
 -62666,
 187958053,
 983158,
 -1,
 188023583,
 983155,
 188284927,
 187504086,
 -1,
 188287803,
 188164442,
 -1,
 -62662,
 188223716,
 983914,
 -1,
 188286150,
 983913,
 -1,
 188234101,
 983912,
 -62659,
 187447556,
 128303,
 -1,
 188489286,
 128510,
 188681030,
 187374723,
 -1,
 188746564,
 188616700,
 -1,
 188812099,
 188684575,
 -1,
 -62654,
 188756000,
 128164,
 -1,
 188814007,
 128564,
 -1,
 188758358,
 128554,
 -62651,
 188687837,
 127920,
 -1,
 189011899,
 127829,
 189205324,
 188627263,
 -1,
 189270858,
 189147929,
 -1,
 -62647,
 189211158,
 128137,
 -1,
 189268926,
 983201,
 189530111,
 189210997,
 983094,
 -1,
 189401787,
 983093,
 189598546,
 189140832,
 -1,
 189664080,
 189534048,
 -1,
 -62641,
 189599241,
 127793,
 -1,
 189661940,
 128584,
 -62639,
 189608097,
 983168,
 -1,
 189793939,
 128186,
 189991767,
 189532403,
 -1,
 190057301,
 189929245,
 127979,
 -1,
 189989205,
 127890,
 -62634,
 190000154,
 128220,
 -1,
 190125916,
 983185,
 190319451,
 189934782,
 -1,
 -62631,
 190251846,
 983133,
 -62630,
 190317349,
 983159,
 -1,
 190382879,
 983156,
 190581600,
 190259573,
 -1,
 190647135,
 190513990,
 -1,
 -62626,
 190585824,
 128013,
 -1,
 190650546,
 128012,
 -1,
 190588586,
 127938,
 190909284,
 190513990,
 -1,
 -62622,
 190855471,
 127927,
 -62621,
 190918999,
 128225,
 -1,
 190979043,
 127862,
 191171431,
 190847780,
 -1,
 -62618,
 191116371,
 128128,
 -1,
 191174494,
 127935,
 -62616,
 191117212,
 127946,
 -1,
 191304819,
 983183,
 191499393,
 165295576,
 -1,
 191564907,
 191442110,
 -1,
 191630298,
 191496989,
 983230,
 191695735,
 191562560,
 983252,
 -62610,
 191628096,
 983432,
 -62609,
 191693630,
 983431,
 -62608,
 191759161,
 983430,
 -62607,
 191824695,
 983429,
 -62606,
 191890221,
 983428,
 -62605,
 191955751,
 983427,
 -62604,
 192021285,
 983426,
 -62603,
 192086815,
 983425,
 -62602,
 192152349,
 983424,
 -1,
 192217883,
 983423,
 192416642,
 191628094,
 983251,
 -62599,
 192348992,
 983422,
 -62598,
 192414526,
 983421,
 -62597,
 192480057,
 983420,
 -62596,
 192545591,
 983419,
 -62595,
 192611117,
 983418,
 -62594,
 192676647,
 983417,
 -62593,
 192742181,
 983416,
 -62592,
 192807711,
 983415,
 -62591,
 192873245,
 983414,
 -1,
 192938779,
 983413,
 193137549,
 192348985,
 983250,
 -62588,
 193069888,
 983412,
 -62587,
 193135422,
 983411,
 -62586,
 193200953,
 983410,
 -62585,
 193266487,
 983409,
 -62584,
 193332013,
 983408,
 -62583,
 193397543,
 983407,
 -62582,
 193463077,
 983406,
 -62581,
 193528607,
 983405,
 -62580,
 193594141,
 983404,
 -1,
 193659675,
 983403,
 193858456,
 193069879,
 983245,
 -62577,
 193790784,
 983402,
 -62576,
 193856318,
 983401,
 -62575,
 193921849,
 983400,
 -62574,
 193987383,
 983399,
 -62573,
 194052909,
 983398,
 -62572,
 194118439,
 983397,
 -62571,
 194183973,
 983396,
 -62570,
 194249503,
 983395,
 -62569,
 194315037,
 983394,
 -1,
 194380571,
 983393,
 194579363,
 193790765,
 983244,
 -62566,
 194511680,
 983392,
 -62565,
 194577214,
 983391,
 -62564,
 194642745,
 983390,
 -62563,
 194708279,
 983389,
 -62562,
 194773805,
 983388,
 -62561,
 194839335,
 983387,
 -62560,
 194904869,
 983386,
 -62559,
 194970399,
 983385,
 -62558,
 195035933,
 983384,
 -1,
 195101467,
 983383,
 195300270,
 194511655,
 983243,
 -62555,
 195232576,
 983382,
 -62554,
 195298110,
 983381,
 -62553,
 195363641,
 983380,
 -62552,
 195429175,
 983379,
 -62551,
 195494701,
 983378,
 -62550,
 195560231,
 983377,
 -62549,
 195625765,
 983376,
 -62548,
 195691295,
 983375,
 -62547,
 195756829,
 983374,
 -1,
 195822363,
 983373,
 196021177,
 195232549,
 983242,
 -62544,
 195953472,
 983372,
 -62543,
 196019006,
 983371,
 -62542,
 196084537,
 983370,
 -62541,
 196150071,
 983369,
 -62540,
 196215597,
 983368,
 -62539,
 196281127,
 983367,
 -62538,
 196346661,
 983366,
 -62537,
 196412191,
 983365,
 -62536,
 196477725,
 983364,
 -1,
 196543259,
 983363,
 196742084,
 195953439,
 983241,
 -62533,
 196674368,
 983362,
 -62532,
 196739902,
 983361,
 -62531,
 196805433,
 983360,
 -62530,
 196870967,
 983359,
 -62529,
 196936493,
 983358,
 -62528,
 197002023,
 983357,
 -62527,
 197067557,
 983356,
 -62526,
 197133087,
 983355,
 -62525,
 197198621,
 983354,
 -1,
 197264155,
 983353,
 197462991,
 196674333,
 983240,
 -62522,
 197395264,
 983352,
 -62521,
 197460798,
 983351,
 -62520,
 197526329,
 983350,
 -62519,
 197591863,
 983349,
 -62518,
 197657389,
 983348,
 -62517,
 197722919,
 983347,
 -62516,
 197788453,
 983346,
 -62515,
 197853983,
 983345,
 -62514,
 197919517,
 983344,
 -1,
 197985051,
 983343,
 198246399,
 197395227,
 983239,
 -62511,
 198116160,
 983342,
 -62510,
 198181694,
 983341,
 -62509,
 198247225,
 983340,
 -62508,
 198312759,
 983339,
 -62507,
 198378285,
 983338,
 -62506,
 198443815,
 983337,
 -62505,
 198509349,
 983336,
 -62504,
 198574879,
 983335,
 -62503,
 198640413,
 983334,
 -1,
 198705947,
 983333,
 198904862,
 191562527,
 983231,
 198970342,
 198837031,
 983257,
 -62499,
 198902592,
 983482,
 -62498,
 198968126,
 983481,
 -62497,
 199033657,
 983480,
 -62496,
 199099191,
 983479,
 -62495,
 199164717,
 983478,
 -62494,
 199230247,
 983477,
 -62493,
 199295781,
 983476,
 -62492,
 199361311,
 983475,
 -62491,
 199426845,
 983474,
 -1,
 199492379,
 983473,
 199691249,
 198902565,
 983256,
 -62488,
 199623488,
 983472,
 -62487,
 199689022,
 983471,
 -62486,
 199754553,
 983470,
 -62485,
 199820087,
 983469,
 -62484,
 199885613,
 983468,
 -62483,
 199951143,
 983467,
 -62482,
 200016677,
 983466,
 -62481,
 200082207,
 983465,
 -62480,
 200147741,
 983464,
 -1,
 200213275,
 983463,
 200412156,
 199623455,
 983255,
 -62477,
 200344384,
 983462,
 -62476,
 200409918,
 983461,
 -62475,
 200475449,
 983460,
 -62474,
 200540983,
 983459,
 -62473,
 200606509,
 983458,
 -62472,
 200672039,
 983457,
 -62471,
 200737573,
 983456,
 -62470,
 200803103,
 983455,
 -62469,
 200868637,
 983454,
 -1,
 200934171,
 983453,
 201133063,
 200344349,
 983254,
 -62466,
 201065280,
 983452,
 -62465,
 201130814,
 983451,
 -62464,
 201196345,
 983450,
 -62463,
 201261879,
 983449,
 -62462,
 201327405,
 983448,
 -62461,
 201392935,
 983447,
 -62460,
 201458469,
 983446,
 -62459,
 201523999,
 983445,
 -62458,
 201589533,
 983444,
 -1,
 201655067,
 983443,
 201853970,
 201065243,
 983253,
 -62455,
 201786176,
 983442,
 -62454,
 201851710,
 983441,
 -62453,
 201917241,
 983440,
 -62452,
 201982775,
 983439,
 -62451,
 202048301,
 983438,
 -62450,
 202113831,
 983437,
 -62449,
 202179365,
 983436,
 -62448,
 202244895,
 983435,
 -62447,
 202310429,
 983434,
 -1,
 202375963,
 983433,
 202574874,
 201786157,
 983258,
 -62444,
 202507063,
 983489,
 -62443,
 202572589,
 983488,
 -62442,
 202638119,
 983487,
 -62441,
 202703653,
 983486,
 -62440,
 202769183,
 983485,
 -62439,
 202834717,
 983484,
 -1,
 202900251,
 983483,
 -62437,
 202507072,
 983262,
 -62436,
 203031358,
 983261,
 -62435,
 203096889,
 983260,
 -1,
 203162423,
 983259,
 203361321,
 198837056,
 983238,
 -62432,
 203293504,
 983332,
 -62431,
 203359038,
 983331,
 -62430,
 203424569,
 983330,
 -62429,
 203490103,
 983329,
 -62428,
 203555629,
 983328,
 -62427,
 203621159,
 983327,
 -62426,
 203686693,
 983326,
 -62425,
 203752223,
 983325,
 -62424,
 203817757,
 983324,
 -1,
 203883291,
 983323,
 204082228,
 203293502,
 983237,
 -62421,
 204014400,
 983322,
 -62420,
 204079934,
 983321,
 -62419,
 204145465,
 983320,
 -62418,
 204210999,
 983319,
 -62417,
 204276525,
 983318,
 -62416,
 204342055,
 983317,
 -62415,
 204407589,
 983316,
 -62414,
 204473119,
 983315,
 -62413,
 204538653,
 983314,
 -1,
 204604187,
 983313,
 204803135,
 204014393,
 983236,
 -62410,
 204735296,
 983312,
 -62409,
 204800830,
 983311,
 -62408,
 204866361,
 983310,
 -62407,
 204931895,
 983309,
 -62406,
 204997421,
 983308,
 -62405,
 205062951,
 983307,
 -62404,
 205128485,
 983306,
 -62403,
 205194015,
 983305,
 -62402,
 205259549,
 983304,
 -1,
 205325083,
 983303,
 205524042,
 204735287,
 983235,
 -62399,
 205456192,
 983302,
 -62398,
 205521726,
 983301,
 -62397,
 205587257,
 983300,
 -62396,
 205652791,
 983299,
 -62395,
 205718317,
 983298,
 -62394,
 205783847,
 983297,
 -62393,
 205849381,
 983296,
 -62392,
 205914911,
 983295,
 -62391,
 205980445,
 983294,
 -1,
 206045979,
 983293,
 206244949,
 205456173,
 983234,
 -62388,
 206177088,
 983292,
 -62387,
 206242622,
 983291,
 -62386,
 206308153,
 983290,
 -62385,
 206373687,
 983289,
 -62384,
 206439213,
 983288,
 -62383,
 206504743,
 983287,
 -62382,
 206570277,
 983286,
 -62381,
 206635807,
 983285,
 -62380,
 206701341,
 983284,
 -1,
 206766875,
 983283,
 206965856,
 206177063,
 983233,
 -62377,
 206897984,
 983282,
 -62376,
 206963518,
 983281,
 -62375,
 207029049,
 983280,
 -62374,
 207094583,
 983279,
 -62373,
 207160109,
 983278,
 -62372,
 207225639,
 983277,
 -62371,
 207291173,
 983276,
 -62370,
 207356703,
 983275,
 -62369,
 207422237,
 983274,
 -1,
 207487771,
 983273,
 207749119,
 206897957,
 983232,
 -62366,
 207618880,
 983272,
 -62365,
 207684414,
 983271,
 -62364,
 207749945,
 983270,
 -62363,
 207815479,
 983269,
 -62362,
 207881005,
 983268,
 -62361,
 207946535,
 983267,
 -62360,
 208012069,
 983266,
 -62359,
 208077599,
 983265,
 -62358,
 208143133,
 983264,
 -1,
 208208667,
 983263,
 208407670,
 191500128,
 -1,
 208473202,
 208342477,
 -1,
 208538737,
 208416272,
 -1,
 -62353,
 208483610,
 7414,
 -62352,
 208546879,
 7411,
 -1,
 208607965,
 7413,
 -1,
 208482904,
 7412,
 208928767,
 208415901,
 -1,
 208931957,
 208798644,
 983069,
 -1,
 208863582,
 983143,
 -1,
 208873900,
 128678,
 209128574,
 208344924,
 -1,
 209194108,
 209063310,
 -1,
 209259643,
 209125376,
 -1,
 -62342,
 209196099,
 127918,
 -1,
 209258802,
 128249,
 -1,
 209193400,
 128252,
 -62339,
 209134631,
 127931,
 -1,
 209455250,
 128243,
 209652864,
 209072207,
 983070,
 -1,
 209595582,
 983144,
 -1,
 209593372,
 127755,
 209849756,
 191432947,
 -1,
 209915123,
 209786288,
 -1,
 209980647,
 209847110,
 -1,
 210046174,
 209919043,
 -1,
 210111670,
 209984985,
 -1,
 210177164,
 210055247,
 -1,
 210242698,
 210120783,
 -1,
 -62327,
 210179521,
 69906,
 -1,
 210240348,
 69905,
 -62325,
 210179521,
 69911,
 -1,
 210371420,
 69910,
 210570385,
 210116981,
 -1,
 -62322,
 210516329,
 69904,
 -62321,
 210575792,
 69909,
 -62320,
 210637864,
 69899,
 -1,
 210699100,
 69914,
 210898071,
 210504950,
 -1,
 210963605,
 210832630,
 -1,
 -62316,
 210900417,
 69908,
 -1,
 210961244,
 69907,
 -62314,
 210900417,
 69913,
 -1,
 211092316,
 69912,
 211291290,
 210843967,
 -1,
 -62311,
 211237225,
 69920,
 -1,
 211288924,
 69921,
 211487901,
 211232447,
 -1,
 -62308,
 211424705,
 69916,
 -1,
 211485532,
 69915,
 211684512,
 211426084,
 -1,
 -62305,
 211621313,
 69896,
 -1,
 211682140,
 69895,
 211881123,
 211622544,
 -1,
 -62302,
 211817921,
 69903,
 -1,
 211878748,
 69902,
 212077734,
 211817500,
 -1,
 -62299,
 212014529,
 69898,
 -1,
 212075356,
 69897,
 212274345,
 212011251,
 -1,
 -62296,
 212211137,
 69901,
 -1,
 212271964,
 69900,
 212470956,
 212207393,
 -1,
 -62293,
 212407745,
 69918,
 -1,
 212468572,
 69917,
 -62291,
 212416291,
 69924,
 -62290,
 212611956,
 69893,
 -62289,
 212675845,
 69925,
 -62288,
 212740503,
 69922,
 -62287,
 212803504,
 69919,
 -62286,
 212868263,
 69923,
 -62285,
 212932444,
 69892,
 -62284,
 212997569,
 69926,
 -62283,
 213061472,
 69894,
 -1,
 213123932,
 69891,
 213322951,
 210046198,
 -1,
 213388485,
 213260402,
 -1,
 213454011,
 213332047,
 -1,
 -62278,
 213399702,
 69944,
 -1,
 213456685,
 69945,
 213650622,
 213396670,
 -1,
 -62275,
 213588585,
 69948,
 -1,
 213652054,
 69949,
 213847233,
 213586607,
 -1,
 -62272,
 213788268,
 69946,
 -1,
 213850692,
 69947,
 -62270,
 213793328,
 69942,
 -62269,
 213984439,
 69943,
 -62268,
 214049324,
 69951,
 -1,
 214110244,
 69950,
 -62266,
 213329444,
 69954,
 -1,
 214238598,
 69953,
 214437076,
 213267928,
 -1,
 214502611,
 214378164,
 -1,
 214568140,
 214434630,
 69927,
 -62261,
 214512500,
 69935,
 -1,
 214570844,
 69933,
 214764750,
 214512500,
 69930,
 -1,
 214709108,
 69931,
 214895824,
 214704970,
 69934,
 -1,
 214832988,
 69936,
 215026898,
 214832988,
 69928,
 -1,
 214964060,
 69929,
 -1,
 214962016,
 69932,
 -1,
 214440398,
 69939,
 215289050,
 214379710,
 -1,
 215354585,
 215226488,
 -1,
 -62249,
 215299736,
 69890,
 -62248,
 215353677,
 69888,
 -1,
 215418336,
 69889,
 -1,
 215289789,
 69952,
 -62245,
 215230769,
 69955,
 -62244,
 215622486,
 69937,
 -62243,
 215687092,
 69940,
 -1,
 215746258,
 69938,
 216006655,
 209987930,
 -1,
 216009955,
 215888050,
 -1,
 216075490,
 215954742,
 128200,
 -1,
 216006680,
 128185,
 -1,
 216010495,
 128201,
 216334335,
 215942138,
 983058,
 216399871,
 216203264,
 -1,
 -62234,
 216283125,
 983139,
 -1,
 216346012,
 983136,
 216534254,
 209915744,
 -1,
 216599787,
 216476767,
 -1,
 -62230,
 216545612,
 127800,
 -1,
 216602702,
 127826,
 -62228,
 216543161,
 127792,
 -62227,
 216738085,
 127937,
 -1,
 216797506,
 128227,
 216993009,
 216471388,
 -1,
 -62224,
 216931660,
 128696,
 -1,
 216992548,
 128020,
 -62222,
 216935407,
 127876,
 -1,
 217129872,
 127851,
 217320753,
 209853571,
 -1,
 217386283,
 217260874,
 -1,
 217451812,
 217320198,
 -1,
 217517344,
 217383045,
 -1,
 217582853,
 217460815,
 -1,
 217648383,
 217528065,
 -1,
 217713916,
 217588554,
 -1,
 -62213,
 217645843,
 128349,
 -1,
 217710869,
 128337,
 217972735,
 217649242,
 -1,
 -62210,
 217842451,
 128359,
 -1,
 217907477,
 128347,
 218107138,
 217585453,
 -1,
 -62207,
 218039059,
 128350,
 -1,
 218104085,
 128338,
 218365951,
 218042472,
 -1,
 -62204,
 218235667,
 128357,
 -1,
 218300693,
 128345,
 218500364,
 217525438,
 -1,
 218565897,
 218438249,
 -1,
 -62200,
 218497811,
 128353,
 -1,
 218562837,
 128341,
 218824703,
 218501718,
 -1,
 -62197,
 218694419,
 128354,
 -1,
 218759445,
 128342,
 218959123,
 218436271,
 -1,
 219024656,
 218900076,
 -1,
 -62193,
 218956563,
 128351,
 -1,
 219021589,
 128339,
 219283455,
 218962500,
 -1,
 -62190,
 219153171,
 128352,
 -1,
 219218197,
 128340,
 219417882,
 218894176,
 -1,
 219483415,
 219356704,
 -1,
 -62186,
 219415315,
 128358,
 -1,
 219480341,
 128346,
 219742207,
 219420754,
 -1,
 -62183,
 219611923,
 128355,
 -1,
 219676949,
 128343,
 219876637,
 219358391,
 -1,
 -62180,
 219808531,
 128348,
 -1,
 219873557,
 128336,
 220135423,
 219816492,
 -1,
 -62177,
 220005139,
 128356,
 -1,
 220070165,
 128344,
 220332031,
 217462724,
 -1,
 220335395,
 220212125,
 128257,
 -1,
 220266948,
 128258,
 -1,
 220270294,
 128259,
 220594175,
 217394523,
 -1,
 220597544,
 220471250,
 -1,
 -62169,
 220539348,
 128235,
 -1,
 220602180,
 128234,
 -62167,
 220542052,
 127746,
 -62166,
 220733175,
 128272,
 -1,
 220792933,
 128213,
 220990766,
 217323356,
 -1,
 -62163,
 220931874,
 128203,
 -1,
 220996169,
 127867,
 221249535,
 220923385,
 -1,
 -62160,
 221124909,
 128079,
 -1,
 221188336,
 127916,
 221384022,
 217260874,
 -1,
 221449535,
 221323323,
 -1,
 221515070,
 221383909,
 -1,
 221580599,
 221460799,
 -1,
 -62154,
 221517660,
 42614,
 -1,
 221581660,
 42617,
 221777209,
 221524852,
 42615,
 -1,
 221715550,
 42612,
 221908283,
 221714268,
 42613,
 -1,
 221849081,
 42655,
 -62148,
 221851387,
 42618,
 -62147,
 221979734,
 42619,
 -1,
 222041662,
 42616,
 -1,
 221449824,
 7676,
 222301513,
 221389173,
 -1,
 222367044,
 222237359,
 -1,
 -62142,
 222311820,
 128533,
 -62141,
 222373472,
 128534,
 -1,
 222433738,
 127882,
 222629191,
 222310354,
 -1,
 -62138,
 222574817,
 128119,
 -1,
 222637579,
 128679,
 -62136,
 222574121,
 127978,
 -1,
 222769925,
 983186,
 222956878,
 222241793,
 -1,
 223022413,
 222893916,
 -1,
 -62132,
 222962195,
 127859,
 -1,
 223022944,
 127850,
 -1,
 222957531,
 127834,
 223284560,
 222902017,
 128004,
 -1,
 223215743,
 128046,
 223415635,
 223226000,
 -1,
 -62126,
 223358598,
 11507,
 -1,
 223414663,
 11506,
 -62124,
 223360294,
 128145,
 -62123,
 223551181,
 128165,
 -1,
 223611694,
 127864,
 223808872,
 221315910,
 -1,
 223874396,
 223752271,
 128008,
 224002047,
 223805567,
 128049,
 224067583,
 223871360,
 -1,
 -62117,
 223951080,
 128572,
 -1,
 224014644,
 128569,
 224202081,
 223816026,
 -1,
 -62114,
 224144156,
 983073,
 -62113,
 224208588,
 127887,
 -62112,
 224274040,
 127904,
 -1,
 224333067,
 128199,
 224529765,
 224141685,
 983098,
 224595300,
 224463408,
 983097,
 -1,
 224526418,
 983170,
 -1,
 224530254,
 127852,
 -62106,
 224469225,
 128247,
 -62105,
 224730571,
 128197,
 -1,
 224791710,
 127797,
 224988538,
 223750490,
 983074,
 225054066,
 224928586,
 -1,
 225119600,
 224997209,
 -1,
 225185135,
 225050624,
 -1,
 225250670,
 225126405,
 128322,
 -1,
 225182269,
 128321,
 -1,
 225189900,
 10060,
 -1,
 225120210,
 127884,
 -62095,
 225065067,
 128081,
 -1,
 225446768,
 128010,
 225643895,
 224999743,
 -1,
 225709430,
 225581343,
 -1,
 -62091,
 225645239,
 128546,
 -1,
 225708488,
 128575,
 -1,
 225652637,
 128302,
 226033663,
 225578848,
 -1,
 -62087,
 225914173,
 127769,
 -1,
 225971712,
 128179,
 226168196,
 224925532,
 -1,
 226233730,
 226110016,
 -1,
 226299265,
 226172278,
 -1,
 226364800,
 226236427,
 -1,
 -62081,
 226299717,
 127568,
 -1,
 226363925,
 127569,
 -1,
 226299000,
 128320,
 -1,
 226243972,
 127914,
 -62077,
 226177892,
 127750,
 -1,
 226632202,
 127910,
 226823565,
 226113855,
 -1,
 226889100,
 226765773,
 -1,
 226954633,
 226831992,
 -1,
 -62072,
 226897368,
 1319,
 -1,
 226962153,
 42593,
 227213311,
 226888055,
 -1,
 -62069,
 227093976,
 1318,
 -1,
 227158761,
 42592,
 -1,
 226822985,
 127744,
 227413398,
 226767732,
 -1,
 227478931,
 227354970,
 -1,
 227544466,
 227420506,
 -1,
 -62063,
 227490113,
 127835,
 -1,
 227545231,
 128177,
 -1,
 227483527,
 10160,
 227868671,
 227422078,
 -1,
 -62059,
 227746914,
 128707,
 -1,
 227804720,
 127854,
 228003225,
 227351273,
 -1,
 -62056,
 227938991,
 64047,
 -1,
 228003680,
 64046,
 -62054,
 227945978,
 983187,
 -62053,
 228136267,
 983200,
 -1,
 228198983,
 983171,
 228396625,
 209790655,
 -1,
 228462063,
 228334723,
 -1,
 228527597,
 228394773,
 -1,
 228593071,
 228470863,
 -1,
 228658597,
 228538530,
 -1,
 -62046,
 228601633,
 127138,
 -62045,
 228660847,
 127154,
 -62044,
 228724164,
 127170,
 -1,
 228789098,
 127186,
 228986282,
 228595517,
 -1,
 -62041,
 228929313,
 127139,
 -62040,
 228988527,
 127155,
 -62039,
 229051844,
 127171,
 -1,
 229116778,
 127187,
 229375999,
 228921464,
 -1,
 -62036,
 229256993,
 127146,
 -62035,
 229316207,
 127162,
 -62034,
 229379524,
 127178,
 -1,
 229444458,
 127194,
 229641658,
 228535486,
 -1,
 229707189,
 229579372,
 -1,
 -62030,
 229650209,
 127142,
 -62029,
 229709423,
 127158,
 -62028,
 229772740,
 127174,
 -1,
 229837674,
 127190,
 230096895,
 229642843,
 -1,
 -62025,
 229977889,
 127143,
 -62024,
 230037103,
 127159,
 -62023,
 230100420,
 127175,
 -1,
 230165354,
 127191,
 230362565,
 229579556,
 -1,
 230428096,
 230302242,
 -1,
 -62019,
 230371105,
 127148,
 -62018,
 230430319,
 127164,
 -62017,
 230493636,
 127180,
 -1,
 230558570,
 127196,
 230817791,
 230365510,
 -1,
 -62014,
 230698785,
 127150,
 -62013,
 230757999,
 127166,
 -62012,
 230821316,
 127182,
 -1,
 230886250,
 127198,
 231083472,
 230298287,
 -1,
 231149003,
 231024240,
 -1,
 -62008,
 231092001,
 127140,
 -62007,
 231151215,
 127156,
 -62006,
 231214532,
 127172,
 -1,
 231279466,
 127188,
 231538687,
 231086664,
 -1,
 -62003,
 231419681,
 127141,
 -62002,
 231478895,
 127157,
 -62001,
 231542212,
 127173,
 -1,
 231607146,
 127189,
 231804373,
 231024923,
 -1,
 -61998,
 231747361,
 127149,
 -61997,
 231806575,
 127165,
 -61996,
 231869892,
 127181,
 -1,
 231934826,
 127197,
 232132058,
 231744049,
 -1,
 -61993,
 232075041,
 127145,
 -61992,
 232134255,
 127161,
 -61991,
 232197572,
 127177,
 -1,
 232262506,
 127193,
 232459743,
 232069781,
 -1,
 -61988,
 232402721,
 127147,
 -61987,
 232461935,
 127163,
 -61986,
 232525252,
 127179,
 -1,
 232590186,
 127195,
 232787428,
 232394794,
 -1,
 -61983,
 232730401,
 127144,
 -61982,
 232789615,
 127160,
 -61981,
 232852932,
 127176,
 -1,
 232917866,
 127192,
 233115113,
 232719325,
 -1,
 -61978,
 233058081,
 127137,
 -61977,
 233117295,
 127153,
 -61976,
 233180612,
 127169,
 -1,
 233245546,
 127185,
 233442796,
 233047841,
 -1,
 -61973,
 233381047,
 127183,
 -1,
 233440229,
 127136,
 -1,
 233387920,
 127199,
 -61970,
 228471668,
 983150,
 -1,
 233639158,
 983147,
 233836036,
 228393798,
 -1,
 233901559,
 233778316,
 -1,
 233967094,
 233838479,
 -1,
 -61965,
 233911474,
 983149,
 -61964,
 233968588,
 983145,
 -61963,
 234032780,
 983146,
 -1,
 234096436,
 983148,
 -1,
 233912669,
 127881,
 234360316,
 233837686,
 -1,
 234425851,
 234291200,
 -1,
 -61958,
 234371029,
 128195,
 -1,
 234427079,
 128196,
 -1,
 234367322,
 128223,
 234687998,
 234294518,
 983121,
 -1,
 234622440,
 983120,
 -61953,
 234632983,
 128062,
 -61952,
 234762095,
 128706,
 -61951,
 234825551,
 128206,
 -61950,
 234889668,
 128060,
 -61949,
 234954471,
 127796,
 -1,
 235014942,
 128230,
 235212315,
 233770848,
 -1,
 235277843,
 235153754,
 -1,
 235343378,
 235220158,
 -1,
 235408913,
 235283558,
 -1,
 235474448,
 235339776,
 -1,
 235539981,
 235419599,
 -1,
 -61941,
 235481142,
 128590,
 -61940,
 235541397,
 128591,
 -1,
 235604039,
 128113,
 -61938,
 235481568,
 128588,
 -61937,
 235738089,
 128589,
 -1,
 235800695,
 128583,
 -1,
 235406557,
 128187,
 -1,
 235344484,
 128547,
 -1,
 235279288,
 127917,
 236195351,
 235217269,
 -1,
 -61931,
 236138711,
 9956,
 -61930,
 236203591,
 128532,
 -1,
 236262821,
 128039,
 236457498,
 236127046,
 -1,
 -61927,
 236398938,
 127824,
 -1,
 236456519,
 127825,
 -1,
 236391848,
 128694,
 236719661,
 235152202,
 -1,
 236785186,
 236663668,
 -1,
 236850720,
 236728875,
 -1,
 -61921,
 236786359,
 128545,
 -1,
 236849608,
 128574,
 -61919,
 236789612,
 127831,
 -1,
 236980807,
 128093,
 237178406,
 236723800,
 -1,
 237243941,
 237111732,
 128659,
 -1,
 237186259,
 128680,
 -1,
 237183947,
 128110,
 237440553,
 237121615,
 -1,
 -61912,
 237372316,
 128688,
 -1,
 237437231,
 127858,
 237637164,
 237383550,
 -1,
 -61909,
 237570181,
 128238,
 -1,
 237634793,
 128239,
 -1,
 237577147,
 128041,
 237899321,
 236656476,
 -1,
 237964850,
 237835292,
 128022,
 238092287,
 237895680,
 -1,
 -61903,
 237970096,
 128061,
 -1,
 238031543,
 128055,
 238226997,
 237904380,
 -1,
 -61900,
 238159371,
 127821,
 -1,
 238223460,
 127885,
 238423608,
 238165123,
 -1,
 -61897,
 238361731,
 128138,
 -1,
 238423923,
 128169,
 -1,
 238366655,
 128299,
 238685762,
 237843316,
 -1,
 238751293,
 238627162,
 -1,
 -61892,
 238693716,
 128091,
 -1,
 238757771,
 128156,
 -61890,
 238694503,
 128686,
 -61889,
 238890484,
 128204,
 -61888,
 238946343,
 128226,
 -61887,
 239010591,
 983167,
 -1,
 239076125,
 983164,
 239275599,
 238627162,
 -1,
 239341134,
 239212380,
 -1,
 239406669,
 239285722,
 -1,
 239472204,
 239350061,
 -1,
 239537737,
 239403715,
 -1,
 -61880,
 239469343,
 983166,
 -1,
 239534877,
 983163,
 239796223,
 239468544,
 -1,
 -61877,
 239678291,
 983165,
 -1,
 239740087,
 983162,
 -1,
 239406293,
 983192,
 -1,
 239346110,
 128120,
 -1,
 239276387,
 983229,
 -61872,
 239214479,
 983193,
 -1,
 240061873,
 983219,
 240258738,
 228335989,
 -1,
 240324244,
 240193376,
 -1,
 240389769,
 240260168,
 -1,
 240455279,
 240332624,
 -1,
 240520812,
 240393478,
 -1,
 -61865,
 240466405,
 127369,
 -61864,
 240531775,
 127368,
 -61863,
 240597240,
 127367,
 -61862,
 240662273,
 127366,
 -61861,
 240727512,
 127365,
 -61860,
 240792436,
 127364,
 -61859,
 240857167,
 127363,
 -61858,
 240921790,
 127362,
 -61857,
 240986458,
 127361,
 -61856,
 241051874,
 127360,
 -61855,
 241115978,
 127358,
 -61854,
 241181045,
 127357,
 -61853,
 241244964,
 127354,
 -61852,
 241309532,
 127352,
 -61851,
 241374640,
 127351,
 -61850,
 241439772,
 127350,
 -61849,
 241504943,
 127349,
 -61848,
 241569632,
 127348,
 -61847,
 241634550,
 127347,
 -61846,
 241699059,
 127346,
 -61845,
 241764129,
 127345,
 -1,
 241828678,
 127344,
 -61843,
 240465772,
 127375,
 -61842,
 241962093,
 10062,
 -1,
 242025334,
 127374,
 242224776,
 240388840,
 -1,
 -61839,
 242170341,
 127337,
 -61838,
 242235711,
 127336,
 -61837,
 242301176,
 127335,
 -61836,
 242366209,
 127334,
 -61835,
 242431448,
 127333,
 -61834,
 242496372,
 127332,
 -61833,
 242561103,
 127331,
 -61832,
 242625726,
 127330,
 -61831,
 242690394,
 127329,
 -61830,
 242755810,
 127328,
 -61829,
 242819914,
 127326,
 -61828,
 242884981,
 127325,
 -61827,
 242950031,
 127324,
 -61826,
 243014787,
 127323,
 -61825,
 243079972,
 127322,
 -61824,
 243145360,
 127321,
 -61823,
 243210076,
 127320,
 -61822,
 243274780,
 127318,
 -61821,
 243339951,
 127317,
 -61820,
 243404640,
 127316,
 -61819,
 243469558,
 127315,
 -61818,
 243534067,
 127314,
 -61817,
 243599137,
 127313,
 -1,
 243663686,
 127312,
 -1,
 242156526,
 983091,
 243928720,
 240334593,
 -1,
 243994255,
 243859456,
 -1,
 244059790,
 243933506,
 -1,
 -61811,
 244004831,
 127770,
 -1,
 244068384,
 127761,
 -1,
 243998334,
 983063,
 -1,
 243937064,
 128240,
 -61807,
 243874103,
 983130,
 -61806,
 244331970,
 128528,
 -61805,
 244391043,
 983131,
 -1,
 244452155,
 128084,
 244649636,
 240264010,
 -1,
 244715166,
 244580352,
 -1,
 244780697,
 244647713,
 -1,
 -61800,
 244722270,
 983126,
 -1,
 244783100,
 128691,
 -61798,
 244723436,
 128685,
 -61797,
 244918057,
 128695,
 -61796,
 244983000,
 128286,
 -61795,
 245047595,
 128245,
 -1,
 245108933,
 128683,
 245304994,
 244658255,
 -1,
 245370529,
 245239735,
 128211,
 -1,
 245301726,
 128212,
 -1,
 245303918,
 128323,
 -61789,
 245247316,
 128067,
 -1,
 245506445,
 128689,
 245698216,
 244593524,
 -1,
 245763751,
 245636227,
 983041,
 -1,
 245701763,
 983040,
 -1,
 245706836,
 128297,
 245960364,
 245629766,
 -1,
 -61782,
 245899341,
 128219,
 -61781,
 245963556,
 983092,
 -1,
 246028469,
 128133,
 246222511,
 245892897,
 -1,
 -61778,
 246165272,
 983196,
 -1,
 246224304,
 983127,
 -61776,
 246161849,
 983222,
 -61775,
 246357123,
 983066,
 -1,
 246421602,
 127747,
 246615838,
 240196739,
 -1,
 246681338,
 246547270,
 -1,
 246746855,
 246624806,
 -1,
 246812377,
 246688958,
 -1,
 246877904,
 246751227,
 -1,
 246943420,
 246820030,
 -1,
 247008955,
 246876873,
 -1,
 -61766,
 246945159,
 983617,
 -1,
 247006219,
 983618,
 -1,
 246940287,
 42921,
 247271103,
 246887236,
 -1,
 -61762,
 247207303,
 983615,
 -1,
 247268363,
 983616,
 247467714,
 247211341,
 -1,
 -61759,
 247403911,
 983613,
 -1,
 247464971,
 983614,
 247664325,
 247406981,
 -1,
 -61756,
 247604080,
 42917,
 -1,
 247664018,
 42897,
 247860936,
 247600906,
 -1,
 -61753,
 247797127,
 983619,
 -1,
 247858187,
 983620,
 248057547,
 247796764,
 -1,
 -61750,
 247993790,
 983199,
 -1,
 248054399,
 42913,
 -61748,
 247998819,
 42919,
 -61747,
 248192133,
 42894,
 -61746,
 248257378,
 42915,
 -61745,
 248318207,
 42899,
 -1,
 248382487,
 983612,
 248643583,
 246821860,
 -1,
 -61742,
 248524879,
 8348,
 -61741,
 248589502,
 8347,
 -61740,
 248653503,
 8346,
 -61739,
 248717685,
 8345,
 -61738,
 248782735,
 8344,
 -61737,
 248847491,
 8343,
 -61736,
 248912676,
 8342,
 -1,
 248976816,
 8341,
 249171686,
 246745463,
 -1,
 249237213,
 249110917,
 -1,
 -61732,
 249176944,
 42916,
 -1,
 249236882,
 42896,
 249433824,
 249173020,
 -1,
 -61729,
 249370046,
 983198,
 -1,
 249430655,
 42912,
 -61727,
 249377595,
 42893,
 -61726,
 249572588,
 42920,
 -61725,
 249637219,
 42918,
 -61724,
 249699170,
 42914,
 -61723,
 249763250,
 42922,
 -1,
 249825535,
 42898,
 -1,
 249109985,
 43002,
 250089200,
 246686540,
 -1,
 250154731,
 250027028,
 -1,
 -61718,
 250094400,
 3807,
 -1,
 250156378,
 3806,
 250351342,
 250090384,
 -1,
 -61715,
 250291302,
 983203,
 -1,
 250349321,
 983204,
 -61713,
 250293263,
 983205,
 -1,
 250486511,
 983206,
 250679030,
 250030843,
 -1,
 250744564,
 250611794,
 -1,
 -61709,
 250678716,
 128311,
 -1,
 250743521,
 128309,
 -61707,
 250686094,
 128308,
 -1,
 250881430,
 128310,
 251072249,
 250621836,
 -1,
 -61704,
 251017183,
 127772,
 -1,
 251080736,
 127767,
 -1,
 251006801,
 128030,
 251334406,
 246621002,
 -1,
 251399936,
 251267846,
 128274,
 251465471,
 251337091,
 -1,
 -61698,
 251410992,
 983079,
 -1,
 251471031,
 983076,
 -1,
 251396693,
 128271,
 251727619,
 251344375,
 -1,
 -61694,
 251665874,
 128140,
 -1,
 251729703,
 127977,
 -61692,
 251672323,
 128261,
 -61691,
 251868162,
 128557,
 -1,
 251928262,
 127853,
 252120848,
 251268960,
 -1,
 252186380,
 252056562,
 -1,
 252251915,
 252117699,
 -1,
 -61686,
 252192736,
 128269,
 -1,
 252253703,
 9958,
 -1,
 252182737,
 128709,
 -61683,
 252126518,
 128006,
 -61682,
 252453177,
 127819,
 -61681,
 252513716,
 128210,
 -1,
 252576884,
 127811,
 252776217,
 252057436,
 -1,
 252841751,
 252715381,
 -1,
 252907286,
 252776290,
 -1,
 252972821,
 252850380,
 983068,
 -1,
 252903774,
 983142,
 -1,
 252908296,
 983062,
 -1,
 252844889,
 128279,
 -61672,
 252782729,
 128132,
 -1,
 253170953,
 128648,
 253366045,
 252717402,
 -1,
 -61669,
 253305674,
 983220,
 -61668,
 253370255,
 983215,
 -1,
 253431648,
 983217,
 -1,
 253301423,
 983065,
 253693824,
 246550368,
 -1,
 253759309,
 253636687,
 -1,
 253824843,
 253695732,
 -1,
 253890376,
 253767677,
 -1,
 253955889,
 253824246,
 -1,
 254021418,
 253901285,
 -1,
 254086950,
 253955936,
 43797,
 -1,
 254021472,
 43796,
 -61657,
 254030708,
 43793,
 -61656,
 254157642,
 43798,
 -61655,
 254220124,
 43794,
 -1,
 254280540,
 43795,
 254541823,
 253955513,
 -1,
 254545709,
 254414688,
 43789,
 -1,
 254480224,
 43788,
 -61650,
 254489460,
 43785,
 -61649,
 254616394,
 43790,
 -61648,
 254678876,
 43786,
 -1,
 254739292,
 43787,
 254938937,
 253889051,
 -1,
 255004468,
 254873440,
 43813,
 -1,
 254938976,
 43812,
 255135542,
 254935878,
 43808,
 -1,
 255066950,
 43811,
 -61641,
 255079284,
 43809,
 -61640,
 255206218,
 43814,
 -1,
 255268700,
 43810,
 255463233,
 254871375,
 -1,
 255528764,
 255397728,
 43821,
 -1,
 255463264,
 43820,
 255659838,
 255460166,
 43816,
 -1,
 255591238,
 43819,
 -61633,
 255603572,
 43817,
 -61632,
 255730506,
 43822,
 -1,
 255792988,
 43818,
 256049151,
 255406887,
 -1,
 256053060,
 255922016,
 43781,
 -1,
 255987552,
 43780,
 -61627,
 255996788,
 43777,
 -61626,
 256123722,
 43782,
 -61625,
 256186204,
 43778,
 -1,
 256246620,
 43779,
 256507903,
 253823883,
 -1,
 -61622,
 256390871,
 4958,
 -1,
 256447621,
 4957,
 -61620,
 253769976,
 983047,
 -1,
 256575265,
 983096,
 256773981,
 253698421,
 -1,
 256839514,
 256707832,
 -1,
 256905049,
 256779203,
 -1,
 256970580,
 256847951,
 -1,
 257036115,
 256911879,
 983048,
 -1,
 256966694,
 983095,
 -1,
 256971421,
 983046,
 -61611,
 256912736,
 983134,
 -61610,
 257173626,
 983178,
 -61609,
 257237104,
 983099,
 -61608,
 257302142,
 983064,
 -1,
 257365400,
 983177,
 -1,
 256849928,
 128282,
 257625948,
 256780514,
 983051,
 -1,
 257569849,
 983050,
 -1,
 257570311,
 128233,
 257822566,
 256706068,
 128066,
 257888099,
 257765764,
 -1,
 257953634,
 257819462,
 -1,
 -61599,
 257895933,
 127759,
 -1,
 257958126,
 127758,
 -1,
 257888832,
 127757,
 258277375,
 257818909,
 -1,
 -61595,
 258157360,
 127806,
 -1,
 258220000,
 127805,
 258412396,
 257760603,
 -1,
 258477931,
 258346129,
 -1,
 -61591,
 258421364,
 128294,
 -61590,
 258484157,
 128268,
 -1,
 258547315,
 128161,
 -1,
 258418531,
 128024,
 258805616,
 258354366,
 -1,
 258871151,
 258738419,
 983104,
 -1,
 258803189,
 983103,
 -1,
 258802502,
 983135,
 259067764,
 258745162,
 -1,
 -61582,
 259010639,
 983049,
 -61581,
 259071887,
 983100,
 -1,
 259136643,
 983067,
 259329911,
 259012989,
 -1,
 -61578,
 259271870,
 128064,
 -1,
 259331406,
 128083,
 259526522,
 259275000,
 -1,
 -61575,
 259469977,
 128125,
 -1,
 259532904,
 128529,
 259723133,
 259470715,
 -1,
 -61572,
 259663903,
 127972,
 -1,
 259721665,
 127984,
 -61570,
 259667512,
 127794,
 -61569,
 259860195,
 983179,
 -1,
 259916519,
 128231,
 260116437,
 253634906,
 -1,
 260181928,
 260050784,
 -1,
 260247453,
 260117803,
 -1,
 -61564,
 260192741,
 127487,
 -61563,
 260258111,
 127486,
 -61562,
 260323576,
 127485,
 -61561,
 260388609,
 127484,
 -61560,
 260453848,
 127483,
 -61559,
 260518772,
 127482,
 -61558,
 260583503,
 127481,
 -61557,
 260648126,
 127480,
 -61556,
 260712794,
 127479,
 -61555,
 260778210,
 127478,
 -61554,
 260843199,
 127477,
 -61553,
 260907850,
 127476,
 -61552,
 260972917,
 127475,
 -61551,
 261037967,
 127474,
 -61550,
 261102723,
 127473,
 -61549,
 261167908,
 127472,
 -61548,
 261233296,
 127471,
 -61547,
 261298012,
 127470,
 -61546,
 261363120,
 127469,
 -61545,
 261428252,
 127468,
 -61544,
 261493423,
 127467,
 -61543,
 261558112,
 127466,
 -61542,
 261623030,
 127465,
 -61541,
 261687539,
 127464,
 -61540,
 261752609,
 127463,
 -1,
 261817158,
 127462,
 262016930,
 260191704,
 -1,
 262082465,
 261951826,
 -1,
 -61536,
 262020739,
 983151,
 -1,
 262084880,
 983152,
 -1,
 262022199,
 128158,
 262344613,
 261949683,
 -1,
 -61532,
 262285928,
 128665,
 -1,
 262350250,
 983112,
 -61530,
 262287307,
 128699,
 -61529,
 262479463,
 128524,
 -1,
 262540539,
 127822,
 262737850,
 260113222,
 -1,
 262803380,
 262674268,
 -1,
 262868914,
 262745435,
 -1,
 262934446,
 262807439,
 -1,
 -61523,
 262868243,
 127339,
 -1,
 262932728,
 127338,
 -61521,
 262870530,
 9995,
 -61520,
 263066487,
 9994,
 -61519,
 263130660,
 11827,
 -1,
 263195566,
 11828,
 -61517,
 262807988,
 127752,
 -1,
 263331707,
 128643,
 263524278,
 262737399,
 128251,
 -1,
 263454765,
 128280,
 263655352,
 263456594,
 128007,
 -1,
 263585919,
 128048,
 -61511,
 263598159,
 128000,
 -1,
 263724943,
 128015,
 263917506,
 262677322,
 -1,
 -61508,
 263862118,
 128675,
 -61507,
 263926916,
 128205,
 -61506,
 263990612,
 127801,
 -61505,
 264054228,
 128019,
 -61504,
 264117929,
 127906,
 -61503,
 264178473,
 128640,
 -1,
 264242816,
 127840,
 264441803,
 263853916,
 983153,
 264507334,
 264377618,
 -1,
 -61499,
 264447968,
 128270,
 -1,
 264508935,
 9957,
 264703945,
 264440355,
 -1,
 -61496,
 264637490,
 127832,
 -1,
 264701765,
 127833,
 -61494,
 264643091,
 128141,
 -1,
 264832855,
 127872,
 265031632,
 264385396,
 -1,
 265097167,
 264970848,
 -1,
 -61490,
 265034080,
 127933,
 -1,
 265097453,
 127939,
 -1,
 265032806,
 127945,
 265359316,
 264969347,
 -1,
 -61486,
 265298762,
 983221,
 -61485,
 265363343,
 983216,
 -1,
 265424736,
 983218,
 -1,
 265301182,
 983113,
 265687087,
 260053796,
 -1,
 265752593,
 265623300,
 -1,
 265818119,
 265685984,
 -1,
 265883617,
 265760847,
 -1,
 265949148,
 265826689,
 -1,
 -61477,
 265888586,
 983929,
 -1,
 265945926,
 983927,
 266145759,
 265885104,
 -1,
 -61474,
 266085194,
 983934,
 -1,
 266142534,
 983932,
 -61472,
 266085194,
 983933,
 -1,
 266273606,
 983931,
 266473446,
 265822581,
 -1,
 -61469,
 266418658,
 983925,
 -61468,
 266478410,
 983935,
 -61467,
 266540378,
 983920,
 -1,
 266601286,
 983930,
 266801132,
 266410788,
 -1,
 266866666,
 266737072,
 -1,
 -61463,
 266806090,
 983919,
 -1,
 266863430,
 983917,
 -61461,
 266806090,
 983918,
 -1,
 266994502,
 983916,
 267194354,
 266733811,
 -1,
 267259888,
 267130288,
 -1,
 -61457,
 267199306,
 983924,
 -1,
 267256646,
 983922,
 -61455,
 267199306,
 983923,
 -1,
 267387718,
 983921,
 267587574,
 267136190,
 -1,
 -61452,
 267529474,
 983946,
 -61451,
 267589054,
 983945,
 -1,
 267649862,
 983947,
 267849723,
 267527871,
 -1,
 267915258,
 267785648,
 -1,
 -61447,
 267854666,
 983939,
 -1,
 267912006,
 983937,
 -1,
 267854666,
 983938,
 268177406,
 267787395,
 -1,
 -61443,
 268116810,
 983943,
 -1,
 268174150,
 983949,
 268374017,
 268111094,
 -1,
 -61440,
 268313418,
 983928,
 -1,
 268370758,
 983926,
 -61438,
 268319202,
 983941,
 -61437,
 268514989,
 983944,
 -61436,
 268577807,
 983942,
 -61435,
 268640552,
 983940,
 -61434,
 268703166,
 983948,
 -1,
 268764966,
 983936,
 268963853,
 265754866,
 -1,
 269029386,
 268905651,
 983952,
 -1,
 268974399,
 983953,
 269221887,
 268970210,
 -1,
 -61428,
 269103988,
 983951,
 -1,
 269160288,
 983954,
 269418495,
 268908265,
 -1,
 -61425,
 269296709,
 983955,
 -61424,
 269355895,
 983950,
 -1,
 269419359,
 983956,
 269619234,
 265683782,
 -1,
 269684769,
 269562106,
 -1,
 269750297,
 269617114,
 -1,
 -61419,
 269693812,
 983964,
 -61418,
 269755210,
 983966,
 -61417,
 269817692,
 983963,
 -61416,
 269881184,
 983965,
 -1,
 269943622,
 983962,
 270204927,
 269681478,
 -1,
 270209056,
 270080415,
 -1,
 270274590,
 270151759,
 -1,
 -61411,
 270218100,
 983968,
 -1,
 270279498,
 983969,
 -61409,
 270214847,
 983970,
 -1,
 270404128,
 983967,
 -1,
 270150219,
 110592,
 -1,
 269623911,
 983202,
 270733356,
 269555548,
 -1,
 270798891,
 270675801,
 128143,
 270864426,
 270735647,
 -1,
 270929961,
 270799543,
 128535,
 271056895,
 270860672,
 -1,
 -61400,
 270937823,
 128537,
 -1,
 270994255,
 128538,
 -1,
 270862816,
 128573,
 -1,
 270794986,
 128139,
 -1,
 270737725,
 128088,
 271388718,
 270668456,
 128273,
 -1,
 271321433,
 128287,
 -1,
 271328093,
 128040,
 271585407,
 265622191,
 -1,
 271650893,
 271516486,
 -1,
 271716425,
 271583475,
 -1,
 271781960,
 271650658,
 -1,
 271847491,
 271726538,
 -1,
 271913026,
 271777792,
 -1,
 271978553,
 271855581,
 128539,
 272105471,
 271908866,
 -1,
 -61384,
 271988664,
 128540,
 -1,
 272052749,
 128541,
 272240701,
 271917898,
 -1,
 272306236,
 272181045,
 128558,
 -1,
 272236552,
 128560,
 -1,
 272243506,
 128582,
 -61378,
 272183604,
 128514,
 -61377,
 272442011,
 128581,
 -61376,
 272506979,
 128567,
 -61375,
 272572169,
 128548,
 -1,
 272632704,
 128531,
 -1,
 271853192,
 128566,
 272896070,
 271789246,
 -1,
 -61371,
 272829498,
 128561,
 -1,
 272893678,
 128523,
 -61369,
 272839139,
 128536,
 -1,
 273031196,
 128134,
 -1,
 271725183,
 127981,
 -61366,
 271661306,
 128224,
 -61365,
 273232293,
 127877,
 -61364,
 273293592,
 128106,
 -1,
 273358495,
 127810,
 273551455,
 271587164,
 -1,
 273616983,
 273492314,
 -1,
 273682516,
 273551200,
 128293,
 273748051,
 273627356,
 -1,
 -61358,
 273689790,
 127878,
 -1,
 273744234,
 127879,
 -1,
 273678448,
 128658,
 274071551,
 273624972,
 -1,
 -61354,
 273954783,
 127771,
 -1,
 274018336,
 127763,
 274206812,
 273558718,
 -1,
 274272347,
 274142640,
 128031,
 -61350,
 274209102,
 127907,
 -1,
 274268213,
 127845,
 -1,
 274215233,
 128074,
 274595839,
 274144606,
 -1,
 -61346,
 274476408,
 983106,
 -1,
 274535330,
 128193,
 274731110,
 273492314,
 -1,
 274796644,
 274670410,
 -1,
 -61342,
 274741371,
 128550,
 -61341,
 274801390,
 128037,
 -1,
 274863134,
 128056,
 -61339,
 274733079,
 127844,
 -1,
 274993284,
 127839,
 275189869,
 274670410,
 -1,
 275255402,
 275130714,
 -1,
 -61335,
 275193745,
 983071,
 -1,
 275258150,
 127860,
 -61333,
 275199316,
 127808,
 -61332,
 275392022,
 128099,
 -1,
 275453148,
 127745,
 275648627,
 275127427,
 -1,
 275714161,
 275587914,
 -1,
 -61328,
 275658616,
 127924,
 -1,
 275720259,
 128190,
 -61326,
 275658134,
 128563,
 -1,
 275845777,
 128170,
 276041847,
 275592949,
 -1,
 -61323,
 275972901,
 983210,
 -61322,
 276038431,
 983209,
 -1,
 276103965,
 983208,
 276303994,
 275985495,
 -1,
 -61319,
 276248543,
 127773,
 -1,
 276312096,
 127765,
 276500605,
 276238176,
 -1,
 -61316,
 276442225,
 127905,
 -1,
 276497980,
 128552,
 -61314,
 276442302,
 983107,
 -1,
 276632239,
 983072,
 276828366,
 271521200,
 -1,
 276893848,
 276767562,
 -1,
 276959372,
 276834650,
 -1,
 277024904,
 276896390,
 -1,
 277090439,
 276956084,
 983059,
 277217279,
 277020672,
 -1,
 -61306,
 277100533,
 983140,
 -1,
 277163420,
 983137,
 -1,
 277031340,
 128677,
 277479423,
 276966740,
 128014,
 277544959,
 277348352,
 -1,
 -61301,
 277424539,
 127943,
 -1,
 277484215,
 128052,
 277680273,
 276902772,
 -1,
 277745808,
 277622103,
 -1,
 -61297,
 277690345,
 127969,
 -1,
 277743805,
 127968,
 -1,
 277687040,
 9203,
 278007956,
 277619215,
 -1,
 -61293,
 277940081,
 128029,
 -1,
 278004048,
 127855,
 -61291,
 277950803,
 127976,
 -61290,
 278146875,
 127973,
 -61289,
 278210239,
 983123,
 -1,
 278268599,
 128298,
 278466733,
 276828000,
 -1,
 278532267,
 278397766,
 -1,
 278597795,
 278476541,
 -1,
 278663326,
 278535967,
 -1,
 -61283,
 278605346,
 10079,
 -1,
 278662715,
 10080,
 278859937,
 278596854,
 -1,
 -61280,
 278799404,
 128178,
 -1,
 278862428,
 10135,
 -61278,
 278800322,
 10133,
 -1,
 278995229,
 10134,
 279187626,
 278538586,
 -1,
 279253161,
 279130193,
 -1,
 279318696,
 279197647,
 -1,
 -61273,
 279259945,
 128157,
 -1,
 279316063,
 128152,
 -1,
 279252339,
 128159,
 -1,
 279184116,
 128585,
 -1,
 279121679,
 127911,
 -61268,
 278473277,
 127807,
 -1,
 279649886,
 128641,
 279843007,
 278402908,
 -1,
 279908534,
 279783865,
 -1,
 279974069,
 279840730,
 -1,
 -61263,
 279917428,
 983959,
 -61262,
 279978826,
 983961,
 -61261,
 280041308,
 983958,
 -61260,
 280104800,
 983960,
 -1,
 280167238,
 983957,
 -1,
 279905829,
 110593,
 280432830,
 279844064,
 -1,
 280498363,
 280363715,
 -1,
 280563898,
 280440623,
 128644,
 -1,
 280494471,
 128645,
 -1,
 280499847,
 128096,
 280821759,
 280428544,
 -1,
 -61251,
 280699804,
 983122,
 -1,
 280758431,
 128262,
 -1,
 280365050,
 127802,
 281022664,
 279774022,
 -1,
 281088196,
 280960911,
 -1,
 -61246,
 281030567,
 128057,
 -61245,
 281092315,
 128296,
 -1,
 281151699,
 127828,
 -61243,
 281030930,
 128035,
 -61242,
 281290828,
 128587,
 -61241,
 281354722,
 128092,
 -1,
 281418196,
 128135,
 281612491,
 280965199,
 983060,
 -61238,
 281554110,
 983138,
 -1,
 281614992,
 983141,
 281870335,
 281555828,
 -1,
 -61235,
 281750985,
 128559,
 -1,
 281813480,
 128175,
 282005787,
 276761846,
 -1,
 282071278,
 281939808,
 -1,
 282136809,
 282015192,
 -1,
 282202338,
 282068321,
 -1,
 282267866,
 282146537,
 -1,
 282333398,
 282211188,
 -1,
 -61227,
 282276883,
 2391,
 -1,
 282333024,
 2390,
 282530009,
 282272586,
 -1,
 -61224,
 282469312,
 2363,
 -1,
 282529632,
 2362,
 -1,
 282461958,
 2383,
 282853375,
 282205657,
 -1,
 282857694,
 282735476,
 -1,
 -61219,
 282801171,
 2423,
 -1,
 282857312,
 2422,
 283054305,
 282796874,
 -1,
 -61216,
 282993600,
 2420,
 -1,
 283053920,
 2419,
 -1,
 282986246,
 2421,
 283377663,
 282138542,
 -1,
 283381990,
 283258959,
 -1,
 -61211,
 283326614,
 983085,
 -1,
 283383597,
 983087,
 -61209,
 283324356,
 983160,
 -61208,
 283518135,
 983083,
 -1,
 283579348,
 983089,
 283775212,
 282074243,
 983119,
 -61205,
 283712080,
 128666,
 -1,
 283775411,
 983118,
 -61203,
 283715347,
 127980,
 -1,
 283904724,
 127795,
 284102906,
 282010442,
 -1,
 284168434,
 284047470,
 -1,
 -61199,
 284110529,
 128317,
 -1,
 284175010,
 128315,
 284365045,
 284111732,
 -1,
 -61196,
 284300543,
 127849,
 -1,
 284362776,
 10175,
 284561655,
 284300316,
 128021,
 -1,
 284491903,
 128054,
 -61192,
 284501389,
 128682,
 -61191,
 284630865,
 128044,
 -1,
 284688642,
 128687,
 284889347,
 284039004,
 -1,
 284954878,
 284834367,
 -1,
 -61187,
 284897312,
 128171,
 -1,
 284955319,
 128565,
 285151489,
 284896552,
 -1,
 -61184,
 285086391,
 128542,
 -1,
 285149406,
 128549,
 -61182,
 285092485,
 127919,
 -1,
 285279531,
 128160,
 285479180,
 284820294,
 -1,
 285544711,
 285417845,
 -1,
 -61178,
 285480282,
 127841,
 -1,
 285542979,
 128131,
 285741322,
 285480145,
 -1,
 -61175,
 285682531,
 11831,
 -1,
 285744517,
 11830,
 -61173,
 285683901,
 983081,
 -1,
 285879734,
 128168,
 286069011,
 285419866,
 -1,
 286134544,
 286008138,
 -1,
 -61169,
 286074782,
 128167,
 -1,
 286138454,
 128042,
 286331154,
 286065832,
 128009,
 -1,
 286261375,
 128050,
 -1,
 286265759,
 128087,
 286527769,
 286001395,
 -1,
 -61163,
 286469310,
 983161,
 -61162,
 286524199,
 983090,
 -61161,
 286589733,
 983088,
 -61160,
 286655263,
 983086,
 -1,
 286720797,
 983084,
 -61158,
 286471665,
 128192,
 -1,
 286858587,
 983082,
 287052112,
 281949953,
 -1,
 287117608,
 286987696,
 -1,
 287183143,
 287054399,
 -1,
 -61153,
 287126709,
 128070,
 -61152,
 287190850,
 128307,
 -61151,
 287255407,
 128073,
 -61150,
 287320383,
 10068,
 -61149,
 287382928,
 128072,
 -61148,
 287446646,
 9989,
 -61147,
 287511433,
 128174,
 -61146,
 287576695,
 10069,
 -1,
 287641233,
 128071,
 -1,
 287114481,
 128011,
 287904052,
 287056714,
 -1,
 287969586,
 287842191,
 -1,
 288035121,
 287901013,
 128105,
 288100656,
 287976640,
 -1,
 -61139,
 288042273,
 128097,
 -61138,
 288101960,
 128082,
 -61137,
 288164706,
 128090,
 -1,
 288229482,
 128098,
 -1,
 288031129,
 128111,
 -1,
 287969458,
 128698,
 -61133,
 287911014,
 128543,
 -1,
 288497190,
 128058,
 288690498,
 287834950,
 -1,
 288756027,
 288633191,
 -1,
 288821562,
 288686080,
 -1,
 -61128,
 288765745,
 127754,
 -61127,
 288820059,
 128702,
 -1,
 288884917,
 128003,
 -1,
 288759986,
 127817,
 289149246,
 288700713,
 -1,
 -61123,
 289084695,
 127764,
 -1,
 289147992,
 127762,
 289345857,
 289088058,
 -1,
 -61120,
 289281303,
 127766,
 -1,
 289344600,
 127768,
 -1,
 289289865,
 128075,
 289608008,
 288624480,
 -1,
 289673542,
 289539696,
 -1,
 -61115,
 289608375,
 128553,
 -1,
 289671624,
 128576,
 -61113,
 289609778,
 983225,
 -1,
 289803629,
 128146,
 290001228,
 289544421,
 -1,
 -61110,
 289938469,
 128521,
 -61109,
 290000741,
 127863,
 -1,
 290065667,
 127888,
 290263375,
 289941850,
 -1,
 -61106,
 290197631,
 128295,
 -1,
 290260477,
 127873,
 -1,
 290200208,
 983224,
 290525562,
 286991178,
 -1,
 290591070,
 290465471,
 -1,
 290656604,
 290525024,
 -1,
 290722139,
 290595191,
 -1,
 290787671,
 290660306,
 -1,
 -61098,
 290728404,
 128236,
 -1,
 290791236,
 128237,
 -61096,
 290725618,
 128275,
 -61095,
 290919971,
 128080,
 -61094,
 290984781,
 128194,
 -1,
 291047525,
 128214,
 -1,
 290662931,
 983190,
 -61091,
 290599414,
 128191,
 -1,
 291247868,
 9934,
 291443049,
 290531674,
 -1,
 291508584,
 291379827,
 -1,
 291574117,
 291447995,
 -1,
 -61086,
 291515985,
 2933,
 -61085,
 291580170,
 2930,
 -61084,
 291640811,
 2931,
 -1,
 291704884,
 2934,
 291962879,
 291516874,
 -1,
 -61081,
 291843675,
 2935,
 -1,
 291907858,
 2932,
 -1,
 291440011,
 128217,
 292163952,
 291381621,
 -1,
 292229487,
 292096918,
 -1,
 -61076,
 292172045,
 128662,
 -61075,
 292235258,
 128660,
 -61074,
 292292826,
 128653,
 -1,
 292357850,
 128664,
 -1,
 292159999,
 128283,
 292622707,
 292101446,
 -1,
 -61070,
 292567209,
 128117,
 -1,
 292626440,
 128116,
 -61068,
 292567288,
 128002,
 -61067,
 292763057,
 128228,
 -61066,
 292826426,
 983191,
 -61065,
 292887356,
 128076,
 -61064,
 292950846,
 127970,
 -61063,
 293014910,
 127842,
 -1,
 293080197,
 128025,
 293278118,
 290460700,
 -1,
 293343628,
 293218650,
 -1,
 293409154,
 293279580,
 -1,
 293474689,
 293347961,
 -1,
 293540224,
 293409463,
 128512,
 -1,
 293470868,
 128513,
 -1,
 293472762,
 128568,
 -1,
 293412796,
 128556,
 293802374,
 293343223,
 -1,
 -61052,
 293738071,
 128154,
 -61051,
 293800037,
 128215,
 -1,
 293864971,
 127823,
 294064521,
 293741386,
 -1,
 -61048,
 294008739,
 128151,
 -1,
 294073552,
 983109,
 294322175,
 293995334,
 -1,
 -61045,
 294201175,
 127815,
 -1,
 294260521,
 127891,
 294457754,
 293277536,
 -1,
 294523289,
 294397372,
 -1,
 294588819,
 294460889,
 -1,
 -61040,
 294531968,
 983915,
 -61039,
 294591659,
 4351,
 -61038,
 294655550,
 4350,
 -1,
 294716476,
 4349,
 294916502,
 294530680,
 -1,
 -61035,
 294861279,
 11559,
 -1,
 294913084,
 11565,
 295174143,
 294848887,
 -1,
 -61032,
 295057887,
 4295,
 -1,
 295109692,
 4301,
 -1,
 294461349,
 128142,
 295375262,
 294400884,
 -1,
 -61028,
 295312038,
 2800,
 -61027,
 295377466,
 127928,
 -1,
 295437876,
 128130,
 295637409,
 295313135,
 -1,
 -61024,
 295581614,
 127775,
 -1,
 295634783,
 127760,
 -61022,
 295578814,
 983110,
 -61021,
 295773030,
 128016,
 -61020,
 295836122,
 128103,
 -61019,
 295900962,
 128123,
 -1,
 295961873,
 127922,
 296161728,
 293214044,
 -1,
 296227261,
 296100213,
 -1,
 296292783,
 296167634,
 -1,
 296358317,
 296230143,
 -1,
 -61013,
 296300193,
 128289,
 -61012,
 296361480,
 128292,
 -1,
 296421796,
 128288,
 -61010,
 296300615,
 128291,
 -1,
 296559404,
 128290,
 296751543,
 296227757,
 -1,
 296817078,
 296693122,
 -1,
 296882612,
 296759375,
 -1,
 -61005,
 296827030,
 983111,
 -1,
 296884013,
 983108,
 -61003,
 296821943,
 983114,
 -1,
 297014228,
 983105,
 -1,
 296750492,
 128129,
 297275834,
 296684790,
 983129,
 -60999,
 297211801,
 8377,
 -1,
 297276020,
 983128,
 -60997,
 297219654,
 9959,
 -60996,
 297405342,
 128232,
 -1,
 297470089,
 128229,
 -60994,
 296172014,
 127982,
 -60993,
 297607496,
 128127,
 -1,
 297667111,
 127848,
 297865675,
 296098448,
 -1,
 297931210,
 297796422,
 -1,
 297996745,
 297871109,
 -1,
 -60988,
 297938983,
 128304,
 -60987,
 298002463,
 127971,
 -60986,
 298066921,
 128121,
 -60985,
 298128733,
 128122,
 -60984,
 298192414,
 127886,
 -1,
 298256833,
 127983,
 -1,
 297929489,
 127875,
 -1,
 297865115,
 128086,
 298586579,
 297808756,
 -1,
 298652111,
 298526423,
 -1,
 -60978,
 298593985,
 128316,
 -1,
 298658466,
 128314,
 298848722,
 298590581,
 -1,
 -60975,
 298785316,
 983115,
 -1,
 298845513,
 128530,
 -1,
 298790078,
 983116,
 299110873,
 298531381,
 -1,
 299176407,
 299049333,
 -1,
 -60970,
 299113104,
 983213,
 -1,
 299174065,
 983248,
 -60968,
 299118360,
 983212,
 -1,
 299309712,
 983214,
 299565055,
 299055423,
 -1,
 -60965,
 299439989,
 983228,
 -1,
 299503694,
 128155]
_charnames_2112 = [
2460,
2454,
2452,
2453,
2451,
2458,
2443,
2456,
2440,
2442,
2441,
2449,
2448,
2447,
2436,
2457,
2446,
2437,
2445,
2444,
2438,
2439,
2461,
2459,
2450,
2465,
2462,
2464,
-1,
-1,
2463,
]

_charnames_2208 = [
1898,
-1,
1896,
1891,
1897,
1892,
1894,
1893,
1885,
1886,
1889,
1890,
1888,
]

_charnames_2276 = [
1915,
1917,
1913,
1916,
1918,
1914,
1908,
1905,
1911,
1907,
1904,
1910,
1925,
1926,
1924,
1880,
1932,
1933,
1935,
1901,
1920,
1900,
1922,
1928,
1929,
1921,
1930,
]

_charnames_2383 = [
4313,
-1,
-1,
-1,
-1,
-1,
-1,
4309,
4308,
]

_charnames_4295 = [
4503,
-1,
-1,
-1,
-1,
-1,
4504,
]

_charnames_7098 = [
2779,
2772,
2773,
2774,
2771,
2770,
865,
834,
860,
832,
848,
864,
857,
850,
829,
842,
847,
853,
826,
851,
861,
833,
858,
862,
855,
828,
844,
830,
835,
839,
836,
827,
846,
852,
825,
840,
856,
831,
838,
863,
841,
849,
859,
854,
884,
872,
874,
873,
876,
871,
875,
870,
867,
868,
889,
890,
887,
886,
]

_charnames_7360 = [
2762,
2761,
2760,
2766,
2763,
2764,
2765,
2767,
]

_charnames_8341 = [
3800,
3799,
3798,
3797,
3796,
3795,
3794,
3793,
]

_charnames_9193 = [
1080,
1083,
1085,
1088,
1081,
1084,
1082,
2106,
2814,
1599,
4240,
]

_charnames_9989 = [
4387,
-1,
-1,
-1,
-1,
4015,
4014,
]

_charnames_10060 = [
3438,
-1,
3693,
-1,
-1,
-1,
-1,
1087,
4385,
4389,
]

_charnames_11559 = [
4500,
-1,
-1,
-1,
-1,
-1,
4501,
]

_charnames_11826 = [
1635,
4016,
4017,
1633,
4361,
4360,
1634,
1624,
1654,
1660,
]

_charnames_42612 = [
3384,
3385,
3381,
3383,
3389,
3382,
3387,
3388,
]

_charnames_42893 = [
3808,
3788,
-1,
3804,
3780,
3813,
3790,
]

_charnames_42912 = [
3807,
3786,
3811,
3789,
3803,
3779,
3810,
3787,
3809,
3771,
3812,
]

_charnames_43744 = [
2406,
2405,
2407,
2400,
2395,
2394,
2404,
2403,
2401,
2398,
2397,
2417,
2416,
2413,
2414,
2412,
2424,
2421,
2420,
2423,
2422,
2415,
2418,
]

_charnames_43777 = [
3908,
3910,
3911,
3907,
3906,
3909,
-1,
-1,
3885,
3887,
3888,
3884,
3883,
3886,
-1,
-1,
3878,
3880,
3881,
3877,
3876,
3879,
]

_charnames_43808 = [
3892,
3894,
3896,
3893,
3891,
3890,
3895,
-1,
3900,
3902,
3904,
3901,
3899,
3898,
3903,
]

_charnames_64434 = [
1871,
1870,
1861,
1860,
1867,
1866,
1865,
1864,
1878,
1877,
1872,
1859,
1858,
1879,
1875,
1874,
]

_charnames_67968 = [
2355,
2353,
2351,
2348,
2344,
2345,
2342,
2343,
2347,
2349,
2331,
2332,
2329,
2330,
2337,
2338,
2350,
2340,
2352,
2334,
2335,
2336,
2341,
2346,
2325,
2326,
2323,
2324,
2327,
2354,
2356,
2357,
2373,
2385,
2383,
2380,
2375,
2376,
2387,
2379,
2381,
2369,
2368,
2377,
2382,
2371,
2384,
2366,
2374,
2365,
2372,
2378,
2363,
2362,
2361,
2386,
-1,
-1,
-1,
-1,
-1,
-1,
2389,
2390,
]

_charnames_69632 = [
1058,
1059,
1055,
1057,
1056,
951,
954,
973,
974,
959,
960,
924,
925,
926,
927,
988,
953,
935,
952,
969,
968,
977,
976,
943,
980,
979,
972,
971,
941,
932,
931,
948,
947,
942,
934,
933,
950,
949,
944,
963,
962,
983,
982,
986,
984,
985,
966,
928,
957,
956,
958,
987,
965,
939,
937,
938,
1028,
1035,
1031,
1032,
1029,
1030,
1021,
1022,
1023,
1024,
1034,
1027,
1033,
1026,
1036,
1053,
1052,
1066,
1065,
1063,
1067,
1062,
-1,
-1,
-1,
-1,
1010,
992,
995,
1005,
1008,
999,
1001,
1016,
1014,
997,
993,
996,
1006,
1009,
1000,
1002,
1017,
1015,
1013,
1012,
1048,
1049,
1040,
1041,
1046,
1047,
1043,
1044,
1051,
1050,
]

_charnames_69840 = [
2723,
2722,
2735,
2734,
2733,
2732,
2714,
2711,
2727,
2712,
2720,
2725,
2719,
2724,
2731,
2728,
2729,
2710,
2736,
2718,
2730,
2721,
2726,
2717,
2715,
]

_charnames_69872 = [
2747,
2748,
2739,
2740,
2745,
2746,
2742,
2743,
2750,
2749,
-1,
-1,
-1,
-1,
-1,
-1,
3287,
3288,
3286,
3253,
3250,
3245,
3252,
3231,
3230,
3237,
3236,
3215,
3240,
3239,
3234,
3233,
3213,
3209,
3208,
3220,
3219,
3214,
3211,
3210,
3222,
3221,
3216,
3228,
3227,
3243,
3242,
3248,
3224,
3225,
3247,
3249,
3244,
3246,
3251,
3273,
3280,
3281,
3276,
3277,
3282,
3275,
3278,
3274,
3279,
3291,
3293,
3283,
3292,
-1,
3265,
3266,
3257,
3258,
3263,
3264,
3260,
3261,
3268,
3267,
3289,
3270,
3269,
3290,
]

_charnames_70016 = [
2633,
2630,
2626,
2551,
2554,
2573,
2574,
2559,
2560,
2529,
2530,
2531,
2532,
2589,
2553,
2586,
2552,
2569,
2568,
2577,
2576,
2543,
2580,
2579,
2572,
2571,
2541,
2537,
2536,
2548,
2547,
2542,
2539,
2538,
2550,
2549,
2544,
2563,
2562,
2583,
2582,
2587,
2584,
2585,
2566,
2565,
2533,
2557,
2556,
2558,
2588,
2599,
2602,
2603,
2600,
2601,
2592,
2593,
2594,
2595,
2605,
2598,
2604,
2597,
2627,
2629,
2632,
2631,
2635,
2622,
2621,
2636,
2634,
]

_charnames_70096 = [
2617,
2618,
2609,
2610,
2615,
2616,
2612,
2613,
2620,
2619,
]

_charnames_71296 = [
1503,
1506,
1524,
1525,
1507,
1508,
1541,
1505,
1537,
1504,
1520,
1519,
1528,
1527,
1495,
1531,
1530,
1523,
1522,
1493,
1489,
1488,
1500,
1499,
1494,
1491,
1490,
1502,
1501,
1496,
1517,
1516,
1534,
1533,
1538,
1535,
1514,
1539,
1536,
1510,
1511,
1540,
1513,
1572,
1569,
1560,
1563,
1564,
1561,
1562,
1566,
1559,
1565,
1558,
1570,
1571,
]

_charnames_71360 = [
1552,
1553,
1544,
1545,
1550,
1551,
1547,
1548,
1555,
1554,
]

_charnames_92160 = [
551,
659,
628,
629,
572,
603,
648,
560,
606,
625,
626,
582,
644,
553,
580,
587,
596,
614,
547,
634,
565,
612,
550,
654,
653,
546,
585,
620,
657,
621,
592,
559,
662,
658,
545,
613,
597,
598,
590,
638,
622,
569,
631,
581,
574,
630,
643,
651,
611,
646,
584,
635,
568,
639,
591,
602,
652,
665,
664,
640,
610,
586,
605,
543,
607,
556,
618,
566,
661,
552,
583,
573,
595,
557,
647,
609,
619,
562,
579,
555,
637,
563,
663,
650,
575,
571,
594,
699,
734,
708,
709,
729,
671,
718,
737,
670,
719,
723,
738,
727,
701,
702,
740,
722,
733,
706,
705,
680,
673,
696,
714,
741,
713,
728,
724,
746,
694,
691,
745,
710,
735,
684,
689,
690,
681,
707,
674,
685,
697,
721,
683,
743,
672,
744,
715,
678,
677,
730,
692,
700,
675,
717,
693,
404,
441,
495,
533,
402,
419,
405,
528,
453,
530,
445,
437,
451,
523,
423,
460,
479,
529,
482,
496,
440,
463,
414,
455,
497,
490,
491,
512,
424,
506,
432,
502,
514,
401,
535,
444,
471,
438,
398,
517,
456,
474,
435,
504,
399,
538,
418,
415,
413,
539,
536,
452,
537,
431,
518,
501,
410,
428,
486,
397,
467,
464,
519,
488,
430,
406,
532,
400,
412,
436,
489,
411,
422,
470,
498,
421,
509,
513,
454,
468,
461,
480,
450,
481,
459,
494,
427,
473,
472,
510,
484,
485,
407,
443,
520,
524,
525,
505,
299,
386,
246,
282,
247,
360,
249,
259,
240,
265,
385,
234,
312,
236,
331,
342,
311,
252,
318,
332,
377,
335,
322,
284,
268,
301,
293,
324,
376,
250,
329,
231,
346,
389,
233,
391,
269,
288,
355,
270,
305,
290,
363,
289,
281,
358,
256,
297,
338,
264,
344,
323,
375,
330,
383,
345,
232,
285,
255,
328,
368,
366,
262,
356,
239,
286,
242,
374,
369,
373,
271,
274,
319,
336,
244,
235,
347,
294,
334,
260,
343,
302,
241,
354,
243,
258,
251,
388,
333,
380,
350,
348,
263,
382,
357,
295,
279,
317,
304,
315,
310,
337,
277,
313,
275,
367,
278,
314,
364,
303,
359,
381,
349,
276,
298,
321,
392,
36,
120,
100,
165,
222,
160,
72,
154,
209,
49,
40,
68,
112,
13,
179,
215,
152,
22,
73,
119,
172,
162,
51,
28,
91,
11,
27,
50,
211,
45,
85,
155,
17,
98,
198,
12,
46,
93,
159,
23,
38,
113,
151,
69,
34,
19,
142,
199,
117,
133,
86,
116,
177,
153,
124,
220,
217,
166,
65,
110,
203,
29,
149,
97,
101,
54,
63,
206,
115,
173,
143,
56,
141,
105,
39,
80,
130,
168,
188,
205,
8,
178,
90,
14,
201,
190,
59,
84,
136,
21,
57,
53,
87,
95,
189,
62,
103,
200,
186,
102,
67,
9,
171,
79,
60,
134,
18,
76,
187,
192,
43,
225,
121,
223,
224,
164,
75,
109,
111,
35,
148,
135,
24,
131,
138,
139,
128,
129,
176,
83,
44,
70,
216,
193,
221,
167,
94,
212,
210,
25,
30,
146,
147,
185,
61,
77,
161,
180,
106,
89,
92,
123,
181,
104,
125,
191,
202,
779,
817,
776,
819,
784,
798,
757,
809,
786,
787,
794,
799,
761,
753,
789,
767,
766,
768,
769,
775,
773,
750,
749,
752,
811,
764,
812,
759,
803,
758,
814,
804,
788,
760,
782,
774,
755,
756,
765,
805,
818,
815,
808,
807,
778,
791,
783,
795,
793,
792,
800,
777,
770,
816,
]

_charnames_93952 = [
2241,
2252,
2187,
2240,
2244,
2243,
2216,
2251,
2235,
2234,
2154,
2209,
2185,
2186,
2153,
2208,
2165,
2167,
2188,
2214,
2161,
2160,
2223,
2222,
2221,
2220,
2152,
2207,
2151,
2206,
2250,
2232,
2189,
2238,
2237,
2164,
2163,
2213,
2247,
2248,
2231,
2230,
2147,
2202,
2158,
2157,
2148,
2203,
2183,
2190,
2199,
2226,
2225,
2178,
2176,
2149,
2204,
2184,
2227,
2179,
2177,
2174,
2172,
2215,
2173,
2171,
2249,
2217,
2246,
]

_charnames_94032 = [
2166,
2306,
2304,
2305,
2263,
2271,
2270,
2264,
2265,
2285,
2287,
2292,
2291,
2279,
2282,
2283,
2288,
2254,
2255,
2256,
2257,
2259,
2262,
2261,
2258,
2260,
2272,
2273,
2274,
2275,
2276,
2278,
2277,
2289,
2290,
2266,
2267,
2281,
2294,
2280,
2293,
2269,
2284,
2268,
2286,
2295,
2296,
]

_charnames_94095 = [
2299,
2298,
2301,
2300,
2145,
2144,
2143,
2142,
2141,
2140,
2139,
2198,
2197,
2196,
2195,
2194,
2193,
]

_charnames_126464 = [
1840,
1852,
1848,
1706,
-1,
1843,
1831,
1849,
1825,
1842,
1838,
1744,
1847,
1846,
1777,
1841,
1851,
1778,
1845,
1844,
1776,
1829,
1827,
1837,
1828,
1707,
1832,
1850,
1704,
1702,
1703,
1701,
-1,
1802,
1798,
-1,
1791,
-1,
-1,
1792,
-1,
1793,
1789,
1797,
1796,
1795,
1782,
1803,
1800,
1783,
1794,
-1,
1781,
1786,
1785,
1788,
-1,
1801,
-1,
1799,
-1,
-1,
-1,
-1,
-1,
-1,
1821,
-1,
-1,
-1,
-1,
1822,
-1,
1816,
-1,
1819,
-1,
1818,
1809,
1824,
-1,
1810,
1817,
-1,
1808,
-1,
-1,
1820,
-1,
1815,
-1,
1823,
-1,
1814,
-1,
1813,
-1,
1774,
1771,
-1,
1764,
-1,
-1,
1765,
1750,
1767,
1762,
-1,
1770,
1769,
1753,
1775,
1773,
1754,
1768,
-1,
1752,
1749,
1748,
1761,
-1,
1759,
1766,
1772,
1758,
-1,
1757,
-1,
1730,
1743,
1740,
1727,
1724,
1733,
1721,
1725,
1715,
1732,
-1,
1738,
1737,
1736,
1718,
1731,
1742,
1719,
1735,
1734,
1717,
1714,
1712,
1739,
1713,
1728,
1722,
1741,
-1,
-1,
-1,
-1,
-1,
1698,
1694,
1684,
-1,
1687,
1681,
1695,
1675,
1686,
-1,
1692,
1691,
1690,
1678,
1699,
1697,
1679,
1689,
1688,
1677,
1674,
1672,
1693,
1673,
1685,
1682,
1696,
]

_charnames_127136 = [
3563,
3557,
3489,
3494,
3527,
3532,
3505,
3510,
3552,
3542,
3499,
3547,
3516,
3537,
3521,
-1,
-1,
3558,
3490,
3495,
3528,
3533,
3506,
3511,
3553,
3543,
3500,
3548,
3517,
3538,
3522,
-1,
-1,
3559,
3491,
3496,
3529,
3534,
3507,
3512,
3554,
3544,
3501,
3549,
3518,
3539,
3523,
3562,
-1,
3560,
3492,
3497,
3530,
3535,
3508,
3513,
3555,
3545,
3502,
3550,
3519,
3540,
3524,
3564,
]

_charnames_127280 = [
2672,
-1,
2671,
2670,
2669,
2668,
2667,
2666,
2665,
2664,
2663,
2662,
2661,
-1,
2660,
-1,
2659,
2658,
-1,
2657,
2656,
2655,
-1,
2654,
2653,
2652,
-1,
-1,
-1,
-1,
-1,
2699,
3719,
3718,
3717,
3716,
3715,
3714,
3713,
-1,
3712,
3711,
3710,
3709,
3708,
3707,
3706,
-1,
3705,
3704,
3703,
3702,
3701,
3700,
3699,
3698,
3697,
3696,
4013,
4012,
-1,
-1,
-1,
-1,
3691,
3690,
3689,
3688,
3687,
3686,
3685,
3684,
3683,
-1,
3682,
-1,
-1,
3681,
3680,
-1,
3679,
3678,
3677,
3676,
3675,
3674,
3673,
3672,
3671,
3670,
-1,
-1,
-1,
-1,
3694,
3692,
-1,
2692,
2691,
2705,
2704,
2695,
2694,
2703,
2702,
2701,
2700,
]

_charnames_127462 = [
3996,
3995,
3994,
3993,
3992,
3991,
3990,
3989,
3988,
3987,
3986,
3985,
3984,
3983,
3982,
3981,
3980,
3979,
3978,
3977,
3976,
3975,
3974,
3973,
3972,
3971,
-1,
2698,
2697,
]

_charnames_127538 = [
2680,
2679,
2689,
2686,
2684,
2685,
2681,
2690,
2688,
]

_charnames_127744 = [
3468,
4204,
3368,
3761,
2781,
2780,
3458,
2782,
4018,
1070,
4407,
3200,
2317,
3938,
3937,
3936,
4512,
3725,
4413,
4182,
4412,
4217,
4415,
3832,
4416,
3448,
3724,
4181,
3831,
4216,
2784,
4511,
2641,
]

_charnames_127792 = [
3307,
2894,
3965,
4333,
3586,
3431,
-1,
1638,
3305,
4029,
4286,
2783,
1094,
3941,
3940,
4267,
4202,
2479,
4172,
3855,
2517,
1627,
2119,
4490,
2429,
4410,
1574,
3853,
901,
3635,
4007,
4485,
3608,
3609,
3306,
2806,
4291,
2885,
2430,
3616,
4039,
4040,
3405,
3472,
2810,
2831,
1075,
4197,
4033,
4357,
4472,
2787,
4196,
4186,
2754,
2637,
4543,
4339,
3404,
3314,
3428,
3845,
3477,
4243,
2640,
1115,
3624,
3403,
4201,
1646,
2915,
4426,
3413,
1606,
1120,
3373,
906,
-1,
-1,
-1,
4042,
4430,
1123,
4553,
3313,
4170,
4177,
4178,
917,
3574,
3395,
1575,
3439,
3636,
4551,
3422,
4427,
2510,
2900,
4491,
]

_charnames_127904 = [
3423,
4219,
4031,
4185,
2310,
2509,
3459,
4266,
1937,
1623,
3457,
1600,
3376,
3602,
3193,
4353,
2884,
1128,
4517,
1107,
4207,
2515,
2518,
2913,
4508,
2516,
1619,
3196,
2514,
4045,
1647,
2918,
916,
3308,
2911,
4046,
2790,
-1,
1607,
4234,
2127,
4047,
2919,
]

_charnames_127968 = [
4239,
4238,
4471,
4548,
3963,
4245,
895,
2118,
4244,
3842,
3399,
2899,
4332,
4168,
4541,
4552,
3964,
]

_charnames_128000 = [
4024,
2488,
4467,
4409,
3406,
1596,
3852,
4022,
3415,
4368,
3441,
4391,
2910,
2909,
4232,
4025,
4514,
2648,
2492,
4030,
3312,
4341,
3630,
1109,
3947,
4473,
2834,
1136,
2108,
4242,
3833,
4184,
1605,
1093,
1636,
4292,
905,
4194,
1124,
3606,
4142,
3628,
4367,
912,
4344,
2489,
3407,
1597,
4023,
3416,
4369,
2832,
4235,
2493,
4342,
3633,
4195,
4289,
4403,
1119,
3585,
3632,
3582,
-1,
3957,
-1,
3933,
3746,
2490,
1626,
4382,
4390,
4386,
4384,
4187,
4417,
4470,
1658,
1659,
3375,
4440,
3440,
4397,
3958,
3731,
1662,
4554,
4370,
4139,
1129,
4398,
3643,
4294,
3617,
2471,
2131,
4282,
4396,
4399,
4203,
1134,
1133,
1106,
4515,
2432,
4394,
4171,
2470,
1652,
1651,
3621,
4400,
1071,
3596,
2469,
2468,
4466,
4465,
902,
3397,
3661,
4549,
4550,
4516,
907,
3960,
2104,
4542,
2917,
4534,
4509,
4358,
3863,
3755,
4167,
4295,
914,
2888,
3638,
4138,
3841,
4041,
4505,
4131,
1108,
3411,
4423,
1118,
1076,
1653,
2829,
4487,
4263,
1090,
4483,
4571,
3644,
4262,
4001,
4264,
4354,
3946,
2114,
1105,
2881,
3412,
2833,
4366,
4363,
3639,
4210,
4348,
2826,
1661,
4388,
4301,
2496,
3473,
4255,
3449,
897,
900,
899,
898,
2495,
3297,
2897,
3600,
1072,
2315,
4208,
4444,
4377,
4190,
4441,
3577,
3578,
3430,
1645,
3424,
3296,
3298,
915,
3372,
3646,
4028,
3584,
2807,
1616,
1102,
3854,
3743,
3744,
3370,
4442,
4484,
1091,
4456,
1103,
3753,
2901,
2428,
1643,
3579,
4169,
2914,
3647,
3309,
4468,
4540,
3587,
3967,
4539,
3932,
3367,
3366,
4437,
4438,
3626,
3627,
3727,
2504,
2506,
3197,
2507,
3740,
2110,
3429,
-1,
3194,
1641,
4020,
3195,
-1,
-1,
-1,
1655,
3361,
3362,
3363,
2109,
3843,
4285,
2822,
2818,
2821,
2820,
893,
3945,
3849,
4036,
3839,
3369,
4140,
3835,
4439,
1112,
1113,
1101,
3862,
4021,
911,
3929,
4463,
2752,
1625,
3739,
4141,
4524,
4522,
4526,
4525,
4523,
4175,
3944,
4429,
4290,
3751,
4247,
3640,
2309,
1642,
3446,
2876,
4547,
1618,
1086,
4383,
3828,
3827,
3829,
3826,
2856,
2857,
4558,
4337,
4557,
4336,
-1,
-1,
3456,
3437,
3436,
3745,
]

_charnames_128336 = [
3356,
3323,
3329,
3343,
3346,
3336,
3339,
3353,
3359,
3332,
3350,
3326,
3355,
3322,
3328,
3342,
3345,
3335,
3338,
3352,
3358,
3331,
3349,
3325,
]

_charnames_128507 = [
2487,
1628,
2802,
2877,
2508,
4478,
4479,
4157,
2839,
2842,
2843,
2841,
2847,
2845,
4425,
2850,
4165,
4006,
2846,
2849,
2854,
3729,
3961,
4561,
4161,
3605,
3393,
3394,
4133,
4166,
4135,
4136,
4149,
4151,
4152,
4351,
4402,
2113,
3614,
3444,
3601,
4160,
4352,
4193,
2112,
4220,
4420,
2883,
1598,
4481,
3844,
4154,
4300,
4155,
4164,
2122,
4209,
2882,
4349,
4162,
4159,
4480,
3419,
2852,
2853,
3418,
4137,
3615,
3445,
4421,
-1,
-1,
-1,
-1,
4158,
4156,
3599,
2895,
4265,
2823,
4293,
3597,
3598,
3594,
3595,
]

_charnames_128640 = [
4032,
4268,
2811,
4019,
4280,
4281,
1612,
2425,
3864,
2803,
1610,
1611,
1131,
4461,
1608,
1135,
2316,
2128,
4179,
3619,
4460,
1576,
4459,
2117,
4462,
4003,
4330,
1938,
1613,
2497,
2484,
2786,
2485,
2132,
2646,
4027,
2825,
4231,
3189,
3398,
3620,
1617,
4343,
3741,
2858,
3737,
3645,
4345,
3623,
3747,
1127,
3736,
1126,
2486,
3610,
3738,
3311,
2427,
4401,
4005,
904,
1629,
4408,
2639,
891,
892,
3583,
3476,
918,
3851,
]

_charnames_128768 = [
2089,
1985,
2102,
2103,
2087,
1974,
1972,
1973,
1970,
1971,
2035,
2038,
2037,
1952,
2052,
2031,
2062,
2065,
2064,
2005,
1954,
2092,
2040,
2041,
2020,
2021,
2099,
1965,
2082,
2083,
1997,
2016,
2003,
2084,
1949,
1995,
1996,
2004,
1956,
1947,
2042,
2056,
2096,
1983,
1950,
1957,
1948,
2039,
2014,
2015,
2008,
2012,
2011,
2010,
1976,
1977,
2067,
1958,
1982,
2017,
2018,
1980,
2032,
2057,
2058,
2090,
2023,
2026,
2025,
1978,
2101,
1963,
2055,
2098,
2086,
2045,
2000,
2059,
1999,
1966,
2001,
2060,
1962,
2095,
1964,
2100,
2071,
1981,
2047,
2030,
2046,
1984,
1960,
1961,
1951,
2051,
2079,
2077,
2078,
2050,
2049,
1988,
1993,
1992,
1991,
1990,
1979,
2029,
2028,
2019,
2070,
2093,
2080,
2066,
2074,
2073,
]

_charnames_983040 = [
3750,
3749,
2799,
2753,
2797,
2812,
3923,
3915,
3921,
3953,
3931,
3930,
2130,
2129,
2105,
1111,
910,
1140,
3299,
4227,
4296,
1577,
3861,
3726,
3927,
3869,
3760,
3955,
3859,
3187,
3198,
4200,
4222,
3421,
3432,
2644,
3838,
2706,
2645,
3837,
2859,
4362,
4378,
4327,
4376,
4324,
4375,
4325,
4374,
4328,
4373,
3720,
3754,
2891,
2890,
3922,
3916,
3426,
3425,
3926,
3954,
2789,
2788,
3950,
3949,
4533,
4189,
4221,
4531,
4488,
4513,
4530,
4004,
4052,
4532,
4560,
4562,
2815,
4331,
4329,
3581,
3580,
4284,
4246,
1074,
1141,
3735,
3758,
4537,
4535,
3728,
3730,
2796,
2904,
3924,
3951,
3302,
4230,
4297,
3301,
4229,
4298,
3860,
3188,
3199,
3571,
3572,
3566,
3573,
3570,
3565,
3999,
4000,
4034,
2864,
2870,
2906,
2865,
2869,
2905,
4326,
4372,
3659,
3656,
3649,
3658,
3655,
3648,
2896,
2813,
3427,
3483,
2426,
2519,
2800,
2798,
2827,
3928,
3925,
3966,
2795,
2751,
2866,
2920,
2867,
2902,
3400,
3481,
2808,
2791,
4443,
4469,
3660,
3663,
2124,
2125,
3757,
2647,
3806,
3785,
3482,
2889,
4129,
3820,
3821,
3822,
3823,
1589,
4214,
4213,
4212,
2520,
4567,
4565,
4568,
3867,
4050,
3868,
4051,
3664,
3866,
4049,
3759,
2521,
4431,
4422,
2312,
2313,
4570,
3662,
2923,
3034,
3168,
3157,
3146,
3135,
3124,
3113,
3102,
3023,
3012,
3001,
2990,
2979,
2968,
2957,
1139,
1104,
4566,
1138,
2946,
2935,
2924,
3079,
3068,
3057,
3046,
3035,
3090,
3101,
3100,
3099,
3098,
3178,
3177,
3176,
3175,
3174,
3173,
3172,
3171,
3170,
3169,
3167,
3166,
3165,
3164,
3163,
3162,
3161,
3160,
3159,
3158,
3156,
3155,
3154,
3153,
3152,
3151,
3150,
3149,
3148,
3147,
3145,
3144,
3143,
3142,
3141,
3140,
3139,
3138,
3137,
3136,
3134,
3133,
3132,
3131,
3130,
3129,
3128,
3127,
3126,
3125,
3123,
3122,
3121,
3120,
3119,
3118,
3117,
3116,
3115,
3114,
3112,
3111,
3110,
3109,
3108,
3107,
3106,
3105,
3104,
3103,
3033,
3032,
3031,
3030,
3029,
3028,
3027,
3026,
3025,
3024,
3022,
3021,
3020,
3019,
3018,
3017,
3016,
3015,
3014,
3013,
3011,
3010,
3009,
3008,
3007,
3006,
3005,
3004,
3003,
3002,
3000,
2999,
2998,
2997,
2996,
2995,
2994,
2993,
2992,
2991,
2989,
2988,
2987,
2986,
2985,
2984,
2983,
2982,
2981,
2980,
2978,
2977,
2976,
2975,
2974,
2973,
2972,
2971,
2970,
2969,
2967,
2966,
2965,
2964,
2963,
2962,
2961,
2960,
2959,
2958,
2956,
2955,
2954,
2953,
2952,
2951,
2950,
2949,
2948,
2947,
2945,
2944,
2943,
2942,
2941,
2940,
2939,
2938,
2937,
2936,
2934,
2933,
2932,
2931,
2930,
2929,
2928,
2927,
2926,
2925,
3089,
3088,
3087,
3086,
3085,
3084,
3083,
3082,
3081,
3080,
3078,
3077,
3076,
3075,
3074,
3073,
3072,
3071,
3070,
3069,
3067,
3066,
3065,
3064,
3063,
3062,
3061,
3060,
3059,
3058,
3056,
3055,
3054,
3053,
3052,
3051,
3050,
3049,
3048,
3047,
3045,
3044,
3043,
3042,
3041,
3040,
3039,
3038,
3037,
3036,
3097,
3096,
3095,
3094,
3093,
3092,
3091,
]

_charnames_983612 = [
3791,
3776,
3777,
3773,
3774,
3769,
3770,
3782,
3783,
1116,
1475,
1464,
1483,
1463,
1472,
1461,
1471,
1460,
1479,
1480,
1477,
1473,
1468,
1478,
1470,
1469,
1474,
1462,
1481,
1467,
1466,
1465,
1482,
1476,
1307,
1312,
1313,
1308,
1309,
1314,
1315,
1306,
1310,
1311,
1305,
1190,
1195,
1196,
1191,
1192,
1197,
1198,
1189,
1193,
1194,
1188,
1450,
1455,
1456,
1451,
1452,
1457,
1458,
1449,
1453,
1454,
1448,
1177,
1182,
1183,
1178,
1179,
1184,
1185,
1176,
1180,
1181,
1175,
1321,
1326,
1327,
1322,
1323,
1328,
1329,
1320,
1324,
1325,
1319,
1164,
1169,
1170,
1165,
1166,
1171,
1172,
1163,
1167,
1168,
1162,
1333,
1338,
1339,
1334,
1335,
1340,
1341,
1332,
1336,
1337,
1331,
1202,
1207,
1208,
1203,
1204,
1209,
1210,
1201,
1205,
1206,
1200,
1398,
1403,
1404,
1399,
1400,
1405,
1406,
1397,
1401,
1402,
1396,
1411,
1416,
1417,
1412,
1413,
1418,
1419,
1410,
1414,
1415,
1409,
1372,
1377,
1378,
1373,
1374,
1379,
1380,
1371,
1375,
1376,
1370,
1359,
1364,
1365,
1360,
1361,
1366,
1367,
1358,
1362,
1363,
1357,
1281,
1286,
1287,
1282,
1283,
1288,
1289,
1280,
1284,
1285,
1279,
1385,
1390,
1391,
1386,
1387,
1392,
1393,
1384,
1388,
1389,
1383,
1257,
1262,
1263,
1258,
1259,
1264,
1265,
1256,
1260,
1261,
1255,
1269,
1274,
1275,
1270,
1271,
1276,
1277,
1268,
1272,
1273,
1267,
1347,
1352,
1353,
1348,
1349,
1354,
1355,
1346,
1350,
1351,
1345,
1152,
1157,
1158,
1153,
1154,
1159,
1160,
1151,
1155,
1156,
1150,
1424,
1429,
1430,
1425,
1426,
1431,
1432,
1423,
1427,
1428,
1422,
1216,
1221,
1222,
1217,
1218,
1223,
1224,
1215,
1219,
1220,
1214,
1230,
1235,
1236,
1231,
1232,
1237,
1238,
1229,
1233,
1234,
1228,
1242,
1247,
1248,
1243,
1244,
1249,
1250,
1241,
1245,
1246,
1240,
1437,
1442,
1443,
1438,
1439,
1444,
1445,
1436,
1440,
1441,
1435,
1292,
1295,
1300,
1301,
1296,
1297,
1302,
1303,
1294,
1298,
1299,
1293,
1225,
2875,
2874,
2873,
4495,
4075,
4073,
4074,
4072,
4068,
4081,
4079,
4080,
4078,
4066,
4096,
4059,
4095,
4058,
4069,
4064,
4062,
4063,
4061,
4067,
4102,
4089,
4090,
4088,
4100,
4097,
4099,
4092,
4098,
4084,
4083,
4085,
4101,
4093,
4111,
4107,
4104,
4105,
4108,
4110,
4112,
4276,
4274,
4272,
4275,
4273,
4120,
4118,
4116,
4119,
4117,
4127,
4124,
4125,
4126,
2501,
2500,
]

def lookup_charcode(code):
    res = -1
    if code == 1318: res = 3466
    elif code == 1319: res = 3463
    elif code == 1423: res = 1939
    elif code == 1540: res = 1881
    elif code == 1568: res = 1895
    elif code == 1631: res = 1934
    elif 2112 <= code <= 2142: res = _charnames_2112[code-2112]
    elif 2208 <= code <= 2220: res = _charnames_2208[code-2208]
    elif 2276 <= code <= 2302: res = _charnames_2276[code-2276]
    elif code == 2362: res = 4312
    elif code == 2363: res = 4311
    elif 2383 <= code <= 2391: res = _charnames_2383[code-2383]
    elif code == 2419: res = 4320
    elif code == 2420: res = 4319
    elif code == 2421: res = 4321
    elif code == 2422: res = 4317
    elif code == 2423: res = 4316
    elif code == 2800: res = 4507
    elif code == 2930: res = 4450
    elif code == 2931: res = 4451
    elif code == 2932: res = 4455
    elif code == 2933: res = 4449
    elif code == 2934: res = 4452
    elif code == 2935: res = 4454
    elif code == 3369: res = 2474
    elif code == 3386: res = 2473
    elif code == 3406: res = 2475
    elif code == 3806: res = 3818
    elif code == 3807: res = 3817
    elif code == 3980: res = 1585
    elif code == 3981: res = 1583
    elif code == 3982: res = 1582
    elif code == 3983: res = 1584
    elif code == 4057: res = 1588
    elif code == 4058: res = 1587
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif code == 4349: res = 4498
    elif code == 4350: res = 4497
    elif code == 4351: res = 4496
    elif code == 4957: res = 3914
    elif code == 4958: res = 3913
    elif code == 7083: res = 2778
    elif code == 7084: res = 2777
    elif code == 7085: res = 2776
    elif 7098 <= code <= 7155: res = _charnames_7098[code-7098]
    elif code == 7164: res = 882
    elif code == 7165: res = 880
    elif code == 7166: res = 883
    elif code == 7167: res = 881
    elif 7360 <= code <= 7367: res = _charnames_7360[code-7360]
    elif code == 7411: res = 3183
    elif code == 7412: res = 3185
    elif code == 7413: res = 3184
    elif code == 7414: res = 3182
    elif code == 7676: res = 3390
    elif 8341 <= code <= 8348: res = _charnames_8341[code-8341]
    elif code == 8377: res = 4536
    elif code == 8378: res = 1637
    elif 9193 <= code <= 9203: res = _charnames_9193[code-9193]
    elif code == 9934: res = 4445
    elif code == 9954: res = 2121
    elif code == 9956: res = 3604
    elif code == 9957: res = 4037
    elif code == 9958: res = 3850
    elif code == 9959: res = 4538
    elif 9989 <= code <= 9995: res = _charnames_9989[code-9989]
    elif code == 10024: res = 2830
    elif 10060 <= code <= 10069: res = _charnames_10060[code-10060]
    elif code == 10079: res = 4252
    elif code == 10080: res = 4253
    elif code == 10133: res = 4257
    elif code == 10134: res = 4258
    elif code == 10135: res = 4256
    elif code == 10160: res = 3474
    elif code == 10175: res = 4340
    elif code == 10187: res = 2477
    elif code == 10189: res = 2478
    elif code == 10190: res = 2675
    elif code == 10191: res = 2674
    elif code == 11506: res = 3410
    elif code == 11507: res = 3409
    elif 11559 <= code <= 11565: res = _charnames_11559[code-11559]
    elif code == 11622: res = 1593
    elif code == 11623: res = 1592
    elif code == 11632: res = 1594
    elif code == 11647: res = 1595
    elif 11826 <= code <= 11835: res = _charnames_11826[code-11826]
    elif code == 12728: res = 1099
    elif code == 12729: res = 1098
    elif code == 12730: res = 1097
    elif code == 42592: res = 3467
    elif code == 42593: res = 3464
    elif 42612 <= code <= 42619: res = _charnames_42612[code-42612]
    elif code == 42655: res = 3386
    elif 42893 <= code <= 42899: res = _charnames_42893[code-42893]
    elif 42912 <= code <= 42922: res = _charnames_42912[code-42912]
    elif code == 43000: res = 2503
    elif code == 43001: res = 2502
    elif code == 43002: res = 3814
    elif 43744 <= code <= 43766: res = _charnames_43744[code-43744]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43822: res = _charnames_43808[code-43808]
    elif code == 64046: res = 3480
    elif code == 64047: res = 3479
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif 67968 <= code <= 68031: res = _charnames_67968[code-67968]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69840 <= code <= 69864: res = _charnames_69840[code-69840]
    elif 69872 <= code <= 69955: res = _charnames_69872[code-69872]
    elif 70016 <= code <= 70088: res = _charnames_70016[code-70016]
    elif 70096 <= code <= 70105: res = _charnames_70096[code-70096]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 110592: res = 4128
    elif code == 110593: res = 4277
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 1834
    elif code == 126705: res = 1835
    elif 127136 <= code <= 127199: res = _charnames_127136[code-127136]
    elif 127280 <= code <= 127386: res = _charnames_127280[code-127280]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127538 <= code <= 127546: res = _charnames_127538[code-127538]
    elif code == 127568: res = 3454
    elif code == 127569: res = 3455
    elif 127744 <= code <= 127776: res = _charnames_127744[code-127744]
    elif 127792 <= code <= 127891: res = _charnames_127792[code-127792]
    elif 127904 <= code <= 127946: res = _charnames_127904[code-127904]
    elif 127968 <= code <= 127984: res = _charnames_127968[code-127968]
    elif 128000 <= code <= 128323: res = _charnames_128000[code-128000]
    elif 128336 <= code <= 128359: res = _charnames_128336[code-128336]
    elif 128507 <= code <= 128591: res = _charnames_128507[code-128507]
    elif 128640 <= code <= 128709: res = _charnames_128640[code-128640]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 983040 <= code <= 983489: res = _charnames_983040[code-983040]
    elif 983612 <= code <= 983972: res = _charnames_983612[code-983612]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCC or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FCC or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcdddefghidjdklddddmddddddddd\x15\x15\x15noddddddddddd\x15\x15\x15\x15pddddddddddd'
'dddddddddddddddddddddddddddddddddddddddd\x15\x15qddddrdddddddddddddddd'
'ddddddddddddddddddddddddddddddddddddddddddddddddsddddddddddddddd'
'ddddddddddddddddtuvwxyz{dddddddddddddddddddddd|d}~\x7f\x80\x81\x82\x83\x84dddddddd'
'\x85\x865555555\x87\x88\x8955555555555555555555555\x8a55555\x8b55555555555555555\x8c5555'
'5555555555555555555555555555555555\x8d55555555555555555555555555555'
'55555555555555555555555555555555555555\x8e5555555555555555\x8f\x90\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x8a5\x90\x91\x91\x91\x91\x92'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91'
'\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x91\x92'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'\x93\x94dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x95'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x95'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xcd\x89\x89~\x9b~\x89\x8a\x93h\x89\xa8w^xw??????????x\x89\xb6\xb5\xb6\x89'
'\x8933333333333333333333333333\x93\x89h\xa2[\xa2\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x93\xb5h\xb5\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xca\x81\x9b\x9b\x97\x9b\xc6\x81\x9f\xc5(q\xb5\x07\xc2\xa2\xba\xaaLL\x9f\x17\x81\x83\x9fL(mRRR\x81'
'22222202222222220222222\xad0222220\x15\x15\x15\x17\x17\x17\x17\x15\x17\x15\x15\x15\x17\x15\x15\x17\x17\x15\x17\x15\x15\x17\x17\x17\xad\x15\x15\x15\x17\x15\x17\x15\x17'
'2\x152\x172\x172\x172\x172\x172\x172\x172\x152\x152\x172\x172\x172\x152\x172\x172\x172\x172\x170\x152\x172\x152\x172\x172\x150\x152\x172\x17\x152\x172\x172\x170'
'\x150\x152\x152\x172\x15\x150\x152\x152\x172\x170\x152\x172\x172\x172\x172\x172\x172\x172\x172\x170\x152\x172\x152\x172\x172\x172\x172\x172\x1722\x172\x172\x17\x17'
'\x1722\x172\x1722\x17222\x17\x172222\x1722\x17222\x17\x17\x1722\x1722\x172\x172\x1722\x172\x17\x172\x1722\x17222\x172\x1722\x17\x17+2\x17\x17\x17'
'++++2/\x172/\x172/\x172\x152\x152\x152\x152\x152\x152\x152\x15\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x172/\x172\x17222\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x17\x17\x1722\x1722\x17'
'\x172\x172222\x172\x172\x172\x172\x17\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17+\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17         $$\x1f\x1f\x1f\x1f\x1f'
'  \xa1\xa1\x9f\xa1$"$"""$"$$\x1a\x1f\xa1\xa1\xa1\xa1\xa1\xa1\x9f\x9f\x9f\x9f\xa1\x9f\xa1\x9f     \xa1\xa1\xa1\xa1\xa1\xa1\xa1$\xa1\x1f\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888898888888888888888888888888888888888888888882\x172\x17$\xa12\x17\x11\x11\x1e\x17\x17\x17\x87\x11'
'\x11\x11\x11\x11\xa1\xa12\x88222\x112\x1122\x1700000000000000000\x11000000022\x17\x17\x17\x17\x17\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x17\x15\x15\x15\x15\x15\x15\x15\x17\x17\x17\x17\x172\x17\x17222\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x172\x17\xb22\x1722\x17\x17222'
'202222222222222200000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x17\x15\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x17\xc0:::::662\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'22\x172\x172\x172\x172\x172\x172\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11222222222222222'
'22222222222222222222222\x11\x11\x1f\x80\x80\x80\x80\x80\x80\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x11\x80a\x11\x11\x11\x11\x9a\x11:::::::::::::::::::::::::::::::::::::::::::::c:'
'\x8d::\x8d::\x8d:\x11\x11\x11\x11\x11\x11\x11\x11...........................\x11\x11\x11\x11\x11...\x8d\x8e\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
"\x06\x06\x06\x06\x06\x11\xb2\xb2\xa4}}\x96vr\xc5\xc5:::::::::::r\x11\x11rr''''''''''''''''''''''''''''''''"
"\x19'''''''''':::::::::::::::::::::<<<<<<<<<<}ssr'':'''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''r':::::::\x06\xc5::::::\x19\x19::\xc5::::''>>>>>>>>>>'''\xb9\xb9'"
"rrrrrrrrrrrrrr\x11\x05':''''''''''''''''''''''''''''''::::::::::::::::"
":::::::::::\x11\x11'''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''':::::::::::'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11"
'AAAAAAAAAA.................................:::::::::%%\xc5\x87\x87\x87%\x11\x11\x11\x11\x11'
'......................::::%:::::::::%:::%:::::\x11\x11\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x11'
'.........................:::\x11\x11\x8d\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
"\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'\x11'''''''''''\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11"
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:::::::::::::::::::::::::::\x11'
':::4++++++++++++++++++++++++++++++++++++++++++++++++++++++:4:+44'
'4::::::::4444:44+:::::::++++++++++::\x80\x80@@@@@@@@@@\x80\x1f++++++\x11+++++++'
'\x11:44\x11++++++++\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11+\x11\x11\x11++++\x11\x11:+44'
'4::::\x11\x1144\x11\x1144:+\x11\x11\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11++\x11+++::\x11\x11@@@@@@@@@@++\x9a\x9aOOOOOO\xc0\x9a\x11\x11\x11\x11'
'\x11::4\x11++++++\x11\x11\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11++\x11++\x11++\x11\x11:\x1144'
'4::\x11\x11\x11\x11::\x11\x11:::\x11\x11\x11:\x11\x11\x11\x11\x11\x11\x11++++\x11+\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@::+++:\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11::4\x11+++++++++\x11+++\x11++++++++++++++++++++++\x11+++++++\x11++\x11+++++\x11\x11:+44'
'4:::::\x11::4\x1144:\x11\x11+\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@\x80\x9a\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11:44\x11++++++++\x11\x11++\x11\x11++++++++++++++++++++++\x11+++++++\x11++\x11+++++\x11\x11:+4:'
'4::::\x11\x1144\x11\x1144:\x11\x11\x11\x11\x11\x11\x11\x11:4\x11\x11\x11\x11++\x11+++::\x11\x11@@@@@@@@@@\xc0+OOOOOO\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11:+\x11++++++\x11\x11\x11+++\x11++++\x11\x11\x11++\x11+\x11++\x11\x11\x11++\x11\x11\x11+++\x11\x11\x11++++++++++++\x11\x11\x11\x1144'
':44\x11\x11\x11444\x11444:\x11\x11+\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@OOO\xc5\xc5\xc5\xc5\xc5\xc5\x9a\xc5\x11\x11\x11\x11\x11'
'\x11444\x11++++++++\x11+++\x11+++++++++++++++++++++++\x11++++++++++\x11+++++\x11\x11\x11+::'
':4444\x11:::\x11::::\x11\x11\x11\x11\x11\x11\x11::\x11++\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11TTTTTTT\xc0'
'\x11\x1144\x11++++++++\x11+++\x11+++++++++++++++++++++++\x11++++++++++\x11+++++\x11\x11:+47'
'44444\x11744\x1144::\x11\x11\x11\x11\x11\x11\x1144\x11\x11\x11\x11\x11\x11\x11+\x11++::\x11\x11@@@@@@@@@@\x11++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x1144\x11++++++++\x11+++\x11+++++++++++++++++++++++++++++++++++++++++\x11\x11+44'
'4::::\x11444\x11444:+\x11\x11\x11\x11\x11\x11\x11\x114\x11\x11\x11\x11\x11\x11\x11\x11++::\x11\x11@@@@@@@@@@OOOOOO\x11\x11\x11\xc0++++++'
'\x11\x1144\x11++++++++++++++++++\x11\x11\x11++++++++++++++++++++++++\x11+++++++++\x11+\x11\x11'
'+++++++\x11\x11\x11:\x11\x11\x11\x11444:::\x11:\x1144444444\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x1144\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++++++++++++++++++++++++++++++++++++++++++++++++:+*:::::::\x11\x11\x11\x11\x9a'
'++++++\x1f::::::::\x80@@@@@@@@@@\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++\x11+\x11\x11++\x11+\x11\x11+\x11\x11\x11\x11\x11\x11++++\x11+++++++\x11+++\x11+\x11+\x11\x11++\x11++++:+*::::::\x11::+\x11\x11'
'+++++\x11\x1f\x11::::::\x11\x11@@@@@@@@@@\x11\x11++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+\xc0\xc0\xc0\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\xc0\x80\xc0\xc0\xc0::\xc0\xc0\xc0\xc0\xc0\xc0@@@@@@@@@@OOOOOOOOOO\xc0:\xc0:\xc0:\x92g\x92g44'
'++++++++\x11++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11::::::::::::::4'
':::::\x80::+++++:::::::::::\x11::::::::::::::::::::::::::::::::::::\x11\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0:\xc0\xc0\xc0\xc0\xc0\xc0\x11\xc0\xc0\x80\x80\x80\x80\x80\xc0\xc0\xc0\xc0\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++44::::4::::::4::44::+'
'@@@@@@@@@@\x80\x80\x80\x80\x80\x80++++++44::++++:::+444++4444444+++::::+++++++++++'
'++:44::444444:+4@@@@@@@@@@444:\xc0\xc022222222222222222222222222222222'
'222222\x112\x11\x11\x11\x11\x112\x11\x11+++++++++++++++++++++++++++++++++++++++++++\x80\x1f+++'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++\x11++++\x11\x11+++++++\x11+\x11++++\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++\x11++++\x11\x11+++++++++++++++++++++++++++++++++\x11++++\x11\x11+++++++\x11'
'+\x11++++\x11\x11+++++++++++++++\x11++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++\x11++++\x11\x11++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++\x11\x11:::\x80\x80\x80\x80\x80\x80\x80\x80\x80PPPPPPPPPOOOOOOOOOOO\x11\x11\x11'
'++++++++++++++++\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'a+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++\x80\x80+++++++++++++++++'
'\xcc++++++++++++++++++++++++++\x92g\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++\x80\x80\x80DDD\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++\x11++++:::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++++:::\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++++++++\x11+++\x11::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++::4:::::::44'
'444444:44:::::::::::\x80\x80\x80\x1f\x80\x80\x80\x9a+:\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11TTTTTTTTTT\x11\x11\x11\x11\x11\x11'
'\x87\x87\x87\x87\x87\x87a\x87\x87\x87\x87:::\xcc\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++\x1f++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++:+\x11\x11\x11\x11\x11++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++\x11\x11\x11:::4444::444\x11\x11\x11\x1144:444444:::\x11\x11\x11\x11'
'\xc5\x11\x11\x11\x87\x87@@@@@@@@@@++++++++++++++++++++++++++++++\x11\x11+++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x114444444444444444'
'4+++++++44\x11\x11\x11\x11\x11\x11@@@@@@@@@@P\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'+++++++++++++++++++++++::444\x11\x11\x80\x80++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++4:4:::::::\x11:4:44::::::::444444::::::::::\x11\x11:'
'@@@@@@@@@@\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x80\x80\x80\x80\x80\x80\x80\x1f\x80\x80\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::::4+++++++++++++++++++++++++++++++++++++++++++++++:4:::::4:444'
'44:44+++++++\x11\x11\x11\x11@@@@@@@@@@\x80\x80\x80\x80\x80\x80\x80\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0:::::::::\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x11\x11\x11'
'::4++++++++++++++++++++++++++++++4::::44::4:44++@@@@@@@@@@++++++'
'++++++++++++++++++++++++++++++++++++++:4::444:4:::44\x11\x11\x11\x11\x11\x11\x11\x11\x80\x80\x80\x80'
'++++++++++++++++++++++++++++++++++++44444444::::::::44::\x11\x11\x11\x80\x80\x80\x80\x80'
'@@@@@@@@@@\x11\x11\x11+++@@@@@@@@@@++++++++++++++++++++++++++++++\x1f\x1f\x1f\x1f\x1f\x1f\x80\x80'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x80\x80\x80\x80\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11:::\x80:::::::::::::4:::::::++++:++++44:++\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17                    '
'                                           \x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17 \x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17                                     '
':::::::::::::::::::::::::::::::::::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11::::'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\x17\x17\x17\x17\x17\x17\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x11\x11222222\x11\x11\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x17\x1722222222'
'\x17\x17\x17\x17\x17\x17\x11\x11222222\x11\x11\x17\x17\x17\x17\x17\x17\x17\x17\x112\x112\x112\x112\x17\x17\x17\x17\x17\x17\x17\x1722222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x11'
'\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x17\x17\x17////////\x17\x17\x17\x17\x17\x11\x17\x172222/\xa1\x17\xa1'
'\xa1\xa1\x17\x17\x17\x11\x17\x172222/\xa1\xa1\xa1\x17\x17\x17\x17\x11\x11\x17\x172222\x11\xa1\xa1\xa1\x17\x17\x17\x17\x17\x17\x17\x1722222\xa1\xa1\xa1\x11\x11\x17\x17\x17\x11\x17\x172222/\xa1\xa1\x11'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\x08\x08\x08\t\x0e`aa```\x81\x87ol\x91pnk\x91p\x81\x81\x81\x87\x82\x81\x81\x82\xc8\xc9\n\x0f\r\x0b\x10\xca{}{{}\x81\x87\x87\x87qm\x81\x87\x87\x81Z'
'Z\x87\x87\x87\xa5\x92g\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\xb2\x87Z\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87\xcc\x08\x08\x08\x08\x08\x11\x11\x11\x11\x11\x08\x08\x08\x08\x08\x08M \x11\x11LMMMMM\xa7\xa7\xb2\x92g\x1b'
'MLLLLMMMMM\xa7\xa7\xb2\x92g\x11             \x11\x11\x11\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x99\x9a\x9a\x97\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x9a\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:::::::::::::6666:666::::::::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc52\xc2\xc5\xc2\xc52\xc5\xc2\x17222\x17\x17222\x15\xc52\xc2\xc5\xb422222\xc5\xc5\xc5\xc2\xc2\xc52\xc50\xc52\xc52022\xbc\x172222\x17++++\x17\xc5\xc5\x17\x1722'
'\xb3\xb2\xb2\xb2\xb22\x17\x17\x17\x17\xc5\xb2\xc5\xc5\x17\xc0TTTRRTTTTTTRRRRTBBBBBBBBBBBBEEEECCCCCCCCCCFFFFFF'
'DDD2\x17DDDDR\x11\x11\x11\x11\x11\x11\xad\xad\xad\xad\xad\xc2\xc2\xc2\xc2\xc2\xb2\xb2\xc5\xc5\xc5\xc5\xb2\xc5\xc5\xb2\xc5\xc5\xb2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xc5\xc5\xad\xc5\xad\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xad\xb3\xae\xae\xb3\xb2\xb2\xad\xae\xb3\xb3\xae\xb3\xb3\xb2\xad\xb2\xae\xa7\xab\xb2\xae\xb3\xb2\xb2\xb2\xae\xb3\xb3\xae\xad\xae\xae\xb3\xb3\xad\xb3\xad\xb3\xad\xad\xad\xad\xae\xae\xb3\xae\xb3\xb3\xb3\xb3\xb3\xad\xad\xad\xad\xb2\xb3\xb2\xb3\xae\xae\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xae\xb3\xb3\xb3\xae\xb2\xb2\xb2\xb2\xb2\xae\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xae\xad\xb3\xb2\xae\xae\xae\xae\xb3\xb3\xae\xae\xb2\xb2\xae\xae\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xae\xae\xb3\xb3\xae\xae\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb3\xb3\xb2\xb2\xad\xb2\xb2\xb3\xad\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb2\xad\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xae'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb3\xb3\xb3\xb3\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb3\xb3\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x95j\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc5\xb2\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc0\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11SSSSSSSSSRRRRRRRRRRRSSSSSSSSSRRR'
'RRRRRRRRLLLLLLLLLKKKKKKKKKKK\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe'
'\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbe\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbf\xbfURRRRRRRRRRSSSSSSSSSRS'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc5\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc2\xad\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5'
'\xc2\xad\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc5\xc5\xc2\xc5\xc5\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc2\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc2\xc2\xc2\xc5\xc2\xc2\xc2\xc2\xc5\xc2\xc2\xc5\xad\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc0\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc2'
'\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc5\xc2\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2\xc2'
'\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc2\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x92g\x92g\x92g\x92g\x92g\x92g\x92gSSSSSSSSSR'
'UUUUUUUUUTUUUUUUUUUT\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xb3\xb2\xb2\xb3\xb3\x92g\xb2\xb3\xb3\xb2\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb2\xb2\xb2\xb3\xb3\xb3\xb3\x93h\x93h\x93h\x93h\x92g\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb2\xb2\xb2\x92g\x93h\x92g\x92g\x92g\x92g\x92g\x92g\x92g\x92g\x92g\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb3\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb2\xb3\xb3\xb2\xb2\x92g\x92g\xb3\xb2\xb2\xb2\xb2\xb3\xb2\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\x92g\xb2\xb2'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb2\xb3\xb2\xb2\xb3\xb2\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb2'
'\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb2\xb3\xb3\xb2\xb2\xb3\xb3\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3'
'\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb2\xb3\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb2\xb3\xb3\xb3\xb2\xb2\xb2\xb2\xb3\xb2\xb2\xb2\xb3\xb3\xb3\xb3\xb3\xb2\xb3\xb2\xb2'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2\xb2'
'\xb2\xb2\xb2\xb2\xb2\xc5\xc5\xb2\xb2\xb2\xb2\xb2\xb2\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc2\xc2\xc2\xc2\xc2\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'22222222222222222222222222222222222222222222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x112\x17222\x17\x172\x172\x172\x172222\x172\x17\x172\x17\x17\x17\x17\x17\x17  22'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x17\xc5\xc5\xc5\xc5\xc5\xc52\x172\x17:::2\x17\x11\x11\x11\x11\x11\x87\x87\x87\x87T\x87\x87'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x17\x11\x11\x11\x11\x11\x17\x11\x11++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x1f\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11:'
'+++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++\x11+++++++\x11+++++++\x11+++++++\x11'
'+++++++\x11+++++++\x11+++++++\x11+++++++\x11::::::::::::::::::::::::::::::::'
'\x87\x87qmqm\x87\x87\x87qm\x87qm\x87\x87\x87\x87\x87\x87\x87\x87\x87a\x87\x87a\x87qm\x87\x87qm\x92g\x92g\x92g\x92g\x87\x87\x87\x87\x87#\x87\x87\x87\x87\x87\x87\x87\x87\x87\x87aa\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11'
'\xcb\x8b\x8b\x8b\xc7!,G\x95j\x95j\x95j\x95j\x95j\xc7\xc7\x95j\x95j\x95j\x95jb\x94ii\xc7GGGGGGGGG;;;;55b!!!!!\xc7\xc7GGG!,\x8b\xc7\xc5'
'\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,\x11\x11;;\xa3\xa3!!,b,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x8b!!!,'
'\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,\x11\xc1\xc1QQQQ\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11\x11'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11,,,,,,,,,,,,,,,,'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\x11QQQQQQQQQQ\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1NNNNNNNN\xc7VVVVVVVVVVVVVVV\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\xc7\xc1'
'QQQQQQQQQQ\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1VVVVVVVVVVVVVVV'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\xc7\xc7\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\xc7\xc7\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7\xc7\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc7'
',,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'-,,-,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,-,,,,,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-'
'-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,-,-,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',-,---,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',----,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,-,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,--'
',,,,,,,,,,,,---,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,-,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,-,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,!,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,\x11\x11\x11\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7'
'\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++++++++++++++++++++++++++\x1f\x1f\x1f\x1f\x1f\x1f\x80\x80'
'++++++++++++\x1f\x87\x87\x87++++++++++++++++@@@@@@@@@@++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17+:666\x87::::::::::\x87$'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17\x11\x11\x11\x11\x11\x11\x11:++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++++++++++DDDDDDDDDD::\x80\x80\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11'
'\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1\xa1$$$$$$$$$\xa1\xa12\x172\x172\x172\x172\x172\x172\x17\x17\x172\x172\x172\x172\x172\x172\x172\x17'
'2\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x172\x17 \x17\x17\x17\x17\x17\x17\x17\x172\x172\x1722\x17'
'2\x172\x172\x172\x17$\x9e\x9e2\x172\x17\x112\x172\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x112\x172\x172\x172\x172\x172\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11  \x17+++++'
'++:+++:++++:+++++++++++++++++++++++44::4\xc5\xc5\xc5\xc5\x11\x11\x11\x11OOOOOO\xc0\xc0\x9a\xbb\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++\x87\x87\x87\x87\x11\x11\x11\x11\x11\x11\x11\x11'
'44++++++++++++++++++++++++++++++++++++++++++++++++++444444444444'
'4444:\x11\x11\x11\x11\x11\x11\x11\x11\x11\x80\x80@@@@@@@@@@\x11\x11\x11\x11\x11\x11::::::::::::::::::++++++\x80\x80\x80+\x11\x11\x11\x11'
'@@@@@@@@@@++++++++++++++++++++++++++++::::::::\x80\x80++++++++++++++++'
'+++++++:::::::::::44\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x80,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11'
':::4+++++++++++++++++++++++++++++++++++++++++++++++:44::::44:444'
'4\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x80\x11\x1f@@@@@@@@@@\x11\x11\x11\x11\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++::::::44::44::\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++:++++++++:4\x11\x11@@@@@@@@@@\x11\x11\x80\x80\x80\x80++++++++++++++++\x1f++++++\xc0\xc0\xc0+4\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++:+:::++::+++++::'
'+:+\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++\x1f\x80\x80+++++++++++4::44\x80\x80+\x1f\x1f4:\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11++++++\x11\x11++++++\x11\x11++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++\x11+++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++44:44:44\x804:\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++'
'+++++++\x11\x11\x11\x11+++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,-,,,,-,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,-,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x17\x17\x17\x17\x17\x17\x17\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x17\x17\x17\x17\x17\x11\x11\x11\x11\x11.:..........\xa7.............\x11.....\x11.\x11'
"..\x11..\x11..........''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d\x9d"
"\x9d\x9d\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''&&&&&&''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x91f"
"\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11''''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''''''''''\x11\x11''''''''''''''''''''''''''''''''''''''''''''''"
"''''''''\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11''''''''''&&\x96\xc5\x11\x11"
'8888888888888888\x8b\x8b\x8b\x8c\x8b\x8b\x8b\x94i\x8b\x11\x11\x11\x11\x11\x11:::::::\x11\x11\x11\x11\x11\x11\x11\x11\x11\x8bbb\\\\\x94i\x94i\x94i\x94i\x94i\x94'
"i\x94i\x94i\x8b\x8b\x94i\x8b\x8b\x8b\x8b\\\\\\y\x8bz\x11\x8bz\x8b\x8bb\x95j\x95j\x95j\x7f\x8b\x8b\xa9_\xb8\xb8\xb7\x11\x8b\x9c\x7f\x8b\x11\x11\x11\x11&'&'&\x11&'&'&'&'&'"
"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''"
"'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''\x11\x11\x08"
'\x11\x84\x84|\x98|\x84\x85\x8fd\x84\xa6t]ut==========u\x84\xb0\xaf\xb0\x84\x8411111111111111111111111111\x8f\x84d\xa0Y'
'\xa0\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x8f\xafd\xaf\x8fd\x86\x90e\x86\x86))))))))))\x1d)))))))))))))))'
'))))))))))))))))))))))))))))))\x1c\x1c)))))))))))))))))))))))))))))))\x11'
'\x11\x11))))))\x11\x11))))))\x11\x11))))))\x11\x11)))\x11\x11\x11\x98\x98\xaf\xa0\xc3\x98\x98\x11\xc4\xb1\xb1\xb1\xb1\xc4\xc4\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x0c\x0c\x0c\xc5\xc2\x11\x11'
'++++++++++++\x11++++++++++++++++++++++++++\x11+++++++++++++++++++\x11++\x11+'
'++++++++++++++\x11\x11++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11'
'\x80\x87\x80\x11\x11\x11\x11OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\x11\x11\x11\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHTTTT\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5T\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0:\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++\x11\x11\x11++++++++++++++++++++++++++++++++'
'+++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++\x11OOOO\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11++++++++++++++++'
'+D++++++++D\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++\x11\x80++++++++++++++++++++++++++++++++'
'++++\x11\x11\x11\x11++++++++\x80DDDDD\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'2222222222222222222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17++++++++++++++++++++++++++++++++++++++++++++++++'
'++++++++++++++++++++++++++++++\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......\x11\x11.\x11............................................\x11..\x11\x11\x11.\x11\x11.'
'......................\x11\x8dWWWWWWWW\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......................WWWWWW\x11\x11\x11\x87..........................\x11\x11\x11\x11\x11\x8d'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'........................................................\x11\x11\x11\x11\x11\x11..'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'.:::\x11::\x11\x11\x11\x11\x11::::....\x11...\x11...........................\x11\x11\x11\x11:::\x11\x11\x11\x11:'
'XXXXWWWW\x11\x11\x11\x11\x11\x11\x11\x11\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x8d\x11\x11\x11\x11\x11\x11\x11.............................WW\x8d'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'......................................................\x11\x11\x11\x87\x87\x87\x87\x87\x87\x87'
'......................\x11\x11WWWWWWWW...................\x11\x11\x11\x11\x11WWWWWWWW'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'................................................................'
'.........\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11JJJJJJJJJIIIIIIIIIIIIIIIIIIIIII\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'4:4+++++++++++++++++++++++++++++++++++++++++++++++++++++::::::::'
':::::::\x80\x80\x80\x80\x80\x80\x80\x11\x11\x11\x11UUUUUUUUUTTTTTTTTTTT@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::4+++++++++++++++++++++++++++++++++++++++++++++444::::44::\x80\x80\t\x80\x80'
'\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11'
':::++++++++++++++++++++++++++++++++++++:::::4::::::::\x11@@@@@@@@@@'
'\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'::4++++++++++++++++++++++++++++++++++++++++++++++++444:::::::::4'
'4++++\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++:4:44::::::4:\x11\x11\x11\x11\x11\x11\x11\x11'
'@@@@@@@@@@\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD'
'DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x80\x80\x80\x80\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
'+++++\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11+4444444444444444444444444444444444444444444444\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11::::\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
',,\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x11\x11\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc044:::\xc0\xc0\xc0444444\x08\x08\x08\x08\x08\x08\x08\x08:::::'
':::\xc0\xc0:::::::\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0::::\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5:::\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11OOOOOOOOOOOOOOOOOO\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'22222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17222222222222'
'22222222222222\x17\x17\x17\x17\x17\x17\x17\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17222222222222222222222222'
'22\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172\x1122\x11\x112\x11\x1122\x11\x112222\x1122222222\x17\x17\x17\x17\x11\x17\x11\x17\x17\x17'
'\x17\x17\x17\x17\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x1722\x112222\x11\x1122222222\x112222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722\x112222\x11'
'22222\x112\x11\x11\x112222222\x11\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222'
'222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x1722222222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172222'
'2222222222222222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x172222222222222222'
'2222222222\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x11\x11222222222222222222222222'
'2\xac\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172222222222222222222222222\xac\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172222222222222222222222222\xac\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172222222222222222222222222\xac\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172222222222222222222222222\xac\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\xb3\x17\x17\x17\x17\x17\x172\x17\x11\x11>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
"''''\x11'''''''''''''''''''''''''''\x11''\x11'\x11\x11'\x11''''''''''\x11''''\x11'\x11'\x11\x11\x11\x11"
"\x11\x11'\x11\x11\x11\x11'\x11'\x11'\x11'''\x11''\x11'\x11\x11'\x11'\x11'\x11'\x11'\x11''\x11'\x11\x11''''\x11'''''''\x11''''\x11''''\x11'\x11"
"''''''''''\x11'''''''''''''''''\x11\x11\x11\x11\x11'''\x11'''''\x11'''''''''''''''''\x11\x11\x11\x11"
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xb2\xb2\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11'
'\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'LLLLLLLLLLL\x11\x11\x11\x11\x11\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc0\x11\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xc5\xc5\x11\x11\x11\x11\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0'
'\xc1\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11\x11\x11'
'\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\xc1\xc1\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\x11\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11'
'\xc5\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\xc5\xc5\xc5\xc5\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11'
'\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\x11\x11\x11\x11\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5'
'\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
',-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,-,,,,,,,,-,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,-,,'
',,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,-,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12'
'\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x12\x11\x11'
'\x11\x08\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888888888888888888888888888888888888888888888888888888888888888'
'8888888888888888888888888888888888888888888888888888888888888888'
'888888888888888888888888888888888888888888888888\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11\x11'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13'
'\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x13\x11\x11'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
}

_decimal_corrected = {
6618: None,
}
_digit = {
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
74802: 216000.0,
74803: 432000.0,
74838: -1.0,
74839: -1.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
}

_numeric_corrected = {
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
613: 42893,
614: 42922,
1319: 1318,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42897: 42896,
42899: 42898,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
}

_toupper_corrected = {
}
_tolower = {
1318: 1319,
4295: 11559,
4301: 11565,
11506: 11507,
42592: 42593,
42893: 613,
42896: 42897,
42898: 42899,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
}

_tolower_corrected = {
}
_totitle = {
613: 42893,
614: 42922,
1319: 1318,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42897: 42896,
42899: 42898,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
}

_totitle_corrected = {
}
_special_casing = {
}

_special_casing_corrected = {
}

def toupper(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return code - 32
        return code
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return code + 32
        return code
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    if code < 128:
        if ord('a') <= code <= ord('z'):
            return [code - 32]
        return [code]
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    if code < 128:
        if ord('A') <= code <= ord('Z'):
            return [code + 32]
        return [code]
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
43000: '<super> 0126',
43001: '<super> 0153',
64046: '90DE',
64047: '96B7',
69934: '11131 11127',
69935: '11132 11127',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127280: '<square> 0041',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127294: '<square> 004F',
127296: '<square> 0051',
127297: '<square> 0052',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
r_longlong(69937 << 32 | 69927): 69934,
r_longlong(69938 << 32 | 69927): 69935,
}

_canon_decomposition = {
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
43000: [294],
43001: [339],
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
126464: [1575],
126465: [1576],
126466: [1580],
126467: [1583],
126469: [1608],
126470: [1586],
126471: [1581],
126472: [1591],
126473: [1610],
126474: [1603],
126475: [1604],
126476: [1605],
126477: [1606],
126478: [1587],
126479: [1593],
126480: [1601],
126481: [1589],
126482: [1602],
126483: [1585],
126484: [1588],
126485: [1578],
126486: [1579],
126487: [1582],
126488: [1584],
126489: [1590],
126490: [1592],
126491: [1594],
126492: [1646],
126493: [1722],
126494: [1697],
126495: [1647],
126497: [1576],
126498: [1580],
126500: [1607],
126503: [1581],
126505: [1610],
126506: [1603],
126507: [1604],
126508: [1605],
126509: [1606],
126510: [1587],
126511: [1593],
126512: [1601],
126513: [1589],
126514: [1602],
126516: [1588],
126517: [1578],
126518: [1579],
126519: [1582],
126521: [1590],
126523: [1594],
126530: [1580],
126535: [1581],
126537: [1610],
126539: [1604],
126541: [1606],
126542: [1587],
126543: [1593],
126545: [1589],
126546: [1602],
126548: [1588],
126551: [1582],
126553: [1590],
126555: [1594],
126557: [1722],
126559: [1647],
126561: [1576],
126562: [1580],
126564: [1607],
126567: [1581],
126568: [1591],
126569: [1610],
126570: [1603],
126572: [1605],
126573: [1606],
126574: [1587],
126575: [1593],
126576: [1601],
126577: [1589],
126578: [1602],
126580: [1588],
126581: [1578],
126582: [1579],
126583: [1582],
126585: [1590],
126586: [1592],
126587: [1594],
126588: [1646],
126590: [1697],
126592: [1575],
126593: [1576],
126594: [1580],
126595: [1583],
126596: [1607],
126597: [1608],
126598: [1586],
126599: [1581],
126600: [1591],
126601: [1610],
126603: [1604],
126604: [1605],
126605: [1606],
126606: [1587],
126607: [1593],
126608: [1601],
126609: [1589],
126610: [1602],
126611: [1585],
126612: [1588],
126613: [1578],
126614: [1579],
126615: [1582],
126616: [1584],
126617: [1590],
126618: [1592],
126619: [1594],
126625: [1576],
126626: [1580],
126627: [1583],
126629: [1608],
126630: [1586],
126631: [1581],
126632: [1591],
126633: [1610],
126635: [1604],
126636: [1605],
126637: [1606],
126638: [1587],
126639: [1593],
126640: [1601],
126641: [1589],
126642: [1602],
126643: [1585],
126644: [1588],
126645: [1578],
126646: [1579],
126647: [1582],
126648: [1584],
126649: [1590],
126650: [1592],
126651: [1594],
127280: [65],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127294: [79],
127296: [81],
127297: [82],
127299: [84],
127300: [85],
127301: [86],
127303: [88],
127304: [89],
127305: [90],
127311: [87, 67],
127338: [77, 67],
127339: [77, 68],
127489: [12467, 12467],
127490: [12469],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127568: [24471],
127569: [21487],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u0dca\u200d\u0dba',
u'\u0dca\u200d\u0dbb',
u'\u0dbb\u0dca\u200d',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
6,
7,
7,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
11,
11,
11,
12,
12,
13,
13,
14,
14,
14,
15,
15,
15,
16,
16,
17,
17,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
23,
23,
24,
24,
25,
25,
26,
26,
27,
27,
28,
28,
28,
29,
29,
29,
30,
30,
30,
31,
31,
31,
32,
127,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
136,
136,
136,
137,
137,
137,
138,
138,
138,
139,
139,
139,
140,
140,
140,
141,
141,
141,
142,
142,
142,
143,
143,
143,
144,
144,
145,
145,
145,
146,
146,
146,
147,
147,
148,
148,
149,
149,
150,
150,
150,
151,
151,
151,
152,
152,
153,
153,
154,
154,
155,
155,
156,
156,
157,
157,
158,
158,
159,
159,
160,
173,
418,
419,
847,
1801,
3294,
3741,
3743,
3747,
3749,
4048,
6155,
6156,
6157,
6158,
8203,
8204,
8205,
8206,
8207,
8234,
8235,
8236,
8237,
8238,
8239,
8287,
8288,
8472,
9288,
9289,
40981,
65048,
65024,
65025,
65026,
65027,
65028,
65029,
65030,
65031,
65032,
65033,
65034,
65035,
65036,
65037,
65038,
65039,
65279,
65279,
65279,
118981,
917760,
917761,
917762,
917763,
917764,
917765,
917766,
917767,
917768,
917769,
917770,
917771,
917772,
917773,
917774,
917775,
917776,
917777,
917778,
917779,
917780,
917781,
917782,
917783,
917784,
917785,
917786,
917787,
917788,
917789,
917790,
917791,
917792,
917793,
917794,
917795,
917796,
917797,
917798,
917799,
917800,
917801,
917802,
917803,
917804,
917805,
917806,
917807,
917808,
917809,
917810,
917811,
917812,
917813,
917814,
917815,
917816,
917817,
917818,
917819,
917820,
917821,
917822,
917823,
917824,
917825,
917826,
917827,
917828,
917829,
917830,
917831,
917832,
917833,
917834,
917835,
917836,
917837,
917838,
917839,
917840,
917841,
917842,
917843,
917844,
917845,
917846,
917847,
917848,
917849,
917850,
917851,
917852,
917853,
917854,
917855,
917856,
917857,
917858,
917859,
917860,
917861,
917862,
917863,
917864,
917865,
917866,
917867,
917868,
917869,
917870,
917871,
917872,
917873,
917874,
917875,
917876,
917877,
917878,
917879,
917880,
917881,
917882,
917883,
917884,
917885,
917886,
917887,
917888,
917889,
917890,
917891,
917892,
917893,
917894,
917895,
917896,
917897,
917898,
917899,
917900,
917901,
917902,
917903,
917904,
917905,
917906,
917907,
917908,
917909,
917910,
917911,
917912,
917913,
917914,
917915,
917916,
917917,
917918,
917919,
917920,
917921,
917922,
917923,
917924,
917925,
917926,
917927,
917928,
917929,
917930,
917931,
917932,
917933,
917934,
917935,
917936,
917937,
917938,
917939,
917940,
917941,
917942,
917943,
917944,
917945,
917946,
917947,
917948,
917949,
917950,
917951,
917952,
917953,
917954,
917955,
917956,
917957,
917958,
917959,
917960,
917961,
917962,
917963,
917964,
917965,
917966,
917967,
917968,
917969,
917970,
917971,
917972,
917973,
917974,
917975,
917976,
917977,
917978,
917979,
917980,
917981,
917982,
917983,
917984,
917985,
917986,
917987,
917988,
917989,
917990,
917991,
917992,
917993,
917994,
917995,
917996,
917997,
917998,
917999,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
}

_casefolds_corrected = {
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
1631: 220,
2137: 220,
2138: 220,
2139: 220,
2276: 230,
2277: 230,
2278: 220,
2279: 230,
2280: 230,
2281: 220,
2282: 230,
2283: 230,
2284: 230,
2285: 220,
2286: 220,
2287: 220,
2288: 27,
2289: 28,
2290: 29,
2291: 230,
2292: 230,
2293: 230,
2294: 220,
2295: 230,
2296: 230,
2297: 220,
2298: 220,
2299: 230,
2300: 230,
2301: 230,
2302: 230,
4957: 230,
4958: 230,
7083: 9,
7142: 7,
7154: 9,
7155: 9,
7412: 230,
7676: 233,
11647: 9,
42612: 230,
42613: 230,
42614: 230,
42615: 230,
42616: 230,
42617: 230,
42618: 230,
42619: 230,
42655: 230,
43766: 9,
69702: 9,
69888: 230,
69889: 230,
69890: 230,
69939: 9,
69940: 9,
70080: 9,
71350: 9,
71351: 7,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

