; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i1 @or_implies_sle(i8 %x, i8 %y, i1 %other) {
; CHECK-LABEL: @or_implies_sle(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[X:%.*]], 23
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp sgt i8 [[OR]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %or = or i8 %x, 23
  %cond = icmp sle i8 %or, %y
  br i1 %cond, label %T, label %F
T:
  %r = icmp sle i8 %x, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @or_implies_sle_fail(i8 %x, i8 %y, i1 %other) {
; CHECK-LABEL: @or_implies_sle_fail(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[X:%.*]], -34
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp sgt i8 [[OR]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[R:%.*]] = icmp sle i8 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %or = or i8 %x, -34
  %cond = icmp sle i8 %or, %y
  br i1 %cond, label %T, label %F
T:
  %r = icmp sle i8 %x, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @or_distjoint_implies_ule(i8 %x, i8 %y, i1 %other) {
; CHECK-LABEL: @or_distjoint_implies_ule(
; CHECK-NEXT:    [[X2:%.*]] = or disjoint i8 [[X:%.*]], 24
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp ugt i8 [[X2]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %x1 = or disjoint i8 %x, 23
  %x2 = or disjoint i8 %x, 24

  %cond = icmp ule i8 %x2, %y
  br i1 %cond, label %T, label %F
T:
  %r = icmp ule i8 %x1, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @or_distjoint_implies_ule_fail(i8 %x, i8 %y, i1 %other) {
; CHECK-LABEL: @or_distjoint_implies_ule_fail(
; CHECK-NEXT:    [[X2:%.*]] = or disjoint i8 [[X:%.*]], 24
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp ugt i8 [[X2]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[X1:%.*]] = or disjoint i8 [[X]], 28
; CHECK-NEXT:    [[R:%.*]] = icmp ule i8 [[X1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %x1 = or disjoint i8 %x, 28
  %x2 = or disjoint i8 %x, 24

  %cond = icmp ule i8 %x2, %y
  br i1 %cond, label %T, label %F
T:
  %r = icmp ule i8 %x1, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @or_prove_distjoin_implies_ule(i8 %xx, i8 %y, i1 %other) {
; CHECK-LABEL: @or_prove_distjoin_implies_ule(
; CHECK-NEXT:    [[X:%.*]] = and i8 [[XX:%.*]], -16
; CHECK-NEXT:    [[X2:%.*]] = or disjoint i8 [[X]], 10
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp ugt i8 [[X2]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %x = and i8 %xx, -16
  %x1 = or i8 %x, 7
  %x2 = or i8 %x, 10

  %cond = icmp ule i8 %x2, %y
  br i1 %cond, label %T, label %F
T:
  %r = icmp ule i8 %x1, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_or_distjoint_implies_sle(i8 %x, i8 %y, i1 %other) {
; CHECK-LABEL: @src_or_distjoint_implies_sle(
; CHECK-NEXT:    [[X2:%.*]] = or disjoint i8 [[X:%.*]], 24
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp sgt i8 [[X2]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %x1 = or disjoint i8 %x, 23
  %x2 = or disjoint i8 %x, 24

  %cond = icmp sle i8 %x2, %y
  br i1 %cond, label %T, label %F
T:
  %r = icmp sle i8 %x1, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_or_distjoint_implies_sle_fail(i8 %x, i8 %y, i1 %other) {
; CHECK-LABEL: @src_or_distjoint_implies_sle_fail(
; CHECK-NEXT:    [[X2:%.*]] = or disjoint i8 [[X:%.*]], 24
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp slt i8 [[X2]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[X1:%.*]] = or disjoint i8 [[X]], 23
; CHECK-NEXT:    [[R:%.*]] = icmp sle i8 [[X1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %x1 = or disjoint i8 %x, 23
  %x2 = or disjoint i8 %x, 24

  %cond = icmp sle i8 %y, %x2
  br i1 %cond, label %T, label %F
T:
  %r = icmp sle i8 %x1, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_addnsw_implies_sle(i8 %x, i8 %y, i1 %other) {
; CHECK-LABEL: @src_addnsw_implies_sle(
; CHECK-NEXT:    [[X2:%.*]] = add nsw i8 [[X:%.*]], 24
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp sgt i8 [[X2]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %x1 = add nsw i8 %x, 23
  %x2 = add nsw i8 %x, 24

  %cond = icmp sle i8 %x2, %y
  br i1 %cond, label %T, label %F
T:
  %r = icmp sle i8 %x1, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_addnsw_implies_sle_fail(i8 %x, i8 %y, i1 %other) {
; CHECK-LABEL: @src_addnsw_implies_sle_fail(
; CHECK-NEXT:    [[X2:%.*]] = add nsw i8 [[X:%.*]], 23
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp sgt i8 [[X2]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[X1:%.*]] = add nsw i8 [[X]], 24
; CHECK-NEXT:    [[R:%.*]] = icmp sle i8 [[X1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %x1 = add nsw i8 %x, 24
  %x2 = add nsw i8 %x, 23

  %cond = icmp sle i8 %x2, %y
  br i1 %cond, label %T, label %F
T:
  %r = icmp sle i8 %x1, %y
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_and_implies_ult(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_and_implies_ult(
; CHECK-NEXT:    [[COND:%.*]] = icmp ult i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %cond = icmp ult i8 %x, %z
  br i1 %cond, label %T, label %F
T:
  %and = and i8 %z, %x
  %r = icmp ult i8 %and, %z
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_and_implies_ult_fail(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_and_implies_ult_fail(
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp ugt i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], [[Z]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[AND]], [[Z]]
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %cond = icmp ule i8 %x, %z
  br i1 %cond, label %T, label %F
T:
  %and = and i8 %x, %z
  %r = icmp ult i8 %and, %z
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_and_implies_slt_fail(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_and_implies_slt_fail(
; CHECK-NEXT:    [[COND:%.*]] = icmp slt i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp slt i8 [[AND]], [[Z]]
; CHECK-NEXT:    ret i1 [[R]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %cond = icmp slt i8 %x, %z
  br i1 %cond, label %T, label %F
T:
  %and = and i8 %x, %y
  %r = icmp slt i8 %and, %z
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_or_implies_ule(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_or_implies_ule(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp ugt i8 [[OR]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %or = or i8 %y, %x
  %cond = icmp uge i8 %z, %or
  br i1 %cond, label %T, label %F
T:
  %r = icmp ule i8 %x, %z
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_or_implies_false_ugt_todo(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_or_implies_false_ugt_todo(
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[COND:%.*]] = icmp ugt i8 [[OR]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
; CHECK:       F:
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i8 [[X]], [[Z]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %or = or i8 %x, %y
  %cond = icmp ugt i8 %or, %z
  br i1 %cond, label %T, label %F
T:
  ret i1 %other
F:
  %r = icmp ugt i8 %x, %z
  ret i1 %r

}

define i1 @src_udiv_implies_ult(i8 %x, i8 %z, i1 %other) {
; CHECK-LABEL: @src_udiv_implies_ult(
; CHECK-NEXT:    [[COND:%.*]] = icmp ugt i8 [[Z:%.*]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %cond = icmp ugt i8 %z, %x
  br i1 %cond, label %T, label %F
T:
  %and = udiv i8 %x, 3
  %r = icmp ult i8 %and, %z
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_udiv_implies_ult2(i8 %x, i8 %z, i1 %other) {
; CHECK-LABEL: @src_udiv_implies_ult2(
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp ugt i8 [[Z:%.*]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
; CHECK:       F:
; CHECK-NEXT:    ret i1 true
;
  %cond = icmp ule i8 %z, %x
  br i1 %cond, label %T, label %F
T:
  ret i1 %other
F:
  %and = udiv i8 %x, 3
  %r = icmp ult i8 %and, %z
  ret i1 %r
}

define i1 @src_smin_implies_sle(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_smin_implies_sle(
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp sgt i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %cond = icmp sle i8 %x, %z
  br i1 %cond, label %T, label %F
T:
  %um = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = icmp sle i8 %um, %z
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_umin_implies_ule(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_umin_implies_ule(
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp ugt i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %cond = icmp ule i8 %x, %z
  br i1 %cond, label %T, label %F
T:
  %um = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = icmp ule i8 %um, %z
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_umax_implies_ule(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_umax_implies_ule(
; CHECK-NEXT:    [[UM:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp ugt i8 [[UM]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %um = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %cond = icmp ule i8 %um, %z
  br i1 %cond, label %T, label %F
T:
  %r = icmp ule i8 %x, %z
  ret i1 %r
F:
  ret i1 %other
}

define i1 @src_smax_implies_sle(i8 %x, i8 %y, i8 %z, i1 %other) {
; CHECK-LABEL: @src_smax_implies_sle(
; CHECK-NEXT:    [[UM:%.*]] = call i8 @llvm.smax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[COND_NOT:%.*]] = icmp sgt i8 [[UM]], [[Z:%.*]]
; CHECK-NEXT:    br i1 [[COND_NOT]], label [[F:%.*]], label [[T:%.*]]
; CHECK:       T:
; CHECK-NEXT:    ret i1 true
; CHECK:       F:
; CHECK-NEXT:    ret i1 [[OTHER:%.*]]
;
  %um = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %cond = icmp sle i8 %um, %z
  br i1 %cond, label %T, label %F
T:
  %r = icmp sle i8 %x, %z
  ret i1 %r
F:
  ret i1 %other
}
