/********************************************************************************
* Copyright (c) Erik Kunze 1996 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*
* $Id: audio.h,v 1.8 1999/04/07 13:36:46 erik Rel $
*******************************************************************************/
#ifndef _XZX_AUDIO_H
#define _XZX_AUDIO_H
#include <sys/types.h>
#include "beep.h"
#include "speaker.h"
#include "ay8912.h"
#ifdef REGISTERED
#include "mixer.h"
#endif
enum { AUC_REINIT,
AUC_ON, AUC_OFF,
AUC_FASTON, AUC_FASTOFF,
AUC_SPON, AUC_SPOFF,
AUC_AYON, AUC_AYOFF };
typedef struct _audioSettings {
unsigned int active:1;
#ifdef SPEAKER_AUDIO
unsigned int spOn:1;
unsigned int spVol;
unsigned char *spBuf;
#endif
#ifdef AYCHIP_AUDIO
unsigned int ayOn:1;
unsigned int ayVol;
unsigned char *ayBuf;
#endif
unsigned int sampleRate;
unsigned int tstatesPerSample;
unsigned int samplesPerFrame;
} AudioSettings;
extern void AudioInit(void);
extern void AudioControl(int);
extern void AudioPlayBuffer(void);
extern AudioSettings Audio;
extern int OsdOpenAudioDevice(char *, int);
extern void OsdCloseAudioDevice(void);
extern int OsdDrainAudioDevice(void);
extern size_t OsdGetAudioFreespace(void);
extern size_t OsdPlayAudioBuffer(unsigned char *, size_t);
#endif
