package test.contrib.classloader;

/*
 +----------------------------------------------------------------------+
 | XEnvoy Project                                                       |
 +----------------------------------------------------------------------+
 | Copyright (c) 2005 The XEnvoy Group                                  |
 +----------------------------------------------------------------------+
 | The contents of this file are licensed under the XEnvoy license.     |
 |                                                                      |
 | XEnvoy license available through :                                   |
 | 1- This package in the file LICENSE.                                 |
 | 2- The world-wide-web at url: http://www.xenvoy.com/license/1_0.txt. |
 |                                                                      |
 | If you did not receive a copy of the license and are unable to       |
 | obtain it through the world-wide-web, please send a note to          |
 | license@xenvoy.com so we can mail you a copy immediately.            |
 +----------------------------------------------------------------------+
 | Author: Mina R Waheeb <mina@kemetex.com>                             |
 +----------------------------------------------------------------------+

 $Id: Test.java,v 1.0.0 Apr 28, 2007 4:46:56 PM mina Exp $
 */

import java.io.File;
import java.net.URL;

public class Test {

	public static void main(String[] args) throws Exception {
		// Path to substance classes directory or jar file ..
		File bin = new File("C:/JProjects/workspace/substance/bin/");
		File substance = new File("C:/JProjects/substance/drop/substance.jar");
		File swingx = new File("C:/JProjects/substance/lib/swingx.jar");
		File laf = new File("C:/JProjects/substance/lib/substance-swingx.jar");
		// our classpath
		Classpath classpath = new Classpath(new URL[] { substance.toURL(),
				swingx.toURL(), laf.toURL(), bin.toURL() }, null);
		// our classloader
		UniversalClassLoader loader = new UniversalClassLoader(classpath, null);
		Class clazz = loader
				.loadClass("test.contrib.classloader.InternalClass");
		clazz.newInstance();
	}

}
