package test.contrib;

import java.awt.*;
import java.util.Vector;

import javax.swing.*;
import javax.swing.plaf.FontUIResource;

import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.FontSet;
import org.jvnet.substance.theme.*;

public class SubstanceTest extends JFrame {
	String[] themeNames;
	Vector<SubstanceTheme> themes;

	JComboBox comboBox;
	ThemeComboRenderer themeRenderer;

	public SubstanceTest() {
		super("Substance Test");
		showGUI();
	}

	static void initSubstance() {
		/*
		 * setSubstanceFontSize(11);
		 * 
		 * SubstanceLookAndFeel.setCurrentGradientPainter(GlassGradientPainter.classgetName());
		 * 
		 * UIManager.put(SubstanceLookAndFeel.FOCUS_KIND,
		 * SubstanceConstants.FocusKind.UNDERLINE);
		 * 
		 * UIManager.put(SubstanceLookAndFeel.WATERMARK_TO_BLEED, Boolean.TRUE);
		 * 
		 * UIManager.put(SubstanceLookAndFeel.NO_EXTRA_ELEMENTS, Boolean.TRUE);
		 * 
		 * SubstanceLookAndFeel.setCurrentButtonShaper(new
		 * ClassicButtonShaper());
		 * 
		 * 
		 * 
		 * SubstanceLookAndFeel.setCurrentTitlePainter(new ArcHeaderPainter()); /*
		 * ArcHeaderPainter BrushedMetalHeaderPainter ClassicTitlePainter
		 * FlatTitlePainter Glass3DTitlePainter MarbleNoiseHeaderPainter
		 * MatteHeaderPainter RandomCubesTitlePainter
		 */

		UIManager.put(SubstanceLookAndFeel.OVERLAY_PROPERTY, Boolean.TRUE);

		/*
		 * 
		 * UIManager.put(SubstanceLookAndFeel.TABBED_PANE_CONTENT_BORDER_KIND,
		 * TabContentPaneBorderKind.SINGLE_FULL);
		 * UIManager.put(SubstanceLookAndFeel.FLAT_PROPERTY, false);
		 * 
		 * FadeConfigurationManager.getInstance().allowFades(FadeKind.FOCUS_LOOP_ANIMATION);
		 * FadeConfigurationManager.getInstance().allowFades(FadeKind.GHOSTING_ICON_ROLLOVER);
		 * FadeConfigurationManager.getInstance().allowFades(FadeKind.GHOSTING_BUTTON_PRESS);
		 */
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	void initComboBox() {
		boolean inverted = false;
		boolean negated = false;

		themeNames = new String[] { "Aqua", "Barbie Pink", "Bottle Green",
				"Brown", "Light Aqua", "Lime Green", "Orange", "Purple",
				"Raspberry", "Sun Glare", "Sunset", "Olive", "Sepia",
				"Steel Blue", "Terracotta", "Burnt Charcoal", "Dark Violet",
				"Ebony", "Jade Forest", "Ultra Marine" };
		themes = new Vector<SubstanceTheme>();

		for (int i = 0; i < themeNames.length; i++)
			themes.addElement(getTheme(i, inverted, negated));

		themeRenderer = new ThemeComboRenderer();
		comboBox = new JComboBox(themes);
		comboBox.putClientProperty(SubstanceLookAndFeel.FLAT_PROPERTY, true);
		comboBox.setRenderer(themeRenderer);
	}

	void drawAll() {
		initSubstance();
		initComboBox();
		Container c = getContentPane();
		c.setLayout(new FlowLayout());
		c.setPreferredSize(new Dimension(250, 150));
		c.add(comboBox);
	}

	void showGUI() {
		this.setDefaultCloseOperation(this.EXIT_ON_CLOSE);
		drawAll();
		pack();
		setLocation(500, 400);
		setVisible(true);
		this.requestFocus();
	}

	static SubstanceTheme getTheme(int theme, boolean inverted, boolean negated) {
		switch (theme) {
		case 0:
			if (!inverted && !negated)
				return new SubstanceAquaTheme();
			else if (!negated)
				return new SubstanceAquaTheme().invert();
			else
				return new SubstanceAquaTheme().negate();

		case 1:
			if (!inverted && !negated)
				return new SubstanceBarbyPinkTheme();
			else if (!negated)
				return new SubstanceBarbyPinkTheme().invert();
			else
				return new SubstanceBarbyPinkTheme().negate();

		case 2:
			if (!inverted && !negated)
				return new SubstanceBottleGreenTheme();
			else if (!negated)
				return new SubstanceBottleGreenTheme().invert();
			else
				return new SubstanceBottleGreenTheme().negate();

		case 3:
			if (!inverted && !negated)
				return new SubstanceBrownTheme();
			else if (!negated)
				return new SubstanceBrownTheme().invert();
			else
				return new SubstanceBrownTheme().negate();

		case 4:
			if (!inverted && !negated)
				return new SubstanceLightAquaTheme();
			else if (!negated)
				return new SubstanceLightAquaTheme().invert();
			else
				return new SubstanceLightAquaTheme().negate();

		case 5:
			if (!inverted && !negated)
				return new SubstanceLimeGreenTheme();
			else if (!negated)
				return new SubstanceLimeGreenTheme().invert();
			else
				return new SubstanceLimeGreenTheme().negate();

		case 6:
			if (!inverted && !negated)
				return new SubstanceOrangeTheme();
			else if (!negated)
				return new SubstanceOrangeTheme().invert();
			else
				return new SubstanceOrangeTheme().negate();

		case 7:
			if (!inverted && !negated)
				return new SubstancePurpleTheme();
			else if (!negated)
				return new SubstancePurpleTheme().invert();
			else
				return new SubstancePurpleTheme().negate();

		case 8:
			if (!inverted && !negated)
				return new SubstanceRaspberryTheme();
			else if (!negated)
				return new SubstanceRaspberryTheme().invert();
			else
				return new SubstanceRaspberryTheme().negate();

		case 9:
			if (!inverted && !negated)
				return new SubstanceSunGlareTheme();
			else if (!negated)
				return new SubstanceSunGlareTheme().invert();
			else
				return new SubstanceSunGlareTheme().negate();
			/*
			 * case 10: if (!inverted && !negated) return new
			 * SubstanceSunfireRedTheme(); else if (!negated) return new
			 * SubstanceSunfireRedTheme().invert();
			 */

		case 10:
			if (!inverted && !negated)
				return new SubstanceSunsetTheme();
			else if (!negated)
				return new SubstanceSunsetTheme().invert();
			else
				return new SubstanceSunsetTheme().negate();

		case 11:
			if (!inverted && !negated)
				return new SubstanceOliveTheme();
			else if (!negated)
				return new SubstanceOliveTheme().invert();
			else
				return new SubstanceOliveTheme().negate();

		case 12:
			if (!inverted && !negated)
				return new SubstanceSepiaTheme();
			else if (!negated)
				return new SubstanceSepiaTheme().invert();
			else
				return new SubstanceSepiaTheme().negate();

		case 13:
			if (!inverted && !negated)
				return new SubstanceSteelBlueTheme();
			else if (!negated)
				return new SubstanceSteelBlueTheme().invert();
			else
				return new SubstanceSteelBlueTheme().negate();

		case 14:
			if (!inverted && !negated)
				return new SubstanceTerracottaTheme();
			else if (!negated)
				return new SubstanceTerracottaTheme().invert();
			else
				return new SubstanceTerracottaTheme().negate();

		case 15:
			if (!inverted && !negated)
				return new SubstanceCharcoalTheme();
			else if (!negated)
				return new SubstanceCharcoalTheme().invert();
			else
				return new SubstanceCharcoalTheme().negate();

		case 16:
			if (!inverted && !negated)
				return new SubstanceDarkVioletTheme();
			else if (!negated)
				return new SubstanceDarkVioletTheme().invert();
			else
				return new SubstanceDarkVioletTheme().negate();

		case 17:
			if (!inverted && !negated)
				return getEbonyHighContrastTheme();
			else if (!negated)
				return getEbonyHighContrastTheme().invert();
			else
				return getEbonyHighContrastTheme().negate();
		case 18:
			if (!inverted && !negated)
				return new SubstanceJadeForestTheme();
			else if (!negated)
				return new SubstanceJadeForestTheme().invert();
			else
				return new SubstanceJadeForestTheme().negate();

		case 19:
			if (!inverted && !negated)
				return new SubstanceUltramarineTheme();
			else if (!negated)
				return new SubstanceUltramarineTheme().invert();
			else
				return new SubstanceUltramarineTheme().negate();

		default:
			if (!inverted && !negated)
				return new SubstanceAquaTheme();
			else if (!negated)
				return new SubstanceAquaTheme().invert();
			else
				return new SubstanceAquaTheme().negate();
		}
	}

	void cout(String s) {
		System.out.println(s);
	}

	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (Exception e) {
			e.printStackTrace();
		}

		new SubstanceTest();
	}

	class ThemeComboRenderer extends JLabel implements ListCellRenderer {
		protected SubstanceTheme currTheme;

		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {
			// cout(value.toString());

			SubstanceTheme theme = (SubstanceTheme) value;
			this.setBackground(theme.getColorScheme().getMidColor());
			this.setForeground(theme.getColorScheme().getForegroundColor());
			this.setText("  " + themeNames[themes.indexOf(value)]);
			this.currTheme = theme;

			return this;
		}
		
		@Override
		public void setBackground(Color bg) {
			System.out.println(this.getBackground() + "->" + bg);
			super.setBackground(bg);
		}

		@Override
		public void paint(Graphics g) {
			int width = this.getWidth();
			int height = this.getHeight();
			SubstanceImageCreator
					.paintRectangularBackground(g, 0, 0, width, height,
							this.currTheme.getColorScheme(), (float) .75, false);

			System.out.println("Theme " + this.currTheme + ", backgr "
					+ this.getBackground());
			super.paint(g);
		}

	}

	public static SubstanceTheme getEbonyHighContrastTheme() {
		return new SubstanceComplexTheme("Ebony High Contrast",
				SubstanceTheme.ThemeKind.DARK, new SubstanceEbonyTheme(),
				getContrastMetallic(), getContrastGray(),
				new SubstanceEbonyTheme());
	}

	static SubstanceTheme getContrastMetallic() {
		ColorScheme metallic = new ColorScheme() {
			private final Color mainUltraLightColor = new Color(125, 126, 128);

			private final Color mainExtraLightColor = new Color(120, 122, 125);

			private final Color mainLightColor = new Color(100, 105, 110);

			private final Color mainMidColor = new Color(90, 92, 95);

			private final Color mainDarkColor = new Color(40, 42, 45);

			private final Color mainUltraDarkColor = new Color(16, 19, 21);

			private final Color foregroundColor = Color.white;

			public Color getForegroundColor() {
				return foregroundColor;
			}

			public Color getUltraLightColor() {
				return mainUltraLightColor;
			}

			public Color getExtraLightColor() {
				return mainExtraLightColor;
			}

			public Color getLightColor() {
				return mainLightColor;
			}

			public Color getMidColor() {
				return mainMidColor;
			}

			public Color getDarkColor() {
				return mainDarkColor;
			}

			public Color getUltraDarkColor() {
				return mainUltraDarkColor;
			}
		};

		return new SubstanceTheme(metallic, "Contrast Metallic",
				SubstanceTheme.ThemeKind.DARK);
	}

	static SubstanceTheme getContrastGray() {
		ColorScheme gray = new ColorScheme() {
			private final Color mainUltraLightColor = new Color(125, 125, 125);

			private final Color mainExtraLightColor = new Color(120, 120, 120);

			private final Color mainLightColor = new Color(112, 112, 112);

			private final Color mainMidColor = new Color(105, 105, 105);

			private final Color mainDarkColor = new Color(90, 90, 90);

			private final Color mainUltraDarkColor = new Color(50, 50, 50);

			private final Color foregroundColor = Color.white;

			public Color getForegroundColor() {
				return foregroundColor;
			}

			public Color getUltraLightColor() {
				return mainUltraLightColor;
			}

			public Color getExtraLightColor() {
				return mainExtraLightColor;
			}

			public Color getLightColor() {
				return mainLightColor;
			}

			public Color getMidColor() {
				return mainMidColor;
			}

			public Color getDarkColor() {
				return mainDarkColor;
			}

			public Color getUltraDarkColor() {
				return mainUltraDarkColor;
			}
		};

		return new SubstanceTheme(gray, "Contrast Gray",
				SubstanceTheme.ThemeKind.DARK);
	}

	private static class CustomFontSet implements FontSet {
		private int size;
		private FontSet delegate;

		public CustomFontSet(FontSet delegate, int theSize) {
			super();
			this.delegate = delegate;
			this.size = theSize;
		}

		private FontUIResource getWrappedFont(FontUIResource systemFont) {
			return new FontUIResource(systemFont.getFontName(), systemFont
					.getStyle(), this.size);
		}

		public FontUIResource getControlFont() {
			return this.getWrappedFont(this.delegate.getControlFont());
		}

		public FontUIResource getMenuFont() {
			return this.getWrappedFont(this.delegate.getMenuFont());
		}

		public FontUIResource getMessageFont() {
			return this.getWrappedFont(this.delegate.getMessageFont());
		}

		public FontUIResource getSmallFont() {
			return this.getWrappedFont(this.delegate.getSmallFont());
		}

		public FontUIResource getTitleFont() {
			return this.getWrappedFont(this.delegate.getTitleFont());
		}

		public FontUIResource getWindowTitleFont() {
			return new FontUIResource(this.getTitleFont().getFontName(),
					Font.BOLD, this.getTitleFont().getSize() + 2);
		}

	}

	public static void setSubstanceFontSize(int theSize) {
		final int newSize = theSize;
		SubstanceLookAndFeel.setFontPolicy(null);

		final FontSet substanceCoreFontSet = SubstanceLookAndFeel
				.getFontPolicy().getFontSet("Substance", null);
		FontPolicy newFontPolicy = new FontPolicy() {
			public FontSet getFontSet(String lafName, UIDefaults table) {
				return new CustomFontSet(substanceCoreFontSet, newSize);
			}
		};

		SubstanceLookAndFeel.setFontPolicy(newFontPolicy);
	}

}
