package test.contrib;

import java.awt.BorderLayout;
import java.util.Hashtable;

import javax.swing.*;

public class SliderWithHtmlLabels extends JPanel {
	private final static int NB = 2;

	public SliderWithHtmlLabels() {
		super();

		// Slider
		JSlider oSlider = new JSlider(SwingConstants.HORIZONTAL, 0, NB, 0);
		Hashtable<Integer, JLabel> oLabelMap = new Hashtable<Integer, JLabel>(
				NB);
		for (int iIndex = 0; iIndex <= NB; iIndex++) {
			JLabel oLabel = new JLabel("<html><body>" + iIndex + "<br><b>"
					+ iIndex + "</b><br><i>" + iIndex + "</i></body></html>");
			oLabelMap.put(new Integer(iIndex), oLabel);
		}
		oSlider.setLabelTable(oLabelMap);
		oSlider.setPaintLabels(true);

		// Layout
		setLayout(new BorderLayout());
		add(BorderLayout.CENTER, oSlider);
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				initLAF();
				JFrame oFrame = new JFrame();
				oFrame.setTitle("Bug...");
				oFrame.setContentPane(new SliderWithHtmlLabels());
				oFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				oFrame.setLocationRelativeTo(null);
				oFrame.pack();
				oFrame.setVisible(true);
			}
		});
	};

	private static void initLAF() {
		try {
			UIManager
					.setLookAndFeel("org.jvnet.substance.SubstanceLookAndFeel");
		} catch (Exception oException) {
		}
	}

}
