package test;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.text.JTextComponent;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.substance.SubstanceLookAndFeel;

public class CheckAutoCompletionEditor extends JFrame {
	public CheckAutoCompletionEditor() {
		this.setLayout(new FlowLayout());
		final JComboBox combo = new JComboBox(new Object[] { "Alice", "Bob",
				"Stan" });
		combo.setEditable(true);
		combo.putClientProperty(LafWidget.COMBO_BOX_NO_AUTOCOMPLETION,
				Boolean.TRUE);
		final JComboBox combo2 = new JComboBox(new Object[] { "Alice", "Bob",
				"Stan" });
		combo2.putClientProperty(LafWidget.COMBO_BOX_NO_AUTOCOMPLETION,
				Boolean.TRUE);
		combo2.setEditable(true);

		this.add(combo);
		this.add(combo2);

		JButton check = new JButton("Check editors");
		check.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Component editor = combo.getEditor().getEditorComponent();
				if (editor instanceof JTextComponent) {
					System.out.println("1: "
							+ ((JTextComponent) editor).getDocument()
									.getClass().getName());
				}
				Component editor2 = combo2.getEditor().getEditorComponent();
				if (editor2 instanceof JTextComponent) {
					System.out.println("2: "
							+ ((JTextComponent) editor2).getDocument()
									.getClass().getName());
				}
			}
		});
		this.add(check);
		this.setSize(300, 100);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());

		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new CheckAutoCompletionEditor().setVisible(true);
			}
		});

	}
}
