/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jvnet.substance.text;

import java.awt.Graphics;
import java.awt.Shape;

import javax.swing.plaf.UIResource;
import javax.swing.text.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.text.SubstanceTextPainter;

/**
 * Custom highlighter for painting views of text components with
 * {@link SubstanceTextPainter}-based approach.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstanceHighlighter extends DefaultHighlighter implements
		UIResource {
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.text.DefaultHighlighter#paintLayeredHighlights(java.awt.Graphics,
	 *      int, int, java.awt.Shape, javax.swing.text.JTextComponent,
	 *      javax.swing.text.View)
	 */
	@Override
	public void paintLayeredHighlights(Graphics g, final int p0, final int p1,
			final Shape viewBounds, final JTextComponent editor, final View view) {
		SubstanceTextPainter textPainter = SubstanceLookAndFeel
				.getCurrentTextPainter();
		if (textPainter.needsBackgroundImage()) {
			textPainter
					.attachCallback(new SubstanceTextPainter.BackgroundPaintingCallback() {
						public void paintBackground(Graphics g) {
							// System.out.println("Painting highlight from " +
							// p0
							// + " to " + p1 + " in " + viewBounds);
							// Highlighter.Highlight[] highlights =
							// getHighlights();
							// for (int counter = highlights.length - 1; counter
							// >= 0; counter--) {
							// Highlighter.Highlight tag = highlights[counter];
							// System.out.println("\t" + tag.getStartOffset()
							// + " - " + tag.getEndOffset());
							// }
							SubstanceHighlighter.super.paintLayeredHighlights(
									g, p0, p1, viewBounds, editor, view);
						}
					});
		} else {
			super.paintLayeredHighlights(g, p0, p1, viewBounds, editor, view);
		}
	}
}
