/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jvnet.substance.skin;

import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.*;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.painter.decoration.BrushedMetalDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants.ColorShiftKind;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;

/**
 * <code>Office Silver 2007</code> skin. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 */
public class OfficeSilver2007Skin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static final String NAME = "Office Silver 2007";

	/**
	 * Creates a new <code>Office Silver 2007</code> skin.
	 */
	public OfficeSilver2007Skin() {
		SubstanceTheme activeTheme = new SubstanceOrangeTheme().saturate(-0.1);
		SubstanceTheme defaultTheme = new SubstanceTheme(
				new BlendBiColorScheme(new MetallicColorScheme(),
						new LightGrayColorScheme(), 0.7), "Metallic",
				ThemeKind.COLD).tint(0.1);
		SubstanceTheme disabledTheme = new SubstanceTheme(
				new LightGrayColorScheme(), "Metallic", ThemeKind.COLD)
				.tint(0.2);
		SubstanceTheme activeTitleTheme = defaultTheme;

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.BRIGHT, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme);

		// register state-specific themes on rollovers and selections
		theme.registerComponentStateTheme(new SubstanceBlendBiTheme(
				new SubstanceOrangeTheme(), new SubstanceSunGlareTheme()
						.saturate(-0.1), 0.4), false,
				ComponentState.ROLLOVER_UNSELECTED);
		theme.registerComponentStateTheme(new SubstanceBlendBiTheme(
				new SubstanceOrangeTheme(), new SubstanceSunsetTheme(), 0.3),
				false, ComponentState.ROLLOVER_SELECTED);
		theme.registerComponentStateTheme(new SubstanceBlendBiTheme(
				new SubstanceRaspberryTheme(), new SubstanceSunsetTheme(), 0.6)
				.saturate(0.2), false, ComponentState.PRESSED_SELECTED);
		theme.registerComponentStateTheme(
				new SubstanceBlendBiTheme(new SubstanceRaspberryTheme(),
						new SubstanceSunsetTheme(), 0.2), false,
				ComponentState.PRESSED_UNSELECTED);

		// register state-specific highlight themes on rollover and selections
		theme.registerComponentHighlightStateTheme(new SubstanceBlendBiTheme(
				new SubstanceOrangeTheme(), new SubstanceSunGlareTheme(), 0.3)
				.saturate(0.3), 0.5f, ComponentState.ROLLOVER_UNSELECTED);
		theme.registerComponentHighlightStateTheme(new SubstanceBlendBiTheme(
				new SubstanceOrangeTheme(), new SubstanceSunsetTheme(), 0.8),
				0.5f, ComponentState.SELECTED);
		theme.registerComponentHighlightStateTheme(new SubstanceBlendBiTheme(
				new SubstanceOrangeTheme(), new SubstanceSunsetTheme(), 0.2),
				0.7f, ComponentState.ROLLOVER_SELECTED);
		theme.registerComponentHighlightStateTheme(new SubstanceBlendBiTheme(
				new SubstanceOrangeTheme(), new SubstanceSunsetTheme(), 0.8),
				0.7f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);

		theme.registerDecorationAreaTheme(activeTitleTheme, false,
				DecorationAreaType.PRIMARY_TITLE_PANE,
				DecorationAreaType.SECONDARY_TITLE_PANE,
				DecorationAreaType.HEADER, DecorationAreaType.GENERAL);

		theme.setSelectedTabFadeStart(0.1);
		theme.setSelectedTabFadeEnd(0.3);

		theme.setPaintingToolbarDropShadows();

		this.theme = theme;
		this.buttonShaper = new ClassicButtonShaper();
		this.watermark = new SubstanceStripeWatermark();
		this.gradientPainter = new ClassicGradientPainter();
		this.borderPainter = new ClassicInnerBorderPainter(0.8f,
				ColorShiftKind.TINT);

		BrushedMetalDecorationPainter decorationPainter = new BrushedMetalDecorationPainter();
		decorationPainter.setPaintingSeparators(true);
		decorationPainter.setTextureAlpha(0.45f);
		this.decorationPainter = decorationPainter;

		this.highlightPainter = new ClassicHighlightPainter();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
