/* Here is stuff for interfacing to directories.
** Copyright (c) 1993, 1994 by Olin Shivers.
*/

#include <sys/types.h>
#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

/* Make sure our exports match up w/the implementation: */
#include "scheme48.h"
#include "dirstuff1.h"

s48_value open_dir(s48_value sch_dirname)
{
  char *fname;
  struct dirent *dirent;
  DIR *d;
  s48_value dirlist = S48_NULL;

  S48_DECLARE_GC_PROTECT(1);
  
  S48_GC_PROTECT_1(dirlist);
  
  if( NULL == (d = opendir(s48_extract_string (sch_dirname))) ) 
    s48_raise_os_error_1 (errno, sch_dirname);
  
  while( NULL != (dirent = readdir(d)) ) {
    if((strcmp(dirent->d_name,".") == 0) || (strcmp(dirent->d_name,"..") == 0))
      continue;
    
    dirlist = s48_cons (s48_enter_string (dirent->d_name),
			dirlist);
    
  }
  if (closedir(d) == -1)
    s48_raise_os_error_1 (errno, sch_dirname);
  
  S48_GC_UNPROTECT ();
  return dirlist;
}

void s48_init_dirstuff (){
  S48_EXPORT_FUNCTION(open_dir);
}
