.TH ilib_for_link 1 "May 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
ilib_for_link - utility for shared library management with link
.SH CALLING SEQUENCE
.nf
libn=ilib_for_link(names,files,libs,flag,makename,loadername])
.fi
.SH PARAMETERS
.TP 10
names
: a string matrix giving the entry names which are to be linked.
.TP 10 
files
: string matrix giving objects files needed for shared library
creation
.TP 10 
libs 
: string matrix giving extra libraries needed for shred library
creation
.TP 10 
flag
: a string flag ("c" or "f") for C or Fortran entry points.
.TP 10
makename
: character string. The pathname of the Makefile file without
extension (default value \fVMakelib\fR).
.TP 10
loadername
: character string. The pathname of the loader file (default value 
\fVloader.sce\fR).
.TP 10
libn
: character string. The path of the really generated shared library file.
.SH DESCRIPTION
.LP 
This tool is used to create shared libraries and to generate a 
loader file which can be used to dynamically load the shared library 
into Scilab with the \fVlink\fR function. New entry points 
given by \fVnames\fR are then accessible through the \fVcall\fR 
function or with non linear tools \fVode\fR, \fVoptim\fR,...

Many examples are provided in \fVexamples/link-examples-so\fR
directory. 

.SH EXAMPLE
.nf

f1=['int ext1c(n, a, b, c)'
    'int *n;     double *a, *b, *c;'
    '{int k;'
    '  for (k = 0; k < *n; ++k) '
    '      c[k] = a[k] + b[k];'
    '  return(0);}'];

mputl(f1,'fun1.c')

//creating the shared library (a gateway, a Makefile and a loader are 
//generated. 

ilib_for_link('ext1c','fun1.o',[],"c") 

// load the shared library 

exec loader.sce 

//using the new primitive
a=[1,2,3];b=[4,5,6];n=3;
c=call('ext1c',n,1,'i',a,2,'d',b,3,'d','out',[1,3],4,'d');
if norm(c-(a+b)) > %eps then pause,end

.fi 
.SH SEE ALSO
addinter, link, ilib_compile, ilib_gen_Make, ilib_gen_gateway,
ilib_gen_loader, ilib_for_link



