.TH "TK_EvalFile" 2 " 02 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
TK_EvalFile - Reads and evaluate a tcl/tk file
.SH CALLING SEQUENCE
.nf
TK_EvalFile(filename)
.fi
.SH PARAMETERS
.TP 10
filename
: string character Contains the name of the file to read and evaluate. 

.SH Description
With this routine, one can read and evaluate the content of a file
containing tcl/tk scripts. This allows to create powerful tk
interfaces.
.LP
The filename might be relative or absolute.
.SH Advantages and drawbacks of this functionality 
This routines allows to use directly tcl/tk scripts. This thus allows,
for instance to use Interface Builders such as SpecTcl to design the
interface. The interfaces built directly with tcl/tk scripts are much
faster than th ones built with the Scilab Graphic Object library
provided with tksci (see uicontrol for example). Indeed, those Objects
are warpings around tk graphic widgets.  Nevertheless, this way of
creating graphic user interface sould only be used when one aims at
adressing directly specific tk/tcl features.  There are two main
reasons for this.  First of all, there is no simple way to manipulate
scilab objects from within a tcl/tk script. Thus, the interface
designer has to write two sets of callbacks routines. One to describe
the changes occuring in the interface when the user acts on the
widgets.  The second set of call routines will perform the (pure)
scilab reactions to the user actions.  
.LP
Here is an example: Suppose you design a scrollbar corresponding to a
spline tension value. You want the spline to be displayed in a graphic
windows and updated each time the user moves the scrollbar. At the
same time, you want the value of this tension parameter to be
displayed within the Interface. You will have to write a first tcl/tk
(callback) function which will be automatically called by the tk
scrollbar ('-command' option). This callback function will update the
displayed value of the parameter in the interface and will then call
the scilab routine ('ScilabEval' command) to update the graph.
.SH Remarks on the tcl/tk script style
Because Scilab manages the tcl/tk events, it creates the root window
 ".", this window should not be destroyed nor directly used by your
tcl/tk scripts. You should thus always create your own toplevel
windows.  Moreover, since this module was written at a time when
namespaces didn't exist, some variables defined by scilab tcl/tk
scripts could bother your code. 
.SH AUTHOR
Bertrand Guiheneuf
.SH EXAMPLE
.nf

TK_EvalFile(SCI+'/demos/tk/puzzle')
.fi
.SH See also
ScilabEval, TK_EvalStr, TK_GetVar, TK_Setvar
