.TH grep 3 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
grep - find matches of a string in a vector of strings
.SH CALLING SEQUENCE
.nf
row=grep(str1,str2)
[row,which]=grep(str1,str2)
.fi
.SH PARAMETERS
.TP 15
str1
: a vector of strings. 
.TP
str2
: a character string or character string vector . The string(s) to search in \fVstr1\fR
.TP
row
: vector of  indices: row where a match has been found or an empty
matrix if no match found.
.TP
which
: vector of indices: index of str2 string found or an empty
matrix if no match found.

.SH DESCRIPTION
Foreach entry of \fVstr1\fR,   \fVgrep \fR searches if at least a string in
\fVstr2\fR matches a substring. \fVstr1\fR  entries index where  at least a match has been
found are returned in the \fVrow\fR argument. while optionnal
\fVwhich\fR argument gives the index of first string of  \fVstr2\fR found.

.SH EXAMPLE
.nf
txt=['find matches of a string in a vector of strings'
     'search position of a character string in an other string'
     'Compare Strings'];

grep(txt,'strings')
grep(txt,['strings' 'Strings'])

[r,w]=grep(txt,['strings' 'Strings'])

.fi
.SH SEE ALSO
strindex


