.TH srfaur 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
srfaur - square-root algorithm
.SH CALLING SEQUENCE
.nf
[p,s,t,l,rt,tt]=srfaur(h,f,g,r0,n,p,s,t,l)
.fi
.SH PARAMETERS
.TP 10
h, f, g
: convenient matrices of the state-space model.
.TP
r0
: E(yk*yk').
.TP
n
: number of iterations.
.TP
p
: estimate of the solution after n iterations.
.TP
s, t, l
: intermediate matrices for
 successive iterations;
.TP
rt, tt
: gain matrices of the filter model after \fVn\fR iterations.
.TP
p, s, t, l
: may be given as input if more than one recursion
is desired (evaluation of intermediate values of \fVp\fR).
.SH DESCRIPTION
square-root algorithm for the algebraic Riccati equation.
.SH EXAMPLE
.nf
//GENERATE SIGNAL
x=%pi/10:%pi/10:102.4*%pi;
rand('seed',0);rand('normal');
y=[1;1]*sin(x)+[sin(2*x);sin(1.9*x)]+rand(2,1024);
//COMPUTE CORRELATIONS
c=[];for j=1:2,for k=1:2,c=[c;corr(y(k,:),y(j,:),64)];end;end
c=matrix(c,2,128);
//FINDING H,F,G with 6 states
hk=hank(20,20,c);
[H,F,G]=phc(hk,2,6);
//SOLVING RICCATI EQN
r0=c(1:2,1:2);
[P,s,t,l,Rt,Tt]=srfaur(H,F,G,r0,200);
//Make covariance matrix exactly symetric
Rt=(Rt+Rt')/2
.fi
.SH SEE ALSO
phc, faurre, lindquist
