.TH factors 8 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
factors - numeric real factorization
.SH CALLING SEQUENCE
.nf
[lnum,g]=factors(pol [,'flag'])
[lnum,lden,g]=factors(rat [,'flag'])
rat=factors(rat,'flag')
.fi
.SH PARAMETERS
.TP
pol
: real polynomial
.TP
rat
: real rational polynomial (\fVrat=pol1/pol2\fR)
.TP
lnum
: list of polynomials (of degrees 1 or 2)
.TP
lden
: list of polynomials (of degrees 1 or 2)
.TP
g
: real number
.TP
flag
: character string \fV'c'\fR or \fV'd'\fR
.SH DESCRIPTION
returns the factors of polynomial \fVpol\fR in the list \fVlnum\fR
and the "gain" g.
.LP
One has pol= g times product of entries of the list \fVlnum\fR
(if \fVflag\fR is not given). If \fVflag='c'\fR is given, then
one has \fV|pol(i omega)|\fR = \fV|g*prod(lnum_j(i omega)|\fR.
If \fVflag='d'\fR is given, then
one has \fV|pol(exp(i omega))|\fR = \fV|g*prod(lnum_i(exp(i omega))|\fR.
If argument of \fVfactors\fR is a 1x1 rational \fVrat=pol1/pol2\fR, 
the factors of the numerator \fVpol1\fR and the denominator \fVpol2\fR 
are returned in the lists \fVlnum\fR and \fVlden\fR respectively.
.LP
The "gain" is returned as \fVg\fR,i.e. one has:
rat= g times (product entries in lnum) / (product entries in lden).
.LP
If \fVflag\fR is \fV'c'\fR (resp. \fV'd'\fR), the roots of \fVpol\fR 
are refected wrt the imaginary axis (resp. the unit circle), i.e. 
the factors in \fVlnum\fR are stable polynomials.
.LP
Same thing if \fVfactors\fR is invoked with a rational arguments:
the entries in \fVlnum\fR and \fVlden\fR are stable polynomials if
\fVflag\fR is given. \fVR2=factors(R1,'c')\fR or \fVR2=factors(R1,'d')\fR
with \fVR1\fR a rational function or SISO \fVsyslin\fR list then the 
output \fVR2\fR is a transfer with stable numerator and denominator and
with same magnitude as \fVR1\fR along the imaginary axis (\fV'c'\fR)
or unit circle (\fV'd'\fR).
.SH EXAMPLE
.nf
n=poly([0.2,2,5],'z');
d=poly([0.1,0.3,7],'z');
R=syslin('d',n,d);
R1=factors(R,'d')
roots(R1('num'))
roots(R1('den'))
w=exp(2*%i*%pi*[0:0.1:1]);
norm(abs(horner(R1,w))-abs(horner(R,w)))
.fi
.SH SEE ALSO
simp



