.TH chsolve G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
chsolve - sparse Cholesky solver
.SH CALLING SEQUENCE
.nf
sol=chsolve(spcho,rhs)
.fi
.SH PARAMETERS
.TP
spcho
: list containing the Cholesky factors in coded form returned by chfact 
.TP 
rhs, sol
: full column vectors
.SH DESCRIPTION
\fVsol=chsolve(spcho,rhs)\fR computes the solution of 
\fVsol=A*rhs\fR, with \fVA\fR a symmetric sparse positive definite
matrix. This function is based on the Ng-Peyton programs (ORNL). See the
Fortran programs for a complete description of the variables in
\fVspcho\fR.
.SH EXAMPLE
.nf
A=sprand(20,20,0.1);
A=A*A'+eye();  
spcho=chfact(A);
sol=(1:20)';rhs=A*sol;
spcho=chfact(A);
chsolve(spcho,rhs)
.fi
.SH SEE ALSO
chfact, sparse, lufact, luget, spchol

