.TH polarplot  "April 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
polarplot - Plot polar coordinates
.SH CALLING SEQUENCE
.nf
polarplot(theta,rho,[style,strf,leg,rect])
polarplot(theta,rho,<opt_args>)
.fi
.SH PARAMETERS 
.TP 7
rho
: a vector, the radius values
.TP 7
theta
: a vector with same size than rho, the angle values.
.TP
<opt_args>
: a sequence of statements \fVkey1=value1,
key2=value2\fR, ... where keys may be
\fVstyle\fR,\fVleg\fR,\fVrect\fR,\fVstrf\fR or \fVframeflag\fR
.TP
style
: is a real row vector of size nc. The style to use for curve \fVi\fR is
defined by \fVstyle(i)\fR.

The default style is \fV1:nc\fR (1 for the first curve, 
2 for the second, etc.).
.RS
.TP 3
-
if \fVstyle(i)\fR is negative, the curve is plotted using the mark with id 
\fVabs(style(i))+1\fR; use \fVxset()\fR to see the mark ids.
.TP
-
if \fVstyle(i)\fR is strictly positive, a plain line with color id 
\fVstyle(i)\fR or a dashed line with dash id \fVstyle(i)\fR is used; 
use \fVxset()\fR to see the color ids.
.TP
- 
When only one curve is drawn, \fVstyle\fR can be the row vector 
of size 2 \fV[sty,pos]\fR
where \fVsty\fR is used to specify the style and \fVpos\fR is an integer
ranging from 1 to 6 which specifies a position to use for the caption. 
This can be useful when a user wants to draw multiple curves on a plot by 
calling the function \fVplot2d\fR several times and wants to give a caption 
for each curve.
.RE
.TP
strf
: is a string of length 3 \fV"xy0"\fR.
.RS
.TP
The default is \fV"030"\fR.
.TP 3
x
: controls the display of captions, 
.RS
.TP 5
x=0
: no captions.
.TP
x=1
: captions are displayed. They are given by the optional argument
\fVleg\fR. 

.RE
.TP
y
: controls the computation of the frame. same as frameflag
.RS
.TP 5
y=0
: the current boundaries (set by a previous call to another high level
plotting function) are used. Useful when superposing multiple plots.
.TP
y=1
: the optional argument \fVrect\fR is used to specify the boundaries of 
the plot.
.TP
y=2 
: the boundaries of the plot are computed using min and max values of \fVx\fR and \fVy\fR.
.TP
y=3
: like \fVy=1\fR but produces isoview scaling.
.TP
y=4
: like \fVy=2\fR but produces isoview scaling.
.TP
y=5
: like \fVy=1\fR but \fVplot2d\fR can change the boundaries of the plot and 
the ticks of the axes to produce pretty graduations. When the zoom button 
is activated, this mode is used.
.TP
y=6
: like \fVy=2\fR but \fVplot2d\fR can change the boundaries of the plot and 
the ticks of the axes to produce pretty graduations. When the zoom button 
is activated, this mode is used.
.TP
y=7
: like \fVy=5\fR but the scale of the new plot is merged with the 
current scale.
.TP
y=8
: like \fVy=6\fR but the scale of the new plot is merged with the 
current scale.
.RE
.RE
.TP
leg
: a string. It is used when the first character x of argument \fVstrf\fR is 1.
\fVleg\fR has the form \fV"leg1@leg2@...."\fR where \fVleg1\fR, \fVleg2\fR, 
etc. are respectively the captions of the first curve,
of the second curve, etc.

The default is \fV" "\fR.
.TP
rect
: This argument is used when the second character y of argument \fVstrf\fR is 1,
3 or 5. It is a row vector of size 4 and gives the dimension of the frame: 
\fVrect=[xmin,ymin,xmax,ymax]\fR.
.RE
.LP

.SH DESCRIPTION
polarplot creates a polar coordinate plot of the angle theta
versus the radius rho. theta is the angle from the x-axis to the
radius vector specified in radians; rho is the length of the radius
vector specified in dataspace units.

.SH EXAMPLES 
.nf
t= 0:.01:2*%pi;
xbasc();polarplot(sin(7*t),cos(8*t))

xbasc();polarplot([sin(7*t') sin(6*t')],[cos(8*t') cos(8*t')],[1,2])

.fi
