.TH readmps 1 "MAY 1998" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
readmps - reads a file in MPS format 
.SH CALLING SEQUENCE
.nf
 mps= readmps (file-name,bounds [,maxsizes]);	
.fi
.SH PARAMETERS
.TP 10
file-name
: character string, path of the MPS file
.TP
bounds
: 2-vector \fV[lowbound,upbound]\fR , default lower ans upper bounds
.TP
maxsizes
: 3-vector \fV[maxm,maxn,maxnza]\fR Maximum number of contraints and
variables, maximum number of nonzeros entries in the LP constraint
matrix. If omitted readmps reads the file once just to compute these
numbers.
.TP 10
mps
: tlist with following fields
.RS
.TP 10
irobj
: integer (index of the objective row).
.TP 
namec
: character string (Name of the objective).
.TP
nameb
: character string (Name of the right hand side).
.TP
namran
: character string (Name of the ranges section).
.TP
nambnd
: character string (Name of the bounds section).
.TP
name
: character string (Name of the  LP problem).
.TP
rownames
: character string column vector (Name of the rows).
colnames
: character string row vector (Name of the columns).
.TP 10
rowstat
: integer vector,  row types:
.RS
.TP 2
1
:  row type is "=" 
.TP 2
2
:  row type is ">=" 
.TP 2
3
:  row type is "<=" 
.TP 2
4
:  objective row
.TP 2
5
:  other free row
.RE

.TP 10
rowcode
: real matrix \fV[hdrowcd,lnkrow]\fR with
.RS
.TP 10
hdrowcd
: real vector (Header to the linked list of rows with the same codes).
.TP 10
lnkrow
: integer vector (Linked list of rows with the same codes).
.RE
.TP 10
colcode
: real matrix \fV[hdcolcd,lnkcol]\fR with
.RS
.TP 10
hdcolcd
: integer vector (Header to the linked list of columns with the same codes).
.TP 10
lnkcol
: integer vector (Linked list of columns with the same codes).
.RE
.TP 10    
rownmbs
: integer vector (Row numbers of nonzeros in columns of matrix A.)
.TP 10
colpnts
: integer vector (Pointers to the beginning of columns of matrix A).
.TP 10
acoeff
: real vector (Array of nonzero elements for each column).
.TP 10
rhs
:real vector ( Right hand side of the linear program).
.TP 10
ranges
: real vector of constraint ranges.
.TP 10
bounds
: real matrix \fV[lbounds,ubounds]\fR with
.RS
.TP 10
ubounds   
: full column vector of upper bounds 
.TP 10
lbounds   
: full column vector of lower bounds 
.RE
.TP 10
stavar
: full column vector of variable status
.RS
.TP 
0
:standard (non negative) variable
.TP
1
: upper bounded variable
.TP
2
: lower bounded variable
.TP
3
: lower and upper bounded variable
.TP
4
: minus infinity type variable  i.e -inf<x<=u
.TP
5
: plus infinity type variable  i.e l<=x< inf
.TP
6
: fixed type variable  i.e l=x=u

.TP
-k
: free variable
.RE
.RE
.SH DESCRIPTION
\fVreadmps\fR.
Utility function: reads a file containing description of an LP problem
given  in MPS format. It is an
interface with the program \fVrdmps1.f\fR of hopdm (J. Gondzio).
For a description of the variables, see the file rdmps1.f.
.LP
MPS format is a standard ASCII medium for LP codes.  
MPS format is described in more detail in Murtagh's book:
.LP
Murtagh B. (1981). Advanced Linear Programming, McGrew-Hill,
New York, 1981.
.SH EXAMPLE
.nf

//Let the LP problem:
//objective:
//   min     XONE + 4 YTWO + 9 ZTHREE
//constraints:
//  LIM1:    XONE +   YTWO            < = 5
//  LIM2:    XONE +            ZTHREE > = 10
// MYEQN:         -   YTWO  +  ZTHREE   = 7
//Bounds
//  0 < = XONE < = 4
// -1 < = YTWO < = 1

//Generate MPS file 
txt=['NAME          TESTPROB'
     'ROWS'
     ' N  COST'
     ' L  LIM1'
     ' G  LIM2'
     ' E  MYEQN'
     'COLUMNS'
     '    XONE      COST                 1   LIM1                 1'
     '    XONE      LIM2                 1'
     '    YTWO      COST                 4   LIM1                 1'
     '    YTWO      MYEQN               -1'
     '    ZTHREE    COST                 9   LIM2                 1'
     '    ZTHREE    MYEQN                1'
     'RHS'
     '    RHS1      LIM1                 5   LIM2                10'
     '    RHS1      MYEQN                7'
     'BOUNDS'
     ' UP BND1      XONE                 4'
     ' LO BND1      YTWO                -1'
     ' UP BND1      YTWO                 1'
     'ENDATA'];
u=file('open','/tmp/test.mps','unknown')
write(u,txt,'(a)');file('close',u)
//Read the MPS file
P=readmps('/tmp/test.mps',[0 10^30])
//Convert it to linpro format
LP=mps2linpro(P)
//Solve it with linpro
[x,lagr,f]=linpro(LP(2:$))
.fi
.SH SEE ALSO
mps2linpro



