.TH mget 1 "April 1999" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
mget - reads  byte or word in a given binary format and convert to double
mgeti - reads  byte or word in a given binary format return an int type
.SH CALLING SEQUENCE
.nf
x=mget([n,type,fd])
x=mgeti([n,type,fd])
.fi
.SH PARAMETERS
.TP 10
n
:a positive scalar: The number of items to be read.
.TP
fd
: scalar. The \fVfd\fR parameter returned by the function
\fVmopen\fR. -1 stands for last opened file. Default value is -1.
.TP 
type
: a string. Give the binary format used to write all the entries of x.
.TP 
x
: a vector of floating point or integer type numbers
.SH DESCRIPTION
The \fVmget\fR function reads data in the input specified by the
stream parameter \fVfd\fR and returns a vector of floating point data.
The \fVmgeti\fR function reads data in the input specified by the
stream parameter \fVfd\fR and returns a vector of integer data.
.LP
 Data is read at the position at which the file pointer is currently
pointing and advances the indicator appropriately.
.LP
The \fVtype\fR parameter is a conversion specifier which may be set to any of the
following flag characters (with default value "l"):
.TP 13
"l","i","s","ul","ui","us","d","f","c","uc"
: for reading respectively a long, an int, a short, an unsigned
long, an unsigned int, an unsigned short, a double, a float, a char and an unsigned
char. The bytes which are read are automatically swapped if necessary (by checking
little-endian status). This default swapping mode can be
suppressed by adding a flag in the \fVmopen\fR function. Format "l", "d" and
"f" are valid only with the \fVmget\fR function.
.TP
"..l" or "..b" 
: It is also possible to read in little-endian or big-endian mode 
by adding a 'l' or 'b' character at the end of a type specification.
For example "db" will read a double in big-endian mode.
.SH EXAMPLE 
.nf 
file1 = 'test1.bin';
file2 = 'test2.bin';
fd1=mopen(file1,'wb');
fd2=mopen(file2,'wb');
mput(1996,'ull',fd1);
mput(1996,'ull',fd2);
mclose(fd1);
mclose(fd2);

fd1=mopen(file1,'rb');
if 1996<>mget(1,'ull',fd1) ;write(%io(2),'Bug');end;
fd2=mopen(file2,'rb');
if 1996<>mget(1,'ull',fd2) ;write(%io(2),'Bug');end;
mclose(fd1);
mclose(fd2);
.fi 
.SH SEE ALSO
mclose, meof, mfprintf, fprintfMat, mfscanf, fscanfMat, mget, mgetstr, mopen, mprintf, mput, mputstr, mscanf, mseek, mtell


