.TH lex_sort 1 "April 1999" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
lex_sort - lexicographic matrix rows  sorting
.SH CALLING SEQUENCE
.nf
[N, [k]]=lex_sort(M [,sel] [,'unique'])

.fi
.SH PARAMETERS
.TP
M 
: real matrix
.TP
N
: real  matrix
.TP
k
: column vector  of integers
.SH DESCRIPTION
\fVN=lex_sort(M)\fR sorts the rows (as a group) of the matrix \fVM\fR
in ascending order. If required the output argument \fVk\fR contains
the ordering: \fV[N,k]=lex_sort(M)\fR returns \fVk\fR  such as \fVN\fR  is
uequal to \fVM(k,:)\fR .
.LP
\fVN=lex_sort(M,sel [,'unique'])\fR produces the  same result as the
following sequence of instructions:
.nf
[N,k]=lex_sort(M(:,sel) [,'unique']);
N=M(k,:)
.fi
.LP
The \fV'unique'\fR flag has to be given if one wants to retain only
unique rows in the result. Note that \fVlex_sort(M,sel,'unique')\fR
retains only rows such that M(:,sel) are unique.

.SH EXAMPLE
.nf
M=round(2*rand(20,3));

lex_sort(M)
lex_sort(M,'unique')
[N,k]=lex_sort(M,[1 3],'unique')

.fi
.SH SEE ALSO
sort

