// File:	StepToTopoDS_TranslateVertex.cxx
// Created:	Tue Jan  3 15:00:17 1995
// Author:	Frederic MAUPAS
//		<fma@stylox>
//:   gka 09.04.99: S4136: eliminate BRepAPI::Precision()

#include <StepToTopoDS_TranslateVertex.ixx>
#include <StepToGeom_MakeCartesianPoint.hxx>
#include <TopoDS.hxx>

#include <TopoDS_Vertex.hxx>
#include <BRep_Builder.hxx>
//#include <BRepAPI.hxx>

#include <StepGeom_Point.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepShape_VertexPoint.hxx>
#include <StepShape_Vertex.hxx>

#include <Geom_CartesianPoint.hxx>
#include <Precision.hxx>

// ============================================================================
// Method  : StepToTopoDS_TranslateVertex::StepToTopoDS_TranslateVertex
// Purpose : Empty Constructor
// ============================================================================

StepToTopoDS_TranslateVertex::StepToTopoDS_TranslateVertex()
{
  done = Standard_False;
}

// ============================================================================
// Method  : StepToTopoDS_TranslateVertex::StepToTopoDS_TranslateVertex
// Purpose : Constructor with a Vertex and a Tool
// ============================================================================

StepToTopoDS_TranslateVertex::StepToTopoDS_TranslateVertex(const Handle(StepShape_Vertex)& V, StepToTopoDS_Tool& T)
{
  Init(V, T);
}

// ============================================================================
// Method  : Init
// Purpose : Init with a Vertex and a Tool
// ============================================================================

void StepToTopoDS_TranslateVertex::Init(const Handle(StepShape_Vertex)& aVertex, 
				       StepToTopoDS_Tool& aTool)
{
  if (!aTool.IsBound(aVertex)) {
    BRep_Builder B;
//:S4136    Standard_Real preci = BRepAPI::Precision();
    Handle(StepShape_VertexPoint) VP =
      Handle(StepShape_VertexPoint)::DownCast(aVertex);
    Handle(StepGeom_Point) P = VP->VertexGeometry();
    Handle(StepGeom_CartesianPoint) P1 =
      Handle(StepGeom_CartesianPoint)::DownCast(P);
    StepToGeom_MakeCartesianPoint MkPoint(P1);
    Handle(Geom_CartesianPoint) P2 = MkPoint.Value();
    TopoDS_Vertex V;
    B.MakeVertex(V, P2->Pnt(), Precision::Confusion()); //:S4136: preci
    
    aTool.Bind(aVertex,V);
    myResult = V;
    myError  = StepToTopoDS_TranslateVertexDone;
    done     = Standard_True;
  }
  else {
    myResult = TopoDS::Vertex(aTool.Find(aVertex));
    myError  = StepToTopoDS_TranslateVertexDone;
    done     = Standard_True;
  }
}

// ============================================================================
// Method  : Value
// Purpose : Return the mapped Shape
// ============================================================================

const TopoDS_Shape& StepToTopoDS_TranslateVertex::Value() const 
{
  StdFail_NotDone_Raise_if(!done,"");
  return myResult;
}

// ============================================================================
// Method  : Error
// Purpose : Return the TranslateVertex Error Code
// ============================================================================

StepToTopoDS_TranslateVertexError StepToTopoDS_TranslateVertex::Error() const
{
  return myError;
}
