// File:	StepToGeom_MakePlane.cxx
// Created:	Fri Jul  2 18:22:22 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakePlane.ixx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <Geom_Axis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un Plane de Geom a partir d' un plane de Step
//=============================================================================

StepToGeom_MakePlane::StepToGeom_MakePlane
  ( const Handle(StepGeom_Plane)& P)
{
  Handle (StepGeom_Axis2Placement3d) A;
  Handle (Geom_Axis2Placement    )       A1;
  gp_Ax2                                 A2;

  A  = P->Position();
  StepToGeom_MakeAxis2Placement MkAxis2(A);
  A1 = MkAxis2.Value();
  A2 = A1->Ax2();
  thePlane = new Geom_Plane(A2);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Plane) &
      StepToGeom_MakePlane::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return thePlane;
}
