#include <Handle_Standard_Transient.hxx>

//============================================================================

const Handle(Standard_Transient) Handle(Standard_Transient)::DownCast(const Handle(Standard_Transient)& AnObject) 
{
  Handle(Standard_Transient) _anOtherObject;
  
  if (!AnObject.IsNull()) 
    if (AnObject->IsKind(STANDARD_TYPE(Standard_Transient))) 
      {
	_anOtherObject = Handle(Standard_Transient)((Handle(Standard_Transient)&)AnObject);
      }
  
  return _anOtherObject ;
}

//============================================================================

void Handle(Standard_Transient)::Dump(Standard_OStream& out) const
{ 
  out << Access();
}

//============================================================================

void Handle(Standard_Transient)::Assign (const Standard_Transient *anItem)
{
  if ( anItem == entity ) return;
  EndScope();
  entity = ( anItem ? (Standard_Transient*)anItem : UndefinedHandleAddress );
  BeginScope();
}

//============================================================================

void Handle(Standard_Transient)::EndScope()
{
  if (entity == UndefinedHandleAddress) 
    return;
  entity->count--;
  if (entity->count == 0)
    entity->Delete();
  entity = UndefinedHandleAddress;
}
