/* MA2FX6.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <ApproxF2var.h>
#endif 
/* Subroutine */ int mma2fx6_(ncfmxu, ncfmxv, ndimen, nbsesp, ndimse, nbupat, 
	nbvpat, iordru, iordrv, epsapr, epsfro, patcan, errmax, ncoefu, 
	ncoefv)
const integer *ncfmxu, *ncfmxv, *ndimen, *nbsesp, *ndimse, *nbupat, *nbvpat, *
	iordru, *iordrv;
const doublereal *epsapr, *epsfro, *patcan, *errmax;
integer *ncoefu, *ncoefv;
{
    /* System generated locals */
    integer epsfro_dim1, epsfro_offset, patcan_dim1, patcan_dim2, patcan_dim3,
	     patcan_dim4, patcan_offset, errmax_dim1, errmax_dim2, 
	    errmax_offset, ncoefu_dim1, ncoefu_offset, ncoefv_dim1, 
	    ncoefv_offset, i__1, i__2, i__3, i__4, i__5;
    doublereal d__1, d__2;

    /* Local variables */
    static integer idim, ncfu, ncfv, id, ii, nd, jj, ku, kv, ns, ibb;
    static doublereal bid;
    extern integer mnfndeb_();
    static doublereal tol;
    extern /* Subroutine */ int mgenmsg_(), mgsomsg_();





/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Reduction de degre lorsque les carreaux sont les carreaux de */
/*     contraintes. */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS,AB_SPECIFI::CARREAU&,REDUCTION,&CARREAU */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/* NCFMXU: Nbre maximal de coeff en u de la solution P(u,v) (tableau */
/*         PATCAN). Cet argument sert uniquement a declarer la taille */
/*         de ce tableau. */
/* NCFMXV: Nbre maximal de coeff en v de la solution P(u,v) (tableau */
/*         PATCAN). Cet argument sert uniquement a declarer la taille */
/*         de ce tableau. */
/* NDIMEN: Dimension totale de l' espace ou la fonction a approcher */
/*         prend ses valeurs.(somme des dimensions des sous-espaces) */
/* NBSESP: Nombre de sous-espaces independants ou l'on mesure les */
/*         erreurs. */
/* NDIMSE: Table des dimensions des NBSESP sous-espaces. */
/* NBUPAT: Nbre de carreau solution en u. */
/* NBVPAT: Nbre de carreau solution en v. */
/* IORDRU: Ordre de contrainte impose aux extremites de l'iso-V */
/*         = 0, on calcule les extremites de l'iso-V */
/*         = 1, on calcule, en plus, la derivee 1ere dans le sens */
/*              de l'iso-V */
/*         = 2, on calcule, en plus, la derivee 2nde dans le sens */
/*              de l'iso-V */
/* IORDRV: Ordre de contrainte impose aux extremites de l'iso-U */
/*         = 0, on calcule les extremites de l'iso-U. */
/*         = 1, on calcule, en plus, la derivee 1ere dans le sens */
/*              de l'iso-U */
/*         = 2, on calcule, en plus, la derivee 2nde dans le sens */
/*              de l'iso-U */
/* EPSAPR: Table des precisions imposees, sous-espace par sous-espace. */
/* EPSFRO: Table des precisions imposees, sous-espace par sous-espace */
/*         sur les frontieres des carreaux. */
/* PATCAN: Tableau des coeff. dans la base canonique des carreaux P(u,v) 
*/
/*         calcules, pour (u,v) dans (-1,1). */
/* ERRMAX: Table des erreurs (sous-espace par sous espace) */
/*         MAXIMALES commises dans l' approximation de F(u,v) par */
/*         les P(u,v). */
/* NCOEFU: Table des Nbres de coeff. significatifs en u des carreaux */
/*         calcules. */
/* NCOEFV: Table des Nbres de coeff. significatifs en v des carreaux */
/*         calcules. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/* NCOEFU: Table des Nbres de coeff. significatifs en u des carreaux */
/*         calcules. */
/* NCOEFV: Table des Nbres de coeff. significatifs en v des carreaux */
/*         calcules. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     15-07-1996: JCT/RBD; Initialisation de TOL quand on reduit */
/*                          le degre uniquement en V */
/*     14-02-1992: RBD; Creation. */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */


    /* Parameter adjustments */
    epsfro_dim1 = *nbsesp;
    epsfro_offset = epsfro_dim1 * 5 + 1;
    epsfro -= epsfro_offset;
    --epsapr;
    --ndimse;
    ncoefv_dim1 = *nbupat;
    ncoefv_offset = ncoefv_dim1 + 1;
    ncoefv -= ncoefv_offset;
    ncoefu_dim1 = *nbupat;
    ncoefu_offset = ncoefu_dim1 + 1;
    ncoefu -= ncoefu_offset;
    errmax_dim1 = *nbsesp;
    errmax_dim2 = *nbupat;
    errmax_offset = errmax_dim1 * (errmax_dim2 + 1) + 1;
    errmax -= errmax_offset;
    patcan_dim1 = *ncfmxu;
    patcan_dim2 = *ncfmxv;
    patcan_dim3 = *ndimen;
    patcan_dim4 = *nbupat;
    patcan_offset = patcan_dim1 * (patcan_dim2 * (patcan_dim3 * (patcan_dim4 
	    + 1) + 1) + 1) + 1;
    patcan -= patcan_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMA2FX6", 7L);
    }


    i__1 = *nbvpat;
    for (jj = 1; jj <= i__1; ++jj) {
	i__2 = *nbupat;
	for (ii = 1; ii <= i__2; ++ii) {
	    ncfu = ncoefu[ii + jj * ncoefu_dim1];
	    ncfv = ncoefv[ii + jj * ncoefv_dim1];

/* **************************************************************
******** */
/* -------------------- Reduction du degre en U -----------------
-------- */
/* **************************************************************
******** */

L200:
	    if (ncfu <= (*iordru + 1) << 1 && ncfu > 2) {

		idim = 0;
		i__3 = *nbsesp;
		for (ns = 1; ns <= i__3; ++ns) {
		    tol = epsapr[ns];
/* Computing MIN */
		    d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 9];
		    tol = min(d__1,d__2);
/* Computing MIN */
		    d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 10];
		    tol = min(d__1,d__2);
/* Computing MIN */
		    d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 11];
		    tol = min(d__1,d__2);
/* Computing MIN */
		    d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 12];
		    tol = min(d__1,d__2);
		    if (ii == 1 || ii == *nbupat || jj == 1 || jj == *nbvpat) 
			    {
/* Computing MIN */
			d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 5];
			tol = min(d__1,d__2);
/* Computing MIN */
			d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 6];
			tol = min(d__1,d__2);
/* Computing MIN */
			d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 7];
			tol = min(d__1,d__2);
/* Computing MIN */
			d__1 = tol, d__2 = epsfro[ns + (epsfro_dim1 << 3)];
			tol = min(d__1,d__2);
		    }
		    bid = 0.;

		    i__4 = ndimse[ns];
		    for (nd = 1; nd <= i__4; ++nd) {
			id = idim + nd;
			i__5 = ncfv;
			for (kv = 1; kv <= i__5; ++kv) {
			    bid += (d__1 = patcan[ncfu + (kv + (id + (ii + jj 
				    * patcan_dim4) * patcan_dim3) * 
				    patcan_dim2) * patcan_dim1], abs(d__1));
/* L230: */
			}
/* L220: */
		    }

		    if (bid > tol * 1e-6 || bid > errmax[ns + (ii + jj * 
			    errmax_dim2) * errmax_dim1]) {
			goto L300;
		    }
		    idim += ndimse[ns];
/* L210: */
		}

		--ncfu;
		goto L200;
	    }

/* **************************************************************
******** */
/* -------------------- Reduction du degre en V -----------------
-------- */
/* **************************************************************
******** */

L300:
	    if (ncfv <= (*iordrv + 1) << 1 && ncfv > 2) {

		idim = 0;
		i__3 = *nbsesp;
		for (ns = 1; ns <= i__3; ++ns) {
		    tol = epsapr[ns];
/* Computing MIN */
		    d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 9];
		    tol = min(d__1,d__2);
/* Computing MIN */
		    d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 10];
		    tol = min(d__1,d__2);
/* Computing MIN */
		    d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 11];
		    tol = min(d__1,d__2);
/* Computing MIN */
		    d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 12];
		    tol = min(d__1,d__2);
		    if (ii == 1 || ii == *nbupat || jj == 1 || jj == *nbvpat) 
			    {
/* Computing MIN */
			d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 5];
			tol = min(d__1,d__2);
/* Computing MIN */
			d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 6];
			tol = min(d__1,d__2);
/* Computing MIN */
			d__1 = tol, d__2 = epsfro[ns + epsfro_dim1 * 7];
			tol = min(d__1,d__2);
/* Computing MIN */
			d__1 = tol, d__2 = epsfro[ns + (epsfro_dim1 << 3)];
			tol = min(d__1,d__2);
		    }
		    bid = 0.;

		    i__4 = ndimse[ns];
		    for (nd = 1; nd <= i__4; ++nd) {
			id = idim + nd;
			i__5 = ncfu;
			for (ku = 1; ku <= i__5; ++ku) {
			    bid += (d__1 = patcan[ku + (ncfv + (id + (ii + jj 
				    * patcan_dim4) * patcan_dim3) * 
				    patcan_dim2) * patcan_dim1], abs(d__1));
/* L330: */
			}
/* L320: */
		    }

		    if (bid > tol * 1e-6 || bid > errmax[ns + (ii + jj * 
			    errmax_dim2) * errmax_dim1]) {
			goto L400;
		    }
		    idim += ndimse[ns];
/* L310: */
		}

		--ncfv;
		goto L300;
	    }

/* --- On recupere les nbres de coeff. et on passe au carreau suiv
ant --- */

L400:
	    ncoefu[ii + jj * ncoefu_dim1] = max(ncfu,2);
	    ncoefv[ii + jj * ncoefv_dim1] = max(ncfv,2);
/* L110: */
	}
/* L100: */
    }

/* ------------------------------ The End ------------------------------- 
*/

    if (ibb >= 3) {
	mgsomsg_("MMA2FX6", 7L);
    }

 return 0 ;
} /* mma2fx6_ */

