// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_IntersectionTool_HeaderFile
#define _ShapeFix_IntersectionTool_HeaderFile

#ifndef _Handle_ShapeBuild_ReShape_HeaderFile
#include <Handle_ShapeBuild_ReShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_ShapeExtend_WireData_HeaderFile
#include <Handle_ShapeExtend_WireData.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
class ShapeBuild_ReShape;
class TopoDS_Edge;
class TopoDS_Vertex;
class TopoDS_Face;
class ShapeExtend_WireData;
class ShapeFix_DataMapOfShapeBox2d;
class Bnd_Box2d;
class Geom2d_Curve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Tool for fixing selfintersecting wire <br>
//!          and intersecting wires <br>
class ShapeFix_IntersectionTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructor <br>
Standard_EXPORT ShapeFix_IntersectionTool(const Handle(ShapeBuild_ReShape)& context,const Standard_Real preci,const Standard_Real maxtol = 1.0);
//! Returns context <br>
  Handle_ShapeBuild_ReShape Context() const;

//! Split edge on two new edges using new vertex "vert" <br>
//!          and "param" - parameter for splitting <br>
//!          The "face" is necessary for pcurves and using TransferParameterProj <br>
Standard_EXPORT   Standard_Boolean SplitEdge(const TopoDS_Edge& edge,const Standard_Real param,const TopoDS_Vertex& vert,const TopoDS_Face& face,TopoDS_Edge& newE1,TopoDS_Edge& newE2,const Standard_Real preci) const;

//! Cut edge by parameters pend and cut <br>
Standard_EXPORT   Standard_Boolean CutEdge(const TopoDS_Edge& edge,const Standard_Real pend,const Standard_Real cut,const TopoDS_Face& face,Standard_Boolean& iscutline) const;


Standard_EXPORT   Standard_Boolean FixSelfIntersectWire(Handle(ShapeExtend_WireData)& sewd,const TopoDS_Face& face,Standard_Integer& NbSplit,Standard_Integer& NbCut,Standard_Integer& NbRemoved) const;


Standard_EXPORT   Standard_Boolean FixIntersectingWires(TopoDS_Face& face) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean SplitEdge1(const Handle(ShapeExtend_WireData)& sewd,const TopoDS_Face& face,const Standard_Integer num,const Standard_Real param,const TopoDS_Vertex& vert,const Standard_Real preci,ShapeFix_DataMapOfShapeBox2d& boxes) const;


Standard_EXPORT   Standard_Boolean SplitEdge2(const Handle(ShapeExtend_WireData)& sewd,const TopoDS_Face& face,const Standard_Integer num,const Standard_Real param1,const Standard_Real param2,const TopoDS_Vertex& vert,const Standard_Real preci,ShapeFix_DataMapOfShapeBox2d& boxes) const;


Standard_EXPORT   Standard_Boolean UnionVertexes(const Handle(ShapeExtend_WireData)& sewd,TopoDS_Edge& edge1,TopoDS_Edge& edge2,const Standard_Integer num2,ShapeFix_DataMapOfShapeBox2d& boxes,const Bnd_Box2d& B2) const;


Standard_EXPORT   Standard_Boolean FindVertAndSplitEdge(const Standard_Real param1,const TopoDS_Edge& edge1,const TopoDS_Edge& edge2,const Handle(Geom2d_Curve)& Crv1,Standard_Real& MaxTolVert,Standard_Integer& num1,const Handle(ShapeExtend_WireData)& sewd,const TopoDS_Face& face,ShapeFix_DataMapOfShapeBox2d& boxes,const Standard_Boolean aTmpKey) const;


 // Fields PRIVATE
 //
Handle_ShapeBuild_ReShape myContext;
Standard_Real myPreci;
Standard_Real myMaxTol;


};


#include <ShapeFix_IntersectionTool.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
