// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Select2D_SensitiveSegment_HeaderFile
#define _Select2D_SensitiveSegment_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Select2D_SensitiveSegment_HeaderFile
#include <Handle_Select2D_SensitiveSegment.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _Select2D_SensitiveEntity_HeaderFile
#include <Select2D_SensitiveEntity.hxx>
#endif
#ifndef _Handle_SelectBasics_EntityOwner_HeaderFile
#include <Handle_SelectBasics_EntityOwner.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class SelectBasics_EntityOwner;
class gp_Pnt2d;
class SelectBasics_ListOfBox2d;


//! A framework to define sensitive areas along a line segment. <br>
class Select2D_SensitiveSegment : public Select2D_SensitiveEntity {

public:
 // Methods PUBLIC
 // 

//! Constructs the sensitive line segment object defined <br>
//! by the owner OwnerId, the 2D starting and ending <br>
//! points FirstPoint and LastPoint and the maximum <br>
//! number of sensitive bounding boxes MaxRect. <br>
//! The parameters can be modified using the functions provided. <br>
Standard_EXPORT Select2D_SensitiveSegment(const Handle(SelectBasics_EntityOwner)& OwnerId,const gp_Pnt2d& FirstP,const gp_Pnt2d& LastP,const Standard_Integer MaxRect = 3);

//! Sets the maximum number of 2D sensitive bounding boxes - MaxRect. <br>
Standard_EXPORT   void Set(const Standard_Integer MaxRect) ;
//! changes the start Point of the Segment; <br>
  void StartPoint(const gp_Pnt2d& aPt) ;
//! changes the end point of the segment <br>
  void EndPoint(const gp_Pnt2d& aPt) ;
//! gives the 3D start Point of the Segment <br>
 const gp_Pnt2d& StartPoint() const;
//! Returnes the 3D start Point of the Segment <br>
 const gp_Pnt2d& EndPoint() const;


Standard_EXPORT   void Areas(SelectBasics_ListOfBox2d& aSeq) ;


Standard_EXPORT   Standard_Boolean Matches(const Standard_Real X,const Standard_Real Y,const Standard_Real aTol,Standard_Real& DMin) ;


Standard_EXPORT   Standard_Boolean Matches(const Standard_Real XMin,const Standard_Real YMin,const Standard_Real XMax,const Standard_Real YMax,const Standard_Real aTol) ;
//! Returns the max number of sensitive aeas describing the sensitive segment <br>
  Standard_Integer MaxBoxes() const;
//Standard_EXPORT ~Select2D_SensitiveSegment();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer mymaxrect;
gp_Pnt2d mystart;
gp_Pnt2d myend;


};


#include <Select2D_SensitiveSegment.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
