// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MoniTool_Timer_HeaderFile
#define _MoniTool_Timer_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MoniTool_Timer_HeaderFile
#include <Handle_MoniTool_Timer.hxx>
#endif

#ifndef _OSD_Timer_HeaderFile
#include <OSD_Timer.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_MoniTool_Timer_HeaderFile
#include <Handle_MoniTool_Timer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class OSD_Timer;
class MoniTool_DataMapOfTimer;


//! Provides convenient service on global timers <br>
//!          accessed by string name, mostly aimed for debugging purposes <br>
//! <br>
//!          As an instance, envelopes the OSD_Timer to have it as Handle <br>
class MoniTool_Timer : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 
//! Create timer in empty state <br>
MoniTool_Timer();

 const OSD_Timer& Timer() const;
//! Return reference to embedded OSD_Timer <br>
  OSD_Timer& Timer() ;

  void Start() ;

  void Stop() ;
//! Start, Stop and reset the timer <br>
//!          In addition to doing that to embedded OSD_Timer, <br>
//!          manage also counter of hits <br>
  void Reset() ;
//! Return value of hits counter (count of Start/Stop pairs) <br>
  Standard_Integer Count() const;
//! Returns value of nesting counter <br>
  Standard_Integer IsRunning() const;
//! Return value of CPU time minus accumulated amendment <br>
  Standard_Real CPU() ;
//! Return value of accumulated amendment on CPU time <br>
  Standard_Real Amend() const;

//! Dumps current state of a timer shortly (one-line output) <br>
Standard_EXPORT   void Dump(Standard_OStream& ostr) ;

//! Returns a timer from a dictionary by its name <br>
//!          If timer not existed, creates a new one <br>
Standard_EXPORT static  Handle_MoniTool_Timer Timer(const Standard_CString name) ;

static  void Start(const Standard_CString name) ;
//! Inline methods to conveniently start/stop timer by name <br>
//!          Shortcut to Timer(name)->Start/Stop() <br>
static  void Stop(const Standard_CString name) ;

//! Returns map of timers <br>
Standard_EXPORT static  MoniTool_DataMapOfTimer& Dictionary() ;

//! Clears map of timers <br>
Standard_EXPORT static  void ClearTimers() ;

//! Dumps contents of the whole dictionary <br>
Standard_EXPORT static  void DumpTimers(Standard_OStream& ostr) ;

//! Computes and remembers amendments for times to <br>
//!          access, start, and stop of timer, and estimates <br>
//!          second-order error measured by 10 nested timers <br>
Standard_EXPORT static  void ComputeAmendments() ;

//! The computed amendmens are returned (for information only) <br>
Standard_EXPORT static  void GetAmendments(Standard_Real& Access,Standard_Real& Internal,Standard_Real& External,Standard_Real& Error10) ;
//Standard_EXPORT ~MoniTool_Timer();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT static  void AmendAccess() ;


Standard_EXPORT   void AmendStart() ;

//! Internal functions to amend other timers to avoid <br>
//!          side effects of operations with current one <br>
Standard_EXPORT   void AmendStop() ;


 // Fields PRIVATE
 //
OSD_Timer myTimer;
Standard_Integer myCount;
Standard_Integer myNesting;
Standard_Real myAmend;
Handle_MoniTool_Timer myPrev;
Handle_MoniTool_Timer myNext;


};


#include <MoniTool_Timer.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
