// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Law_BSpline_HeaderFile
#define _Law_BSpline_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Law_BSpline_HeaderFile
#include <Handle_Law_BSpline.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_BSplKnotDistribution_HeaderFile
#include <GeomAbs_BSplKnotDistribution.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TColStd_HArray1OfReal;
class TColStd_HArray1OfInteger;
class Standard_ConstructionError;
class Standard_DimensionError;
class Standard_DomainError;
class Standard_OutOfRange;
class Standard_RangeError;
class Standard_NoSuchObject;
class TColStd_Array1OfReal;
class TColStd_Array1OfInteger;


//! Definition of the 1D B_spline curve. <br>
//! <br>
//!         Uniform  or non-uniform <br>
//!         Rational or non-rational <br>
//!         Periodic or non-periodic <br>
//! <br>
//!  a b-spline curve is defined by : <br>
//! <br>
//!         The Degree (up to 25) <br>
//! <br>
//!         The Poles  (and the weights if it is rational) <br>
//! <br>
//!         The Knots and Multiplicities <br>
//! <br>
//!           The knot vector   is an  increasing  sequence  of <br>
//!           reals without  repetition. The multiplicities are <br>
//!           the repetition of the knots. <br>
//! <br>
//!           If the knots are regularly spaced (the difference <br>
//!           of two  consecutive  knots  is a   constant), the <br>
//!           knots repartition is : <br>
//! <br>
//!              - Uniform if all multiplicities are 1. <br>
//! <br>
//!              -  Quasi-uniform if  all multiplicities are  1 <br>
//!              but the first and the last which are Degree+1. <br>
//! <br>
//!              -   PiecewiseBezier if  all multiplicites  are <br>
//!              Degree but the   first and the  last which are <br>
//!              Degree+1. <br>
//! <br>
//!         The curve may be periodic. <br>
//! <br>
//!              On a periodic curve if there are k knots and p <br>
//!              poles. the period is knot(k) - knot(1) <br>
//! <br>
//!              the poles and knots are infinite vectors with : <br>
//! <br>
//!                knot(i+k) = knot(i) + period <br>
//! <br>
//!                pole(i+p) = pole(i) <br>
//! <br>
//! <br>
//! References : <br>
//!  . A survey of curve and surface methods in CADG Wolfgang BOHM <br>
//!    CAGD 1 (1984) <br>
//!  . On de Boor-like algorithms and blossoming Wolfgang BOEHM <br>
//!    cagd 5 (1988) <br>
//!  . Blossoming and knot insertion algorithms for B-spline curves <br>
//!    Ronald N. GOLDMAN <br>
//!  . Modelisation des surfaces en CAO, Henri GIAUME Peugeot SA <br>
//!  . Curves and Surfaces for Computer Aided Geometric Design, <br>
//!    a practical guide Gerald Farin <br>
class Law_BSpline : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//!  Creates a  non-rational B_spline curve   on  the <br>
//!         basis <Knots, Multiplicities> of degree <Degree>. <br>
Standard_EXPORT Law_BSpline(const TColStd_Array1OfReal& Poles,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Multiplicities,const Standard_Integer Degree,const Standard_Boolean Periodic = Standard_False);

//! Creates  a rational B_spline  curve  on the basis <br>
//!         <Knots, Multiplicities> of degree <Degree>. <br>
Standard_EXPORT Law_BSpline(const TColStd_Array1OfReal& Poles,const TColStd_Array1OfReal& Weights,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Multiplicities,const Standard_Integer Degree,const Standard_Boolean Periodic = Standard_False);

//! Increase the degree to  <Degree>. Nothing is  done <br>
//!          if  <Degree>   is lower or  equal  to the  current <br>
//!          degree. <br>
Standard_EXPORT   void IncreaseDegree(const Standard_Integer Degree) ;

//!Increases the multiplicity  of the knot <Index> to <br>
//!         <M>. <br>
//! <br>
//!         If   <M>   is   lower   or  equal   to  the current <br>
//!         multiplicity nothing is done. If <M> is higher than <br>
//!         the degree the degree is used. <br>//! If <Index> is not in [FirstUKnotIndex, LastUKnotIndex] <br>
Standard_EXPORT   void IncreaseMultiplicity(const Standard_Integer Index,const Standard_Integer M) ;

//!Increases  the  multiplicities   of  the knots  in <br>
//!         [I1,I2] to <M>. <br>
//! <br>
//!         For each knot if  <M>  is  lower  or equal  to  the <br>
//!         current multiplicity  nothing  is  done. If <M>  is <br>
//!         higher than the degree the degree is used. <br>//! If <I1,I2> are not in [FirstUKnotIndex, LastUKnotIndex] <br>
Standard_EXPORT   void IncreaseMultiplicity(const Standard_Integer I1,const Standard_Integer I2,const Standard_Integer M) ;

//!Increment  the  multiplicities   of  the knots  in <br>
//!         [I1,I2] by <M>. <br>
//! <br>
//!         If <M> is not positive nithing is done. <br>
//! <br>
//!         For   each  knot   the resulting   multiplicity  is <br>
//!         limited to the Degree. <br>//! If <I1,I2> are not in [FirstUKnotIndex, LastUKnotIndex] <br>
Standard_EXPORT   void IncrementMultiplicity(const Standard_Integer I1,const Standard_Integer I2,const Standard_Integer M) ;

//! Inserts a knot value in the sequence of knots.  If <br>
//!          <U>  is an  existing knot     the multiplicity  is <br>
//!          increased by <M>. <br>
//! <br>
//!          If U  is  not  on the parameter  range  nothing is <br>
//!          done. <br>
//! <br>
//!          If the multiplicity is negative or null nothing is <br>
//!          done. The  new   multiplicity  is limited  to  the <br>
//!          degree. <br>
//! <br>
//!          The  tolerance criterion  for  knots  equality  is <br>
//!          the max of Epsilon(U) and ParametricTolerance. <br>
Standard_EXPORT   void InsertKnot(const Standard_Real U,const Standard_Integer M = 1,const Standard_Real ParametricTolerance = 0.0,const Standard_Boolean Add = Standard_True) ;

//! Inserts a set of knots  values in  the sequence of <br>
//!          knots. <br>
//! <br>
//!          For each U = Knots(i), M = Mults(i) <br>
//! <br>
//!          If <U>  is an existing  knot  the  multiplicity is <br>
//!          increased by  <M> if  <Add>  is True, increased to <br>
//!          <M> if <Add> is False. <br>
//! <br>
//!          If U  is  not  on the parameter  range  nothing is <br>
//!          done. <br>
//! <br>
//!          If the multiplicity is negative or null nothing is <br>
//!          done. The  new   multiplicity  is limited  to  the <br>
//!          degree. <br>
//! <br>
//!          The  tolerance criterion  for  knots  equality  is <br>
//!          the max of Epsilon(U) and ParametricTolerance. <br>
Standard_EXPORT   void InsertKnots(const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults,const Standard_Real ParametricTolerance = 0.0,const Standard_Boolean Add = Standard_False) ;

//! Decrement the knots multiplicity to <M>. If  M is <br>
//!         0 the knot   is  removed. The  Poles  sequence   is <br>
//!         modified. <br>
//! <br>
//!         As there are two ways to  compute the new poles the <br>
//!         average is  computed if  the distance is lower than <br>
//!         the <Tolerance>, else False is returned. <br>
//! <br>
//!         A low tolerance is used to prevent the modification <br>
//!         of the curve. <br>
//! <br>
//!         A high tolerance is used to "smooth" the curve. <br>
//! <br>
//!  Raised if Index is not in the range <br>
//!  [FirstUKnotIndex, LastUKnotIndex] <br>//! pole insertion and pole removing <br>
//!  this operation is limited to the Uniform or QuasiUniform <br>
//!  BSplineCurve. The knot values are modified . If the BSpline is <br>
//!  NonUniform or Piecewise Bezier an exception Construction error <br>
//!  is raised. <br>
Standard_EXPORT   Standard_Boolean RemoveKnot(const Standard_Integer Index,const Standard_Integer M,const Standard_Real Tolerance) ;


//!  Changes the direction of parametrization of <me>. The Knot <br>
//!  sequence is modified, the FirstParameter and the <br>
//!  LastParameter are not modified. The StartPoint of the <br>
//!  initial curve becomes the EndPoint of the reversed curve <br>
//!  and the EndPoint of the initial curve becomes the StartPoint <br>
//!  of the reversed curve. <br>
Standard_EXPORT   void Reverse() ;

//! Returns the  parameter on the  reversed  curve for <br>
//!          the point of parameter U on <me>. <br>
//! <br>
//!          returns UFirst + ULast - U <br>
Standard_EXPORT   Standard_Real ReversedParameter(const Standard_Real U) const;


//!  Segments the curve between U1 and U2. <br>
//!  The control points are modified, the first and the last point <br>
//!  are not the same. <br>
//! Warnings : <br>
//!  Even if <me> is not closed it can become closed after the <br>
//!  segmentation for example if U1 or U2 are out of the bounds <br>
//!  of the curve <me> or if the curve makes loop. <br>
//!  After the segmentation the length of a curve can be null. <br>//! raises if U2 < U1. <br>
Standard_EXPORT   void Segment(const Standard_Real U1,const Standard_Real U2) ;

//!  Changes the knot of range Index. <br>
//!  The multiplicity of the knot is not modified. <br>//! Raised if K >= Knots(Index+1) or K <= Knots(Index-1). <br>//! Raised if Index < 1 || Index > NbKnots <br>
Standard_EXPORT   void SetKnot(const Standard_Integer Index,const Standard_Real K) ;

//!  Changes all the knots of the curve <br>
//!  The multiplicity of the knots are not modified. <br>
//!  Raised if there is an index such that K (Index+1) <= K (Index). <br>
//!  Raised if  K.Lower() < 1 or K.Upper() > NbKnots <br>
Standard_EXPORT   void SetKnots(const TColStd_Array1OfReal& K) ;


//!  Changes the knot of range Index with its multiplicity. <br>
//!  You can increase the multiplicity of a knot but it is <br>
//!  not allowed to decrease the multiplicity of an existing knot. <br>
//!  Raised if K >= Knots(Index+1) or K <= Knots(Index-1). <br>
//!  Raised if M is greater than Degree or lower than the previous <br>
//!  multiplicity of knot of range Index. <br>//! Raised if Index < 1 || Index > NbKnots <br>
Standard_EXPORT   void SetKnot(const Standard_Integer Index,const Standard_Real K,const Standard_Integer M) ;

//! returns the parameter normalized within <br>
//!         the period if the curve is periodic : otherwise <br>
//!         does not do anything <br>
Standard_EXPORT   void PeriodicNormalization(Standard_Real& U) const;


//!  Makes a closed B-spline into a periodic curve. The curve is <br>
//!  periodic if the knot sequence is periodic and if the curve is <br>
//!  closed (The tolerance criterion is Resolution from gp). <br>
//!  The period T is equal to Knot(LastUKnotIndex) - <br>
//!   Knot(FirstUKnotIndex). A periodic B-spline can be uniform <br>
//!   or not. <br>//! Raised if the curve is not closed. <br>
Standard_EXPORT   void SetPeriodic() ;

//! Set the origin of a periodic curve at Knot(index) <br>
//!          KnotVector and poles are modified. <br>//! Raised if the curve is not periodic <br>//! Raised if index not in the range <br>
//!          [FirstUKnotIndex , LastUKnotIndex] <br>
Standard_EXPORT   void SetOrigin(const Standard_Integer Index) ;


//!  Makes a non periodic curve. If the curve was non periodic <br>
//!  the curve is not modified. <br>
Standard_EXPORT   void SetNotPeriodic() ;

//! Substitutes the Pole of range Index with P. <br>
//!  Raised if Index < 1 || Index > NbPoles <br>
Standard_EXPORT   void SetPole(const Standard_Integer Index,const Standard_Real P) ;


//!  Substitutes the pole and the weight of range Index. <br>
//!  If the curve <me> is not rational it can become rational <br>
//!  If the curve was rational it can become non rational <br>
//!  Raised if Index < 1 || Index > NbPoles <br>//! Raised if Weight <= 0.0 <br>
Standard_EXPORT   void SetPole(const Standard_Integer Index,const Standard_Real P,const Standard_Real Weight) ;


//!  Changes the weight for the pole of range Index. <br>
//!  If the curve was non rational it can become rational. <br>
//!  If the curve was rational it can become non rational. <br>
//!  Raised if Index < 1 || Index > NbPoles <br>//! Raised if Weight <= 0.0 <br>
Standard_EXPORT   void SetWeight(const Standard_Integer Index,const Standard_Real Weight) ;


//!  Returns the continuity of the curve, the curve is at least C0. <br>//! Raised if N < 0. <br>
Standard_EXPORT   Standard_Boolean IsCN(const Standard_Integer N) const;


//!  Returns true if the distance between the first point and the <br>
//!  last point of the curve is lower or equal to Resolution <br>
//!  from package gp. <br>
//! Warnings : <br>
//!  The first and the last point can be different from the first <br>
//!  pole and the last pole of the curve. <br>
Standard_EXPORT   Standard_Boolean IsClosed() const;

//! Returns True if the curve is periodic. <br>
Standard_EXPORT   Standard_Boolean IsPeriodic() const;


//!  Returns True if the weights are not identical. <br>
//!  The tolerance criterion is Epsilon of the class Real. <br>
Standard_EXPORT   Standard_Boolean IsRational() const;


//!  Returns the global continuity of the curve : <br>
//!  C0 : only geometric continuity, <br>
//!  C1 : continuity of the first derivative all along the Curve, <br>
//!  C2 : continuity of the second derivative all along the Curve, <br>
//!  C3 : continuity of the third derivative all along the Curve, <br>
//!  CN : the order of continuity is infinite. <br>
//!  For a B-spline curve of degree d if a knot Ui has a <br>
//!  multiplicity p the B-spline curve is only Cd-p continuous <br>
//!  at Ui. So the global continuity of the curve can't be greater <br>
//!  than Cd-p where p is the maximum multiplicity of the interior <br>
//!  Knots. In the interior of a knot span the curve is infinitely <br>
//!  continuously differentiable. <br>
Standard_EXPORT   GeomAbs_Shape Continuity() const;

//! Computation of value and derivatives <br>
Standard_EXPORT   Standard_Integer Degree() const;


Standard_EXPORT   Standard_Real Value(const Standard_Real U) const;


Standard_EXPORT   void D0(const Standard_Real U,Standard_Real& P) const;


Standard_EXPORT   void D1(const Standard_Real U,Standard_Real& P,Standard_Real& V1) const;


Standard_EXPORT   void D2(const Standard_Real U,Standard_Real& P,Standard_Real& V1,Standard_Real& V2) const;


Standard_EXPORT   void D3(const Standard_Real U,Standard_Real& P,Standard_Real& V1,Standard_Real& V2,Standard_Real& V3) const;


//!  The following functions computes the point  of parameter U and <br>
//!  the  derivatives at   this  point on  the  B-spline curve  arc <br>
//!  defined between the knot FromK1  and the knot  ToK2.  U can be <br>
//!  out of bounds   [Knot  (FromK1), Knot   (ToK2)] but   for  the <br>
//!  computation we only  use  the definition of the  curve between <br>
//!  these  two  knots. This  method is  useful  to  compute  local <br>
//!  derivative,  if the order of  continuity of the whole curve is <br>
//!  not   greater  enough.   Inside   the parametric   domain Knot <br>
//!  (FromK1), Knot (ToK2)  the evaluations are the  same as if  we <br>
//!  consider  the whole  definition of the  curve.   Of course the <br>
//!  evaluations are different outside this parametric domain. <br>
Standard_EXPORT   Standard_Real DN(const Standard_Real U,const Standard_Integer N) const;


Standard_EXPORT   Standard_Real LocalValue(const Standard_Real U,const Standard_Integer FromK1,const Standard_Integer ToK2) const;


Standard_EXPORT   void LocalD0(const Standard_Real U,const Standard_Integer FromK1,const Standard_Integer ToK2,Standard_Real& P) const;


Standard_EXPORT   void LocalD1(const Standard_Real U,const Standard_Integer FromK1,const Standard_Integer ToK2,Standard_Real& P,Standard_Real& V1) const;


Standard_EXPORT   void LocalD2(const Standard_Real U,const Standard_Integer FromK1,const Standard_Integer ToK2,Standard_Real& P,Standard_Real& V1,Standard_Real& V2) const;


Standard_EXPORT   void LocalD3(const Standard_Real U,const Standard_Integer FromK1,const Standard_Integer ToK2,Standard_Real& P,Standard_Real& V1,Standard_Real& V2,Standard_Real& V3) const;


Standard_EXPORT   Standard_Real LocalDN(const Standard_Real U,const Standard_Integer FromK1,const Standard_Integer ToK2,const Standard_Integer N) const;


//!  Returns the last point of the curve. <br>
//! Warnings : <br>
//!  The last point of the curve is different from the last <br>
//!  pole of the curve if the multiplicity of the last knot <br>
//!  is lower than Degree. <br>
Standard_EXPORT   Standard_Real EndPoint() const;


//!  For a B-spline curve the first parameter (which gives the start <br>
//!  point of the curve) is a knot value but if the multiplicity of <br>
//!  the first knot index is lower than Degree + 1 it is not the <br>
//!  first knot of the curve. This method computes the index of the <br>
//!  knot corresponding to the first parameter. <br>
Standard_EXPORT   Standard_Integer FirstUKnotIndex() const;


//!  Computes the parametric value of the start point of the curve. <br>
//!  It is a knot value. <br>
Standard_EXPORT   Standard_Real FirstParameter() const;


//!  Returns the knot of range Index. When there is a knot <br>
//!  with a multiplicity greater than 1 the knot is not repeated. <br>
//!  The method Multiplicity can be used to get the multiplicity <br>
//!  of the Knot. <br>//! Raised if Index < 1 or Index > NbKnots <br>
Standard_EXPORT   Standard_Real Knot(const Standard_Integer Index) const;

//! returns the knot values of the B-spline curve; <br>
//!  Raised if the length of K is not equal to the number of knots. <br>
Standard_EXPORT   void Knots(TColStd_Array1OfReal& K) const;

//! Returns the knots sequence. <br>
//!  In this sequence the knots with a multiplicity greater than 1 <br>
//!  are repeated. <br>
//! Example : <br>
//!  K = {k1, k1, k1, k2, k3, k3, k4, k4, k4} <br>
//!  Raised if the length of K is not equal to NbPoles + Degree + 1 <br>
Standard_EXPORT   void KnotSequence(TColStd_Array1OfReal& K) const;


//!  Returns NonUniform or Uniform or QuasiUniform or PiecewiseBezier. <br>
//!  If all the knots differ by a positive constant from the <br>
//!  preceding knot the BSpline Curve can be : <br>
//!  - Uniform if all the knots are of multiplicity 1, <br>
//!  - QuasiUniform if all the knots are of multiplicity 1 except for <br>
//!    the first and last knot which are of multiplicity Degree + 1, <br>
//!  - PiecewiseBezier if the first and last knots have multiplicity <br>
//!    Degree + 1 and if interior knots have multiplicity Degree <br>
//!    A piecewise Bezier with only two knots is a BezierCurve. <br>
//!  else the curve is non uniform. <br>
//!  The tolerance criterion is Epsilon from class Real. <br>
Standard_EXPORT   GeomAbs_BSplKnotDistribution KnotDistribution() const;


//!  For a BSpline curve the last parameter (which gives the <br>
//!  end point of the curve) is a knot value but if the <br>
//!  multiplicity of the last knot index is lower than <br>
//!  Degree + 1 it is not the last knot of the curve. This <br>
//!  method computes the index of the knot corresponding to <br>
//!  the last parameter. <br>
Standard_EXPORT   Standard_Integer LastUKnotIndex() const;


//!  Computes the parametric value of the end point of the curve. <br>
//!  It is a knot value. <br>
Standard_EXPORT   Standard_Real LastParameter() const;


//!  Locates the parametric value U in the sequence of knots. <br>
//!  If "WithKnotRepetition" is True we consider the knot's <br>
//!  representation with repetition of multiple knot value, <br>
//!  otherwise  we consider the knot's representation with <br>
//!  no repetition of multiple knot values. <br>
//!  Knots (I1) <= U <= Knots (I2) <br>
//!  . if I1 = I2  U is a knot value (the tolerance criterion <br>
//!    ParametricTolerance is used). <br>
//!  . if I1 < 1  => U < Knots (1) - Abs(ParametricTolerance) <br>
//!  . if I2 > NbKnots => U > Knots (NbKnots) + Abs(ParametricTolerance) <br>
Standard_EXPORT   void LocateU(const Standard_Real U,const Standard_Real ParametricTolerance,Standard_Integer& I1,Standard_Integer& I2,const Standard_Boolean WithKnotRepetition = Standard_False) const;


//!  Returns the multiplicity of the knots of range Index. <br>//! Raised if Index < 1 or Index > NbKnots <br>
Standard_EXPORT   Standard_Integer Multiplicity(const Standard_Integer Index) const;


//!  Returns the multiplicity of the knots of the curve. <br>
//!  Raised if the length of M is not equal to NbKnots. <br>
Standard_EXPORT   void Multiplicities(TColStd_Array1OfInteger& M) const;


//!  Returns the number of knots. This method returns the number of <br>
//!  knot without repetition of multiple knots. <br>
Standard_EXPORT   Standard_Integer NbKnots() const;

//! Returns the number of poles <br>
Standard_EXPORT   Standard_Integer NbPoles() const;

//! Returns the pole of range Index. <br>//! Raised if Index < 1 or Index > NbPoles. <br>
Standard_EXPORT   Standard_Real Pole(const Standard_Integer Index) const;

//! Returns the poles of the B-spline curve; <br>
//!  Raised if the length of P is not equal to the number of poles. <br>
Standard_EXPORT   void Poles(TColStd_Array1OfReal& P) const;


//!  Returns the start point of the curve. <br>
//! Warnings : <br>
//!  This point is different from the first pole of the curve if the <br>
//!  multiplicity of the first knot is lower than Degree. <br>
Standard_EXPORT   Standard_Real StartPoint() const;

//! Returns the weight of the pole of range Index . <br>//! Raised if Index < 1 or Index > NbPoles. <br>
Standard_EXPORT   Standard_Real Weight(const Standard_Integer Index) const;

//! Returns the weights of the B-spline curve; <br>
//!  Raised if the length of W is not equal to NbPoles. <br>
Standard_EXPORT   void Weights(TColStd_Array1OfReal& W) const;


//!  Returns the value of the maximum degree of the normalized <br>
//!  B-spline basis functions in this package. <br>
Standard_EXPORT static  Standard_Integer MaxDegree() ;


//! Changes the value of the Law at parameter U to NewValue. <br>
//! and makes its derivative at U be derivative. <br>
//! StartingCondition = -1 means first can move <br>
//! EndingCondition   = -1 means last point can move <br>
//! StartingCondition = 0 means the first point cannot move <br>
//! EndingCondition   = 0 means the last point cannot move <br>
//! StartingCondition = 1 means the first point and tangent cannot move <br>
//! EndingCondition   = 1 means the last point and tangent cannot move <br>
//! and so forth <br>
//! ErrorStatus != 0 means that there are not enought degree of freedom <br>
//! with the constrain to deform the curve accordingly <br>
//! <br>
Standard_EXPORT   void MovePointAndTangent(const Standard_Real U,const Standard_Real NewValue,const Standard_Real Derivative,const Standard_Real Tolerance,const Standard_Integer StartingCondition,const Standard_Integer EndingCondition,Standard_Integer& ErrorStatus) ;

//!  given Tolerance3D returns UTolerance <br>
//!           such that if f(t) is the curve we have <br>
//!           | t1 - t0| < Utolerance ===> <br>
//!           |f(t1) - f(t0)| < Tolerance3D <br>
Standard_EXPORT   void Resolution(const Standard_Real Tolerance3D,Standard_Real& UTolerance) const;


Standard_EXPORT   Handle_Law_BSpline Copy() const;
//Standard_EXPORT ~Law_BSpline();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


//!           Tells whether the Cache is valid for the <br>
//!           given parameter <br>
//! Warnings : the parameter must be normalized within <br>
//! the period if the curve is periodic. Otherwise <br>
//! the answer will be false <br>
//! <br>
Standard_EXPORT   Standard_Boolean IsCacheValid(const Standard_Real Parameter) const;

//! Recompute  the  flatknots,  the knotsdistribution, the <br>
//!          continuity. <br>
Standard_EXPORT   void UpdateKnots() ;


 // Fields PRIVATE
 //
Standard_Boolean rational;
Standard_Boolean periodic;
GeomAbs_BSplKnotDistribution knotSet;
GeomAbs_Shape smooth;
Standard_Integer deg;
Handle_TColStd_HArray1OfReal poles;
Handle_TColStd_HArray1OfReal weights;
Handle_TColStd_HArray1OfReal flatknots;
Handle_TColStd_HArray1OfReal knots;
Handle_TColStd_HArray1OfInteger mults;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
