// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_FloatFormat_HeaderFile
#define _IGESSelect_FloatFormat_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_FloatFormat_HeaderFile
#include <Handle_IGESSelect_FloatFormat.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _IGESSelect_FileModifier_HeaderFile
#include <IGESSelect_FileModifier.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class TCollection_AsciiString;
class IFSelect_ContextWrite;
class IGESData_IGESWriter;


//! This class gives control out format for floatting values : <br>
//!           ZeroSuppress or no, Main Format, Format in Range (for values <br>
//!           around 1.), as IGESWriter allows to manage it. <br>
//!           Formats are given under C-printf form <br>
class IGESSelect_FloatFormat : public IGESSelect_FileModifier {

public:
 // Methods PUBLIC
 // 

//! Creates a new FloatFormat, with standard options : <br>
//!           ZeroSuppress, Main Format = %E, <br>
//!           Format between 0.001 and 1000. = %f <br>
Standard_EXPORT IGESSelect_FloatFormat();

//! Sets FloatFormat to default value (see Create) but if <digits> <br>
//!           is given positive, it commands Formats (main and range) to <br>
//!           ensure <digits> significant digits to be displayed <br>
Standard_EXPORT   void SetDefault(const Standard_Integer digits = 0) ;

//! Sets ZeroSuppress mode to a new value <br>
Standard_EXPORT   void SetZeroSuppress(const Standard_Boolean mode) ;

//! Sets Main Format to a new value <br>
//!           Remark : SetFormat, SetZeroSuppress and SetFormatForRange are <br>
//!           independant <br>
Standard_EXPORT   void SetFormat(const Standard_CString format = "%E") ;

//! Sets Format for Range to a new value with its range of <br>
//!           application. <br>
//!           To cancel it, give format as "" (empty string) <br>
//!           Remark that if the condition (0. < Rmin < Rmax)  is not <br>
//!           verified, this secondary format will be ignored. <br>
//!           Moreover, this secondary format is intended to be used in a <br>
//!           range around 1. <br>
Standard_EXPORT   void SetFormatForRange(const Standard_CString format = "%f",const Standard_Real Rmin = 0.1,const Standard_Real Rmax = 1000.0) ;

//! Returns all recorded parameters : <br>
//!           zerosup  : ZeroSuppress status <br>
//!           mainform : Main Format (which applies out of the range, or <br>
//!                       for every real if no range is set) <br>
//!           hasrange : True if a FormatInRange is set, False else <br>
//!                      (following parameters do not apply if it is False) <br>
//!           forminrange : Secondary Format (it applies inside the range) <br>
//!           rangemin, rangemax : the range in which the secondary format <br>
//!                                applies <br>
Standard_EXPORT   void Format(Standard_Boolean& zerosup,TCollection_AsciiString& mainform,Standard_Boolean& hasrange,TCollection_AsciiString& forminrange,Standard_Real& rangemin,Standard_Real& rangemax) const;

//! Sets the Floatting Formats of IGESWriter to the recorded <br>
//!           parameters <br>
Standard_EXPORT   void Perform(IFSelect_ContextWrite& ctx,IGESData_IGESWriter& writer) const;

//! Returns specific Label : for instance, <br>
//!           "Float Format [ZeroSuppress] %E [, in range R1-R2 %f]" <br>
Standard_EXPORT   TCollection_AsciiString Label() const;
//Standard_EXPORT ~IGESSelect_FloatFormat();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean thezerosup;
TCollection_AsciiString themainform;
TCollection_AsciiString theformrange;
Standard_Real therangemin;
Standard_Real therangemax;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
