// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Approx_SameParameter_HeaderFile
#define _Approx_SameParameter_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _Handle_Adaptor3d_HSurface_HeaderFile
#include <Handle_Adaptor3d_HSurface.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_Adaptor2d_HCurve2d_HeaderFile
#include <Handle_Adaptor2d_HCurve2d.hxx>
#endif
class Geom2d_BSplineCurve;
class Adaptor3d_HCurve;
class Adaptor3d_HSurface;
class Standard_OutOfRange;
class Standard_ConstructionError;
class Geom_Curve;
class Geom2d_Curve;
class Geom_Surface;
class Adaptor2d_HCurve2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Approximation of a  PCurve  on a surface to  make  its <br>
//!          parameter be the same that the parameter of a given 3d <br>
//!          reference curve. <br>
class Approx_SameParameter  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  Warning: the C3D and C2D must have the same parametric domain. <br>
//! <br>
Standard_EXPORT Approx_SameParameter(const Handle(Geom_Curve)& C3D,const Handle(Geom2d_Curve)& C2D,const Handle(Geom_Surface)& S,const Standard_Real Tol);


Standard_EXPORT Approx_SameParameter(const Handle(Adaptor3d_HCurve)& C3D,const Handle(Geom2d_Curve)& C2D,const Handle(Adaptor3d_HSurface)& S,const Standard_Real Tol);


//!  Warning: the C3D and C2D must have the same parametric domain. <br>
//! <br>
Standard_EXPORT Approx_SameParameter(const Handle(Adaptor3d_HCurve)& C3D,const Handle(Adaptor2d_HCurve2d)& C2D,const Handle(Adaptor3d_HSurface)& S,const Standard_Real Tol);

  Standard_Boolean IsDone() const;

  Standard_Real TolReached() const;
//! Tells whether the original data  had already the  same <br>
//!          parameter up to  the tolerance :  in that case nothing <br>
//!          is done. <br>
  Standard_Boolean IsSameParameter() const;
//! Returns the 2D  curve that has  the same parameter  as <br>
//!          the  3D curve once evaluated on  the surface up to the <br>
//!          specified tolerance <br>
  Handle_Geom2d_BSplineCurve Curve2d() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Compute the Pcurve (internal use only). <br>
Standard_EXPORT   void Build(const Standard_Real Tol) ;


 // Fields PRIVATE
 //
Standard_Boolean mySameParameter;
Standard_Boolean myDone;
Standard_Real myTolReached;
Handle_Geom2d_BSplineCurve myCurve2d;
Handle_Adaptor3d_HCurve myC3d;
Handle_Adaptor3d_HSurface mySurf;


};


#include <Approx_SameParameter.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
