open Tk;;

let rgb () =
  let fentre_principale = openTk () in

  let crer_glissire nom =
    Scale.create fentre_principale
                  [Label nom; From 0.0; To 255.0;
                   Length(Centimeters 10.0); Orient Horizontal] in

  let rouge = crer_glissire "Rouge"
  and vert  = crer_glissire "Vert"
  and bleu  = crer_glissire "Bleu"
  and chantillon =
    Frame.create fentre_principale
                  [Height(Centimeters 1.5); Width(Centimeters 6.0)]
  and quitter =
    Button.create fentre_principale
                   [Text "Quitter"; Command closeTk] in

  let rafrachir_couleur x =
    let r = int_of_float(Scale.get rouge)
    and v = int_of_float(Scale.get vert)
    and b = int_of_float(Scale.get bleu) in
    let couleur = Printf.sprintf "#%02x%02x%02x" r v b in
    Frame.configure chantillon [Background (NamedColor couleur)] in

  Scale.configure rouge [ScaleCommand rafrachir_couleur];
  Scale.configure vert [ScaleCommand rafrachir_couleur];
  Scale.configure bleu [ScaleCommand rafrachir_couleur];
  pack [rouge; vert; bleu] [Side Side_Top];
  pack [quitter] [Side Side_Bottom];
  pack [chantillon] [Side Side_Bottom; PadY(Millimeters 2.0)];
  mainLoop ();;

if !Sys.interactive then () else begin rgb (); exit 0 end;;
