type entry = {
  name : string;
  address : string;
  tel : string;
  url : string;
};;

type address_book = {
  file : string;
  entries : (string, entry) Hashtbl.t
};;

let make_entry n a t u = {name = n; address = a; tel = t; url = u};;

let print_entry =
 printf "Name : %s\n" e.name;
 printf "Address : %s\n" e.address;
 printf "Tel : %s\n" e.tel;
 printf "URL : %s\n" e.url;;

let dummy_entry = make_entry "" "" "" "";;

let dummy_file = "book";;

let the_book =
 ref {file = dummy_file; entries = (Hashtbl.create 100 dummy_entry)};;

let read_address_book_ic ic =
 (input_value ic : address_book);;
let save_address_book_oc oc ad =
 (output_value oc (ad : address_book));;

let read_address_book ab =
 let ic = open_in_bin ab in
 read_address_book_ic ic;;

let init_address_book ab =
 if ab <> "" then read_address_book ab else read_address_book dummy_file;;

(*
let add_entry
let modify_entry
let delete_entry
let search_named_entry
let search_regexp_entry
let search_entry
*)
