#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 31 July 2009 13:11:08 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/icos_net.py,v 1.7 2009/07/31 20:31:15 vareille Exp $
#
# $Id: icos_net.py,v 1.7 2009/07/31 20:31:15 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from symserv.VisionInterface.SymservNodes import symlib
from MolKit.VisionInterface.MolKitNodes import molkitlib
from DejaVu.VisionInterface.DejaVuNodes import vizlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(symlib,"symserv.VisionInterface.SymservNodes", "symlib")

masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Read Molecule ##
    from MolKit.VisionInterface.MolKitNodes import ReadMolecule
    Read_Molecule_0 = ReadMolecule(constrkw={}, name='Read Molecule', library=molkitlib)
    masterNet.addNode(Read_Molecule_0,19,13)
    Read_Molecule_0.inputPortByName['filename'].widget.set(r"chain-4.pdb", run=False)
except:
    print "WARNING: failed to restore ReadMolecule named Read Molecule in network masterNet"
    print_exc()
    Read_Molecule_0=None

try:
    ## saving node CPK Macro ##
    from MolKit.VisionInterface.MolKitNodes import CPKMacro
    CPK_Macro_1 = CPKMacro(constrkw={}, name='CPK Macro', library=molkitlib)
    masterNet.addNode(CPK_Macro_1,49,162)
    Assign_Radii_4 = CPK_Macro_1.macroNetwork.nodes[2]
    Assign_Radii_4.inputPortByName['united'].widget.set(1, run=False)
    Select_Nodes_5 = CPK_Macro_1.macroNetwork.nodes[3]
    Select_Nodes_5.inputPortByName['nodeType'].widget.set(r"Atom", run=False)
    Select_Nodes_5.inputPortByName['selectionString'].widget.set(r".*", run=False)
    Extract_Atom_Property_6 = CPK_Macro_1.macroNetwork.nodes[4]
    Extract_Atom_Property_6.inputPortByName['propertyName'].widget.set(r"coords", run=False)
    spheres_7 = CPK_Macro_1.macroNetwork.nodes[5]
    spheres_7.inputPortByName['quality'].widget.set(10, run=False)
    spheres_7.inputPortByName['name'].widget.set(r"", run=False)
    spheres_7.inputPortByName['geoms'].widget.set(r"spheres", run=False)

    ## saving connections for network CPK Macro ##
    CPK_Macro_1.macroNetwork.freeze()
    input_Ports_2 = CPK_Macro_1.macroNetwork.ipNode
    if input_Ports_2 is not None and spheres_7 is not None:
        try:
            CPK_Macro_1.macroNetwork.connectNodes(
                input_Ports_2, spheres_7, "new", "instanceMatrices", blocking=True
                , splitratio=[0.3026666952089706, 0.74168936659584483])
        except:
            print "WARNING: failed to restore connection between input_Ports_2 and spheres_7 in network CPK_Macro_1.macroNetwork"
    CPK_Macro_1.macroNetwork.unfreeze()

    ## modifying MacroInputNode dynamic ports
    input_Ports_2.outputPorts[1].configure(name='Assign_Radii_molecules')
    input_Ports_2.outputPorts[2].configure(name='spheres_instanceMatrices')

    ## modifying MacroOutputNode dynamic ports
    output_Ports_3 = CPK_Macro_1.macroNetwork.opNode
    output_Ports_3.inputPorts[1].configure(singleConnection=True)
    output_Ports_3.inputPorts[1].configure(name='spheres_spheres')
    CPK_Macro_1.inputPorts[0].configure(name='Assign_Radii_molecules')
    CPK_Macro_1.inputPorts[0].configure(datatype='MoleculeSet')
    CPK_Macro_1.inputPorts[1].configure(name='spheres_instanceMatrices')
    CPK_Macro_1.inputPorts[1].configure(datatype='instancemat(0)')
    ## configure MacroNode input ports
    CPK_Macro_1.outputPorts[0].configure(name='spheres_spheres')
    CPK_Macro_1.outputPorts[0].configure(datatype='geomOrInsert2d')
    ## configure MacroNode output ports
    CPK_Macro_1.shrink()
except:
    print "WARNING: failed to restore CPKMacro named CPK Macro in network masterNet"
    print_exc()
    CPK_Macro_1=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_8 = Viewer(constrkw={}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_8,81,245)
    ##
        ## Saving State for Viewer
    Viewer_8.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 1946, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -627.76123], 'd2cutH': 255, 'far': 874.77526177051629, 'd1off': 4, 'lookFrom': [0.0, 0.0, 627.76123], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 414.24501703232227, 'drawThumbnail': False, 'rooty': 87, 'd1scale': 0.012999999999999999}
    apply(Viewer_8.vi.cameras[0].Set, (), state)

    state = {'end': 795.25023797319659, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 460.27224114702472, 'mode': 'GL_LINEAR'}
    apply(Viewer_8.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [15.0, 7.5, 7.5], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-15.0, -7.5, -7.5], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(Viewer_8.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_8.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_8.vi.rootObject:
        Viewer_8.vi.rootObject.clipP = []
        Viewer_8.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_8=None

try:
    ## saving node Icosahedral1 ##
    from symserv.VisionInterface.SymservNodes import Icos1
    Icosahedral1_9 = Icos1(constrkw={}, name='Icosahedral1', library=symlib)
    masterNet.addNode(Icosahedral1_9,271,41)
    _5_fold_12 = Icosahedral1_9.macroNetwork.nodes[2]
    _5_fold_12.inputPortByName['vector'].widget.set([0.0, 0.52549288072191591, 0.85079799735929229], run=False)
    _5_fold_12.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _5_fold_12.inputPortByName['identity'].widget.set(1, run=False)
    _3_fold_13 = Icosahedral1_9.macroNetwork.nodes[3]
    _3_fold_13.inputPortByName['vector'].widget.set([0.57735026918962584, 0.57735026918962584, 0.57735026918962584], run=False)
    _3_fold_13.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _3_fold_13.inputPortByName['identity'].widget.set(1, run=False)
    _2_fold_14 = Icosahedral1_9.macroNetwork.nodes[4]
    _2_fold_14.inputPortByName['vector'].widget.set([1.0, 0.0, 0.0], run=False)
    _2_fold_14.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_14.inputPortByName['identity'].widget.set(1, run=False)
    _2_fold_15 = Icosahedral1_9.macroNetwork.nodes[5]
    _2_fold_15.inputPortByName['vector'].widget.set([0.0, 0.0, 1.0], run=False)
    _2_fold_15.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_15.inputPortByName['identity'].widget.set(0, run=False)
    _2_fold_16 = Icosahedral1_9.macroNetwork.nodes[6]
    _2_fold_16.inputPortByName['vector'].widget.set([0.0, 1.0, 0.0], run=False)
    _2_fold_16.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_16.inputPortByName['identity'].widget.set(0, run=False)

    ## saving connections for network Icosahedral1 ##
    Icosahedral1_9.macroNetwork.freeze()
    Icosahedral1_9.macroNetwork.unfreeze()

    ## modifying MacroOutputNode dynamic ports
    output_Ports_11 = Icosahedral1_9.macroNetwork.opNode
    output_Ports_11.inputPorts[1].configure(singleConnection=True)
    output_Ports_11.inputPorts[1].configure(name='Merge_outMatrices')
    ## configure MacroNode input ports
    Icosahedral1_9.outputPorts[0].configure(name='Merge_outMatrices')
    Icosahedral1_9.outputPorts[0].configure(datatype='instancemat(0)')
    ## configure MacroNode output ports
    Icosahedral1_9.shrink()
except:
    print "WARNING: failed to restore Icos1 named Icosahedral1 in network masterNet"
    print_exc()
    Icosahedral1_9=None

#masterNet.run()
masterNet.freeze()

## saving connections for network icos ##
if CPK_Macro_1 is not None and Viewer_8 is not None:
    try:
        masterNet.connectNodes(
            CPK_Macro_1, Viewer_8, "spheres_spheres", "geometries", blocking=True
            , splitratio=[0.42510898588941959, 0.61989762691555039])
    except:
        print "WARNING: failed to restore connection between CPK_Macro_1 and Viewer_8 in network masterNet"
if Icosahedral1_9 is not None and CPK_Macro_1 is not None:
    try:
        masterNet.connectNodes(
            Icosahedral1_9, CPK_Macro_1, "Merge_outMatrices", "spheres_instanceMatrices", blocking=True
            , splitratio=[0.45363441181997038, 0.42018990925914657])
    except:
        print "WARNING: failed to restore connection between Icosahedral1_9 and CPK_Macro_1 in network masterNet"
if Read_Molecule_0 is not None and CPK_Macro_1 is not None:
    try:
        masterNet.connectNodes(
            Read_Molecule_0, CPK_Macro_1, "MolSets", "Assign_Radii_molecules", blocking=True
            , splitratio=[0.62067247087486788, 0.34104673933799828])
    except:
        print "WARNING: failed to restore connection between Read_Molecule_0 and CPK_Macro_1 in network masterNet"
masterNet.runOnNewData.value = False


def loadSavedStates_Viewer_8(self=Viewer_8, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|spheres
    ## End Object root|spheres

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -627.76123], 'd2cutH': 255, 'far': 874.77526177051629, 'd1off': 4, 'lookFrom': [0.0, 0.0, 627.76123], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 414.24501703232227, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 795.25023797319659, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 460.27224114702472, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [15.0, 7.5, 7.5], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-15.0, -7.5, -7.5], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_8.restoreStates_cb = Viewer_8.restoreStatesFirstRun = loadSavedStates_Viewer_8
Viewer_8.menu.add_separator()
Viewer_8.menu.add_command(label='Restore states', command=Viewer_8.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

