/****************************************************************************
 **
 ** $Id: lincvs.h,v 1.186.2.1 2005/01/25 22:53:22 tilo Exp $
 **
 ** Copyright (C) 1999-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.org>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Tom Mishima <tmishima@mail.at-m.or.jp>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/


#ifndef LINCVS_H_20010626
#define LINCVS_H_20010626

#include "config.h"

#include <qmenubar.h>
#include <qpixmap.h>
#include <qptrlist.h>

#include "globals.h"
#include "cvscontrol.h"
#include "cvstoolbar.h"
#include "CvsBuffer.h"

#include "CustomizeDialogImpl.h"
#include "StatusWidget.h"
#include "Menu.h"

class QTabWidget;
class QToolBar;
class QToolButton;
class QMultiLineEdit;
class QListViewItem;
class QListView;
class QPixMap;
class QString;
class QStringList;
class QDialog;
class QLabel;
class CvsDirListView;
class CvsIgnoreListView;
class NonCvsListView;
class CvsListView;
class Directory;
class ColorTabWidget;
class QSplitter;
class CPixmapTimer;

class ApplicationWindow: public CvsControl
{
   Q_OBJECT

 public:

   ApplicationWindow( QString);
   ~ApplicationWindow();

   MenuItem *M_COMMIT;
   MenuItem *M_COMMITFILE;
   MenuItem *M_CUSTOMIZE;
   MenuItem *M_CUSTOMIZEFILE;
   MenuItem *M_DIFFSIDEBYSIDEFILE;
   MenuItem *M_DIFFTOCONSOLEFILE;
   MenuItem *M_DISABLEDIR;
   MenuItem *M_EDITFILE;
   MenuItem *M_EDITDIR;
   MenuItem *M_ENABLEDIR;
   MenuItem *M_EXPANDDIR;
   MenuItem *M_HISTORY;
   MenuItem *M_HISTORYFILE;
   MenuItem *M_LOGIN;
   MenuItem *M_LOGOUT;
   MenuItem *M_LOGTREEFILE;
   MenuItem *M_PROPERTIES;
   MenuItem *M_QUERYUPDATE;
   MenuItem *M_QUERYUPDATEFILE;
   MenuItem *M_RELEASE;
   MenuItem *M_RELEASEANDREMOVE;
   MenuItem *M_REMOVE;
   MenuItem *M_REMOVEFILE;
   MenuItem *M_REMOVEFROMWORKBENCH;
   MenuItem *M_RENAMEFILE;
   MenuItem *M_REREADDIR;
   MenuItem *M_SEPARATOR;
   MenuItem *M_SHOWEDITORS;
   MenuItem *M_SHOWEDITORSFILE;
   MenuItem *M_STATUS;
   MenuItem *M_STATUSFILE;
   MenuItem *M_TAG;
   MenuItem *M_TAGFILE;
   MenuItem *M_UNEDITDIR;
   MenuItem *M_UNEDITFILE;
   MenuItem *M_UPDATE;
   MenuItem *M_UPDATEFILE;
   MenuItem *M_UPDATEOTHER;
   MenuItem *M_UPDATEOTHERFILE;
   MenuItem *M_TEST;
   MenuItem *M_LOCKFILE;
   MenuItem *M_LOCKDIR;
   MenuItem *M_UNLOCKFILE;
   MenuItem *M_UNLOCKDIR;
   MenuItem *M_SHOWWATCHERSFILE;
   MenuItem *M_SHOWWATCHERSDIR;
   MenuItem *M_OPENFILE;
   MenuItem *M_BROWSEDIR;
   MenuItem *M_OPENSHELLDIR;
   MenuItem *M_UPDATEDIRBRANCHFILE;
   MenuItem *M_UPDATEDIRBRANCHDIR;
   MenuItem *M_REMOVELOCALOPTIONSFILE;
   MenuItem *M_REMOVELOCALOPTIONSDIR;
   MenuItem *M_EXPORTDIR;
   MenuItem *M_COLLAPSDIR;
   MenuItem *M_VIEWFILE;
   MenuItem *M_REPLACEFILE;
   MenuItem *M_REPLACEDIR;
   MenuItem *M_RESOLVE;
   MenuItem *M_DIFFTOCONSOLEDIR;
   MenuItem *M_ADVDIFFTOCONSOLEFILE;
   MenuItem *M_ADVDIFFTOCONSOLEDIR;
   MenuItem *M_QUERYUPDATEALL;
   MenuItem *M_REPLACEALLDIR;
   MenuItem *M_UPDATEALL;
   MenuItem *M_UPDATEVIRTUALDIR;
   MenuItem *M_REMOVEFROMDISK;
   MenuItem *M_REMOVEFROMREP;
   MenuItem *M_REMOVEFROMREPANDDISK;
   MenuItem *M_REMOVEFROMDISKDIR;
   MenuItem *M_REMOVEFROMREPANDDISKDIR;
   MenuItem *M_ADDFILE;
   MenuItem *M_ADDFOLDER;
   MenuItem *M_ADDASCIIFILE;
   MenuItem *M_ADDBINARYFILE;
   MenuItem *M_CREATENEWFILE;
   MenuItem *M_CREATENEWDIR;
   MenuItem *M_DELETENONCVSFROMDISKFILE;
   MenuItem *M_DELETEIGNOREFROMDISKFILE;
   MenuItem *M_ADDPROJECT;
   MenuItem *M_CHECKOUTPROJECT;
   MenuItem *M_IMPORTPROJECT;
   MenuItem *M_EXPORTPROJECT;
   MenuItem *M_EXITPROJECT;
   MenuItem *M_SETTINGSOPTIONS;
   MenuItem *M_PROFILESOPTIONS;
   MenuItem *M_KEYSHORTCUTSOPTIONS;
   MenuItem *M_AUTOREFRESHOPTIONS;
   MenuItem *M_REFRESHOPTIONS;
   MenuItem *M_HELP;
   MenuItem *M_ONLINEHELP;
   MenuItem *M_DEBUGLOGHELP;
   MenuItem *M_ABOUTHELP;
   MenuItem *M_ABOUTQTHELP;
   MenuItem *M_OPENFILEMAPPINGOPTIONS;
   MenuItem *M_VIEWFILEMAPPINGOPTIONS;
   MenuItem *M_RENAMEDIR;
   MenuItem *M_COPYFILE;
   MenuItem *M_PASTE;
   MenuItem *M_MERGEDIR;
   MenuItem *M_MERGEFILE;
   MenuItem *M_CREATEPATCHDIR;
   MenuItem *M_LOGTREEDIR;
   MenuItem *M_IMPORTVENDORDIR;
   MenuItem *M_RENAMENONCVSFILE;
   MenuItem *M_REMOVECVSBACKED;
   MenuItem *M_INITLOCALCVS;
   MenuItem *M_ANNOTATEDIR;
   MenuItem *M_ANNOTATELINEDIR;
   MenuItem *M_ANNOTATELINESDIR;
   MenuItem *M_ANNOTATEFILE;
   MenuItem *M_ANNOTATELINEFILE;
   MenuItem *M_ANNOTATELINESFILE;
   MenuItem *M_WATCHONDIR;
   MenuItem *M_WATCHOFFDIR;
   MenuItem *M_WATCHADDDIR;
   MenuItem *M_WATCHREMOVEDIR;
   MenuItem *M_WATCHONFILE;
   MenuItem *M_WATCHOFFFILE;
   MenuItem *M_WATCHADDFILE;
   MenuItem *M_WATCHREMOVEFILE;
   MenuItem *M_ENABLETREE;
   MenuItem *M_DISABLEREVERTTREE;
   MenuItem *M_CREATEPATCHFILE;
   MenuItem *M_CONDITIONALEDITFILE;
   MenuItem *M_CONDITIONALEDITDIR;
   MenuItem *M_REFRESHEDITORS;
   MenuItem *M_ADDSYMLINK;
   MenuItem *M_DIFFFILEMAPPINGOPTIONS;
   MenuItem *M_MODIFYIGNORE;
   MenuItem *M_MODIFYIGNOREFILE;
   MenuItem *M_MODELOKALDIR;
   MenuItem *M_MODELOKALFILE;
   MenuItem *M_MODEREMOTEDIR;
   MenuItem *M_MODEREMOTEFILE;
   MenuItem *M_ADDOTHERFILE;
   
   MenuItem *M_COPYOUTPUT;
   MenuItem *M_SELECTALLOUTPUT;
   MenuItem *M_TOGGLESHOWALLOUTPUT;
   
 public slots:
   
   void showFileMenu(bool show);
   void setDirMenu(bool show=true);
   virtual void setStatusText( const QString &, int ms=0);
   
   /** only for testing purpose, not for release */
   virtual void test();
   
 protected:
   
   void initMenuAndToolbar();
   void initComponents();
   void initDone();
   void customizeFileMapping(Mapping::FileAppList&,QString);
   void blockGUI(bool,int=BLOCKALL);
   bool isGuiBlocked();
   
   Directory* getSelectedDir(const bool bShowWarning = true);
   
 protected slots:
   
   /** Project menu slots */
   virtual void slot_closeApp();
   virtual void slot_addProject();
   virtual void slot_dropProject(const QString);
   virtual void slot_initLocalRep();
   
   /** Config menu slots */
   virtual void slot_settings();
   virtual void slot_setFonts();
   virtual void slot_profiles();
   virtual void slot_customizeKeyShortcuts();
   virtual void slot_customizeOpenFileMapping();
   virtual void slot_customizeViewFileMapping();
   virtual void slot_toggleAutoUpdate();
   virtual void slot_refreshAll();
   
   /** Help menu slots */
   virtual void slot_about();
   virtual void slot_help();
   virtual void slot_aboutQt();
   /* 	virtual void slot_debug(); */
   /* 	virtual void slot_onlineHelp(); */
   
   void slot_dirClicked(DirBase *);
   void slot_renameLocalDir();
   void slot_renameNonCvsFile();
   void slot_createPatchDir();
   void slot_createPatchFile();
/*    void slot_updateOtherRevisionDir(); */
/*    void slot_updateOtherRevisionFile(); */
   
   void slot_removeCvsBackedFiles();
   
   void showDirProperties();
   void resolveFile();
   void closeEvent( QCloseEvent *);
   void customizeDirPopupMenu();
   void customizeFilePopupMenu();
   void fillProjectMenu();
   void fillFileMenu(bool);
   void fillDirMenu(bool);
   void fillConfigMenu();
   void fillHelpMenu();
   void fillOutputPopupMenu(int);
   
   void slot_copyFile();
   void slot_paste();
   
   void checkInProgress(bool);
   
   void updateColor( int c);
   
   void showInfo(const QString&, const QString&);
   void showWarning(const QString&, const QString&);
   bool showYesNoQuestion(const QString&, const QString&);
   bool showOkCancelQuestion(const QString&, const QString&);
   bool showVerifyDialog(const QString&, const QString&);
   
 private:
   
   enum {//what to do after settings-dlg-modification, values are or'ed ...
      Noop = 0,
      Analyze = 1,
   };

   /** menu entries, identified by an id */
   enum {
      MENU_PROJECT   = 0,
      MENU_DIR       = 1,
      MENU_FILE      = 2,
      MENU_OPTIONS   = 3,
      MENU_HELP      = 4
   };
   
   //main menus
   Menu *m_pProjectMenu;
   Menu *m_pDirMenu;
   Menu *m_pFileMenu;
   Menu *m_pConfigMenu;
   Menu *m_pHelpMenu;
   
   //dirsubmenues
   Menu * m_pDirProjectSubMenu;
   Menu * m_pDirStateSubMenu;
   Menu * m_pDirWatchSubMenu;
   Menu * m_pDirImportSubMenu;
   Menu * m_pDirUpdateSubMenu;
   Menu * m_pDirAnnotateSubMenu;
   Menu * m_pDirDiffSubMenu;
   Menu * m_pDirTreeSubMenu;
   Menu * m_pDirEditSubMenu;
   Menu * m_pDirLockSubMenu;
   
   //filesubmenues
   Menu * m_pFileStateSubMenu;
   Menu * m_pFileWatchSubMenu;
   Menu * m_pFileSubMenu;
   Menu * m_pFileAnnotateSubMenu;
   Menu * m_pFileDiffSubMenu;
   Menu * m_pFileLockSubMenu;
   
   //foreign menus
   Menu *m_pOutputMenu;
   
   //Settings
   void saveSettings();
   void writeSetup();

   bool checkFilesSelected();
   
   //Customize PopupMenues
   void setMenuItemState(bool);
   int insertMenuItem(Menu*,MenuItem*);
   int insertMenuItem(Menu*,const MenuItem*, bool);
   Menu *dirPopupMenu;
   Menu *filePopupMenu;
   QVector<MenuItem> *dirPopupMenuItems;
   QVector<MenuItem> *filePopupMenuItems;
   QVector<MenuItem> *allDirPopupMenuItems;
   QVector<MenuItem> *allFilePopupMenuItems;
   bool isFilesAndDirsSelected();
   bool isDirsSelected();
   bool checkOnlyRemovedFilesSelected();
   bool checkOnlyVirtualDirFileItemsSelected();
   int selectCount(const int &);
   
   //MainWindow setup
   QSplitter *m_pHorzSplitter;
   QSplitter *m_pVertSplitter;
   StatusWidget * m_pProgressWidget;
   
   /** Auto-refresh mode flag */
   bool m_AutoRefreshEnabled;
   
   //set/reset ViewPort
   int m_lastHScrollBarValue;
   int m_lastVScrollBarValue;
   QStringList m_selectedList;
   QString m_selectedDir;
   
   //cut,copy,paste
   QStringList m_clipboardFileList;
   bool m_validClipboardData;
   
   //status text
   QString m_statusMsg;
   
   //notifications
   void lockNotifications(bool);
   
   //interrupt
   void setTimersActive(bool);
   QTimer m_showStopTimer;
   
   bool m_onDrag;
   
   QPtrStack<QObject> m_delObjStack;
   
 private slots:

   void slot_updateSettings(int=-1);

   void refreshAllCvsEntries();
   void clipboardDataChanged();
   void statusMessageChanged( const QString &);
   void fillFilePopupMenu();
   void fillDirPopupMenu();
   void copyOutput();
   void selectAllOutput();
   void toggleShowAllOutput();
   void slot_blockGUI(bool);
   void slot_stopStatusTimer();
   void slot_applyAutoUpdate();
   void slot_enableStopButton();
   void slot_poll();
   void dragStarted();
   void dragDone();
   void slot_deleteObject(QObject *);
   void slot_deletePendingObjects();
   void slot_addFiles(const QStringList,bool);
   void slot_moveFiles(const QString,const QStringList);

   //calls to versioning system
   void slot_statusFile();
   void slot_statusDir();

   void slot_editFile();
   void slot_uneditFile();
   void slot_showEditorsFile();
   void slot_editDir();
   void slot_uneditDir();
   void slot_showEditorsDir();

   void slot_watchOnAny();
   void slot_watchOffAny();
   void slot_watchAddAny();
   void slot_watchRemoveAny();
   void slot_watchOnFile();
   void slot_watchOffFile();
   void slot_watchAddFile();
   void slot_watchRemoveFile();
   void slot_showWatchersFile();
   void slot_watchOnDir();
   void slot_watchOffDir();
   void slot_watchAddDir();
   void slot_watchRemoveDir();
   void slot_showWatchersDir();

   void slot_mergeAny();
   void slot_mergeFile();
   void slot_mergeDir();

   void slot_diffFile();
   void slot_diffAdvancedFile();
   void slot_diffDir();
   void slot_diffAdvancedDir();
   void slot_diffFileSideBySide();

   void slot_annotateAny();
   void slot_annotateFile();
   void slot_annotateDir();
   void slot_annotateGrepLineAny();
   void slot_annotateGrepLineFile();
   void slot_annotateGrepLineDir();
   void slot_annotateGrepLinesAny();
   void slot_annotateGrepLinesFile();
   void slot_annotateGrepLinesDir();

   void slot_historyFile();
   void slot_historyDir();

   void slot_logFile();
   void slot_logDir();

   void slot_updateAny();
   void slot_queryUpdateFile();
   void slot_updateFile();
   void slot_updateReplaceFile();
   void slot_updateToDirBranchFile();
   void slot_updateOtherRevisionFile();
   void slot_removeLocalOptionsFile();
   void slot_queryUpdateDir();
   void slot_queryUpdateAllDir();
   void slot_updateDir();
   void slot_updateAllDir();
   void slot_updateReplaceDir();
   void slot_updateReplaceAllDir();
   void slot_updateToDirBranchDir();
   void slot_updateOtherRevisionDir();
   void slot_updateVirtualDir();
   void slot_removeLocalOptionsDir();

   void slot_tagFile();
   void slot_tagDir();

   void slot_checkoutProject();
   void slot_exportProject();

   void slot_importProject();

   void slot_commitAny();
   void slot_commitFile();
   void slot_commitDir();

   void slot_release();
   void slot_releaseAndRemove();

   void slot_addFileAscii();
   void slot_addFileBinary();
   void slot_addDir();

   void slot_resurrectFile();

   void slot_removeFile();
   void slot_removeDir();

   void slot_autoUpdate();

   void slot_renameFile();

   //============================================

};

//----------------------------------------------------------------------------

#endif   //LINCVS_H_20010626

