/****************************************************************************
 **
 ** $Id: CommandInterface.h,v 1.35 2004/10/27 17:00:05 frank Exp $
 **
 ** Copyright (C) 2001-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.at>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#ifndef COMMANDINTERFACE_H
#define COMMANDINTERFACE_H

#include "config.h"


#include <qstring.h>
#include "CvsBuffer.h"

static const bool NOROOT = true;

// never interactive commands:
static const int CVS_NOT_INTERACTIVE_CMD = 255;
static const int CVS_LOG_CMD = 200;

// external commands:
static const int CVS_LOGINANDOUT_CMD = 210;

// interactive commands:
static const int CVS_Y_N                           =  0;
static const int CVS_RELEASE_CMD                   =  1;
static const int CVS_RELEASE_D_CMD                 =  2;
static const int CVS_UNEDIT_CMD                    =  3;
static const int CVS_STATUS_CMD                    =  4;
static const int CVS_STATUS_FILES_CMD              =  5;
static const int CVS_UPDATE_DIR_CMD                =  6;
static const int CVS_UPDATE_FILES_CMD              =  7;
static const int CVS_ANNOTATE_GREP_LINE_CMD        =  8;
static const int CVS_ANNOTATE_GREP_LINES_CMD       =  9;
static const int CVS_COMMIT_CMD                    = 10;
static const int CVS_HISTORY_CMD                   = 11;
static const int CVS_DIFF_CMD                      = 12;
static const int CVS_DIFF_SBS_CMD                  = 13;
static const int CVS_DIFF_EXT_CMD                  = 14;
static const int CVS_ANNOTATE_CMD                  = 15;
static const int CVS_CHECKOUT_CMD                  = 16;
static const int CVS_IMPORT_CMD                    = 17;
static const int CVS_TAG_CMD                       = 18;
static const int CVS_LOG_DIR_CMD                   = 19;
static const int CVS_RENAME_CMD                    = 20;
static const int CVS_REMOVE_CMD                    = 21;
static const int CVS_REMOVE_AND_RENAME_CMD         = 22;
static const int CVS_ADD_CMD                       = 23;
static const int CVS_QUERY_UPDATE_CMD              = 24;
static const int CVS_QUERY_UPDATE_ALL_CMD          = 25;
static const int CVS_EDIT_REVISION_CMD             = 26;
static const int CVS_MERGE_REV_INTO_CMD            = 27;
static const int CVS_RESURRECT_CMD                 = 28;
static const int CVS_SHOW_EDITORS_CMD              = 29;
static const int CVS_SHOW_WATCHERS_CMD             = 30;
static const int CVS_MERGE_DIR_CMD                 = 31;
static const int CVS_MERGE_FILES_CMD               = 32;
static const int CVS_LOCKFILE_CMD                  = 33;
static const int CVS_UNLOCKFILE_CMD                = 34;
static const int CVS_HBROWSEMODULES_CMD            = 35;
static const int CVS_MBROWSEMODULES_CMD            = 36;
static const int CVS_EXPORT_CMD                    = 37;
static const int CVS_REMOVEDIR_CMD                 = 38;
static const int CVS_AUTOUPDATE_DIR_CMD            = 39;
static const int CVS_AUTOUPDATE_DIR_NO_PRUNE_CMD   = 40;
static const int CVS_CHECKOUT_NO_PRUNE_CMD         = 41;
static const int CVS_MERGE_DIR_NO_PRUNE_CMD        = 42;
static const int CVS_UPDATE_VIRTUAL_DIR_CMD        = 43;
static const int CVS_MOVE_FILES_CMD                = 44;
static const int CVS_REVERT_DIR_CMD                = 45;
static const int CVS_REVERT_FILES_CMD              = 46;
static const int CVS_GET_TAG_INFO_PROJECT_CMD      = 47;
static const int CVS_GET_TAG_INFO_FILES_CMD        = 48;

class CvsControl;

class CommandInterface {

 public:
   void initCommandInterface( CvsControl *p);
   void callInteractive( QString& topModule, 
	 QString& dir,
	 QString& cvsRoot,
	 QString& repository,
	 int cmd,
	 QString& cvsRsh,
	 bool noroot=false);

   virtual ~CommandInterface() {}
   virtual void afterCall(int cmd,CvsBuffer *m_pCvsBuffer,bool failed=false) = 0;

 protected:
   virtual void cvsCallStarted();

 private:
   static CvsControl *pCvsControl;
};

#endif
