/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.query.ComponentShowingQuery;

public final class JMenuItemLocation {
    private Component parentOrInvoker;
    private JPopupMenu parentPopup;
    private final boolean inMenuBar;

    @RunsInCurrentThread
    public JMenuItemLocation(JMenuItem menuItem) {
        this.parentOrInvoker = menuItem.getParent();
        if (this.parentOrInvoker instanceof JPopupMenu) {
            this.parentPopup = (JPopupMenu)this.parentOrInvoker;
            this.parentOrInvoker = ((JPopupMenu)this.parentOrInvoker).getInvoker();
        }
        this.inMenuBar = this.parentOrInvoker instanceof JMenuBar;
    }

    public boolean inMenuBar() {
        return this.inMenuBar;
    }

    @RunsInEDT
    public boolean isParentAMenu() {
        if (!(this.parentOrInvoker instanceof JMenuItem)) {
            return false;
        }
        return this.parentPopup == null || !ComponentShowingQuery.isShowing(this.parentPopup);
    }

    public Component parentOrInvoker() {
        return this.parentOrInvoker;
    }

    public JPopupMenu parentPopup() {
        return this.parentPopup;
    }
}

