/*
 * Decompiled with CFR 0.152.
 */
package picard.reference;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SequenceUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class ExtractSequences
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Extracts one or more intervals described in an interval_list file from a given reference sequence and writes them out in FASTA format. Requires a fasta index file to be present.";
    @Option(doc="Interval list describing intervals to be extracted from the reference sequence.")
    public File INTERVAL_LIST;
    @Option(shortName="R", doc="Reference sequence file.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="O", doc="Output fasta file.")
    public File OUTPUT;
    @Option(doc="Maximum line length for sequence data.")
    public int LINE_LENGTH = 80;

    public static void main(String[] args) {
        new ExtractSequences().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INTERVAL_LIST);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IntervalList intervals = IntervalList.fromFile((File)this.INTERVAL_LIST);
        ReferenceSequenceFile ref = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE_SEQUENCE);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)intervals.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)ref.getSequenceDictionary());
        BufferedWriter out = IOUtil.openFileForBufferedWriting((File)this.OUTPUT);
        for (Interval interval : intervals) {
            ReferenceSequence seq = ref.getSubsequenceAt(interval.getSequence(), (long)interval.getStart(), (long)interval.getEnd());
            byte[] bases = seq.getBases();
            if (interval.isNegativeStrand()) {
                SequenceUtil.reverseComplement((byte[])bases);
            }
            try {
                out.write(">");
                out.write(interval.getName());
                out.write("\n");
                for (int i = 0; i < bases.length; ++i) {
                    if (i > 0 && i % this.LINE_LENGTH == 0) {
                        out.write("\n");
                    }
                    out.write(bases[i]);
                }
                out.write("\n");
            }
            catch (IOException ioe) {
                throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), ioe);
            }
        }
        CloserUtil.close((Object)out);
        return 0;
    }
}

